/*
 * Decompiled with CFR 0.152.
 */
package com.google.thirdparty.publicsuffix;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.thirdparty.publicsuffix.PublicSuffixType;
import java.util.ArrayDeque;
import java.util.Deque;

@GwtCompatible
final class TrieParser {
    private static final Joiner DIRECT_JOINER = Joiner.on("");

    static ImmutableMap<String, PublicSuffixType> parseTrie(CharSequence ... encodedChunks) {
        String encoded = DIRECT_JOINER.join(encodedChunks);
        return TrieParser.parseFullString(encoded);
    }

    @VisibleForTesting
    static ImmutableMap<String, PublicSuffixType> parseFullString(String encoded) {
        ImmutableMap.Builder<String, PublicSuffixType> builder = ImmutableMap.builder();
        int encodedLen = encoded.length();
        for (int idx = 0; idx < encodedLen; idx += TrieParser.doParseTrieToBuilder(new ArrayDeque<CharSequence>(), encoded, idx, builder)) {
        }
        return builder.buildOrThrow();
    }

    private static int doParseTrieToBuilder(Deque<CharSequence> stack, CharSequence encoded, int start, ImmutableMap.Builder<String, PublicSuffixType> builder) {
        String domain;
        int idx;
        int encodedLen = encoded.length();
        char c15 = '\u0000';
        for (idx = start; idx < encodedLen && (c15 = encoded.charAt(idx)) != '&' && c15 != '?' && c15 != '!' && c15 != ':' && c15 != ','; ++idx) {
        }
        stack.push(TrieParser.reverse(encoded.subSequence(start, idx)));
        if ((c15 == '!' || c15 == '?' || c15 == ':' || c15 == ',') && (domain = DIRECT_JOINER.join(stack)).length() > 0) {
            builder.put(domain, PublicSuffixType.fromCode(c15));
        }
        ++idx;
        if (c15 != '?' && c15 != ',') {
            while (idx < encodedLen) {
                if (encoded.charAt(idx += TrieParser.doParseTrieToBuilder(stack, encoded, idx, builder)) != '?' && encoded.charAt(idx) != ',') continue;
                ++idx;
                break;
            }
        }
        stack.pop();
        return idx - start;
    }

    private static CharSequence reverse(CharSequence s15) {
        return new StringBuilder(s15).reverse();
    }

    private TrieParser() {
    }
}

