/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.AbstractProtobufList;
import com.google.protobuf.ByteString;
import com.google.protobuf.Internal;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.UnmodifiableLazyStringList;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;

public class LazyStringArrayList
extends AbstractProtobufList<String>
implements LazyStringList,
RandomAccess {
    private static final LazyStringArrayList EMPTY_LIST = new LazyStringArrayList(false);
    @Deprecated
    public static final LazyStringList EMPTY = EMPTY_LIST;
    private final List<Object> list;

    public static LazyStringArrayList emptyList() {
        return EMPTY_LIST;
    }

    public LazyStringArrayList() {
        this(10);
    }

    private LazyStringArrayList(boolean isMutable) {
        super(isMutable);
        this.list = Collections.emptyList();
    }

    public LazyStringArrayList(int initialCapacity) {
        this(new ArrayList<Object>(initialCapacity));
    }

    public LazyStringArrayList(LazyStringList from) {
        this.list = new ArrayList<Object>(from.size());
        this.addAll(from);
    }

    public LazyStringArrayList(List<String> from) {
        this(new ArrayList<Object>(from));
    }

    private LazyStringArrayList(ArrayList<Object> list2) {
        this.list = list2;
    }

    public LazyStringArrayList mutableCopyWithCapacity(int capacity) {
        if (capacity < this.size()) {
            throw new IllegalArgumentException();
        }
        ArrayList<Object> newList = new ArrayList<Object>(capacity);
        newList.addAll(this.list);
        return new LazyStringArrayList(newList);
    }

    @Override
    public String get(int index) {
        Object o15 = this.list.get(index);
        if (o15 instanceof String) {
            return (String)o15;
        }
        if (o15 instanceof ByteString) {
            ByteString bs4 = (ByteString)o15;
            String s15 = bs4.toStringUtf8();
            if (bs4.isValidUtf8()) {
                this.list.set(index, s15);
            }
            return s15;
        }
        byte[] ba5 = (byte[])o15;
        String s16 = Internal.toStringUtf8(ba5);
        if (Internal.isValidUtf8(ba5)) {
            this.list.set(index, s16);
        }
        return s16;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public String set(int index, String s15) {
        this.ensureIsMutable();
        Object o15 = this.list.set(index, s15);
        return LazyStringArrayList.asString(o15);
    }

    @Override
    public void add(int index, String element) {
        this.ensureIsMutable();
        this.list.add(index, element);
        ++this.modCount;
    }

    @Override
    private void add(int index, ByteString element) {
        this.ensureIsMutable();
        this.list.add(index, element);
        ++this.modCount;
    }

    @Override
    private void add(int index, byte[] element) {
        this.ensureIsMutable();
        this.list.add(index, element);
        ++this.modCount;
    }

    @Override
    public boolean addAll(Collection<? extends String> c15) {
        return this.addAll(this.size(), c15);
    }

    @Override
    public boolean addAll(int index, Collection<? extends String> c15) {
        this.ensureIsMutable();
        Collection<? extends String> collection = c15 instanceof LazyStringList ? ((LazyStringList)c15).getUnderlyingElements() : c15;
        boolean ret = this.list.addAll(index, collection);
        ++this.modCount;
        return ret;
    }

    @Override
    public boolean addAllByteString(Collection<? extends ByteString> values2) {
        this.ensureIsMutable();
        boolean ret = this.list.addAll(values2);
        ++this.modCount;
        return ret;
    }

    @Override
    public boolean addAllByteArray(Collection<byte[]> c15) {
        this.ensureIsMutable();
        boolean ret = this.list.addAll(c15);
        ++this.modCount;
        return ret;
    }

    @Override
    public String remove(int index) {
        this.ensureIsMutable();
        Object o15 = this.list.remove(index);
        ++this.modCount;
        return LazyStringArrayList.asString(o15);
    }

    @Override
    public void clear() {
        this.ensureIsMutable();
        this.list.clear();
        ++this.modCount;
    }

    @Override
    public void add(ByteString element) {
        this.ensureIsMutable();
        this.list.add(element);
        ++this.modCount;
    }

    @Override
    public void add(byte[] element) {
        this.ensureIsMutable();
        this.list.add(element);
        ++this.modCount;
    }

    @Override
    public Object getRaw(int index) {
        return this.list.get(index);
    }

    @Override
    public ByteString getByteString(int index) {
        Object o15 = this.list.get(index);
        ByteString b15 = LazyStringArrayList.asByteString(o15);
        if (b15 != o15) {
            this.list.set(index, b15);
        }
        return b15;
    }

    @Override
    public byte[] getByteArray(int index) {
        Object o15 = this.list.get(index);
        byte[] b15 = LazyStringArrayList.asByteArray(o15);
        if (b15 != o15) {
            this.list.set(index, b15);
        }
        return b15;
    }

    @Override
    public void set(int index, ByteString s15) {
        this.setAndReturn(index, s15);
    }

    private Object setAndReturn(int index, ByteString s15) {
        this.ensureIsMutable();
        return this.list.set(index, s15);
    }

    @Override
    public void set(int index, byte[] s15) {
        this.setAndReturn(index, s15);
    }

    private Object setAndReturn(int index, byte[] s15) {
        this.ensureIsMutable();
        return this.list.set(index, s15);
    }

    private static String asString(Object o15) {
        if (o15 instanceof String) {
            return (String)o15;
        }
        if (o15 instanceof ByteString) {
            return ((ByteString)o15).toStringUtf8();
        }
        return Internal.toStringUtf8((byte[])o15);
    }

    private static ByteString asByteString(Object o15) {
        if (o15 instanceof ByteString) {
            return (ByteString)o15;
        }
        if (o15 instanceof String) {
            return ByteString.copyFromUtf8((String)o15);
        }
        return ByteString.copyFrom((byte[])o15);
    }

    private static byte[] asByteArray(Object o15) {
        if (o15 instanceof byte[]) {
            return (byte[])o15;
        }
        if (o15 instanceof String) {
            return Internal.toByteArray((String)o15);
        }
        return ((ByteString)o15).toByteArray();
    }

    @Override
    public List<?> getUnderlyingElements() {
        return Collections.unmodifiableList(this.list);
    }

    @Override
    public void mergeFrom(LazyStringList other) {
        this.ensureIsMutable();
        for (Object o15 : other.getUnderlyingElements()) {
            if (o15 instanceof byte[]) {
                byte[] b15 = (byte[])o15;
                this.list.add(Arrays.copyOf(b15, b15.length));
                continue;
            }
            this.list.add(o15);
        }
    }

    @Override
    public List<byte[]> asByteArrayList() {
        return new ByteArrayListView(this);
    }

    @Override
    public List<ByteString> asByteStringList() {
        return new ByteStringListView(this);
    }

    @Override
    public LazyStringList getUnmodifiableView() {
        if (this.isModifiable()) {
            return new UnmodifiableLazyStringList(this);
        }
        return this;
    }

    private static class ByteStringListView
    extends AbstractList<ByteString>
    implements RandomAccess {
        private final LazyStringArrayList list;

        ByteStringListView(LazyStringArrayList list2) {
            this.list = list2;
        }

        @Override
        public ByteString get(int index) {
            return this.list.getByteString(index);
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public ByteString set(int index, ByteString s15) {
            Object o15 = this.list.setAndReturn(index, s15);
            ++this.modCount;
            return LazyStringArrayList.asByteString(o15);
        }

        @Override
        public void add(int index, ByteString s15) {
            this.list.add(index, s15);
            ++this.modCount;
        }

        @Override
        public ByteString remove(int index) {
            String o15 = this.list.remove(index);
            ++this.modCount;
            return LazyStringArrayList.asByteString(o15);
        }
    }

    private static class ByteArrayListView
    extends AbstractList<byte[]>
    implements RandomAccess {
        private final LazyStringArrayList list;

        ByteArrayListView(LazyStringArrayList list2) {
            this.list = list2;
        }

        @Override
        public byte[] get(int index) {
            return this.list.getByteArray(index);
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public byte[] set(int index, byte[] s15) {
            Object o15 = this.list.setAndReturn(index, s15);
            ++this.modCount;
            return LazyStringArrayList.asByteArray(o15);
        }

        @Override
        public void add(int index, byte[] s15) {
            this.list.add(index, s15);
            ++this.modCount;
        }

        @Override
        public byte[] remove(int index) {
            String o15 = this.list.remove(index);
            ++this.modCount;
            return LazyStringArrayList.asByteArray(o15);
        }
    }
}

