/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Preconditions;
import com.google.common.hash.AbstractHashFunction;
import com.google.common.hash.AbstractHasher;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Immutable;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jspecify.annotations.Nullable;

@Immutable
final class Murmur3_32HashFunction
extends AbstractHashFunction
implements Serializable {
    static final HashFunction MURMUR3_32 = new Murmur3_32HashFunction(0, false);
    static final HashFunction MURMUR3_32_FIXED = new Murmur3_32HashFunction(0, true);
    static final HashFunction GOOD_FAST_HASH_32 = new Murmur3_32HashFunction(Hashing.GOOD_FAST_HASH_SEED, true);
    private static final int CHUNK_SIZE = 4;
    private static final int C1 = -862048943;
    private static final int C2 = 461845907;
    private final int seed;
    private final boolean supplementaryPlaneFix;
    private static final long serialVersionUID = 0L;

    Murmur3_32HashFunction(int seed, boolean supplementaryPlaneFix) {
        this.seed = seed;
        this.supplementaryPlaneFix = supplementaryPlaneFix;
    }

    @Override
    public int bits() {
        return 32;
    }

    @Override
    public Hasher newHasher() {
        return new Murmur3_32Hasher(this.seed);
    }

    public String toString() {
        return "Hashing.murmur3_32(" + this.seed + ")";
    }

    public boolean equals(@Nullable Object object) {
        if (object instanceof Murmur3_32HashFunction) {
            Murmur3_32HashFunction other = (Murmur3_32HashFunction)object;
            return this.seed == other.seed && this.supplementaryPlaneFix == other.supplementaryPlaneFix;
        }
        return false;
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.seed;
    }

    @Override
    public HashCode hashInt(int input) {
        int k15 = Murmur3_32HashFunction.mixK1(input);
        int h15 = Murmur3_32HashFunction.mixH1(this.seed, k15);
        return Murmur3_32HashFunction.fmix(h15, 4);
    }

    @Override
    public HashCode hashLong(long input) {
        int low = (int)input;
        int high = (int)(input >>> 32);
        int k15 = Murmur3_32HashFunction.mixK1(low);
        int h15 = Murmur3_32HashFunction.mixH1(this.seed, k15);
        k15 = Murmur3_32HashFunction.mixK1(high);
        h15 = Murmur3_32HashFunction.mixH1(h15, k15);
        return Murmur3_32HashFunction.fmix(h15, 8);
    }

    @Override
    public HashCode hashUnencodedChars(CharSequence input) {
        int h15 = this.seed;
        for (int i15 = 1; i15 < input.length(); i15 += 2) {
            int k15 = input.charAt(i15 - 1) | input.charAt(i15) << 16;
            k15 = Murmur3_32HashFunction.mixK1(k15);
            h15 = Murmur3_32HashFunction.mixH1(h15, k15);
        }
        if ((input.length() & 1) == 1) {
            int k16 = input.charAt(input.length() - 1);
            k16 = Murmur3_32HashFunction.mixK1(k16);
            h15 ^= k16;
        }
        return Murmur3_32HashFunction.fmix(h15, 2 * input.length());
    }

    @Override
    public HashCode hashString(CharSequence input, Charset charset) {
        if (charset.equals(StandardCharsets.UTF_8)) {
            int k15;
            int utf16Length = input.length();
            int h15 = this.seed;
            int i15 = 0;
            int len = 0;
            while (i15 + 4 <= utf16Length) {
                char c05 = input.charAt(i15);
                char c15 = input.charAt(i15 + 1);
                char c25 = input.charAt(i15 + 2);
                char c35 = input.charAt(i15 + 3);
                if (c05 >= '\u0080' || c15 >= '\u0080' || c25 >= '\u0080' || c35 >= '\u0080') break;
                k15 = c05 | c15 << 8 | c25 << 16 | c35 << 24;
                k15 = Murmur3_32HashFunction.mixK1(k15);
                h15 = Murmur3_32HashFunction.mixH1(h15, k15);
                i15 += 4;
                len += 4;
            }
            long buffer = 0L;
            int shift = 0;
            while (i15 < utf16Length) {
                char c15 = input.charAt(i15);
                if (c15 < '\u0080') {
                    buffer |= (long)c15 << shift;
                    shift += 8;
                    ++len;
                } else if (c15 < '\u0800') {
                    buffer |= Murmur3_32HashFunction.charToTwoUtf8Bytes(c15) << shift;
                    shift += 16;
                    len += 2;
                } else if (c15 < '\ud800' || c15 > '\udfff') {
                    buffer |= Murmur3_32HashFunction.charToThreeUtf8Bytes(c15) << shift;
                    shift += 24;
                    len += 3;
                } else {
                    int codePoint = Character.codePointAt(input, i15);
                    if (codePoint == c15) {
                        return this.hashBytes(input.toString().getBytes(charset));
                    }
                    ++i15;
                    buffer |= Murmur3_32HashFunction.codePointToFourUtf8Bytes(codePoint) << shift;
                    if (this.supplementaryPlaneFix) {
                        shift += 32;
                    }
                    len += 4;
                }
                if (shift >= 32) {
                    k15 = Murmur3_32HashFunction.mixK1((int)buffer);
                    h15 = Murmur3_32HashFunction.mixH1(h15, k15);
                    buffer >>>= 32;
                    shift -= 32;
                }
                ++i15;
            }
            int k16 = Murmur3_32HashFunction.mixK1((int)buffer);
            return Murmur3_32HashFunction.fmix(h15 ^= k16, len);
        }
        return this.hashBytes(input.toString().getBytes(charset));
    }

    @Override
    public HashCode hashBytes(byte[] input, int off, int len) {
        int k15;
        Preconditions.checkPositionIndexes(off, off + len, input.length);
        int h15 = this.seed;
        int i15 = 0;
        while (i15 + 4 <= len) {
            k15 = Murmur3_32HashFunction.mixK1(Murmur3_32HashFunction.getIntLittleEndian(input, off + i15));
            h15 = Murmur3_32HashFunction.mixH1(h15, k15);
            i15 += 4;
        }
        k15 = 0;
        int shift = 0;
        while (i15 < len) {
            k15 ^= Byte.toUnsignedInt(input[off + i15]) << shift;
            ++i15;
            shift += 8;
        }
        return Murmur3_32HashFunction.fmix(h15 ^= Murmur3_32HashFunction.mixK1(k15), len);
    }

    private static int getIntLittleEndian(byte[] input, int offset) {
        return Ints.fromBytes(input[offset + 3], input[offset + 2], input[offset + 1], input[offset]);
    }

    private static int mixK1(int k15) {
        k15 *= -862048943;
        k15 = Integer.rotateLeft(k15, 15);
        return k15 *= 461845907;
    }

    private static int mixH1(int h15, int k15) {
        h15 ^= k15;
        h15 = Integer.rotateLeft(h15, 13);
        h15 = h15 * 5 + -430675100;
        return h15;
    }

    private static HashCode fmix(int h15, int length) {
        h15 ^= length;
        h15 ^= h15 >>> 16;
        h15 *= -2048144789;
        h15 ^= h15 >>> 13;
        h15 *= -1028477387;
        h15 ^= h15 >>> 16;
        return HashCode.fromInt(h15);
    }

    private static long codePointToFourUtf8Bytes(int codePoint) {
        return 0xF0L | (long)(codePoint >>> 18) | (0x80L | (long)(0x3F & codePoint >>> 12)) << 8 | (0x80L | (long)(0x3F & codePoint >>> 6)) << 16 | (0x80L | (long)(0x3F & codePoint)) << 24;
    }

    private static long charToThreeUtf8Bytes(char c15) {
        return 0xE0L | (long)(c15 >>> 12) | (long)((0x80 | 0x3F & c15 >>> 6) << 8) | (long)((0x80 | 0x3F & c15) << 16);
    }

    private static long charToTwoUtf8Bytes(char c15) {
        return 0xC0L | (long)(c15 >>> 6) | (long)((0x80 | 0x3F & c15) << 8);
    }

    private static final class Murmur3_32Hasher
    extends AbstractHasher {
        private int h1;
        private long buffer;
        private int shift;
        private int length;
        private boolean isDone;

        Murmur3_32Hasher(int seed) {
            this.h1 = seed;
            this.length = 0;
            this.isDone = false;
        }

        private void update(int nBytes, long update) {
            this.buffer |= (update & 0xFFFFFFFFL) << this.shift;
            this.shift += nBytes * 8;
            this.length += nBytes;
            if (this.shift >= 32) {
                this.h1 = Murmur3_32HashFunction.mixH1(this.h1, Murmur3_32HashFunction.mixK1((int)this.buffer));
                this.buffer >>>= 32;
                this.shift -= 32;
            }
        }

        @Override
        @CanIgnoreReturnValue
        public Hasher putByte(byte b15) {
            this.update(1, b15 & 0xFF);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Hasher putBytes(byte[] bytes, int off, int len) {
            Preconditions.checkPositionIndexes(off, off + len, bytes.length);
            int i15 = 0;
            while (i15 + 4 <= len) {
                this.update(4, Murmur3_32HashFunction.getIntLittleEndian(bytes, off + i15));
                i15 += 4;
            }
            while (i15 < len) {
                this.putByte(bytes[off + i15]);
                ++i15;
            }
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Hasher putBytes(ByteBuffer buffer) {
            ByteOrder bo4 = buffer.order();
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            while (buffer.remaining() >= 4) {
                this.putInt(buffer.getInt());
            }
            while (buffer.hasRemaining()) {
                this.putByte(buffer.get());
            }
            buffer.order(bo4);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Hasher putInt(int i15) {
            this.update(4, i15);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Hasher putLong(long l15) {
            this.update(4, (int)l15);
            this.update(4, l15 >>> 32);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Hasher putChar(char c15) {
            this.update(2, c15);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Hasher putString(CharSequence input, Charset charset) {
            if (charset.equals(StandardCharsets.UTF_8)) {
                int utf16Length = input.length();
                int i15 = 0;
                while (i15 + 4 <= utf16Length) {
                    char c05 = input.charAt(i15);
                    char c15 = input.charAt(i15 + 1);
                    char c25 = input.charAt(i15 + 2);
                    char c35 = input.charAt(i15 + 3);
                    if (c05 >= '\u0080' || c15 >= '\u0080' || c25 >= '\u0080' || c35 >= '\u0080') break;
                    this.update(4, c05 | c15 << 8 | c25 << 16 | c35 << 24);
                    i15 += 4;
                }
                while (i15 < utf16Length) {
                    char c15 = input.charAt(i15);
                    if (c15 < '\u0080') {
                        this.update(1, c15);
                    } else if (c15 < '\u0800') {
                        this.update(2, Murmur3_32HashFunction.charToTwoUtf8Bytes(c15));
                    } else if (c15 < '\ud800' || c15 > '\udfff') {
                        this.update(3, Murmur3_32HashFunction.charToThreeUtf8Bytes(c15));
                    } else {
                        int codePoint = Character.codePointAt(input, i15);
                        if (codePoint == c15) {
                            this.putBytes(input.subSequence(i15, utf16Length).toString().getBytes(charset));
                            return this;
                        }
                        ++i15;
                        this.update(4, Murmur3_32HashFunction.codePointToFourUtf8Bytes(codePoint));
                    }
                    ++i15;
                }
                return this;
            }
            return super.putString(input, charset);
        }

        @Override
        public HashCode hash() {
            Preconditions.checkState(!this.isDone);
            this.isDone = true;
            this.h1 ^= Murmur3_32HashFunction.mixK1((int)this.buffer);
            return Murmur3_32HashFunction.fmix(this.h1, this.length);
        }
    }
}

