/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.util;

import com.github.weisj.jsvg.attributes.Animatable;
import com.github.weisj.jsvg.attributes.Inherited;
import com.github.weisj.jsvg.attributes.value.LengthValue;
import com.github.weisj.jsvg.attributes.value.PercentageDimension;
import com.github.weisj.jsvg.geometry.size.Length;
import com.github.weisj.jsvg.parser.impl.AttributeNode;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AttributeUtil {
    private AttributeUtil() {
    }

    @SafeVarargs
    public static <T> @NotNull T @Nullable [] toNonnullArray(T ... values2) {
        for (T value : values2) {
            if (value != null) continue;
            return null;
        }
        return values2;
    }

    @NotNull
    public static <T> T notNullOrElse(@Nullable T value, @NotNull T defaultValue) {
        return value != null ? value : defaultValue;
    }

    @NotNull
    public static AxisPair parseAxisPair(@NotNull AttributeNode node, @NotNull String xAttr, @NotNull String yAttr, @NotNull Length fallback, Inherited inherited, @NotNull @NotNull Function<@NotNull LengthValue, @Nullable LengthValue> validator) {
        LengthValue ry4;
        LengthValue rx4;
        LengthValue initialRx = node.getLength(xAttr, PercentageDimension.WIDTH, Length.UNSPECIFIED, inherited, Animatable.NO);
        if ((initialRx = validator.apply(initialRx)) == null) {
            initialRx = Length.UNSPECIFIED;
        }
        LengthValue initialRy = node.getLength(yAttr, PercentageDimension.HEIGHT, initialRx, inherited, Animatable.NO);
        if ((initialRy = validator.apply(initialRy)) == null) {
            initialRy = Length.UNSPECIFIED;
        }
        if (initialRx == Length.UNSPECIFIED && initialRy == Length.UNSPECIFIED) {
            rx4 = AttributeUtil.notNullOrElse(node.getAnimatedLength(xAttr, fallback, PercentageDimension.WIDTH), initialRx);
            ry4 = AttributeUtil.notNullOrElse(node.getAnimatedLength(yAttr, fallback, PercentageDimension.HEIGHT), initialRy);
            if (rx4 == Length.UNSPECIFIED) {
                rx4 = ry4;
            } else if (ry4 == Length.UNSPECIFIED) {
                ry4 = rx4;
            }
        } else if (initialRx == Length.UNSPECIFIED) {
            ry4 = AttributeUtil.notNullOrElse(node.getAnimatedLength(yAttr, initialRy, PercentageDimension.HEIGHT), initialRy);
            rx4 = AttributeUtil.notNullOrElse(node.getAnimatedLength(xAttr, ry4, PercentageDimension.WIDTH), ry4);
        } else if (initialRy == Length.UNSPECIFIED) {
            rx4 = AttributeUtil.notNullOrElse(node.getAnimatedLength(xAttr, initialRx, PercentageDimension.WIDTH), initialRx);
            ry4 = AttributeUtil.notNullOrElse(node.getAnimatedLength(yAttr, rx4, PercentageDimension.HEIGHT), rx4);
        } else {
            rx4 = AttributeUtil.notNullOrElse(node.getAnimatedLength(xAttr, initialRx, PercentageDimension.WIDTH), initialRx);
            ry4 = AttributeUtil.notNullOrElse(node.getAnimatedLength(yAttr, initialRy, PercentageDimension.HEIGHT), initialRy);
        }
        if (rx4 == Length.UNSPECIFIED) {
            rx4 = fallback;
        }
        if (ry4 == Length.UNSPECIFIED) {
            ry4 = fallback;
        }
        return new AxisPair(rx4, ry4);
    }

    @Contract(pure=true)
    public static <T> boolean arrayContains(T @NotNull [] arr, T element) {
        for (T t15 : arr) {
            if (!Objects.equals(t15, element)) continue;
            return true;
        }
        return false;
    }

    public static final class AxisPair {
        @NotNull
        private final LengthValue xAxis;
        @NotNull
        private final LengthValue yAxis;

        public AxisPair(@NotNull LengthValue xAxis, @NotNull LengthValue yAxis) {
            this.xAxis = xAxis;
            this.yAxis = yAxis;
        }

        @NotNull
        public LengthValue xAxis() {
            return this.xAxis;
        }

        @NotNull
        public LengthValue yAxis() {
            return this.yAxis;
        }
    }
}

