/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.FlatClientProperties;
import com.formdev.flatlaf.ui.FlatNativeMacLibrary;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.SystemInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

class FullWindowContentSupport {
    private static final String KEY_DEBUG_SHOW_PLACEHOLDERS = "FlatLaf.debug.panel.showPlaceholders";
    private static ArrayList<WeakReference<JComponent>> placeholders = new ArrayList();

    FullWindowContentSupport() {
    }

    static Dimension getPlaceholderPreferredSize(JComponent c15, String options) {
        Rectangle r15;
        Rectangle bounds;
        JRootPane rootPane;
        if (!options.startsWith(SystemInfo.isMacOS ? "mac" : "win") || !c15.isDisplayable() || (rootPane = SwingUtilities.getRootPane(c15)) == null || (bounds = (Rectangle)rootPane.getClientProperty("FlatLaf.fullWindowContent.buttonsBounds")) == null) {
            return new Dimension(0, 0);
        }
        if (options.length() > 3 && (options.contains("leftToRight") && !c15.getComponentOrientation().isLeftToRight() || options.contains("rightToLeft") && c15.getComponentOrientation().isLeftToRight())) {
            return new Dimension(0, 0);
        }
        if (SystemInfo.isMacFullWindowContentSupported && FlatNativeMacLibrary.isLoaded() && (r15 = FlatNativeMacLibrary.getWindowButtonsBounds(SwingUtilities.windowForComponent(c15))) != null) {
            bounds = r15;
        }
        int width = bounds.width;
        int height = bounds.height;
        if (options.length() > 3) {
            if (width == 0 && options.contains("zeroInFullScreen")) {
                height = 0;
            }
            if (options.contains("horizontal")) {
                height = 0;
            }
            if (options.contains("vertical")) {
                width = 0;
            }
        }
        return new Dimension(width, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void registerPlaceholder(JComponent c15) {
        ArrayList<WeakReference<JComponent>> arrayList = placeholders;
        synchronized (arrayList) {
            if (FullWindowContentSupport.indexOfPlaceholder(c15) < 0) {
                placeholders.add(new WeakReference<JComponent>(c15));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unregisterPlaceholder(JComponent c15) {
        ArrayList<WeakReference<JComponent>> arrayList = placeholders;
        synchronized (arrayList) {
            int index = FullWindowContentSupport.indexOfPlaceholder(c15);
            if (index >= 0) {
                placeholders.remove(index);
            }
        }
    }

    private static int indexOfPlaceholder(JComponent c15) {
        int size = placeholders.size();
        for (int i15 = 0; i15 < size; ++i15) {
            if (placeholders.get(i15).get() != c15) continue;
            return i15;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void revalidatePlaceholders(Component container) {
        ArrayList<WeakReference<JComponent>> arrayList = placeholders;
        synchronized (arrayList) {
            if (placeholders.isEmpty()) {
                return;
            }
            Iterator<WeakReference<JComponent>> it = placeholders.iterator();
            while (it.hasNext()) {
                WeakReference<JComponent> ref = it.next();
                JComponent c15 = (JComponent)ref.get();
                if (c15 == null) {
                    it.remove();
                    continue;
                }
                if (!SwingUtilities.isDescendingFrom(c15, container)) continue;
                c15.revalidate();
            }
        }
    }

    static ComponentListener macInstallListeners(final JRootPane rootPane) {
        ComponentAdapter l15 = new ComponentAdapter(){
            boolean lastFullScreen;

            @Override
            public void componentResized(ComponentEvent e15) {
                boolean fullScreen;
                Window window = SwingUtilities.windowForComponent(rootPane);
                if (window == null) {
                    return;
                }
                boolean bl4 = fullScreen = FlatNativeMacLibrary.isLoaded() && FlatNativeMacLibrary.isWindowFullScreen(window);
                if (fullScreen == this.lastFullScreen) {
                    return;
                }
                this.lastFullScreen = fullScreen;
                FullWindowContentSupport.macUpdateFullWindowContentButtonsBoundsProperty(rootPane);
            }
        };
        rootPane.addComponentListener(l15);
        return l15;
    }

    static void macUninstallListeners(JRootPane rootPane, ComponentListener l15) {
        if (l15 != null) {
            rootPane.removeComponentListener(l15);
        }
    }

    static void macUpdateFullWindowContentButtonsBoundsProperty(JRootPane rootPane) {
        if (!SystemInfo.isMacFullWindowContentSupported || !rootPane.isDisplayable()) {
            return;
        }
        Rectangle bounds = null;
        if (FlatClientProperties.clientPropertyBoolean(rootPane, "apple.awt.fullWindowContent", false)) {
            bounds = FlatNativeMacLibrary.isLoaded() ? FlatNativeMacLibrary.getWindowButtonsBounds(SwingUtilities.windowForComponent(rootPane)) : new Rectangle(68, 28);
        }
        rootPane.putClientProperty("FlatLaf.fullWindowContent.buttonsBounds", bounds);
    }

    static void macUninstallFullWindowContentButtonsBoundsProperty(JRootPane rootPane) {
        if (!SystemInfo.isMacFullWindowContentSupported) {
            return;
        }
        rootPane.putClientProperty("FlatLaf.fullWindowContent.buttonsBounds", null);
    }

    static void debugPaint(Graphics g15, JComponent c15) {
        Rectangle bounds;
        if (!UIManager.getBoolean(KEY_DEBUG_SHOW_PLACEHOLDERS)) {
            return;
        }
        int width = c15.getWidth();
        int height = c15.getHeight();
        if (width <= 0 || height <= 0) {
            return;
        }
        g15.setColor(Color.red);
        FullWindowContentSupport.debugPaintRect(g15, new Rectangle(width, height));
        JRootPane rootPane = SwingUtilities.getRootPane(c15);
        if (rootPane != null && (bounds = (Rectangle)rootPane.getClientProperty("FlatLaf.fullWindowContent.buttonsBounds")) != null && (bounds.width != width || bounds.height != height)) {
            g15.setColor(Color.magenta);
            FullWindowContentSupport.debugPaintRect(g15, SwingUtilities.convertRectangle(rootPane, bounds, c15));
        }
    }

    private static void debugPaintRect(Graphics g15, Rectangle r15) {
        g15.drawRect(r15.x, r15.y, r15.width - 1, r15.height - 1);
        int x25 = r15.x + r15.width - 1;
        int y25 = r15.y + r15.height - 1;
        Object[] oldRenderingHints = FlatUIUtils.setRenderingHints(g15);
        g15.drawLine(r15.x, r15.y, x25, y25);
        g15.drawLine(r15.x, y25, x25, r15.y);
        FlatUIUtils.resetRenderingHints(g15, oldRenderingHints);
    }
}

