/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.commands;

import com.android.aapt.Resources;
import com.android.bundle.Config;
import com.android.bundle.RuntimeEnabledSdkConfigProto;
import com.android.tools.build.bundletool.commands.DumpManagerUtils;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.BundleModuleName;
import com.android.tools.build.bundletool.model.ResourceTableEntry;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.utils.ZipUtils;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoNode;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.zip.ZipFile;

final class DumpManager {
    private final PrintStream printStream;
    private final Path bundlePath;

    DumpManager(OutputStream outputStream, Path bundlePath) {
        this.printStream = new PrintStream(outputStream);
        this.bundlePath = bundlePath;
    }

    void printManifest(BundleModuleName moduleName, Optional<String> xPathExpression) {
        ZipPath manifestPath = ZipPath.create(moduleName.getName()).resolve(BundleModule.SpecialModuleEntry.ANDROID_MANIFEST.getPath());
        XmlProtoNode manifestProto = new XmlProtoNode(DumpManagerUtils.extractAndParseFromAppBundle(this.bundlePath, manifestPath, Resources.XmlNode::parseFrom));
        DumpManagerUtils.printManifest(manifestProto, xPathExpression, this.printStream);
    }

    void printResources(Predicate<ResourceTableEntry> resourcePredicate, boolean printValues) {
        ImmutableList<Resources.ResourceTable> resourceTables;
        try (ZipFile zipFile = new ZipFile(this.bundlePath.toFile());){
            resourceTables = ZipUtils.allFileEntriesPaths(zipFile).filter(path -> path.endsWith(BundleModule.SpecialModuleEntry.RESOURCE_TABLE.getPath())).map(path -> DumpManagerUtils.extractAndParse(zipFile, path, Resources.ResourceTable::parseFrom)).collect(ImmutableList.toImmutableList());
        }
        catch (IOException e15) {
            throw new UncheckedIOException("Error occurred when reading the bundle.", e15);
        }
        DumpManagerUtils.printResources(resourcePredicate, printValues, resourceTables, this.printStream);
    }

    void printBundleConfig() {
        try (ZipFile zipFile = new ZipFile(this.bundlePath.toFile());){
            Config.BundleConfig bundleConfig = DumpManagerUtils.extractAndParse(zipFile, ZipPath.create("BundleConfig.pb"), Config.BundleConfig::parseFrom);
            DumpManagerUtils.printBundleConfig(bundleConfig, this.printStream);
        }
        catch (IOException e15) {
            throw new UncheckedIOException("Error occurred when reading the bundle.", e15);
        }
    }

    void printRuntimeEnabledSdkConfig() {
        try (ZipFile zipFile = new ZipFile(this.bundlePath.toFile());){
            AppBundle appBundle = AppBundle.buildFromZip(zipFile);
            RuntimeEnabledSdkConfigProto.RuntimeEnabledSdkConfig allRuntimeEnabledSdks = RuntimeEnabledSdkConfigProto.RuntimeEnabledSdkConfig.newBuilder().addAllRuntimeEnabledSdk(appBundle.getRuntimeEnabledSdkDependencies().values()).build();
            this.printStream.println(JsonFormat.printer().print((MessageOrBuilder)allRuntimeEnabledSdks));
        }
        catch (IOException e15) {
            throw new UncheckedIOException("Error occurred when reading the bundle.", e15);
        }
    }
}

