/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.util;

public final class Hex {
    private Hex() {
    }

    public static String u8(long v15) {
        char[] result = new char[16];
        for (int i15 = 0; i15 < 16; ++i15) {
            result[15 - i15] = Character.forDigit((int)v15 & 0xF, 16);
            v15 >>= 4;
        }
        return new String(result);
    }

    public static String u4(int v15) {
        char[] result = new char[8];
        for (int i15 = 0; i15 < 8; ++i15) {
            result[7 - i15] = Character.forDigit(v15 & 0xF, 16);
            v15 >>= 4;
        }
        return new String(result);
    }

    public static String u3(int v15) {
        char[] result = new char[6];
        for (int i15 = 0; i15 < 6; ++i15) {
            result[5 - i15] = Character.forDigit(v15 & 0xF, 16);
            v15 >>= 4;
        }
        return new String(result);
    }

    public static String u2(int v15) {
        char[] result = new char[4];
        for (int i15 = 0; i15 < 4; ++i15) {
            result[3 - i15] = Character.forDigit(v15 & 0xF, 16);
            v15 >>= 4;
        }
        return new String(result);
    }

    public static String u2or4(int v15) {
        if (v15 == (char)v15) {
            return Hex.u2(v15);
        }
        return Hex.u4(v15);
    }

    public static String u1(int v15) {
        char[] result = new char[2];
        for (int i15 = 0; i15 < 2; ++i15) {
            result[1 - i15] = Character.forDigit(v15 & 0xF, 16);
            v15 >>= 4;
        }
        return new String(result);
    }

    public static String uNibble(int v15) {
        char[] result = new char[]{Character.forDigit(v15 & 0xF, 16)};
        return new String(result);
    }

    public static String s8(long v15) {
        char[] result = new char[17];
        if (v15 < 0L) {
            result[0] = 45;
            v15 = -v15;
        } else {
            result[0] = 43;
        }
        for (int i15 = 0; i15 < 16; ++i15) {
            result[16 - i15] = Character.forDigit((int)v15 & 0xF, 16);
            v15 >>= 4;
        }
        return new String(result);
    }

    public static String s4(int v15) {
        char[] result = new char[9];
        if (v15 < 0) {
            result[0] = 45;
            v15 = -v15;
        } else {
            result[0] = 43;
        }
        for (int i15 = 0; i15 < 8; ++i15) {
            result[8 - i15] = Character.forDigit(v15 & 0xF, 16);
            v15 >>= 4;
        }
        return new String(result);
    }

    public static String s2(int v15) {
        char[] result = new char[5];
        if (v15 < 0) {
            result[0] = 45;
            v15 = -v15;
        } else {
            result[0] = 43;
        }
        for (int i15 = 0; i15 < 4; ++i15) {
            result[4 - i15] = Character.forDigit(v15 & 0xF, 16);
            v15 >>= 4;
        }
        return new String(result);
    }

    public static String s1(int v15) {
        char[] result = new char[3];
        if (v15 < 0) {
            result[0] = 45;
            v15 = -v15;
        } else {
            result[0] = 43;
        }
        for (int i15 = 0; i15 < 2; ++i15) {
            result[2 - i15] = Character.forDigit(v15 & 0xF, 16);
            v15 >>= 4;
        }
        return new String(result);
    }

    public static String dump(byte[] arr, int offset, int length, int outOffset, int bpl, int addressLength) {
        int end = offset + length;
        if ((offset | length | end) < 0 || end > arr.length) {
            throw new IndexOutOfBoundsException("arr.length " + arr.length + "; " + offset + "..!" + end);
        }
        if (outOffset < 0) {
            throw new IllegalArgumentException("outOffset < 0");
        }
        if (length == 0) {
            return "";
        }
        StringBuilder sb5 = new StringBuilder(length * 4 + 6);
        boolean bol = true;
        int col = 0;
        while (length > 0) {
            if (col == 0) {
                String astr;
                switch (addressLength) {
                    case 2: {
                        astr = Hex.u1(outOffset);
                        break;
                    }
                    case 4: {
                        astr = Hex.u2(outOffset);
                        break;
                    }
                    case 6: {
                        astr = Hex.u3(outOffset);
                        break;
                    }
                    default: {
                        astr = Hex.u4(outOffset);
                    }
                }
                sb5.append(astr);
                sb5.append(": ");
            } else if (!(col & true)) {
                sb5.append(' ');
            }
            sb5.append(Hex.u1(arr[offset]));
            ++outOffset;
            ++offset;
            if (++col == bpl) {
                sb5.append('\n');
                col = 0;
            }
            --length;
        }
        if (col != 0) {
            sb5.append('\n');
        }
        return sb5.toString();
    }
}

