/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.util;

import com.android.dx.util.MutabilityControl;
import com.android.dx.util.ToHuman;
import java.util.Arrays;

public class FixedSizeList
extends MutabilityControl
implements ToHuman {
    private Object[] arr;

    public FixedSizeList(int size) {
        super(size != 0);
        try {
            this.arr = new Object[size];
        }
        catch (NegativeArraySizeException ex4) {
            throw new IllegalArgumentException("size < 0");
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        FixedSizeList list2 = (FixedSizeList)other;
        return Arrays.equals(this.arr, list2.arr);
    }

    public int hashCode() {
        return Arrays.hashCode(this.arr);
    }

    public String toString() {
        String name = this.getClass().getName();
        return this.toString0(name.substring(name.lastIndexOf(46) + 1) + '{', ", ", "}", false);
    }

    @Override
    public String toHuman() {
        String name = this.getClass().getName();
        return this.toString0(name.substring(name.lastIndexOf(46) + 1) + '{', ", ", "}", true);
    }

    public String toString(String prefix, String separator, String suffix) {
        return this.toString0(prefix, separator, suffix, false);
    }

    public String toHuman(String prefix, String separator, String suffix) {
        return this.toString0(prefix, separator, suffix, true);
    }

    public final int size() {
        return this.arr.length;
    }

    public void shrinkToFit() {
        int sz4 = this.arr.length;
        int newSz = 0;
        for (int i15 = 0; i15 < sz4; ++i15) {
            if (this.arr[i15] == null) continue;
            ++newSz;
        }
        if (sz4 == newSz) {
            return;
        }
        this.throwIfImmutable();
        Object[] newa = new Object[newSz];
        int at4 = 0;
        for (int i16 = 0; i16 < sz4; ++i16) {
            Object one = this.arr[i16];
            if (one == null) continue;
            newa[at4] = one;
            ++at4;
        }
        this.arr = newa;
        if (newSz == 0) {
            this.setImmutable();
        }
    }

    protected final Object get0(int n15) {
        try {
            Object result = this.arr[n15];
            if (result == null) {
                throw new NullPointerException("unset: " + n15);
            }
            return result;
        }
        catch (ArrayIndexOutOfBoundsException ex4) {
            return this.throwIndex(n15);
        }
    }

    protected final Object getOrNull0(int n15) {
        return this.arr[n15];
    }

    protected final void set0(int n15, Object obj) {
        this.throwIfImmutable();
        try {
            this.arr[n15] = obj;
        }
        catch (ArrayIndexOutOfBoundsException ex4) {
            this.throwIndex(n15);
        }
    }

    private Object throwIndex(int n15) {
        if (n15 < 0) {
            throw new IndexOutOfBoundsException("n < 0");
        }
        throw new IndexOutOfBoundsException("n >= size()");
    }

    private String toString0(String prefix, String separator, String suffix, boolean human) {
        int len = this.arr.length;
        StringBuilder sb5 = new StringBuilder(len * 10 + 10);
        if (prefix != null) {
            sb5.append(prefix);
        }
        for (int i15 = 0; i15 < len; ++i15) {
            if (i15 != 0 && separator != null) {
                sb5.append(separator);
            }
            if (human) {
                sb5.append(((ToHuman)this.arr[i15]).toHuman());
                continue;
            }
            sb5.append(this.arr[i15]);
        }
        if (suffix != null) {
            sb5.append(suffix);
        }
        return sb5.toString();
    }
}

