/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.file;

import com.android.dex.util.ExceptionWithContext;
import com.android.dx.dex.file.DexFile;
import com.android.dx.dex.file.Item;
import com.android.dx.dex.file.ItemType;
import com.android.dx.dex.file.OffsettedItem;
import com.android.dx.dex.file.Section;
import com.android.dx.util.AnnotatedOutput;
import com.android.dx.util.Hex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;

public final class MixedItemSection
extends Section {
    private static final Comparator<OffsettedItem> TYPE_SORTER = new Comparator<OffsettedItem>(){

        @Override
        public int compare(OffsettedItem item1, OffsettedItem item2) {
            ItemType type1 = item1.itemType();
            ItemType type2 = item2.itemType();
            return type1.compareTo(type2);
        }
    };
    private final ArrayList<OffsettedItem> items = new ArrayList(100);
    private final HashMap<OffsettedItem, OffsettedItem> interns = new HashMap(100);
    private final SortType sort;
    private int writeSize;

    public MixedItemSection(String name, DexFile file2, int alignment, SortType sort) {
        super(name, file2, alignment);
        this.sort = sort;
        this.writeSize = -1;
    }

    @Override
    public Collection<? extends Item> items() {
        return this.items;
    }

    @Override
    public int writeSize() {
        this.throwIfNotPrepared();
        return this.writeSize;
    }

    @Override
    public int getAbsoluteItemOffset(Item item) {
        OffsettedItem oi4 = (OffsettedItem)item;
        return oi4.getAbsoluteOffset();
    }

    public int size() {
        return this.items.size();
    }

    public void writeHeaderPart(AnnotatedOutput out) {
        this.throwIfNotPrepared();
        if (this.writeSize == -1) {
            throw new RuntimeException("write size not yet set");
        }
        int sz4 = this.writeSize;
        int offset = sz4 == 0 ? 0 : this.getFileOffset();
        String name = this.getName();
        if (name == null) {
            name = "<unnamed>";
        }
        int spaceCount = 15 - name.length();
        char[] spaceArr = new char[spaceCount];
        Arrays.fill(spaceArr, ' ');
        String spaces = new String(spaceArr);
        if (out.annotates()) {
            out.annotate(4, name + "_size:" + spaces + Hex.u4(sz4));
            out.annotate(4, name + "_off: " + spaces + Hex.u4(offset));
        }
        out.writeInt(sz4);
        out.writeInt(offset);
    }

    public void add(OffsettedItem item) {
        this.throwIfPrepared();
        try {
            if (item.getAlignment() > this.getAlignment()) {
                throw new IllegalArgumentException("incompatible item alignment");
            }
        }
        catch (NullPointerException ex4) {
            throw new NullPointerException("item == null");
        }
        this.items.add(item);
    }

    public synchronized <T extends OffsettedItem> T intern(T item) {
        this.throwIfPrepared();
        OffsettedItem result = this.interns.get(item);
        if (result != null) {
            return (T)result;
        }
        this.add(item);
        this.interns.put(item, item);
        return item;
    }

    public <T extends OffsettedItem> T get(T item) {
        this.throwIfNotPrepared();
        OffsettedItem result = this.interns.get(item);
        if (result != null) {
            return (T)result;
        }
        throw new NoSuchElementException(item.toString());
    }

    public void writeIndexAnnotation(AnnotatedOutput out, ItemType itemType, String intro) {
        String label;
        this.throwIfNotPrepared();
        TreeMap<String, OffsettedItem> index = new TreeMap<String, OffsettedItem>();
        for (OffsettedItem offsettedItem : this.items) {
            if (offsettedItem.itemType() != itemType) continue;
            label = offsettedItem.toHuman();
            index.put(label, offsettedItem);
        }
        if (index.size() == 0) {
            return;
        }
        out.annotate(0, intro);
        for (Map.Entry entry : index.entrySet()) {
            label = (String)entry.getKey();
            OffsettedItem item = (OffsettedItem)entry.getValue();
            out.annotate(0, item.offsetString() + ' ' + label + '\n');
        }
    }

    @Override
    protected void prepare0() {
        int sz4;
        DexFile file2 = this.getFile();
        int i15 = 0;
        while (i15 < (sz4 = this.items.size())) {
            while (i15 < sz4) {
                OffsettedItem one = this.items.get(i15);
                one.addContents(file2);
                ++i15;
            }
        }
    }

    public void placeItems() {
        this.throwIfNotPrepared();
        switch (this.sort.ordinal()) {
            case 2: {
                Collections.sort(this.items);
                break;
            }
            case 1: {
                Collections.sort(this.items, TYPE_SORTER);
            }
        }
        int sz4 = this.items.size();
        int outAt = 0;
        for (int i15 = 0; i15 < sz4; ++i15) {
            OffsettedItem one = this.items.get(i15);
            try {
                int placedAt = one.place(this, outAt);
                if (placedAt < outAt) {
                    throw new RuntimeException("bogus place() result for " + one);
                }
                outAt = placedAt + one.writeSize();
                continue;
            }
            catch (RuntimeException ex4) {
                throw ExceptionWithContext.withContext(ex4, "...while placing " + one);
            }
        }
        this.writeSize = outAt;
    }

    @Override
    protected void writeTo0(AnnotatedOutput out) {
        boolean annotates = out.annotates();
        boolean first = true;
        DexFile file2 = this.getFile();
        int at4 = 0;
        for (OffsettedItem one : this.items) {
            int alignMask;
            int writeAt;
            if (annotates) {
                if (first) {
                    first = false;
                } else {
                    out.annotate(0, "\n");
                }
            }
            if (at4 != (writeAt = at4 + (alignMask = one.getAlignment() - 1) & ~alignMask)) {
                out.writeZeroes(writeAt - at4);
                at4 = writeAt;
            }
            one.writeTo(file2, out);
            at4 += one.writeSize();
        }
        if (at4 != this.writeSize) {
            throw new RuntimeException("output size mismatch");
        }
    }

    static enum SortType {
        NONE,
        TYPE,
        INSTANCE;

    }
}

