/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.domain;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.ChainableFunction;
import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.Dependency;
import com.tngtech.archunit.core.domain.JavaAnnotation;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.properties.HasAnnotations;
import com.tngtech.archunit.core.domain.properties.HasName;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.base.Splitter;
import com.tngtech.archunit.thirdparty.com.google.common.collect.HashMultimap;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableCollection;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableMap;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Iterables;
import com.tngtech.archunit.thirdparty.com.google.common.collect.SetMultimap;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

@PublicAPI(usage=PublicAPI.Usage.ACCESS)
public final class JavaPackage
implements HasName,
HasAnnotations<JavaPackage> {
    private final String name;
    private final String relativeName;
    private final Set<JavaClass> classes;
    private final Optional<JavaClass> packageInfo;
    private final Map<String, JavaPackage> subpackages;
    private Optional<JavaPackage> parent = Optional.empty();
    private final Function<? super JavaAnnotation<JavaClass>, JavaAnnotation<JavaPackage>> withSelfAsOwner = input -> input.withOwner(this);

    private JavaPackage(String name, Set<JavaClass> classes, Map<String, JavaPackage> subpackages) {
        this.name = Preconditions.checkNotNull(name);
        this.relativeName = name.substring(name.lastIndexOf(".") + 1);
        this.classes = ImmutableSet.copyOf(classes);
        this.packageInfo = this.tryGetClassWithSimpleName("package-info");
        this.subpackages = ImmutableMap.copyOf(subpackages);
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public String getName() {
        return this.name;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public String getRelativeName() {
        return this.relativeName;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public HasAnnotations<?> getPackageInfo() {
        Optional<HasAnnotations<?>> packageInfo = this.tryGetPackageInfo();
        if (!packageInfo.isPresent()) {
            throw new IllegalArgumentException(String.format("%s does not contain a package-info.java", this.getDescription()));
        }
        return packageInfo.get();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Optional<? extends HasAnnotations<?>> tryGetPackageInfo() {
        return this.packageInfo;
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<? extends JavaAnnotation<JavaPackage>> getAnnotations() {
        return this.packageInfo.map(it -> it.getAnnotations().stream().map(this.withSelfAsOwner).collect(Collectors.toSet())).orElse(Collections.emptySet());
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public <A extends Annotation> A getAnnotationOfType(Class<A> type) {
        return this.getAnnotationOfType(type.getName()).as(type);
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaAnnotation<JavaPackage> getAnnotationOfType(String typeName) {
        Optional<JavaAnnotation<JavaPackage>> annotation = this.tryGetAnnotationOfType(typeName);
        if (!annotation.isPresent()) {
            throw new IllegalArgumentException(String.format("%s is not annotated with @%s", this.getDescription(), typeName));
        }
        return annotation.get();
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public <A extends Annotation> Optional<A> tryGetAnnotationOfType(Class<A> type) {
        if (this.packageInfo.isPresent()) {
            return this.packageInfo.get().tryGetAnnotationOfType(type);
        }
        return Optional.empty();
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Optional<JavaAnnotation<JavaPackage>> tryGetAnnotationOfType(String typeName) {
        return this.packageInfo.flatMap(it -> it.tryGetAnnotationOfType(typeName).map(this.withSelfAsOwner));
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isAnnotatedWith(Class<? extends Annotation> annotationType) {
        return this.packageInfo.map(it -> it.isAnnotatedWith(annotationType)).orElse(false);
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isAnnotatedWith(String annotationTypeName) {
        return this.packageInfo.map(it -> it.isAnnotatedWith(annotationTypeName)).orElse(false);
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isAnnotatedWith(DescribedPredicate<? super JavaAnnotation<?>> predicate) {
        return this.packageInfo.map(it -> it.isAnnotatedWith(predicate)).orElse(false);
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isMetaAnnotatedWith(Class<? extends Annotation> annotationType) {
        return this.packageInfo.map(it -> it.isMetaAnnotatedWith(annotationType)).orElse(false);
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isMetaAnnotatedWith(String annotationTypeName) {
        return this.packageInfo.map(it -> it.isMetaAnnotatedWith(annotationTypeName)).orElse(false);
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isMetaAnnotatedWith(DescribedPredicate<? super JavaAnnotation<?>> predicate) {
        return this.packageInfo.map(it -> it.isMetaAnnotatedWith(predicate)).orElse(false);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Optional<JavaPackage> getParent() {
        return this.parent;
    }

    private void setParent(JavaPackage parent) {
        this.parent = Optional.of(parent);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaClass> getClasses() {
        return this.classes;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaClass> getClassesInPackageTree() {
        ImmutableCollection.Builder result = ImmutableSet.builder().addAll(this.classes);
        for (JavaPackage subpackage : this.getSubpackages()) {
            ((ImmutableSet.Builder)result).addAll(subpackage.getClassesInPackageTree());
        }
        return ((ImmutableSet.Builder)result).build();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaPackage> getSubpackages() {
        return ImmutableSet.copyOf(this.subpackages.values());
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaPackage> getSubpackagesInTree() {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (JavaPackage subpackage : this.getSubpackages()) {
            result.add(subpackage);
            result.addAll(subpackage.getSubpackagesInTree());
        }
        return result.build();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean containsClass(JavaClass clazz) {
        return this.classes.contains(clazz);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean containsClass(Class<?> clazz) {
        return this.containsClassWithFullyQualifiedName(clazz.getName());
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaClass getClass(Class<?> clazz) {
        return this.getClassWithFullyQualifiedName(clazz.getName());
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean containsClassWithFullyQualifiedName(String className) {
        return this.tryGetClassWithFullyQualifiedName(className).isPresent();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaClass getClassWithFullyQualifiedName(String className) {
        return this.getValue(this.tryGetClassWithFullyQualifiedName(className), "This package does not contain any class with fully qualified name '%s'", className);
    }

    private Optional<JavaClass> tryGetClassWithFullyQualifiedName(String className) {
        return this.tryGetClassWith(HasName.Functions.GET_NAME.is(DescribedPredicate.equalTo(className)));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean containsClassWithSimpleName(String className) {
        return this.tryGetClassWithSimpleName(className).isPresent();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaClass getClassWithSimpleName(String className) {
        return this.getValue(this.tryGetClassWithSimpleName(className), "This package does not contain any class with simple name '%s'", className);
    }

    private Optional<JavaClass> tryGetClassWithSimpleName(String className) {
        return this.tryGetClassWith(JavaClass.Functions.GET_SIMPLE_NAME.is(DescribedPredicate.equalTo(className)));
    }

    private Optional<JavaClass> tryGetClassWith(DescribedPredicate<? super JavaClass> predicate) {
        Set<JavaClass> matching = this.getClassesWith(predicate);
        return matching.size() == 1 ? Optional.of(Iterables.getOnlyElement(matching)) : Optional.empty();
    }

    private Set<JavaClass> getClassesWith(Predicate<? super JavaClass> predicate) {
        return this.classes.stream().filter(predicate).collect(Collectors.toSet());
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean containsPackage(String packageName) {
        return this.tryGetPackage(packageName).isPresent();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaPackage getPackage(String packageName) {
        return this.getValue(this.tryGetPackage(packageName), "This package does not contain any sub package '%s'", packageName);
    }

    private Optional<JavaPackage> tryGetPackage(String packageName) {
        LinkedList<String> packageParts = new LinkedList<String>(Splitter.on('.').splitToList(packageName));
        return this.tryGetPackage(this, packageParts);
    }

    private Optional<JavaPackage> tryGetPackage(JavaPackage currentPackage, Deque<String> packageParts) {
        if (packageParts.isEmpty()) {
            return Optional.of(currentPackage);
        }
        String next = packageParts.poll();
        JavaPackage child = this.subpackages.get(next);
        return child != null ? child.tryGetPackage(child, packageParts) : Optional.empty();
    }

    private <T> T getValue(Optional<T> optional, String errorMessageTemplate, Object ... messageParams) {
        Preconditions.checkArgument(optional.isPresent(), errorMessageTemplate, messageParams);
        return optional.get();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<Dependency> getClassDependenciesFromThisPackage() {
        return JavaPackage.getClassDependenciesFrom(this.getClasses());
    }

    private static Set<Dependency> getClassDependenciesFrom(Set<JavaClass> classes) {
        return classes.stream().flatMap(javaClass -> javaClass.getDirectDependenciesFromSelf().stream()).filter(dependency -> !classes.contains(dependency.getTargetClass())).collect(ImmutableSet.toImmutableSet());
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<Dependency> getClassDependenciesFromThisPackageTree() {
        return JavaPackage.getClassDependenciesFrom(this.getClassesInPackageTree());
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<Dependency> getClassDependenciesToThisPackage() {
        return JavaPackage.getClassDependenciesTo(this.getClasses());
    }

    private static ImmutableSet<Dependency> getClassDependenciesTo(Set<JavaClass> classes) {
        return classes.stream().flatMap(javaClass -> javaClass.getDirectDependenciesToSelf().stream()).filter(dependency -> !classes.contains(dependency.getOriginClass())).collect(ImmutableSet.toImmutableSet());
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<Dependency> getClassDependenciesToThisPackageTree() {
        return JavaPackage.getClassDependenciesTo(this.getClassesInPackageTree());
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaPackage> getPackageDependenciesFromThisPackage() {
        return this.getPackageDependencies(this.getClassDependenciesFromThisPackage(), Dependency::getTargetClass);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaPackage> getPackageDependenciesFromThisPackageTree() {
        return this.getPackageDependencies(this.getClassDependenciesFromThisPackageTree(), Dependency::getTargetClass);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaPackage> getPackageDependenciesToThisPackage() {
        return this.getPackageDependencies(this.getClassDependenciesToThisPackage(), Dependency::getOriginClass);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaPackage> getPackageDependenciesToThisPackageTree() {
        return this.getPackageDependencies(this.getClassDependenciesToThisPackageTree(), Dependency::getOriginClass);
    }

    private Set<JavaPackage> getPackageDependencies(Set<Dependency> dependencies, Function<Dependency, JavaClass> javaClassFromDependency) {
        return dependencies.stream().map(javaClassFromDependency).map(JavaClass::getPackage).collect(ImmutableSet.toImmutableSet());
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public void traversePackageTree(Predicate<? super JavaClass> predicate, ClassVisitor visitor) {
        for (JavaClass javaClass : this.getClassesWith(predicate)) {
            visitor.visit(javaClass);
        }
        for (JavaPackage subpackage : this.getSubpackages()) {
            subpackage.traversePackageTree(predicate, visitor);
        }
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public void traversePackageTree(Predicate<? super JavaPackage> predicate, PackageVisitor visitor) {
        if (predicate.test(this)) {
            visitor.visit(this);
        }
        for (JavaPackage subpackage : this.getSubpackages()) {
            subpackage.traversePackageTree(predicate, visitor);
        }
    }

    @Override
    public String getDescription() {
        return "Package <" + this.name + ">";
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getName() + "]";
    }

    static JavaPackage simple(JavaClass javaClass) {
        String packageName = javaClass.getPackageName();
        JavaPackage defaultPackage = JavaPackage.from(Collections.singleton(javaClass));
        return packageName.isEmpty() ? defaultPackage : defaultPackage.getPackage(packageName);
    }

    static JavaPackage from(Iterable<JavaClass> classes) {
        return new Tree(classes).toJavaPackage();
    }

    @PublicAPI(usage=PublicAPI.Usage.INHERITANCE)
    public static interface ClassVisitor {
        public void visit(JavaClass var1);
    }

    @PublicAPI(usage=PublicAPI.Usage.INHERITANCE)
    public static interface PackageVisitor {
        public void visit(JavaPackage var1);
    }

    private static class Tree {
        private final String packageName;
        private final Map<String, Tree> subpackageTrees;
        private final Set<JavaClass> classes = new HashSet<JavaClass>();

        Tree(Iterable<JavaClass> classes) {
            this("", classes);
        }

        private Tree(String packageName, Iterable<JavaClass> classes) {
            this.packageName = packageName;
            HashMultimap<String, JavaClass> childPackages = HashMultimap.create();
            for (JavaClass clazz : classes) {
                if (clazz.getPackageName().equals(packageName)) {
                    this.classes.add(clazz);
                    continue;
                }
                String subpackageName = this.findSubpackageName(packageName, clazz);
                childPackages.put(subpackageName, clazz);
            }
            this.subpackageTrees = this.createSubTrees(packageName, childPackages);
        }

        private String findSubpackageName(String packageName, JavaClass clazz) {
            String packageRest = !packageName.isEmpty() ? clazz.getPackageName().substring(packageName.length() + 1) : clazz.getPackageName();
            int indexOfDot = packageRest.indexOf(".");
            return indexOfDot > 0 ? packageRest.substring(0, indexOfDot) : packageRest;
        }

        private Map<String, Tree> createSubTrees(String packageName, SetMultimap<String, JavaClass> childPackages) {
            HashMap<String, Tree> result = new HashMap<String, Tree>();
            for (Map.Entry<String, Collection<JavaClass>> entry : childPackages.asMap().entrySet()) {
                String childPackageName = this.joinSkippingEmpty(packageName, entry.getKey());
                result.put(entry.getKey(), new Tree(childPackageName, (Iterable<JavaClass>)entry.getValue()));
            }
            return result;
        }

        private String joinSkippingEmpty(String first, String second) {
            return !first.isEmpty() ? first + "." + second : second;
        }

        JavaPackage toJavaPackage() {
            JavaPackage result = this.createJavaPackage();
            for (JavaPackage subpackage : result.getSubpackages()) {
                subpackage.setParent(result);
            }
            return result;
        }

        private JavaPackage createJavaPackage() {
            ImmutableMap.Builder<String, JavaPackage> subpackages = ImmutableMap.builder();
            for (Map.Entry<String, Tree> entry : this.subpackageTrees.entrySet()) {
                subpackages.put(entry.getKey(), entry.getValue().toJavaPackage());
            }
            return new JavaPackage(this.packageName, this.classes, subpackages.build());
        }
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static final class Functions {
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final ChainableFunction<JavaPackage, String> GET_RELATIVE_NAME = new ChainableFunction<JavaPackage, String>(){

            @Override
            public String apply(JavaPackage javaPackage) {
                return javaPackage.getRelativeName();
            }
        };
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final ChainableFunction<JavaPackage, Set<JavaClass>> GET_CLASSES = new ChainableFunction<JavaPackage, Set<JavaClass>>(){

            @Override
            public Set<JavaClass> apply(JavaPackage javaPackage) {
                return javaPackage.getClasses();
            }
        };
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final ChainableFunction<JavaPackage, Set<JavaPackage>> GET_SUB_PACKAGES = new ChainableFunction<JavaPackage, Set<JavaPackage>>(){

            @Override
            public Set<JavaPackage> apply(JavaPackage javaPackage) {
                return javaPackage.getSubpackages();
            }
        };

        private Functions() {
        }
    }
}

