/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.panel.grouping.action;

import org.eclipse.jface.action.Action;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.controls.resultset.internal.ResultSetMessages;
import org.jkiss.dbeaver.ui.controls.resultset.panel.grouping.GroupingResultsContainer;

public class PercentFromTotalAction
extends Action {
    private final GroupingResultsContainer resultsContainer;

    public PercentFromTotalAction(@NotNull GroupingResultsContainer resultsContainer) {
        super(ResultSetMessages.grouping_panel_show_percent_of_total_tip, 2);
        this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.PERCENT));
        this.resultsContainer = resultsContainer;
    }

    public boolean isChecked() {
        DBPDataSource dataSource = this.resultsContainer.getDataContainer().getDataSource();
        return dataSource != null && dataSource.getContainer().getPreferenceStore().getBoolean("resultset.grouping.showPercentOfTotal");
    }

    public void run() {
        DBPDataSource dataSource = this.resultsContainer.getDataContainer().getDataSource();
        if (dataSource == null) {
            return;
        }
        dataSource.getContainer().getPreferenceStore().setValue("resultset.grouping.showPercentOfTotal", !this.isChecked());
        try {
            this.resultsContainer.rebuildGrouping();
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError(ResultSetMessages.grouping_panel_error_title, ResultSetMessages.grouping_panel_error_show_percent_of_total_message, (Throwable)e);
        }
    }
}

