/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.utils.io;

import java.nio.charset.Charset;
import org.jkiss.code.NotNull;

public enum ByteOrderMark implements Comparable<ByteOrderMark>
{
    UTF_8("UTF-8", new int[]{239, 187, 191}),
    UTF_16BE("UTF-16BE", new int[]{254, 255}),
    UTF_16LE("UTF-16LE", new int[]{255, 254}),
    UTF_32BE("UTF-32BE", new int[]{0, 0, 254, 255}),
    UTF_32LE("UTF-32LE", new int[]{255, 254, 0, 0});

    private final String charsetName;
    private final int[] bytes;

    private ByteOrderMark(String charsetName, int[] bytes) {
        this.charsetName = charsetName;
        this.bytes = bytes;
    }

    @NotNull
    public String getCharsetName() {
        return this.charsetName;
    }

    @NotNull
    public byte[] getBytes() {
        byte[] buffer = new byte[this.bytes.length];
        for (int index = 0; index < this.bytes.length; ++index) {
            buffer[index] = (byte)(this.bytes[index] & 0xFF);
        }
        return buffer;
    }

    public int get(int position) {
        return this.bytes[position];
    }

    public int length() {
        return this.bytes.length;
    }

    @NotNull
    public static ByteOrderMark fromCharset(@NotNull Charset charset) {
        return ByteOrderMark.fromCharset(charset.name());
    }

    @NotNull
    public static ByteOrderMark fromCharset(@NotNull String charsetName) {
        for (ByteOrderMark bom : ByteOrderMark.values()) {
            if (!bom.charsetName.equalsIgnoreCase(charsetName)) continue;
            return bom;
        }
        throw new IllegalArgumentException("Can't find BOM for charset " + charsetName);
    }
}

