/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.syntax;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;
import org.jkiss.dbeaver.Log;

public class SQLDoubleClickStrategy
implements ITextDoubleClickStrategy {
    private static final Log log = Log.getLog(SQLDoubleClickStrategy.class);
    protected ITextViewer fText;
    protected int curPos;
    protected int startPos;
    protected int endPos;
    protected static char[] fgBrackets = new char[]{'(', ')', '[', ']', '\'', '\'', '\"', '\"'};

    public void doubleClicked(ITextViewer viewer) {
        this.fText = viewer;
        this.curPos = viewer.getSelectedRange().x;
        if (this.curPos < 0 || this.curPos >= this.fText.getDocument().getLength()) {
            return;
        }
        if (!this.selectBracketBlock()) {
            this.selectWord();
        }
    }

    protected boolean matchBracketsAt() {
        if (this.curPos == 0) {
            return false;
        }
        int bracketIndex1 = fgBrackets.length;
        int bracketIndex2 = fgBrackets.length;
        this.startPos = -1;
        this.endPos = -1;
        try {
            int i;
            IDocument doc = this.fText.getDocument();
            char prevChar = doc.getChar(this.curPos - 1);
            char nextChar = doc.getChar(this.curPos);
            for (i = 0; i < fgBrackets.length; i += 2) {
                if (prevChar != fgBrackets[i]) continue;
                this.startPos = this.curPos - 1;
                bracketIndex1 = i;
            }
            for (i = 1; i < fgBrackets.length; i += 2) {
                if (nextChar != fgBrackets[i]) continue;
                this.endPos = this.curPos;
                bracketIndex2 = i;
            }
            if (this.startPos > -1 && bracketIndex1 < bracketIndex2) {
                this.endPos = this.searchForClosingBracket(this.startPos, prevChar, fgBrackets[bracketIndex1 + 1], doc);
                if (this.endPos > -1) {
                    return true;
                }
                this.startPos = -1;
            } else if (this.endPos > -1) {
                this.startPos = this.searchForOpenBracket(this.endPos, fgBrackets[bracketIndex2 - 1], nextChar, doc);
                if (this.startPos > -1) {
                    return true;
                }
                this.endPos = -1;
            }
        }
        catch (BadLocationException x) {
            log.debug((Object)x);
        }
        return false;
    }

    protected boolean matchWord() {
        IDocument doc = this.fText.getDocument();
        try {
            char c;
            int pos;
            for (pos = this.curPos; pos >= 0 && Character.isJavaIdentifierPart(c = doc.getChar(pos)); --pos) {
            }
            this.startPos = pos;
            int length = doc.getLength();
            for (pos = this.curPos; pos < length && Character.isJavaIdentifierPart(c = doc.getChar(pos)); ++pos) {
            }
            this.endPos = pos;
            return true;
        }
        catch (BadLocationException x) {
            log.debug((Object)x);
            return false;
        }
    }

    protected int searchForClosingBracket(int startPosition, char openBracket, char closeBracket, IDocument document) throws BadLocationException {
        int closePosition;
        int stack = 1;
        int length = document.getLength();
        for (closePosition = startPosition + 1; closePosition < length && stack > 0; ++closePosition) {
            char nextChar = document.getChar(closePosition);
            if (nextChar == openBracket && nextChar != closeBracket) {
                ++stack;
                continue;
            }
            if (nextChar != closeBracket) continue;
            --stack;
        }
        if (stack == 0) {
            return closePosition - 1;
        }
        return -1;
    }

    protected int searchForOpenBracket(int startPosition, char openBracket, char closeBracket, IDocument document) throws BadLocationException {
        int openPos;
        int stack = 1;
        for (openPos = startPosition - 1; openPos >= 0 && stack > 0; --openPos) {
            char nextChar = document.getChar(openPos);
            if (nextChar == closeBracket && nextChar != openBracket) {
                ++stack;
                continue;
            }
            if (nextChar != openBracket) continue;
            --stack;
        }
        if (stack == 0) {
            return openPos + 1;
        }
        return -1;
    }

    protected boolean selectBracketBlock() {
        if (this.matchBracketsAt()) {
            if (this.startPos == this.endPos) {
                this.fText.setSelectedRange(this.startPos, 0);
            } else {
                this.fText.setSelectedRange(this.startPos + 1, this.endPos - this.startPos - 1);
            }
            return true;
        }
        return false;
    }

    protected void selectWord() {
        if (this.matchWord()) {
            if (this.startPos == this.endPos) {
                this.fText.setSelectedRange(this.startPos, 0);
            } else {
                this.fText.setSelectedRange(this.startPos + 1, this.endPos - this.startPos - 1);
            }
        }
    }
}

