/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.internal.ui.palette.editparts;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ScrollBar;
import org.eclipse.draw2d.ScrollPane;
import org.eclipse.draw2d.ScrollPaneLayout;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;

public class OverlayScrollPaneLayout
extends ScrollPaneLayout {
    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        ScrollPane scrollpane = (ScrollPane)container;
        Insets insets = scrollpane.getInsets();
        int excludedWidth = insets.getWidth();
        int excludedHeight = insets.getHeight();
        return scrollpane.getViewport().getPreferredSize(wHint - excludedWidth, hHint - excludedHeight).getExpanded(excludedWidth, excludedHeight);
    }

    public void layout(IFigure parent) {
        Rectangle bounds;
        Dimension preferred;
        ScrollPane scrollpane = (ScrollPane)parent;
        Rectangle clientArea = parent.getClientArea();
        ScrollBar hBar = scrollpane.getHorizontalScrollBar();
        ScrollBar vBar = scrollpane.getVerticalScrollBar();
        Viewport viewport = scrollpane.getViewport();
        Insets insets = new Insets();
        insets.bottom = hBar.getPreferredSize((int)clientArea.width, (int)clientArea.height).height;
        insets.right = vBar.getPreferredSize((int)clientArea.width, (int)clientArea.height).width;
        int hVis = scrollpane.getHorizontalScrollBarVisibility();
        int vVis = scrollpane.getVerticalScrollBarVisibility();
        Dimension available = clientArea.getSize();
        boolean none = available.contains(preferred = viewport.getPreferredSize(available.width, available.height).getCopy());
        boolean both = !none && vVis != 0 && hVis != 0 && preferred.contains(available);
        boolean showV = both || preferred.height > available.height;
        boolean showH = both || preferred.width > available.width;
        showV = vVis != 0 && (showV || vVis == 2);
        boolean bl = showH = hVis != 0 && (showH || hVis == 2);
        if (!showV) {
            insets.right = 0;
        }
        if (!showH) {
            insets.bottom = 0;
        }
        Rectangle viewportArea = clientArea;
        if (showV) {
            bounds = new Rectangle(viewportArea.right() - insets.right, viewportArea.y, insets.right, viewportArea.height);
            vBar.setBounds(bounds);
        }
        if (showH) {
            bounds = new Rectangle(viewportArea.x, viewportArea.bottom() - insets.bottom, viewportArea.width, insets.bottom);
            hBar.setBounds(bounds);
        }
        vBar.setVisible(showV);
        hBar.setVisible(showH);
        viewport.setBounds(viewportArea);
    }
}

