/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire.version19;

import java.io.IOException;
import java.sql.SQLException;
import org.firebirdsql.gds.ClumpletReader;
import org.firebirdsql.gds.VaxEncoding;
import org.firebirdsql.gds.impl.wire.XdrInputStream;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.WarningMessageCallback;
import org.firebirdsql.gds.ng.wire.InlineBlobResponse;
import org.firebirdsql.gds.ng.wire.WireConnection;
import org.firebirdsql.gds.ng.wire.version16.V16WireOperations;

public class V19WireOperations
extends V16WireOperations {
    public V19WireOperations(WireConnection<?, ?> connection, WarningMessageCallback defaultWarningMessageCallback) {
        super(connection, defaultWarningMessageCallback);
    }

    @Override
    protected InlineBlobResponse readInlineBlobResponse(XdrInputStream xdrIn) throws SQLException, IOException {
        int bufferLength;
        int segmentLength;
        int transactionHandle = xdrIn.readInt();
        long blobId = xdrIn.readLong();
        byte[] info = xdrIn.readBuffer();
        ClumpletReader clumpletReader = new ClumpletReader(ClumpletReader.Kind.InfoResponse, info);
        if (!clumpletReader.find(6)) {
            xdrIn.readBuffer();
            throw new SQLException("Expected to be able to find isc_info_blob_total_length; this is probably an implementation bug", "0F000");
        }
        int dataLength = clumpletReader.getInt();
        byte[] data = new byte[dataLength];
        int dataPos = 0;
        for (int remainingBuffer = bufferLength = xdrIn.readInt(); remainingBuffer > 0; remainingBuffer -= segmentLength) {
            segmentLength = VaxEncoding.decodeVaxInteger2WithoutLength(xdrIn);
            if (segmentLength > (remainingBuffer -= 2)) {
                xdrIn.skipFully(remainingBuffer);
                xdrIn.skipPadding(bufferLength);
                throw FbExceptionBuilder.forException(337248330).messageParameter("segmentLength", remainingBuffer, segmentLength).toSQLException();
            }
            xdrIn.readFully(data, dataPos, segmentLength);
            dataPos += segmentLength;
        }
        xdrIn.skipPadding(bufferLength);
        return new InlineBlobResponse(transactionHandle, blobId, info, data);
    }
}

