/*
 * Decompiled with CFR 0.152.
 */
package org.cryptacular.ssh;

import java.math.BigInteger;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.DSAParameters;
import org.bouncycastle.crypto.params.DSAPublicKeyParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.cryptacular.CryptUtil;
import org.cryptacular.EncodingException;
import org.cryptacular.pem.Format;
import org.cryptacular.pem.PemObject;
import org.cryptacular.util.ByteUtil;
import org.cryptacular.util.CodecUtil;
import org.cryptacular.util.PemUtil;

public class SSHPublicKeyDecoder {
    public static boolean isRFC4253EncodedPublicKey(String key) {
        return key != null && key.startsWith("ssh-");
    }

    public static boolean isRFC4253EncodedPublicKey(byte[] key) {
        if (key == null || key.length - 10 < 1) {
            return false;
        }
        return SSHPublicKeyDecoder.isRFC4253EncodedPublicKey(new String(key, 0, 10, ByteUtil.ASCII_CHARSET).trim());
    }

    public AsymmetricKeyParameter decode(byte[] encoded) {
        CryptUtil.assertNotNullArgOr(encoded, v -> ((byte[])v).length == 0, "Bytes cannot be null or empty");
        if (PemUtil.isPem(encoded)) {
            PemObject pem = PemObject.decode(encoded);
            if (Format.RFC4716.equals((Object)pem.getDescriptor().getFormat())) {
                return this.decodeInternal(pem.getContent());
            }
            throw new EncodingException("Unsupported SSH public key format: " + (Object)((Object)pem.getDescriptor().getFormat()));
        }
        if (SSHPublicKeyDecoder.isRFC4253EncodedPublicKey(encoded)) {
            return this.decode(new String(encoded, ByteUtil.ASCII_CHARSET));
        }
        throw new EncodingException("Unsupported SSH public key format");
    }

    public AsymmetricKeyParameter decode(String pubData) {
        String[] tokenized = CryptUtil.assertNotNullArgOr(pubData, String::isEmpty, "Public data cannot be null or empty").trim().split("\\s+", 2);
        if (tokenized.length < 2) {
            throw new EncodingException("Unsupported SSH public key format");
        }
        return this.decodeInternal(CodecUtil.b64(tokenized[1]));
    }

    private AsymmetricKeyParameter decodeInternal(byte[] encoded) {
        String type;
        CryptUtil.assertNotNullArgOr(encoded, v -> ((byte[])v).length == 0, "Bytes cannot be null or empty");
        ByteBuffer buffer = ByteBuffer.wrap(encoded).order(ByteOrder.BIG_ENDIAN);
        switch (type = this.decodeString(buffer)) {
            case "ssh-rsa": {
                BigInteger e = this.decodeMPInt(buffer);
                BigInteger m = this.decodeMPInt(buffer);
                return new RSAKeyParameters(false, m, e);
            }
            case "ssh-dss": {
                BigInteger p = this.decodeMPInt(buffer);
                BigInteger q = this.decodeMPInt(buffer);
                BigInteger g = this.decodeMPInt(buffer);
                BigInteger y = this.decodeMPInt(buffer);
                return new DSAPublicKeyParameters(y, new DSAParameters(p, q, g));
            }
        }
        throw new EncodingException("Unsupported SSH2 public key type: " + type);
    }

    private String decodeString(ByteBuffer buffer) {
        try {
            int length = buffer.getInt();
            if (length < 0 || length > 262144) {
                length = 262144;
            }
            byte[] string = new byte[length];
            buffer.get(string);
            return new String(string, ByteUtil.ASCII_CHARSET);
        }
        catch (BufferUnderflowException e) {
            throw new EncodingException("Error decoding ssh key", e);
        }
    }

    private BigInteger decodeMPInt(ByteBuffer buffer) {
        try {
            int length = buffer.getInt();
            if (length < 0 || length > 8192) {
                length = 8192;
            }
            byte[] value = new byte[length];
            buffer.get(value);
            return new BigInteger(value);
        }
        catch (BufferUnderflowException e) {
            throw new EncodingException("Error decoding ssh key", e);
        }
    }
}

