/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection;

public class UpdateRaftVoterRequestData
implements ApiMessage {
    String clusterId;
    int currentLeaderEpoch;
    int voterId;
    Uuid voterDirectoryId;
    ListenerCollection listeners;
    KRaftVersionFeature kRaftVersionFeature;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("cluster_id", Type.COMPACT_NULLABLE_STRING, "The cluster id."), new Field("current_leader_epoch", Type.INT32, "The current leader epoch of the partition, -1 for unknown leader epoch."), new Field("voter_id", Type.INT32, "The replica id of the voter getting updated in the topic partition."), new Field("voter_directory_id", Type.UUID, "The directory id of the voter getting updated in the topic partition."), new Field("listeners", new CompactArrayOf(Listener.SCHEMA_0), "The endpoint that can be used to communicate with the leader."), new Field("kraft_version_feature", KRaftVersionFeature.SCHEMA_0, "The range of versions of the protocol that the replica supports."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public UpdateRaftVoterRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public UpdateRaftVoterRequestData() {
        this.clusterId = "";
        this.currentLeaderEpoch = 0;
        this.voterId = 0;
        this.voterDirectoryId = Uuid.ZERO_UUID;
        this.listeners = new ListenerCollection(0);
        this.kRaftVersionFeature = new KRaftVersionFeature();
    }

    @Override
    public short apiKey() {
        return 82;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public final void read(Readable _readable, short _version) {
        int length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            this.clusterId = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field clusterId had invalid length " + length);
            }
            this.clusterId = _readable.readString(length);
        }
        this.currentLeaderEpoch = _readable.readInt();
        this.voterId = _readable.readInt();
        this.voterDirectoryId = _readable.readUuid();
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field listeners was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ListenerCollection newCollection = new ListenerCollection(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new Listener(_readable, _version));
        }
        this.listeners = newCollection;
        this.kRaftVersionFeature = new KRaftVersionFeature(_readable, _version);
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        Object _stringBytes;
        int _numTaggedFields = 0;
        if (this.clusterId == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _stringBytes = _cache.getSerializedValue(this.clusterId);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
        }
        _writable.writeInt(this.currentLeaderEpoch);
        _writable.writeInt(this.voterId);
        _writable.writeUuid(this.voterDirectoryId);
        _writable.writeUnsignedVarint(this.listeners.size() + 1);
        _stringBytes = this.listeners.iterator();
        while (_stringBytes.hasNext()) {
            Listener listenersElement = (Listener)_stringBytes.next();
            listenersElement.write(_writable, _cache, _version);
        }
        this.kRaftVersionFeature.write(_writable, _cache, _version);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        if (this.clusterId == null) {
            _size.addBytes(1);
        } else {
            byte[] _stringBytes = this.clusterId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'clusterId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.clusterId, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        }
        _size.addBytes(4);
        _size.addBytes(4);
        _size.addBytes(16);
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.listeners.size() + 1));
        for (Listener listenersElement : this.listeners) {
            listenersElement.addSize(_size, _cache, _version);
        }
        this.kRaftVersionFeature.addSize(_size, _cache, _version);
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UpdateRaftVoterRequestData)) {
            return false;
        }
        UpdateRaftVoterRequestData other = (UpdateRaftVoterRequestData)obj;
        if (this.clusterId == null ? other.clusterId != null : !this.clusterId.equals(other.clusterId)) {
            return false;
        }
        if (this.currentLeaderEpoch != other.currentLeaderEpoch) {
            return false;
        }
        if (this.voterId != other.voterId) {
            return false;
        }
        if (!this.voterDirectoryId.equals(other.voterDirectoryId)) {
            return false;
        }
        if (this.listeners == null ? other.listeners != null : !this.listeners.equals(other.listeners)) {
            return false;
        }
        if (this.kRaftVersionFeature == null ? other.kRaftVersionFeature != null : !this.kRaftVersionFeature.equals(other.kRaftVersionFeature)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.clusterId == null ? 0 : this.clusterId.hashCode());
        hashCode = 31 * hashCode + this.currentLeaderEpoch;
        hashCode = 31 * hashCode + this.voterId;
        hashCode = 31 * hashCode + this.voterDirectoryId.hashCode();
        hashCode = 31 * hashCode + (this.listeners == null ? 0 : this.listeners.hashCode());
        hashCode = 31 * hashCode + (this.kRaftVersionFeature == null ? 0 : this.kRaftVersionFeature.hashCode());
        return hashCode;
    }

    @Override
    public UpdateRaftVoterRequestData duplicate() {
        UpdateRaftVoterRequestData _duplicate = new UpdateRaftVoterRequestData();
        _duplicate.clusterId = this.clusterId == null ? null : this.clusterId;
        _duplicate.currentLeaderEpoch = this.currentLeaderEpoch;
        _duplicate.voterId = this.voterId;
        _duplicate.voterDirectoryId = this.voterDirectoryId;
        ListenerCollection newListeners = new ListenerCollection(this.listeners.size());
        for (Listener _element : this.listeners) {
            newListeners.add(_element.duplicate());
        }
        _duplicate.listeners = newListeners;
        _duplicate.kRaftVersionFeature = this.kRaftVersionFeature.duplicate();
        return _duplicate;
    }

    public String toString() {
        return "UpdateRaftVoterRequestData(clusterId=" + (String)(this.clusterId == null ? "null" : "'" + this.clusterId.toString() + "'") + ", currentLeaderEpoch=" + this.currentLeaderEpoch + ", voterId=" + this.voterId + ", voterDirectoryId=" + this.voterDirectoryId.toString() + ", listeners=" + MessageUtil.deepToString(this.listeners.iterator()) + ", kRaftVersionFeature=" + this.kRaftVersionFeature.toString() + ")";
    }

    public String clusterId() {
        return this.clusterId;
    }

    public int currentLeaderEpoch() {
        return this.currentLeaderEpoch;
    }

    public int voterId() {
        return this.voterId;
    }

    public Uuid voterDirectoryId() {
        return this.voterDirectoryId;
    }

    public ListenerCollection listeners() {
        return this.listeners;
    }

    public KRaftVersionFeature kRaftVersionFeature() {
        return this.kRaftVersionFeature;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public UpdateRaftVoterRequestData setClusterId(String v) {
        this.clusterId = v;
        return this;
    }

    public UpdateRaftVoterRequestData setCurrentLeaderEpoch(int v) {
        this.currentLeaderEpoch = v;
        return this;
    }

    public UpdateRaftVoterRequestData setVoterId(int v) {
        this.voterId = v;
        return this;
    }

    public UpdateRaftVoterRequestData setVoterDirectoryId(Uuid v) {
        this.voterDirectoryId = v;
        return this;
    }

    public UpdateRaftVoterRequestData setListeners(ListenerCollection v) {
        this.listeners = v;
        return this;
    }

    public UpdateRaftVoterRequestData setKRaftVersionFeature(KRaftVersionFeature v) {
        this.kRaftVersionFeature = v;
        return this;
    }

    public static class ListenerCollection
    extends ImplicitLinkedHashMultiCollection<Listener> {
        public ListenerCollection() {
        }

        public ListenerCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public ListenerCollection(Iterator<Listener> iterator) {
            super(iterator);
        }

        @Override
        public Listener find(String name) {
            Listener _key = new Listener();
            _key.setName(name);
            return this.find(_key);
        }

        @Override
        public List<Listener> findAll(String name) {
            Listener _key = new Listener();
            _key.setName(name);
            return this.findAll(_key);
        }

        public ListenerCollection duplicate() {
            ListenerCollection _duplicate = new ListenerCollection(this.size());
            for (Listener _element : this) {
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class KRaftVersionFeature
    implements Message {
        short minSupportedVersion;
        short maxSupportedVersion;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("min_supported_version", Type.INT16, "The minimum supported KRaft protocol version."), new Field("max_supported_version", Type.INT16, "The maximum supported KRaft protocol version."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public KRaftVersionFeature(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public KRaftVersionFeature() {
            this.minSupportedVersion = 0;
            this.maxSupportedVersion = 0;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public final void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of KRaftVersionFeature");
            }
            this.minSupportedVersion = _readable.readShort();
            this.maxSupportedVersion = _readable.readShort();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeShort(this.minSupportedVersion);
            _writable.writeShort(this.maxSupportedVersion);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of KRaftVersionFeature");
            }
            _size.addBytes(2);
            _size.addBytes(2);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof KRaftVersionFeature)) {
                return false;
            }
            KRaftVersionFeature other = (KRaftVersionFeature)obj;
            if (this.minSupportedVersion != other.minSupportedVersion) {
                return false;
            }
            if (this.maxSupportedVersion != other.maxSupportedVersion) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.minSupportedVersion;
            hashCode = 31 * hashCode + this.maxSupportedVersion;
            return hashCode;
        }

        @Override
        public KRaftVersionFeature duplicate() {
            KRaftVersionFeature _duplicate = new KRaftVersionFeature();
            _duplicate.minSupportedVersion = this.minSupportedVersion;
            _duplicate.maxSupportedVersion = this.maxSupportedVersion;
            return _duplicate;
        }

        public String toString() {
            return "KRaftVersionFeature(minSupportedVersion=" + this.minSupportedVersion + ", maxSupportedVersion=" + this.maxSupportedVersion + ")";
        }

        public short minSupportedVersion() {
            return this.minSupportedVersion;
        }

        public short maxSupportedVersion() {
            return this.maxSupportedVersion;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public KRaftVersionFeature setMinSupportedVersion(short v) {
            this.minSupportedVersion = v;
            return this;
        }

        public KRaftVersionFeature setMaxSupportedVersion(short v) {
            this.maxSupportedVersion = v;
            return this;
        }
    }

    public static class Listener
    implements Message,
    ImplicitLinkedHashCollection.Element {
        String name;
        String host;
        int port;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0 = new Schema(new Field("name", Type.COMPACT_STRING, "The name of the endpoint."), new Field("host", Type.COMPACT_STRING, "The hostname."), new Field("port", Type.UINT16, "The port."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public Listener(Readable _readable, short _version) {
            this.read(_readable, _version);
            this.prev = -2;
            this.next = -2;
        }

        public Listener() {
            this.name = "";
            this.host = "";
            this.port = 0;
            this.prev = -2;
            this.next = -2;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public final void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of Listener");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field host was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field host had invalid length " + length);
            }
            this.host = _readable.readString(length);
            this.port = _readable.readUnsignedShort();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.name);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _stringBytes = _cache.getSerializedValue(this.host);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _writable.writeUnsignedShort(this.port);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of Listener");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.name, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _stringBytes = this.host.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'host' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.host, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _size.addBytes(2);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        @Override
        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof Listener)) {
                return false;
            }
            Listener other = (Listener)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Listener)) {
                return false;
            }
            Listener other = (Listener)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
                return false;
            }
            if (this.port != other.port) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            return hashCode;
        }

        @Override
        public Listener duplicate() {
            Listener _duplicate = new Listener();
            _duplicate.name = this.name;
            _duplicate.host = this.host;
            _duplicate.port = this.port;
            return _duplicate;
        }

        public String toString() {
            return "Listener(name=" + (String)(this.name == null ? "null" : "'" + this.name.toString() + "'") + ", host=" + (String)(this.host == null ? "null" : "'" + this.host.toString() + "'") + ", port=" + this.port + ")";
        }

        public String name() {
            return this.name;
        }

        public String host() {
            return this.host;
        }

        public int port() {
            return this.port;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public int prev() {
            return this.prev;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public Listener setName(String v) {
            this.name = v;
            return this;
        }

        public Listener setHost(String v) {
            this.host = v;
            return this;
        }

        public Listener setPort(int v) {
            if (v < 0 || v > 65535) {
                throw new RuntimeException("Invalid value " + v + " for unsigned short field.");
            }
            this.port = v;
            return this;
        }

        @Override
        public void setNext(int v) {
            this.next = v;
        }

        @Override
        public void setPrev(int v) {
            this.prev = v;
        }
    }
}

