/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import java.nio.channels.ClosedChannelException;
import java.util.EnumMap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeReference;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;

@InterfaceAudience.Private
class MountVolumeInfo {
    private final EnumMap<StorageType, FsVolumeImpl> storageTypeVolumeMap = new EnumMap(StorageType.class);
    private final EnumMap<StorageType, Double> capacityRatioMap = new EnumMap(StorageType.class);
    private double reservedForArchiveDefault;

    MountVolumeInfo(Configuration conf) {
        this.reservedForArchiveDefault = conf.getDouble("dfs.datanode.reserve-for-archive.default.percentage", 0.0);
        if (this.reservedForArchiveDefault > 1.0) {
            FsDatasetImpl.LOG.warn("Value of reserve-for-archival is > 100%. Setting it to 100%.");
            this.reservedForArchiveDefault = 1.0;
        }
        if (this.reservedForArchiveDefault < 0.0) {
            FsDatasetImpl.LOG.warn("Value of reserve-for-archival is < 0. Setting it to 0.0");
            this.reservedForArchiveDefault = 0.0;
        }
    }

    FsVolumeReference getVolumeRef(StorageType storageType) {
        try {
            FsVolumeImpl volumeImpl = this.storageTypeVolumeMap.getOrDefault(storageType, null);
            if (volumeImpl != null) {
                return volumeImpl.obtainReference();
            }
        }
        catch (ClosedChannelException e) {
            FsDatasetImpl.LOG.warn("Volume closed when getting volume by storage type: " + storageType);
        }
        return null;
    }

    double getCapacityRatio(StorageType storageType) {
        if (this.capacityRatioMap.containsKey(storageType)) {
            return this.capacityRatioMap.get(storageType);
        }
        if (!this.capacityRatioMap.isEmpty()) {
            double leftOver = 1.0;
            for (Map.Entry<StorageType, Double> e : this.capacityRatioMap.entrySet()) {
                leftOver -= e.getValue().doubleValue();
            }
            return leftOver;
        }
        if (this.storageTypeVolumeMap.containsKey(storageType) && this.storageTypeVolumeMap.size() > 1) {
            if (storageType == StorageType.ARCHIVE) {
                return this.reservedForArchiveDefault;
            }
            if (storageType == StorageType.DISK) {
                return 1.0 - this.reservedForArchiveDefault;
            }
        }
        return 1.0;
    }

    boolean addVolume(FsVolumeImpl volume) {
        if (this.storageTypeVolumeMap.containsKey(volume.getStorageType())) {
            FsDatasetImpl.LOG.error("Found storage type already exist. Skipping for now. Please check disk configuration");
            return false;
        }
        this.storageTypeVolumeMap.put(volume.getStorageType(), volume);
        return true;
    }

    void removeVolume(FsVolumeImpl target) {
        this.storageTypeVolumeMap.remove(target.getStorageType());
        this.capacityRatioMap.remove(target.getStorageType());
    }

    boolean setCapacityRatio(StorageType storageType, double capacityRatio) {
        double leftover = 1.0;
        for (Map.Entry<StorageType, Double> e : this.capacityRatioMap.entrySet()) {
            if (e.getKey() == storageType) continue;
            leftover -= e.getValue().doubleValue();
        }
        if (leftover < capacityRatio) {
            return false;
        }
        this.capacityRatioMap.put(storageType, capacityRatio);
        return true;
    }

    int size() {
        return this.storageTypeVolumeMap.size();
    }
}

