/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.observability.settings;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.opensearch.bootstrap.BootstrapInfo;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010 \n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0002bcB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010[\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030R0#J\u0010\u0010\\\u001a\u00020]2\u0006\u0010^\u001a\u00020_H\u0002J\u0010\u0010`\u001a\u00020]2\u0006\u0010^\u001a\u00020_H\u0002J\u000e\u0010a\u001a\u00020]2\u0006\u0010^\u001a\u00020_R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0016X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0016X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0016X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0016X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0016X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0016X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0016X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0016X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00050#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010$\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010)\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u001a\u0010.\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010+\"\u0004\b0\u0010-R\u001a\u00101\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010+\"\u0004\b3\u0010-R\u001a\u00104\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010+\"\u0004\b6\u0010-R\u001a\u00107\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010+\"\u0004\b9\u0010-R\u001a\u0010:\u001a\u00020;X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?R\u001a\u0010@\u001a\u00020AX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010C\"\u0004\bD\u0010ER \u0010F\u001a\b\u0012\u0004\u0012\u00020\u00050#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bG\u0010H\"\u0004\bI\u0010JR\u000e\u0010K\u001a\u00020\u0016X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010L\u001a\n N*\u0004\u0018\u00010M0MX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010O\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050PX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010Q\u001a\b\u0012\u0004\u0012\u00020\u00130RX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010S\u001a\b\u0012\u0004\u0012\u00020\u00160RX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010T\u001a\b\u0012\u0004\u0012\u00020\u00160RX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010U\u001a\b\u0012\u0004\u0012\u00020\u00160RX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010V\u001a\b\u0012\u0004\u0012\u00020\u00160RX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010W\u001a\b\u0012\u0004\u0012\u00020\u00160RX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010X\u001a\b\u0012\u0004\u0012\u00020\u00050RX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010Y\u001a\b\u0012\u0004\u0012\u00020\u00050RX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010Z\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050#0RX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006d"}, d2={"Lorg/opensearch/observability/settings/PluginSettings;", "", "<init>", "()V", "KEY_PREFIX", "", "GENERAL_KEY_PREFIX", "POLLING_KEY_PREFIX", "ACCESS_KEY_PREFIX", "OPERATION_TIMEOUT_MS_KEY", "JOB_LOCK_DURATION_S_KEY", "MIN_POLLING_DURATION_S_KEY", "MAX_POLLING_DURATION_S_KEY", "MAX_LOCK_RETRIES_KEY", "DEFAULT_ITEMS_QUERY_COUNT_KEY", "ADMIN_ACCESS_KEY", "FILTER_BY_KEY", "IGNORE_ROLE_KEY", "DEFAULT_OPERATION_TIMEOUT_MS", "", "MINIMUM_OPERATION_TIMEOUT_MS", "DEFAULT_JOB_LOCK_DURATION_S", "", "MINIMUM_JOB_LOCK_DURATION_S", "DEFAULT_MIN_POLLING_DURATION_S", "MINIMUM_MIN_POLLING_DURATION_S", "DEFAULT_MAX_POLLING_DURATION_S", "MINIMUM_MAX_POLLING_DURATION_S", "DEFAULT_MAX_LOCK_RETRIES", "MINIMUM_LOCK_RETRIES", "DEFAULT_ITEMS_QUERY_COUNT_VALUE", "MINIMUM_ITEMS_QUERY_COUNT", "DEFAULT_ADMIN_ACCESS_METHOD", "DEFAULT_FILTER_BY_METHOD", "DEFAULT_IGNORED_ROLES", "", "operationTimeoutMs", "getOperationTimeoutMs", "()J", "setOperationTimeoutMs", "(J)V", "jobLockDurationSeconds", "getJobLockDurationSeconds", "()I", "setJobLockDurationSeconds", "(I)V", "minPollingDurationSeconds", "getMinPollingDurationSeconds", "setMinPollingDurationSeconds", "maxPollingDurationSeconds", "getMaxPollingDurationSeconds", "setMaxPollingDurationSeconds", "maxLockRetries", "getMaxLockRetries", "setMaxLockRetries", "defaultItemsQueryCount", "getDefaultItemsQueryCount", "setDefaultItemsQueryCount", "adminAccess", "Lorg/opensearch/observability/settings/PluginSettings$AdminAccess;", "getAdminAccess", "()Lorg/opensearch/observability/settings/PluginSettings$AdminAccess;", "setAdminAccess", "(Lorg/opensearch/observability/settings/PluginSettings$AdminAccess;)V", "filterBy", "Lorg/opensearch/observability/settings/PluginSettings$FilterBy;", "getFilterBy", "()Lorg/opensearch/observability/settings/PluginSettings$FilterBy;", "setFilterBy", "(Lorg/opensearch/observability/settings/PluginSettings$FilterBy;)V", "ignoredRoles", "getIgnoredRoles", "()Ljava/util/List;", "setIgnoredRoles", "(Ljava/util/List;)V", "DECIMAL_RADIX", "log", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "defaultSettings", "", "OPERATION_TIMEOUT_MS", "Lorg/opensearch/common/settings/Setting;", "JOB_LOCK_DURATION_S", "MIN_POLLING_DURATION_S", "MAX_POLLING_DURATION_S", "MAX_LOCK_RETRIES", "DEFAULT_ITEMS_QUERY_COUNT", "ADMIN_ACCESS", "FILTER_BY", "IGNORED_ROLES", "getAllSettings", "updateSettingValuesFromLocal", "", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "updateSettingValuesFromCluster", "addSettingsUpdateConsumer", "AdminAccess", "FilterBy", "opensearch-observability"})
public final class PluginSettings {
    @NotNull
    public static final PluginSettings INSTANCE;
    @NotNull
    private static final String KEY_PREFIX = "opensearch.observability";
    @NotNull
    private static final String GENERAL_KEY_PREFIX = "opensearch.observability.general";
    @NotNull
    private static final String POLLING_KEY_PREFIX = "opensearch.observability.polling";
    @NotNull
    private static final String ACCESS_KEY_PREFIX = "opensearch.observability.access";
    @NotNull
    private static final String OPERATION_TIMEOUT_MS_KEY = "opensearch.observability.general.operationTimeoutMs";
    @NotNull
    private static final String JOB_LOCK_DURATION_S_KEY = "opensearch.observability.polling.jobLockDurationSeconds";
    @NotNull
    private static final String MIN_POLLING_DURATION_S_KEY = "opensearch.observability.polling.minPollingDurationSeconds";
    @NotNull
    private static final String MAX_POLLING_DURATION_S_KEY = "opensearch.observability.polling.maxPollingDurationSeconds";
    @NotNull
    private static final String MAX_LOCK_RETRIES_KEY = "opensearch.observability.polling.maxLockRetries";
    @NotNull
    private static final String DEFAULT_ITEMS_QUERY_COUNT_KEY = "opensearch.observability.general.defaultItemsQueryCount";
    @NotNull
    private static final String ADMIN_ACCESS_KEY = "opensearch.observability.access.adminAccess";
    @NotNull
    private static final String FILTER_BY_KEY = "opensearch.observability.access.filterBy";
    @NotNull
    private static final String IGNORE_ROLE_KEY = "opensearch.observability.access.ignoreRoles";
    private static final long DEFAULT_OPERATION_TIMEOUT_MS = 60000L;
    private static final long MINIMUM_OPERATION_TIMEOUT_MS = 100L;
    private static final int DEFAULT_JOB_LOCK_DURATION_S = 300;
    private static final int MINIMUM_JOB_LOCK_DURATION_S = 10;
    private static final int DEFAULT_MIN_POLLING_DURATION_S = 300;
    private static final int MINIMUM_MIN_POLLING_DURATION_S = 60;
    private static final int DEFAULT_MAX_POLLING_DURATION_S = 900;
    private static final int MINIMUM_MAX_POLLING_DURATION_S = 300;
    private static final int DEFAULT_MAX_LOCK_RETRIES = 4;
    private static final int MINIMUM_LOCK_RETRIES = 1;
    private static final int DEFAULT_ITEMS_QUERY_COUNT_VALUE = 1000;
    private static final int MINIMUM_ITEMS_QUERY_COUNT = 10;
    @NotNull
    private static final String DEFAULT_ADMIN_ACCESS_METHOD = "AllObservabilityObjects";
    @NotNull
    private static final String DEFAULT_FILTER_BY_METHOD = "NoFilter";
    @NotNull
    private static final List<String> DEFAULT_IGNORED_ROLES;
    private static volatile long operationTimeoutMs;
    private static volatile int jobLockDurationSeconds;
    private static volatile int minPollingDurationSeconds;
    private static volatile int maxPollingDurationSeconds;
    private static volatile int maxLockRetries;
    private static volatile int defaultItemsQueryCount;
    @NotNull
    private static volatile AdminAccess adminAccess;
    @NotNull
    private static volatile FilterBy filterBy;
    @NotNull
    private static volatile List<String> ignoredRoles;
    private static final int DECIMAL_RADIX = 10;
    private static final Logger log;
    @NotNull
    private static final Map<String, String> defaultSettings;
    @NotNull
    private static final Setting<Long> OPERATION_TIMEOUT_MS;
    @NotNull
    private static final Setting<Integer> JOB_LOCK_DURATION_S;
    @NotNull
    private static final Setting<Integer> MIN_POLLING_DURATION_S;
    @NotNull
    private static final Setting<Integer> MAX_POLLING_DURATION_S;
    @NotNull
    private static final Setting<Integer> MAX_LOCK_RETRIES;
    @NotNull
    private static final Setting<Integer> DEFAULT_ITEMS_QUERY_COUNT;
    @NotNull
    private static final Setting<String> ADMIN_ACCESS;
    @NotNull
    private static final Setting<String> FILTER_BY;
    @NotNull
    private static final Setting<List<String>> IGNORED_ROLES;

    private PluginSettings() {
    }

    public final long getOperationTimeoutMs() {
        return operationTimeoutMs;
    }

    public final void setOperationTimeoutMs(long l) {
        operationTimeoutMs = l;
    }

    public final int getJobLockDurationSeconds() {
        return jobLockDurationSeconds;
    }

    public final void setJobLockDurationSeconds(int n) {
        jobLockDurationSeconds = n;
    }

    public final int getMinPollingDurationSeconds() {
        return minPollingDurationSeconds;
    }

    public final void setMinPollingDurationSeconds(int n) {
        minPollingDurationSeconds = n;
    }

    public final int getMaxPollingDurationSeconds() {
        return maxPollingDurationSeconds;
    }

    public final void setMaxPollingDurationSeconds(int n) {
        maxPollingDurationSeconds = n;
    }

    public final int getMaxLockRetries() {
        return maxLockRetries;
    }

    public final void setMaxLockRetries(int n) {
        maxLockRetries = n;
    }

    public final int getDefaultItemsQueryCount() {
        return defaultItemsQueryCount;
    }

    public final void setDefaultItemsQueryCount(int n) {
        defaultItemsQueryCount = n;
    }

    @NotNull
    public final AdminAccess getAdminAccess() {
        return adminAccess;
    }

    public final void setAdminAccess(@NotNull AdminAccess adminAccess) {
        Intrinsics.checkNotNullParameter((Object)((Object)adminAccess), (String)"<set-?>");
        PluginSettings.adminAccess = adminAccess;
    }

    @NotNull
    public final FilterBy getFilterBy() {
        return filterBy;
    }

    public final void setFilterBy(@NotNull FilterBy filterBy) {
        Intrinsics.checkNotNullParameter((Object)((Object)filterBy), (String)"<set-?>");
        PluginSettings.filterBy = filterBy;
    }

    @NotNull
    public final List<String> getIgnoredRoles() {
        return ignoredRoles;
    }

    public final void setIgnoredRoles(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        ignoredRoles = list;
    }

    @NotNull
    public final List<Setting<?>> getAllSettings() {
        Object[] objectArray = new Setting[]{OPERATION_TIMEOUT_MS, JOB_LOCK_DURATION_S, MIN_POLLING_DURATION_S, MAX_POLLING_DURATION_S, MAX_LOCK_RETRIES, DEFAULT_ITEMS_QUERY_COUNT, ADMIN_ACCESS, FILTER_BY, IGNORED_ROLES};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final void updateSettingValuesFromLocal(ClusterService clusterService) {
        Object object = OPERATION_TIMEOUT_MS.get(clusterService.getSettings());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        operationTimeoutMs = ((Number)object).longValue();
        Object object2 = JOB_LOCK_DURATION_S.get(clusterService.getSettings());
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        jobLockDurationSeconds = ((Number)object2).intValue();
        Object object3 = MIN_POLLING_DURATION_S.get(clusterService.getSettings());
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
        minPollingDurationSeconds = ((Number)object3).intValue();
        Object object4 = MAX_POLLING_DURATION_S.get(clusterService.getSettings());
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"get(...)");
        maxPollingDurationSeconds = ((Number)object4).intValue();
        Object object5 = MAX_LOCK_RETRIES.get(clusterService.getSettings());
        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"get(...)");
        maxLockRetries = ((Number)object5).intValue();
        Object object6 = DEFAULT_ITEMS_QUERY_COUNT.get(clusterService.getSettings());
        Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"get(...)");
        defaultItemsQueryCount = ((Number)object6).intValue();
        Object object7 = ADMIN_ACCESS.get(clusterService.getSettings());
        Intrinsics.checkNotNullExpressionValue((Object)object7, (String)"get(...)");
        adminAccess = AdminAccess.valueOf((String)object7);
        Object object8 = FILTER_BY.get(clusterService.getSettings());
        Intrinsics.checkNotNullExpressionValue((Object)object8, (String)"get(...)");
        filterBy = FilterBy.valueOf((String)object8);
        Object object9 = IGNORED_ROLES.get(clusterService.getSettings());
        Intrinsics.checkNotNullExpressionValue((Object)object9, (String)"get(...)");
        ignoredRoles = (List)object9;
    }

    private final void updateSettingValuesFromCluster(ClusterService clusterService) {
        List clusterIgnoredRoles;
        String clusterFilterBy;
        String clusterAdminAccess;
        Integer clusterDefaultItemsQueryCount;
        Integer clusterMaxLockRetries;
        Integer clusterMaxPollingDurationSeconds;
        Integer clusterMinPollingDurationSeconds;
        Integer clusterJobLockDurationSeconds;
        Long clusterOperationTimeoutMs = (Long)clusterService.getClusterSettings().get(OPERATION_TIMEOUT_MS);
        if (clusterOperationTimeoutMs != null) {
            log.debug("observability:opensearch.observability.general.operationTimeoutMs -autoUpdatedTo-> " + clusterOperationTimeoutMs);
            operationTimeoutMs = clusterOperationTimeoutMs;
        }
        if ((clusterJobLockDurationSeconds = (Integer)clusterService.getClusterSettings().get(JOB_LOCK_DURATION_S)) != null) {
            log.debug("observability:opensearch.observability.polling.jobLockDurationSeconds -autoUpdatedTo-> " + clusterJobLockDurationSeconds);
            jobLockDurationSeconds = clusterJobLockDurationSeconds;
        }
        if ((clusterMinPollingDurationSeconds = (Integer)clusterService.getClusterSettings().get(MIN_POLLING_DURATION_S)) != null) {
            log.debug("observability:opensearch.observability.polling.minPollingDurationSeconds -autoUpdatedTo-> " + clusterMinPollingDurationSeconds);
            minPollingDurationSeconds = clusterMinPollingDurationSeconds;
        }
        if ((clusterMaxPollingDurationSeconds = (Integer)clusterService.getClusterSettings().get(MAX_POLLING_DURATION_S)) != null) {
            log.debug("observability:opensearch.observability.polling.maxPollingDurationSeconds -autoUpdatedTo-> " + clusterMaxPollingDurationSeconds);
            maxPollingDurationSeconds = clusterMaxPollingDurationSeconds;
        }
        if ((clusterMaxLockRetries = (Integer)clusterService.getClusterSettings().get(MAX_LOCK_RETRIES)) != null) {
            log.debug("observability:opensearch.observability.polling.maxLockRetries -autoUpdatedTo-> " + clusterMaxLockRetries);
            maxLockRetries = clusterMaxLockRetries;
        }
        if ((clusterDefaultItemsQueryCount = (Integer)clusterService.getClusterSettings().get(DEFAULT_ITEMS_QUERY_COUNT)) != null) {
            log.debug("observability:opensearch.observability.general.defaultItemsQueryCount -autoUpdatedTo-> " + clusterDefaultItemsQueryCount);
            defaultItemsQueryCount = clusterDefaultItemsQueryCount;
        }
        if ((clusterAdminAccess = (String)clusterService.getClusterSettings().get(ADMIN_ACCESS)) != null) {
            log.debug("observability:opensearch.observability.access.adminAccess -autoUpdatedTo-> " + clusterAdminAccess);
            adminAccess = AdminAccess.valueOf(clusterAdminAccess);
        }
        if ((clusterFilterBy = (String)clusterService.getClusterSettings().get(FILTER_BY)) != null) {
            log.debug("observability:opensearch.observability.access.filterBy -autoUpdatedTo-> " + clusterFilterBy);
            filterBy = FilterBy.valueOf(clusterFilterBy);
        }
        if ((clusterIgnoredRoles = (List)clusterService.getClusterSettings().get(IGNORED_ROLES)) != null) {
            log.debug("observability:opensearch.observability.access.ignoreRoles -autoUpdatedTo-> " + clusterIgnoredRoles);
            ignoredRoles = clusterIgnoredRoles;
        }
    }

    public final void addSettingsUpdateConsumer(@NotNull ClusterService clusterService) {
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        this.updateSettingValuesFromLocal(clusterService);
        this.updateSettingValuesFromCluster(clusterService);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(OPERATION_TIMEOUT_MS, PluginSettings::addSettingsUpdateConsumer$lambda$1);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(JOB_LOCK_DURATION_S, PluginSettings::addSettingsUpdateConsumer$lambda$2);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MIN_POLLING_DURATION_S, PluginSettings::addSettingsUpdateConsumer$lambda$3);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MAX_POLLING_DURATION_S, PluginSettings::addSettingsUpdateConsumer$lambda$4);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MAX_LOCK_RETRIES, PluginSettings::addSettingsUpdateConsumer$lambda$5);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(DEFAULT_ITEMS_QUERY_COUNT, PluginSettings::addSettingsUpdateConsumer$lambda$6);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(ADMIN_ACCESS, PluginSettings::addSettingsUpdateConsumer$lambda$7);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(FILTER_BY, PluginSettings::addSettingsUpdateConsumer$lambda$8);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(IGNORED_ROLES, PluginSettings::addSettingsUpdateConsumer$lambda$9);
    }

    private static final String IGNORED_ROLES$lambda$0(String it) {
        return it;
    }

    private static final void addSettingsUpdateConsumer$lambda$1(Long it) {
        Intrinsics.checkNotNull((Object)it);
        operationTimeoutMs = it;
        log.info("observability:opensearch.observability.general.operationTimeoutMs -updatedTo-> " + it);
    }

    private static final void addSettingsUpdateConsumer$lambda$2(Integer it) {
        Intrinsics.checkNotNull((Object)it);
        jobLockDurationSeconds = it;
        log.info("observability:opensearch.observability.polling.jobLockDurationSeconds -updatedTo-> " + it);
    }

    private static final void addSettingsUpdateConsumer$lambda$3(Integer it) {
        Intrinsics.checkNotNull((Object)it);
        minPollingDurationSeconds = it;
        log.info("observability:opensearch.observability.polling.minPollingDurationSeconds -updatedTo-> " + it);
    }

    private static final void addSettingsUpdateConsumer$lambda$4(Integer it) {
        Intrinsics.checkNotNull((Object)it);
        maxPollingDurationSeconds = it;
        log.info("observability:opensearch.observability.polling.maxPollingDurationSeconds -updatedTo-> " + it);
    }

    private static final void addSettingsUpdateConsumer$lambda$5(Integer it) {
        Intrinsics.checkNotNull((Object)it);
        maxLockRetries = it;
        log.info("observability:opensearch.observability.polling.maxLockRetries -updatedTo-> " + it);
    }

    private static final void addSettingsUpdateConsumer$lambda$6(Integer it) {
        Intrinsics.checkNotNull((Object)it);
        defaultItemsQueryCount = it;
        log.info("observability:opensearch.observability.general.defaultItemsQueryCount -updatedTo-> " + it);
    }

    private static final void addSettingsUpdateConsumer$lambda$7(String it) {
        Intrinsics.checkNotNull((Object)it);
        adminAccess = AdminAccess.valueOf(it);
        log.info("observability:opensearch.observability.access.adminAccess -updatedTo-> " + it);
    }

    private static final void addSettingsUpdateConsumer$lambda$8(String it) {
        Intrinsics.checkNotNull((Object)it);
        filterBy = FilterBy.valueOf(it);
        log.info("observability:opensearch.observability.access.filterBy -updatedTo-> " + it);
    }

    private static final void addSettingsUpdateConsumer$lambda$9(List it) {
        Intrinsics.checkNotNull((Object)it);
        ignoredRoles = it;
        log.info("observability:opensearch.observability.access.ignoreRoles -updatedTo-> " + it);
    }

    static {
        String string;
        String configDirName;
        INSTANCE = new PluginSettings();
        Object[] objectArray = new String[]{"own_index", "opensearch_dashboards_user", "notebooks_full_access", "notebooks_read_access"};
        DEFAULT_IGNORED_ROLES = CollectionsKt.listOf((Object[])objectArray);
        log = LogManager.getLogger(INSTANCE.getClass());
        String settings = null;
        Dictionary dictionary = BootstrapInfo.getSystemProperties();
        String string2 = dictionary != null && (dictionary = dictionary.get("opensearch.path.conf")) != null ? dictionary.toString() : (configDirName = null);
        if (configDirName != null) {
            String[] stringArray = new String[]{"opensearch-observability", "observability.yml"};
            Path defaultSettingYmlFile = Path.of(configDirName, stringArray);
            try {
                settings = Settings.builder().loadFromPath(defaultSettingYmlFile).build();
            }
            catch (IOException exception) {
                log.warn("observability:Failed to load " + defaultSettingYmlFile.toAbsolutePath() + " message:" + exception.getMessage());
            }
        }
        operationTimeoutMs = (string = settings) != null && (string = string.get(OPERATION_TIMEOUT_MS_KEY)) != null ? Long.parseLong(string) : 60000L;
        String string3 = settings;
        jobLockDurationSeconds = string3 != null && (string3 = string3.get(JOB_LOCK_DURATION_S_KEY)) != null ? Integer.parseInt(string3) : 300;
        String string4 = settings;
        minPollingDurationSeconds = string4 != null && (string4 = string4.get(MIN_POLLING_DURATION_S_KEY)) != null ? Integer.parseInt(string4) : 300;
        String string5 = settings;
        maxPollingDurationSeconds = string5 != null && (string5 = string5.get(MAX_POLLING_DURATION_S_KEY)) != null ? Integer.parseInt(string5) : 900;
        String string6 = settings;
        maxLockRetries = string6 != null && (string6 = string6.get(MAX_LOCK_RETRIES_KEY)) != null ? Integer.parseInt(string6) : 4;
        String string7 = settings;
        defaultItemsQueryCount = string7 != null && (string7 = string7.get(DEFAULT_ITEMS_QUERY_COUNT_KEY)) != null ? Integer.parseInt(string7) : 1000;
        String string8 = settings;
        if (string8 == null || (string8 = string8.get(ADMIN_ACCESS_KEY)) == null) {
            string8 = DEFAULT_ADMIN_ACCESS_METHOD;
        }
        adminAccess = AdminAccess.valueOf(string8);
        String string9 = settings;
        if (string9 == null || (string9 = string9.get(FILTER_BY_KEY)) == null) {
            string9 = DEFAULT_FILTER_BY_METHOD;
        }
        filterBy = FilterBy.valueOf(string9);
        Object object = settings;
        if (object == null || (object = object.getAsList(IGNORE_ROLE_KEY)) == null) {
            object = DEFAULT_IGNORED_ROLES;
        }
        ignoredRoles = object;
        Pair[] pairArray = new Pair[8];
        String string10 = Long.toString(operationTimeoutMs, CharsKt.checkRadix((int)10));
        Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"toString(...)");
        pairArray[0] = TuplesKt.to((Object)OPERATION_TIMEOUT_MS_KEY, (Object)string10);
        String string11 = Integer.toString(jobLockDurationSeconds, CharsKt.checkRadix((int)10));
        Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"toString(...)");
        pairArray[1] = TuplesKt.to((Object)JOB_LOCK_DURATION_S_KEY, (Object)string11);
        String string12 = Integer.toString(minPollingDurationSeconds, CharsKt.checkRadix((int)10));
        Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"toString(...)");
        pairArray[2] = TuplesKt.to((Object)MIN_POLLING_DURATION_S_KEY, (Object)string12);
        String string13 = Integer.toString(maxPollingDurationSeconds, CharsKt.checkRadix((int)10));
        Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"toString(...)");
        pairArray[3] = TuplesKt.to((Object)MAX_POLLING_DURATION_S_KEY, (Object)string13);
        String string14 = Integer.toString(maxLockRetries, CharsKt.checkRadix((int)10));
        Intrinsics.checkNotNullExpressionValue((Object)string14, (String)"toString(...)");
        pairArray[4] = TuplesKt.to((Object)MAX_LOCK_RETRIES_KEY, (Object)string14);
        String string15 = Integer.toString(defaultItemsQueryCount, CharsKt.checkRadix((int)10));
        Intrinsics.checkNotNullExpressionValue((Object)string15, (String)"toString(...)");
        pairArray[5] = TuplesKt.to((Object)DEFAULT_ITEMS_QUERY_COUNT_KEY, (Object)string15);
        pairArray[6] = TuplesKt.to((Object)ADMIN_ACCESS_KEY, (Object)adminAccess.name());
        pairArray[7] = TuplesKt.to((Object)FILTER_BY_KEY, (Object)filterBy.name());
        defaultSettings = MapsKt.mapOf((Pair[])pairArray);
        String string16 = defaultSettings.get(OPERATION_TIMEOUT_MS_KEY);
        Intrinsics.checkNotNull((Object)string16);
        Setting.Property[] propertyArray = new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic};
        Setting setting = Setting.longSetting((String)OPERATION_TIMEOUT_MS_KEY, (long)Long.parseLong(string16), (long)100L, (Setting.Property[])propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)setting, (String)"longSetting(...)");
        OPERATION_TIMEOUT_MS = setting;
        String string17 = defaultSettings.get(JOB_LOCK_DURATION_S_KEY);
        Intrinsics.checkNotNull((Object)string17);
        propertyArray = new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic};
        Setting setting2 = Setting.intSetting((String)JOB_LOCK_DURATION_S_KEY, (int)Integer.parseInt(string17), (int)10, (Setting.Property[])propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)setting2, (String)"intSetting(...)");
        JOB_LOCK_DURATION_S = setting2;
        String string18 = defaultSettings.get(MIN_POLLING_DURATION_S_KEY);
        Intrinsics.checkNotNull((Object)string18);
        propertyArray = new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic};
        Setting setting3 = Setting.intSetting((String)MIN_POLLING_DURATION_S_KEY, (int)Integer.parseInt(string18), (int)60, (Setting.Property[])propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)setting3, (String)"intSetting(...)");
        MIN_POLLING_DURATION_S = setting3;
        String string19 = defaultSettings.get(MAX_POLLING_DURATION_S_KEY);
        Intrinsics.checkNotNull((Object)string19);
        propertyArray = new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic};
        Setting setting4 = Setting.intSetting((String)MAX_POLLING_DURATION_S_KEY, (int)Integer.parseInt(string19), (int)300, (Setting.Property[])propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)setting4, (String)"intSetting(...)");
        MAX_POLLING_DURATION_S = setting4;
        String string20 = defaultSettings.get(MAX_LOCK_RETRIES_KEY);
        Intrinsics.checkNotNull((Object)string20);
        propertyArray = new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic};
        Setting setting5 = Setting.intSetting((String)MAX_LOCK_RETRIES_KEY, (int)Integer.parseInt(string20), (int)1, (Setting.Property[])propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)setting5, (String)"intSetting(...)");
        MAX_LOCK_RETRIES = setting5;
        String string21 = defaultSettings.get(DEFAULT_ITEMS_QUERY_COUNT_KEY);
        Intrinsics.checkNotNull((Object)string21);
        propertyArray = new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic};
        Setting setting6 = Setting.intSetting((String)DEFAULT_ITEMS_QUERY_COUNT_KEY, (int)Integer.parseInt(string21), (int)10, (Setting.Property[])propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)setting6, (String)"intSetting(...)");
        DEFAULT_ITEMS_QUERY_COUNT = setting6;
        String string22 = defaultSettings.get(ADMIN_ACCESS_KEY);
        Intrinsics.checkNotNull((Object)string22);
        propertyArray = new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic};
        Setting setting7 = Setting.simpleString((String)ADMIN_ACCESS_KEY, (String)string22, (Setting.Property[])propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)setting7, (String)"simpleString(...)");
        ADMIN_ACCESS = setting7;
        String string23 = defaultSettings.get(FILTER_BY_KEY);
        Intrinsics.checkNotNull((Object)string23);
        propertyArray = new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic};
        Setting setting8 = Setting.simpleString((String)FILTER_BY_KEY, (String)string23, (Setting.Property[])propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)setting8, (String)"simpleString(...)");
        FILTER_BY = setting8;
        propertyArray = new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic};
        Setting setting9 = Setting.listSetting((String)IGNORE_ROLE_KEY, DEFAULT_IGNORED_ROLES, PluginSettings::IGNORED_ROLES$lambda$0, (Setting.Property[])propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)setting9, (String)"listSetting(...)");
        IGNORED_ROLES = setting9;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0080\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/opensearch/observability/settings/PluginSettings$AdminAccess;", "", "<init>", "(Ljava/lang/String;I)V", "Standard", "AllObservabilityObjects", "opensearch-observability"})
    public static final class AdminAccess
    extends Enum<AdminAccess> {
        public static final /* enum */ AdminAccess Standard = new AdminAccess();
        public static final /* enum */ AdminAccess AllObservabilityObjects = new AdminAccess();
        private static final /* synthetic */ AdminAccess[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static AdminAccess[] values() {
            return (AdminAccess[])$VALUES.clone();
        }

        public static AdminAccess valueOf(String value) {
            return Enum.valueOf(AdminAccess.class, value);
        }

        @NotNull
        public static EnumEntries<AdminAccess> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = adminAccessArray = new AdminAccess[]{AdminAccess.Standard, AdminAccess.AllObservabilityObjects};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0080\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lorg/opensearch/observability/settings/PluginSettings$FilterBy;", "", "<init>", "(Ljava/lang/String;I)V", "NoFilter", "User", "Roles", "BackendRoles", "opensearch-observability"})
    public static final class FilterBy
    extends Enum<FilterBy> {
        public static final /* enum */ FilterBy NoFilter = new FilterBy();
        public static final /* enum */ FilterBy User = new FilterBy();
        public static final /* enum */ FilterBy Roles = new FilterBy();
        public static final /* enum */ FilterBy BackendRoles = new FilterBy();
        private static final /* synthetic */ FilterBy[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static FilterBy[] values() {
            return (FilterBy[])$VALUES.clone();
        }

        public static FilterBy valueOf(String value) {
            return Enum.valueOf(FilterBy.class, value);
        }

        @NotNull
        public static EnumEntries<FilterBy> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = filterByArray = new FilterBy[]{FilterBy.NoFilter, FilterBy.User, FilterBy.Roles, FilterBy.BackendRoles};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

