/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.tmx;

import java.util.HashSet;
import java.util.Set;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class TMXContentHandler
extends DefaultHandler {
    private final XHTMLContentHandler xhtml;
    private final Metadata metadata;
    private String sourceLang;
    private final Set<String> targetLanguages = new HashSet<String>();
    private int numberOfTUs = 0;
    private int numberOfTUVs = 0;
    private boolean inSegment = false;

    TMXContentHandler(XHTMLContentHandler xhtml, Metadata metadata) {
        this.xhtml = xhtml;
        this.metadata = metadata;
    }

    @Override
    public void startDocument() throws SAXException {
        this.xhtml.startDocument();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        AttributesImpl attrs;
        AttributesImpl attributeVals = new AttributesImpl();
        attributeVals.setAttributes(attributes);
        if ("header".equals(localName)) {
            this.metadata.add("creation-tool", attributes.getValue("creationtool"));
            this.metadata.add("creation-tool-version", attributes.getValue("creationtoolversion"));
            this.metadata.add("segment-type", attributes.getValue("segtype"));
            this.metadata.add("original-format-type", attributes.getValue("o-tmf"));
            this.metadata.add("data-type", attributes.getValue("datatype"));
            this.sourceLang = attributes.getValue("srclang");
            this.metadata.add("source-language", this.sourceLang);
            this.metadata.add("admin-language", attributes.getValue("adminlang"));
        }
        if ("tu".equals(localName)) {
            ++this.numberOfTUs;
            attrs = this.extractAttributes(attributes);
            this.xhtml.startElement("div", attrs);
        }
        if ("tuv".equals(localName)) {
            ++this.numberOfTUVs;
            attrs = this.extractAttributes(attributes);
            this.xhtml.startElement("p", attrs);
        }
        if ("seg".equals(localName)) {
            this.inSegment = true;
        }
    }

    private AttributesImpl extractAttributes(Attributes attributes) {
        AttributesImpl attrs = new AttributesImpl();
        if (null != attributes.getValue("xml:lang")) {
            String lang = attributes.getValue("xml:lang");
            attrs.addAttribute("", "lang", "lang", "", lang);
            if (!lang.equalsIgnoreCase(this.sourceLang)) {
                this.targetLanguages.add(lang);
            }
        }
        if (null != attributes.getValue("o-encoding")) {
            attrs.addAttribute("", "original-encoding", "original-encoding", "", attributes.getValue("o-encoding"));
        }
        if (null != attributes.getValue("datatype")) {
            attrs.addAttribute("", "datatype", "datatype", "", attributes.getValue("datatype"));
        }
        if (null != attributes.getValue("usagecount")) {
            attrs.addAttribute("", "usagecount", "usagecount", "", attributes.getValue("usagecount"));
        }
        if (null != attributes.getValue("lastusagedate")) {
            attrs.addAttribute("", "lastusagedate", "lastusagedate", "", attributes.getValue("lastusagedate"));
        }
        if (null != attributes.getValue("creationdate")) {
            attrs.addAttribute("", "creationdate", "creationdate", "", attributes.getValue("creationdate"));
        }
        if (null != attributes.getValue("creationid")) {
            attrs.addAttribute("", "creationid", "creationid", "", attributes.getValue("creationid"));
        }
        if (null != attributes.getValue("changedate")) {
            attrs.addAttribute("", "changedate", "changedate", "", attributes.getValue("changedate"));
        }
        if (null != attributes.getValue("changeid")) {
            attrs.addAttribute("", "changeid", "changeid", "", attributes.getValue("changeid"));
        }
        if (null != attributes.getValue("tuid")) {
            attrs.addAttribute("", "tuid", "tuid", "", attributes.getValue("tuid"));
        }
        if (null != attributes.getValue("o-tmf")) {
            attrs.addAttribute("", "o-tmf", "o-tmf", "", attributes.getValue("o-tmf"));
        }
        return attrs;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("tu".equals(localName)) {
            this.xhtml.endElement("div");
        }
        if ("tuv".equals(localName)) {
            this.xhtml.endElement("p");
        }
        if ("seg".equals(localName)) {
            this.inSegment = false;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.inSegment && length != 0) {
            this.xhtml.characters(ch, start, length);
        }
    }

    @Override
    public void endDocument() {
        this.targetLanguages.forEach(s -> this.metadata.add("target-language", s));
        this.metadata.set("tu-count", String.valueOf(this.numberOfTUs));
        this.metadata.set("tuv-count", String.valueOf(this.numberOfTUVs));
    }
}

