/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.remote;

import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.util.MovingAverage;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.index.remote.RemoteTransferTracker;

@PublicApi(since="2.10.0")
public class RemoteTranslogTransferTracker
extends RemoteTransferTracker {
    private final AtomicLong lastSuccessfulUploadTimestamp = new AtomicLong(0L);
    private final AtomicLong lastSuccessfulDownloadTimestamp = new AtomicLong(0L);
    private final AtomicLong totalDownloadsSucceeded = new AtomicLong(0L);
    private final AtomicLong downloadBytesSucceeded = new AtomicLong(0L);
    private final AtomicLong totalDownloadTimeInMillis = new AtomicLong(0L);
    private final AtomicReference<MovingAverage> downloadBytesMovingAverageReference;
    private final Object downloadBytesMutex = new Object();
    private final AtomicReference<MovingAverage> downloadBytesPerSecMovingAverageReference;
    private final Object downloadBytesPerSecMutex;
    private final AtomicReference<MovingAverage> downloadTimeMsMovingAverageReference;
    private final Object downloadTimeMsMutex;

    public RemoteTranslogTransferTracker(ShardId shardId, int movingAverageWindowSize) {
        super(shardId, movingAverageWindowSize);
        this.downloadBytesMovingAverageReference = new AtomicReference<MovingAverage>(new MovingAverage(movingAverageWindowSize));
        this.downloadBytesPerSecMutex = new Object();
        this.downloadBytesPerSecMovingAverageReference = new AtomicReference<MovingAverage>(new MovingAverage(movingAverageWindowSize));
        this.downloadTimeMsMutex = new Object();
        this.downloadTimeMsMovingAverageReference = new AtomicReference<MovingAverage>(new MovingAverage(movingAverageWindowSize));
    }

    public long getLastSuccessfulUploadTimestamp() {
        return this.lastSuccessfulUploadTimestamp.get();
    }

    public void setLastSuccessfulUploadTimestamp(long lastSuccessfulUploadTimestamp) {
        this.lastSuccessfulUploadTimestamp.set(lastSuccessfulUploadTimestamp);
    }

    @Override
    void updateMovingAverageWindowSize(int updatedSize) {
        super.updateMovingAverageWindowSize(updatedSize);
        this.updateMovingAverageWindowSize(updatedSize, this.downloadBytesMutex, this.downloadBytesMovingAverageReference);
        this.updateMovingAverageWindowSize(updatedSize, this.downloadBytesPerSecMutex, this.downloadBytesPerSecMovingAverageReference);
        this.updateMovingAverageWindowSize(updatedSize, this.downloadTimeMsMutex, this.downloadTimeMsMovingAverageReference);
    }

    public long getTotalDownloadsSucceeded() {
        return this.totalDownloadsSucceeded.get();
    }

    void incrementDownloadsSucceeded() {
        this.totalDownloadsSucceeded.addAndGet(1L);
    }

    public long getDownloadBytesSucceeded() {
        return this.downloadBytesSucceeded.get();
    }

    public void addDownloadBytesSucceeded(long count) {
        this.downloadBytesSucceeded.addAndGet(count);
    }

    public long getTotalDownloadTimeInMillis() {
        return this.totalDownloadTimeInMillis.get();
    }

    public void addDownloadTimeInMillis(long duration) {
        this.totalDownloadTimeInMillis.addAndGet(duration);
    }

    public long getLastSuccessfulDownloadTimestamp() {
        return this.lastSuccessfulDownloadTimestamp.get();
    }

    void setLastSuccessfulDownloadTimestamp(long lastSuccessfulDownloadTimestamp) {
        this.lastSuccessfulDownloadTimestamp.set(lastSuccessfulDownloadTimestamp);
    }

    boolean isDownloadBytesMovingAverageReady() {
        return this.downloadBytesMovingAverageReference.get().isReady();
    }

    double getDownloadBytesMovingAverage() {
        return this.downloadBytesMovingAverageReference.get().getAverage();
    }

    void updateDownloadBytesMovingAverage(long count) {
        this.updateMovingAverage(count, this.downloadBytesMutex, this.downloadBytesMovingAverageReference);
    }

    boolean isDownloadBytesPerSecMovingAverageReady() {
        return this.downloadBytesPerSecMovingAverageReference.get().isReady();
    }

    double getDownloadBytesPerSecMovingAverage() {
        return this.downloadBytesPerSecMovingAverageReference.get().getAverage();
    }

    void updateDownloadBytesPerSecMovingAverage(long speed) {
        this.updateMovingAverage(speed, this.downloadBytesPerSecMutex, this.downloadBytesPerSecMovingAverageReference);
    }

    boolean isDownloadTimeMovingAverageReady() {
        return this.downloadTimeMsMovingAverageReference.get().isReady();
    }

    double getDownloadTimeMovingAverage() {
        return this.downloadTimeMsMovingAverageReference.get().getAverage();
    }

    void updateDownloadTimeMovingAverage(long duration) {
        this.updateMovingAverage(duration, this.downloadTimeMsMutex, this.downloadTimeMsMovingAverageReference);
    }

    public void recordDownloadStats(long prevDownloadBytesSucceeded, long prevDownloadTimeInMillis) {
        this.setLastSuccessfulDownloadTimestamp(System.currentTimeMillis());
        this.incrementDownloadsSucceeded();
        long bytesDownloaded = this.getDownloadBytesSucceeded() - prevDownloadBytesSucceeded;
        this.updateDownloadBytesMovingAverage(bytesDownloaded);
        long durationInMillis = this.getTotalDownloadTimeInMillis() - prevDownloadTimeInMillis;
        this.updateDownloadTimeMovingAverage(durationInMillis);
        if (durationInMillis > 0L) {
            this.updateDownloadBytesPerSecMovingAverage(bytesDownloaded * 1000L / durationInMillis);
        }
    }

    public Stats stats() {
        return new Stats.Builder().shardId(this.shardId).lastSuccessfulUploadTimestamp(this.lastSuccessfulUploadTimestamp.get()).totalUploadsStarted(this.totalUploadsStarted.get()).totalUploadsSucceeded(this.totalUploadsSucceeded.get()).totalUploadsFailed(this.totalUploadsFailed.get()).uploadBytesStarted(this.uploadBytesStarted.get()).uploadBytesSucceeded(this.uploadBytesSucceeded.get()).uploadBytesFailed(this.uploadBytesFailed.get()).totalUploadTimeInMillis(this.totalUploadTimeInMillis.get()).uploadBytesMovingAverage(((MovingAverage)this.uploadBytesMovingAverageReference.get()).getAverage()).uploadBytesPerSecMovingAverage(((MovingAverage)this.uploadBytesPerSecMovingAverageReference.get()).getAverage()).uploadTimeMovingAverage(((MovingAverage)this.uploadTimeMsMovingAverageReference.get()).getAverage()).lastSuccessfulDownloadTimestamp(this.lastSuccessfulDownloadTimestamp.get()).totalDownloadsSucceeded(this.totalDownloadsSucceeded.get()).downloadBytesSucceeded(this.downloadBytesSucceeded.get()).totalDownloadTimeInMillis(this.totalDownloadTimeInMillis.get()).downloadBytesMovingAverage(this.downloadBytesMovingAverageReference.get().getAverage()).downloadBytesPerSecMovingAverage(this.downloadBytesPerSecMovingAverageReference.get().getAverage()).downloadTimeMovingAverage(this.downloadTimeMsMovingAverageReference.get().getAverage()).build();
    }

    public String toString() {
        return "RemoteTranslogTransferStats{lastSuccessfulUploadTimestamp=" + this.lastSuccessfulUploadTimestamp.get() + ",totalUploadsStarted=" + this.totalUploadsStarted.get() + ",totalUploadsSucceeded=" + this.totalUploadsSucceeded.get() + ",totalUploadsFailed=" + this.totalUploadsFailed.get() + ",uploadBytesStarted=" + this.uploadBytesStarted.get() + ",uploadBytesFailed=" + this.uploadBytesFailed.get() + ",totalUploadTimeInMillis=" + this.totalUploadTimeInMillis.get() + ",uploadBytesMovingAverage=" + ((MovingAverage)this.uploadBytesMovingAverageReference.get()).getAverage() + ",uploadBytesPerSecMovingAverage=" + ((MovingAverage)this.uploadBytesPerSecMovingAverageReference.get()).getAverage() + ",uploadTimeMovingAverage=" + ((MovingAverage)this.uploadTimeMsMovingAverageReference.get()).getAverage() + ",lastSuccessfulDownloadTimestamp=" + this.lastSuccessfulDownloadTimestamp.get() + ",totalDownloadsSucceeded=" + this.totalDownloadsSucceeded.get() + ",downloadBytesSucceeded=" + this.downloadBytesSucceeded.get() + ",totalDownloadTimeInMillis=" + this.totalDownloadTimeInMillis.get() + ",downloadBytesMovingAverage=" + this.downloadBytesMovingAverageReference.get().getAverage() + ",downloadBytesPerSecMovingAverage=" + this.downloadBytesPerSecMovingAverageReference.get().getAverage() + ",downloadTimeMovingAverage=" + this.downloadTimeMsMovingAverageReference.get().getAverage() + ",}";
    }

    boolean hasSameStatsAs(Stats other) {
        return this.stats().equals(other);
    }

    @PublicApi(since="2.10.0")
    public static class Stats
    implements Writeable {
        final ShardId shardId;
        public final long lastSuccessfulUploadTimestamp;
        public final long totalUploadsStarted;
        public final long totalUploadsFailed;
        public final long totalUploadsSucceeded;
        public final long uploadBytesStarted;
        public final long uploadBytesFailed;
        public final long uploadBytesSucceeded;
        public final long totalUploadTimeInMillis;
        public final double uploadBytesMovingAverage;
        public final double uploadBytesPerSecMovingAverage;
        public final double uploadTimeMovingAverage;
        public final long lastSuccessfulDownloadTimestamp;
        public final long totalDownloadsSucceeded;
        public final long downloadBytesSucceeded;
        public final long totalDownloadTimeInMillis;
        public final double downloadBytesMovingAverage;
        public final double downloadBytesPerSecMovingAverage;
        public final double downloadTimeMovingAverage;

        private Stats(Builder builder) {
            this.shardId = builder.shardId;
            this.lastSuccessfulUploadTimestamp = builder.lastSuccessfulUploadTimestamp;
            this.totalUploadsStarted = builder.totalUploadsStarted;
            this.totalUploadsSucceeded = builder.totalUploadsSucceeded;
            this.totalUploadsFailed = builder.totalUploadsFailed;
            this.uploadBytesStarted = builder.uploadBytesStarted;
            this.uploadBytesSucceeded = builder.uploadBytesSucceeded;
            this.uploadBytesFailed = builder.uploadBytesFailed;
            this.totalUploadTimeInMillis = builder.totalUploadTimeInMillis;
            this.uploadBytesMovingAverage = builder.uploadBytesMovingAverage;
            this.uploadBytesPerSecMovingAverage = builder.uploadBytesPerSecMovingAverage;
            this.uploadTimeMovingAverage = builder.uploadTimeMovingAverage;
            this.lastSuccessfulDownloadTimestamp = builder.lastSuccessfulDownloadTimestamp;
            this.totalDownloadsSucceeded = builder.totalDownloadsSucceeded;
            this.downloadBytesSucceeded = builder.downloadBytesSucceeded;
            this.totalDownloadTimeInMillis = builder.totalDownloadTimeInMillis;
            this.downloadBytesMovingAverage = builder.downloadBytesMovingAverage;
            this.downloadBytesPerSecMovingAverage = builder.downloadBytesPerSecMovingAverage;
            this.downloadTimeMovingAverage = builder.downloadTimeMovingAverage;
        }

        @Deprecated
        public Stats(ShardId shardId, long lastSuccessfulUploadTimestamp, long totalUploadsStarted, long totalUploadsSucceeded, long totalUploadsFailed, long uploadBytesStarted, long uploadBytesSucceeded, long uploadBytesFailed, long totalUploadTimeInMillis, double uploadBytesMovingAverage, double uploadBytesPerSecMovingAverage, double uploadTimeMovingAverage, long lastSuccessfulDownloadTimestamp, long totalDownloadsSucceeded, long downloadBytesSucceeded, long totalDownloadTimeInMillis, double downloadBytesMovingAverage, double downloadBytesPerSecMovingAverage, double downloadTimeMovingAverage) {
            this.shardId = shardId;
            this.lastSuccessfulUploadTimestamp = lastSuccessfulUploadTimestamp;
            this.totalUploadsStarted = totalUploadsStarted;
            this.totalUploadsFailed = totalUploadsFailed;
            this.totalUploadsSucceeded = totalUploadsSucceeded;
            this.uploadBytesStarted = uploadBytesStarted;
            this.uploadBytesFailed = uploadBytesFailed;
            this.uploadBytesSucceeded = uploadBytesSucceeded;
            this.totalUploadTimeInMillis = totalUploadTimeInMillis;
            this.uploadBytesMovingAverage = uploadBytesMovingAverage;
            this.uploadBytesPerSecMovingAverage = uploadBytesPerSecMovingAverage;
            this.uploadTimeMovingAverage = uploadTimeMovingAverage;
            this.lastSuccessfulDownloadTimestamp = lastSuccessfulDownloadTimestamp;
            this.totalDownloadsSucceeded = totalDownloadsSucceeded;
            this.downloadBytesSucceeded = downloadBytesSucceeded;
            this.totalDownloadTimeInMillis = totalDownloadTimeInMillis;
            this.downloadBytesMovingAverage = downloadBytesMovingAverage;
            this.downloadBytesPerSecMovingAverage = downloadBytesPerSecMovingAverage;
            this.downloadTimeMovingAverage = downloadTimeMovingAverage;
        }

        public Stats(StreamInput in) throws IOException {
            this.shardId = new ShardId(in);
            this.lastSuccessfulUploadTimestamp = in.readVLong();
            this.totalUploadsStarted = in.readVLong();
            this.totalUploadsFailed = in.readVLong();
            this.totalUploadsSucceeded = in.readVLong();
            this.uploadBytesStarted = in.readVLong();
            this.uploadBytesFailed = in.readVLong();
            this.uploadBytesSucceeded = in.readVLong();
            this.totalUploadTimeInMillis = in.readVLong();
            this.uploadBytesMovingAverage = in.readDouble();
            this.uploadBytesPerSecMovingAverage = in.readDouble();
            this.uploadTimeMovingAverage = in.readDouble();
            this.lastSuccessfulDownloadTimestamp = in.readVLong();
            this.totalDownloadsSucceeded = in.readVLong();
            this.downloadBytesSucceeded = in.readVLong();
            this.totalDownloadTimeInMillis = in.readVLong();
            this.downloadBytesMovingAverage = in.readDouble();
            this.downloadBytesPerSecMovingAverage = in.readDouble();
            this.downloadTimeMovingAverage = in.readDouble();
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.shardId.writeTo(out);
            out.writeVLong(this.lastSuccessfulUploadTimestamp);
            out.writeVLong(this.totalUploadsStarted);
            out.writeVLong(this.totalUploadsFailed);
            out.writeVLong(this.totalUploadsSucceeded);
            out.writeVLong(this.uploadBytesStarted);
            out.writeVLong(this.uploadBytesFailed);
            out.writeVLong(this.uploadBytesSucceeded);
            out.writeVLong(this.totalUploadTimeInMillis);
            out.writeDouble(this.uploadBytesMovingAverage);
            out.writeDouble(this.uploadBytesPerSecMovingAverage);
            out.writeDouble(this.uploadTimeMovingAverage);
            out.writeVLong(this.lastSuccessfulDownloadTimestamp);
            out.writeVLong(this.totalDownloadsSucceeded);
            out.writeVLong(this.downloadBytesSucceeded);
            out.writeVLong(this.totalDownloadTimeInMillis);
            out.writeDouble(this.downloadBytesMovingAverage);
            out.writeDouble(this.downloadBytesPerSecMovingAverage);
            out.writeDouble(this.downloadTimeMovingAverage);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Stats other = (Stats)obj;
            return this.shardId.equals((Object)other.shardId) && this.lastSuccessfulUploadTimestamp == other.lastSuccessfulUploadTimestamp && this.totalUploadsStarted == other.totalUploadsStarted && this.totalUploadsFailed == other.totalUploadsFailed && this.totalUploadsSucceeded == other.totalUploadsSucceeded && this.uploadBytesStarted == other.uploadBytesStarted && this.uploadBytesFailed == other.uploadBytesFailed && this.uploadBytesSucceeded == other.uploadBytesSucceeded && this.totalUploadTimeInMillis == other.totalUploadTimeInMillis && Double.compare(this.uploadBytesMovingAverage, other.uploadBytesMovingAverage) == 0 && Double.compare(this.uploadBytesPerSecMovingAverage, other.uploadBytesPerSecMovingAverage) == 0 && Double.compare(this.uploadTimeMovingAverage, other.uploadTimeMovingAverage) == 0 && this.lastSuccessfulDownloadTimestamp == other.lastSuccessfulDownloadTimestamp && this.totalDownloadsSucceeded == other.totalDownloadsSucceeded && this.downloadBytesSucceeded == other.downloadBytesSucceeded && this.totalDownloadTimeInMillis == other.totalDownloadTimeInMillis && Double.compare(this.downloadBytesMovingAverage, other.downloadBytesMovingAverage) == 0 && Double.compare(this.downloadBytesPerSecMovingAverage, other.downloadBytesPerSecMovingAverage) == 0 && Double.compare(this.downloadTimeMovingAverage, other.downloadTimeMovingAverage) == 0;
        }

        public int hashCode() {
            return Objects.hash(this.shardId.toString(), this.lastSuccessfulUploadTimestamp, this.totalUploadsStarted, this.totalUploadsFailed, this.totalUploadsSucceeded, this.uploadBytesStarted, this.uploadBytesFailed, this.uploadBytesSucceeded, this.totalUploadTimeInMillis, this.uploadBytesMovingAverage, this.uploadBytesPerSecMovingAverage, this.uploadTimeMovingAverage, this.lastSuccessfulDownloadTimestamp, this.totalDownloadsSucceeded, this.downloadBytesSucceeded, this.totalDownloadTimeInMillis, this.downloadBytesMovingAverage, this.downloadBytesPerSecMovingAverage, this.downloadTimeMovingAverage);
        }

        public static class Builder {
            private ShardId shardId = null;
            private long lastSuccessfulUploadTimestamp = 0L;
            private long totalUploadsStarted = 0L;
            private long totalUploadsSucceeded = 0L;
            private long totalUploadsFailed = 0L;
            private long uploadBytesStarted = 0L;
            private long uploadBytesSucceeded = 0L;
            private long uploadBytesFailed = 0L;
            private long totalUploadTimeInMillis = 0L;
            private double uploadBytesMovingAverage = 0.0;
            private double uploadBytesPerSecMovingAverage = 0.0;
            private double uploadTimeMovingAverage = 0.0;
            private long lastSuccessfulDownloadTimestamp = 0L;
            private long totalDownloadsSucceeded = 0L;
            private long downloadBytesSucceeded = 0L;
            private long totalDownloadTimeInMillis = 0L;
            private double downloadBytesMovingAverage = 0.0;
            private double downloadBytesPerSecMovingAverage = 0.0;
            private double downloadTimeMovingAverage = 0.0;

            public Builder shardId(ShardId shardId) {
                this.shardId = shardId;
                return this;
            }

            public Builder lastSuccessfulUploadTimestamp(long timestamp) {
                this.lastSuccessfulUploadTimestamp = timestamp;
                return this;
            }

            public Builder totalUploadsStarted(long started) {
                this.totalUploadsStarted = started;
                return this;
            }

            public Builder totalUploadsSucceeded(long succeeded) {
                this.totalUploadsSucceeded = succeeded;
                return this;
            }

            public Builder totalUploadsFailed(long failed) {
                this.totalUploadsFailed = failed;
                return this;
            }

            public Builder uploadBytesStarted(long started) {
                this.uploadBytesStarted = started;
                return this;
            }

            public Builder uploadBytesSucceeded(long succeeded) {
                this.uploadBytesSucceeded = succeeded;
                return this;
            }

            public Builder uploadBytesFailed(long failed) {
                this.uploadBytesFailed = failed;
                return this;
            }

            public Builder totalUploadTimeInMillis(long time) {
                this.totalUploadTimeInMillis = time;
                return this;
            }

            public Builder uploadBytesMovingAverage(double average) {
                this.uploadBytesMovingAverage = average;
                return this;
            }

            public Builder uploadBytesPerSecMovingAverage(double average) {
                this.uploadBytesPerSecMovingAverage = average;
                return this;
            }

            public Builder uploadTimeMovingAverage(double average) {
                this.uploadTimeMovingAverage = average;
                return this;
            }

            public Builder lastSuccessfulDownloadTimestamp(long timestamp) {
                this.lastSuccessfulDownloadTimestamp = timestamp;
                return this;
            }

            public Builder totalDownloadsSucceeded(long succeeded) {
                this.totalDownloadsSucceeded = succeeded;
                return this;
            }

            public Builder downloadBytesSucceeded(long succeeded) {
                this.downloadBytesSucceeded = succeeded;
                return this;
            }

            public Builder totalDownloadTimeInMillis(long time) {
                this.totalDownloadTimeInMillis = time;
                return this;
            }

            public Builder downloadBytesMovingAverage(double average) {
                this.downloadBytesMovingAverage = average;
                return this;
            }

            public Builder downloadBytesPerSecMovingAverage(double average) {
                this.downloadBytesPerSecMovingAverage = average;
                return this;
            }

            public Builder downloadTimeMovingAverage(double average) {
                this.downloadTimeMovingAverage = average;
                return this;
            }

            public Stats build() {
                return new Stats(this);
            }
        }
    }
}

