<?php

declare (strict_types=1);
namespace OCA\News\Vendor\FeedIo\Standard;

use OCA\News\Vendor\FeedIo\Formatter\JsonFormatter;
use OCA\News\Vendor\FeedIo\FormatterInterface;
use OCA\News\Vendor\FeedIo\Reader\Document;
use OCA\News\Vendor\FeedIo\StandardAbstract;
class Json extends StandardAbstract
{
    public const SYNTAX_FORMAT = 'Json';
    public const MIME_TYPE = 'application/feed+json';
    protected array $mandatoryFields = ['version', 'title', 'items'];
    /**
     * @param Document $document
     * @return bool
     */
    public function canHandle(Document $document): bool
    {
        return $document->isJson();
    }
    /**
     * @return FormatterInterface
     */
    public function getFormatter(): FormatterInterface
    {
        return new JsonFormatter();
    }
}
