/*
 * Decompiled with CFR 0.152.
 */
package com.github.lgooddatepicker.zinternaltools;

import com.github.lgooddatepicker.components.DatePicker;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;

public class Convert {
    private DatePicker parentDatePicker;

    public Convert(DatePicker parentDatePicker) {
        this.parentDatePicker = parentDatePicker;
    }

    public Date getDateWithDefaultZone() {
        LocalDate pickerDate = this.parentDatePicker.getDate();
        if (pickerDate == null) {
            return null;
        }
        Instant instant = pickerDate.atStartOfDay(ZoneId.systemDefault()).toInstant();
        Date javaUtilDate = this.getJavaUtilDateFromInstant(instant);
        return javaUtilDate;
    }

    public Date getDateWithZone(ZoneId timezone) {
        LocalDate pickerDate = this.parentDatePicker.getDate();
        if (pickerDate == null || timezone == null) {
            return null;
        }
        Instant instant = pickerDate.atStartOfDay(timezone).toInstant();
        Date javaUtilDate = this.getJavaUtilDateFromInstant(instant);
        return javaUtilDate;
    }

    public void setDateWithDefaultZone(Date javaUtilDate) {
        if (javaUtilDate == null) {
            this.parentDatePicker.setDate(null);
            return;
        }
        Instant instant = Instant.ofEpochMilli(javaUtilDate.getTime());
        ZonedDateTime zonedDateTime = instant.atZone(ZoneId.systemDefault());
        LocalDate localDate = zonedDateTime.toLocalDate();
        this.parentDatePicker.setDate(localDate);
    }

    public void setDateWithZone(Date javaUtilDate, ZoneId timezone) {
        if (javaUtilDate == null || timezone == null) {
            this.parentDatePicker.setDate(null);
            return;
        }
        Instant instant = Instant.ofEpochMilli(javaUtilDate.getTime());
        ZonedDateTime zonedDateTime = instant.atZone(timezone);
        LocalDate localDate = zonedDateTime.toLocalDate();
        this.parentDatePicker.setDate(localDate);
    }

    private Date getJavaUtilDateFromInstant(Instant instant) {
        Date javaUtilDate;
        try {
            javaUtilDate = new Date(instant.toEpochMilli());
        }
        catch (ArithmeticException ex) {
            throw new IllegalArgumentException(ex);
        }
        return javaUtilDate;
    }
}

