/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.workflow;

import org.antlr.v4.runtime.tree.ParseTree;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.workflow.ResourceOperationType;
import org.keycloak.models.workflow.ResourceType;
import org.keycloak.models.workflow.WorkflowEvent;
import org.keycloak.models.workflow.WorkflowExecutionContext;
import org.keycloak.models.workflow.conditions.expression.BooleanConditionParser;
import org.keycloak.models.workflow.conditions.expression.ConditionEvaluator;
import org.keycloak.models.workflow.conditions.expression.EvaluatorUtils;
import org.keycloak.models.workflow.conditions.expression.EventEvaluator;
import org.keycloak.utils.StringUtil;

final class EventBasedWorkflow {
    private final KeycloakSession session;
    private final ComponentModel model;

    EventBasedWorkflow(KeycloakSession session, ComponentModel model) {
        this.session = session;
        this.model = model;
    }

    boolean supports(ResourceType type) {
        return ResourceType.USERS.equals((Object)type);
    }

    boolean activate(WorkflowExecutionContext executionContext) {
        WorkflowEvent event = executionContext.getEvent();
        if (event == null) {
            return false;
        }
        return this.supports(event.getResourceType()) && this.activateOnEvent(event) && this.validateResourceConditions(executionContext);
    }

    boolean deactivate(WorkflowExecutionContext executionContext) {
        String cancelInProgress = (String)this.model.getConfig().getFirst((Object)"cancel-in-progress");
        return this.matchesConcurrencySetting(executionContext, cancelInProgress);
    }

    boolean restart(WorkflowExecutionContext executionContext) {
        String restartInProgress = (String)this.model.getConfig().getFirst((Object)"restart-in-progress");
        return this.matchesConcurrencySetting(executionContext, restartInProgress);
    }

    public boolean validateResourceConditions(WorkflowExecutionContext context) {
        String conditions = (String)this.getModel().getConfig().getFirst((Object)"conditions");
        if (StringUtil.isNotBlank((String)conditions)) {
            BooleanConditionParser.EvaluatorContext evaluatorContext = EvaluatorUtils.createEvaluatorContext(this.model, conditions);
            ConditionEvaluator evaluator = new ConditionEvaluator(this.session, context);
            return (Boolean)evaluator.visit((ParseTree)evaluatorContext);
        }
        return true;
    }

    private boolean activateOnEvent(WorkflowEvent event) {
        if (ResourceOperationType.AD_HOC.equals((Object)event.getOperation())) {
            return true;
        }
        String eventConditions = (String)this.model.getConfig().getFirst((Object)"on");
        if (StringUtil.isNotBlank((String)eventConditions)) {
            BooleanConditionParser.EvaluatorContext context = EvaluatorUtils.createEvaluatorContext(this.model, eventConditions);
            EventEvaluator eventEvaluator = new EventEvaluator(this.getSession(), event);
            return (Boolean)eventEvaluator.visit((ParseTree)context);
        }
        return false;
    }

    private boolean matchesConcurrencySetting(WorkflowExecutionContext executionContext, String concurrencySetting) {
        WorkflowEvent event = executionContext.getEvent();
        if (event == null) {
            return false;
        }
        if (StringUtil.isNotBlank((String)concurrencySetting)) {
            if (Boolean.parseBoolean(concurrencySetting)) {
                return StringUtil.isNotBlank((String)((String)this.model.getConfig().getFirst((Object)"on"))) && this.activate(executionContext);
            }
            BooleanConditionParser.EvaluatorContext context = EvaluatorUtils.createEvaluatorContext(this.model, concurrencySetting);
            EventEvaluator eventEvaluator = new EventEvaluator(this.getSession(), executionContext.getEvent());
            return (Boolean)eventEvaluator.visit((ParseTree)context);
        }
        return false;
    }

    private ComponentModel getModel() {
        return this.model;
    }

    private KeycloakSession getSession() {
        return this.session;
    }
}

