/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.platform;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.stream.Stream;
import jdk.internal.platform.CgroupSubsystemController;

public final class CgroupUtil {
    public static Stream<String> readFilePrivileged(Path path) throws IOException {
        try {
            PrivilegedExceptionAction<Stream> privilegedExceptionAction = () -> Files.lines(path);
            return AccessController.doPrivileged(privilegedExceptionAction);
        }
        catch (PrivilegedActionException privilegedActionException) {
            CgroupUtil.unwrapIOExceptionAndRethrow(privilegedActionException);
            throw new InternalError(privilegedActionException.getCause());
        }
        catch (UncheckedIOException uncheckedIOException) {
            throw uncheckedIOException.getCause();
        }
    }

    static void unwrapIOExceptionAndRethrow(PrivilegedActionException privilegedActionException) throws IOException {
        Throwable throwable = privilegedActionException.getCause();
        if (throwable instanceof IOException) {
            throw (IOException)throwable;
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String readStringValue(CgroupSubsystemController cgroupSubsystemController, String string) throws IOException {
        PrivilegedExceptionAction<BufferedReader> privilegedExceptionAction = () -> Files.newBufferedReader(Paths.get(cgroupSubsystemController.path(), string));
        try (BufferedReader bufferedReader = AccessController.doPrivileged(privilegedExceptionAction);){
            String string2;
            String string3 = string2 = bufferedReader.readLine();
            return string3;
        }
        catch (PrivilegedActionException privilegedActionException) {
            CgroupUtil.unwrapIOExceptionAndRethrow(privilegedActionException);
            throw new InternalError(privilegedActionException.getCause());
        }
        catch (UncheckedIOException uncheckedIOException) {
            throw uncheckedIOException.getCause();
        }
    }

    public static List<String> readAllLinesPrivileged(Path path) throws IOException {
        try {
            PrivilegedExceptionAction<List> privilegedExceptionAction = () -> Files.readAllLines(path);
            return AccessController.doPrivileged(privilegedExceptionAction);
        }
        catch (PrivilegedActionException privilegedActionException) {
            CgroupUtil.unwrapIOExceptionAndRethrow(privilegedActionException);
            throw new InternalError(privilegedActionException.getCause());
        }
        catch (UncheckedIOException uncheckedIOException) {
            throw uncheckedIOException.getCause();
        }
    }
}

