/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.chat;

import dev.langchain4j.memory.ChatMemory;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.text.TextController;
import org.freeplane.plugin.ai.chat.AIChatPanel;
import org.freeplane.plugin.ai.chat.AssistantProfileChatMemory;
import org.freeplane.plugin.ai.chat.AssistantProfileSwitchMessage;
import org.freeplane.plugin.ai.chat.ChatListDialog;
import org.freeplane.plugin.ai.chat.ChatMemorySettings;
import org.freeplane.plugin.ai.chat.ChatTokenUsageState;
import org.freeplane.plugin.ai.chat.LiveChatSession;
import org.freeplane.plugin.ai.chat.LiveChatSessionId;
import org.freeplane.plugin.ai.chat.LiveChatSessionManager;
import org.freeplane.plugin.ai.chat.MapRootShortTextCountsMerger;
import org.freeplane.plugin.ai.chat.MapRootShortTextFormatter;
import org.freeplane.plugin.ai.chat.TranscriptMemoryMapper;
import org.freeplane.plugin.ai.chat.history.ChatTranscriptEntry;
import org.freeplane.plugin.ai.chat.history.ChatTranscriptId;
import org.freeplane.plugin.ai.chat.history.ChatTranscriptRecord;
import org.freeplane.plugin.ai.chat.history.ChatTranscriptStore;
import org.freeplane.plugin.ai.chat.history.MapRootShortTextCount;
import org.freeplane.plugin.ai.maps.AvailableMaps;

public class LiveChatController {
    private final AIChatPanel owner;
    private final LiveChatSessionManager liveChatSessionManager;
    private final DateTimeFormatter chatNameFormatter;
    private final SessionActivationHandler sessionActivationHandler;
    private final ChatTranscriptStore transcriptStore;
    private final TranscriptMemoryMapper transcriptMemoryMapper;
    private final ChatMemorySettings chatMemorySettings;
    private final MapRootShortTextFormatter mapRootShortTextFormatter;
    private final MapRootShortTextCountsMerger mapRootShortTextCountsMerger;
    private final Supplier<ChatTokenUsageState> tokenUsageStateSupplier;
    private static final String TRANSCRIPT_HIDDEN_SYSTEM_MESSAGE = "System message: The messages in this session include a restored transcript of a prior chat. Treat those messages as the earlier conversation context, not as hallucinations. The currently opened map may differ from the maps discussed in that transcript. Confirm the map context with the user when needed. The real conversation begins after this message. ";

    public LiveChatController(AIChatPanel parent, AvailableMaps availableMaps, TextController textController, DateTimeFormatter chatNameFormatter, SessionActivationHandler sessionActivationHandler, Supplier<ChatTokenUsageState> tokenUsageStateSupplier) {
        this.owner = parent;
        this.chatNameFormatter = chatNameFormatter;
        this.sessionActivationHandler = sessionActivationHandler;
        this.tokenUsageStateSupplier = tokenUsageStateSupplier;
        this.liveChatSessionManager = new LiveChatSessionManager();
        this.transcriptStore = new ChatTranscriptStore();
        this.transcriptMemoryMapper = new TranscriptMemoryMapper();
        this.chatMemorySettings = new ChatMemorySettings();
        this.mapRootShortTextFormatter = new MapRootShortTextFormatter(availableMaps, textController);
        this.mapRootShortTextCountsMerger = new MapRootShortTextCountsMerger();
    }

    public void initialize(ChatMemory chatMemory) {
        LiveChatSession initialSession = this.liveChatSessionManager.createSession(chatMemory, this.buildDefaultChatName());
        this.liveChatSessionManager.setCurrentSession(initialSession.getId());
        this.sessionActivationHandler.activate(chatMemory, false);
    }

    public void startNewChat() {
        this.switchToNewSession();
    }

    public void openLiveChats() {
        this.createChatListDialog().openDialog();
    }

    public void updateSessionNameFromFirstUserMessage(String userMessage) {
        String normalized;
        LiveChatSession session = this.liveChatSessionManager.getCurrentSession();
        if (session == null) {
            return;
        }
        if (session.isNameEdited() || session.isUserMessageNameApplied()) {
            return;
        }
        String string = normalized = userMessage == null ? "" : userMessage.trim();
        if (normalized.isEmpty()) {
            return;
        }
        String updatedName = this.buildUserMessageName(session.getDisplayName(), normalized);
        this.liveChatSessionManager.updateUserMessageName(updatedName);
    }

    public AvailableMaps.MapAccessListener mapAccessListener() {
        return this::recordMapAccess;
    }

    public void recordUserMessage(String message) {
        this.synchronizeTranscriptWithMemory();
    }

    public void recordAssistantMessage(String message) {
        this.synchronizeTranscriptWithMemory();
    }

    public void recordAssistantProfileMessage(AssistantProfileSwitchMessage message) {
        this.synchronizeTranscriptWithMemory();
    }

    public List<ChatTranscriptEntry> snapshotTranscriptEntries() {
        LiveChatSession session = this.liveChatSessionManager.getCurrentSession();
        if (session == null) {
            return new ArrayList<ChatTranscriptEntry>();
        }
        return new ArrayList<ChatTranscriptEntry>(session.getTranscriptEntries());
    }

    public void persistCurrentSessionIfNeeded() {
        this.persistCurrentSession();
    }

    public ChatTokenUsageState getCurrentTokenUsageState() {
        LiveChatSession session = this.liveChatSessionManager.getCurrentSession();
        if (session == null) {
            return null;
        }
        return session.getTokenUsageState();
    }

    public boolean canUndo() {
        AssistantProfileChatMemory memory = this.activeAssistantProfileChatMemory();
        return memory != null && memory.canUndo();
    }

    public boolean canRedo() {
        AssistantProfileChatMemory memory = this.activeAssistantProfileChatMemory();
        return memory != null && memory.canRedo();
    }

    public String undoLastTurn() {
        AssistantProfileChatMemory memory = this.activeAssistantProfileChatMemory();
        if (memory == null || !memory.canUndo()) {
            return "";
        }
        String userMessage = memory.undo();
        this.synchronizeTranscriptWithMemory();
        return userMessage;
    }

    public void redoLastTurn() {
        AssistantProfileChatMemory memory = this.activeAssistantProfileChatMemory();
        if (memory == null || !memory.canRedo()) {
            return;
        }
        memory.redo();
        this.synchronizeTranscriptWithMemory();
    }

    public void synchronizeTranscriptWithMemory() {
        LiveChatSession session = this.liveChatSessionManager.getCurrentSession();
        if (session == null) {
            return;
        }
        session.setTranscriptEntries(this.transcriptMemoryMapper.toTranscriptEntries(session.getChatMemory()));
        session.setLastActivityTimestamp(System.currentTimeMillis());
    }

    private void switchToNewSession() {
        this.persistCurrentSession();
        ChatMemory newChatMemory = this.createChatMemory();
        LiveChatSession newSession = this.liveChatSessionManager.createSession(newChatMemory, this.buildDefaultChatName());
        this.switchToSession(newSession.getId(), false, false);
    }

    private void switchToSession(LiveChatSessionId sessionId) {
        this.switchToSession(sessionId, true, false);
    }

    private void switchToSession(LiveChatSessionId sessionId, boolean saveCurrent) {
        this.switchToSession(sessionId, saveCurrent, false);
    }

    private void switchToSession(LiveChatSessionId sessionId, boolean saveCurrent, boolean fromTranscriptRestore) {
        if (sessionId == null) {
            return;
        }
        if (saveCurrent) {
            this.persistCurrentSession();
        }
        this.liveChatSessionManager.setCurrentSession(sessionId);
        LiveChatSession session = this.liveChatSessionManager.getCurrentSession();
        if (session == null) {
            return;
        }
        this.sessionActivationHandler.activate(session.getChatMemory(), fromTranscriptRestore);
    }

    private void closeSession(LiveChatSessionId sessionId) {
        if (sessionId == null) {
            return;
        }
        LiveChatSession activeSession = this.liveChatSessionManager.getCurrentSession();
        if (activeSession != null && sessionId.equals(activeSession.getId())) {
            this.persistCurrentSession();
        }
        this.liveChatSessionManager.remove(sessionId);
        LiveChatSession nextSession = this.liveChatSessionManager.getCurrentSession();
        if (nextSession == null) {
            this.switchToNewSession();
            return;
        }
        this.switchToSession(nextSession.getId(), false);
    }

    private void deleteLiveSessionInternal(LiveChatSessionId sessionId) {
        if (sessionId == null) {
            return;
        }
        LiveChatSession activeSession = this.liveChatSessionManager.getCurrentSession();
        boolean isActive = activeSession != null && sessionId.equals(activeSession.getId());
        this.liveChatSessionManager.remove(sessionId);
        if (!isActive) {
            return;
        }
        ChatMemory newChatMemory = this.createChatMemory();
        LiveChatSession newSession = this.liveChatSessionManager.createSession(newChatMemory, this.buildDefaultChatName());
        this.liveChatSessionManager.setCurrentSession(newSession.getId());
        this.sessionActivationHandler.activate(newChatMemory, false);
    }

    private void persistCurrentSession() {
        ChatTranscriptRecord existingRecord;
        List<MapRootShortTextCount> mergedSessionCounts;
        LiveChatSession session = this.liveChatSessionManager.getCurrentSession();
        if (session == null) {
            return;
        }
        session.setTranscriptEntries(this.transcriptMemoryMapper.toTranscriptEntries(session.getChatMemory()));
        this.storeTokenUsageState(session);
        if (session.getTranscriptEntries().isEmpty() && session.getTranscriptId() == null) {
            return;
        }
        ChatTranscriptRecord record = new ChatTranscriptRecord();
        record.setDisplayName(session.getDisplayName());
        record.setEntries(new ArrayList<ChatTranscriptEntry>(session.getTranscriptEntries()));
        List<MapRootShortTextCount> currentCounts = this.mapRootShortTextFormatter.buildCounts(new ArrayList<String>(session.getMapIds()));
        List<MapRootShortTextCount> mergedCounts = mergedSessionCounts = this.mapRootShortTextCountsMerger.mergeByMax(session.getMapRootShortTextCounts(), currentCounts);
        if (session.getTranscriptId() != null && (existingRecord = this.transcriptStore.load(session.getTranscriptId())) != null) {
            mergedCounts = this.mapRootShortTextCountsMerger.mergeByMax(existingRecord.getMapRootShortTextCounts(), mergedSessionCounts);
        }
        record.setMapRootShortTextCounts(mergedCounts);
        ChatTranscriptId transcriptId = this.transcriptStore.save(record, session.getTranscriptId());
        session.setTranscriptId(transcriptId);
        session.setLastActivityTimestamp(record.getTimestamp());
    }

    private String buildDefaultChatName() {
        return this.chatNameFormatter.format(LocalDateTime.now());
    }

    private String buildUserMessageName(String timestampLabel, String userMessage) {
        String[] words = userMessage.split("\\s+");
        StringBuilder builder = new StringBuilder(timestampLabel);
        builder.append(" - ");
        for (int index = 0; index < words.length && index < 4; ++index) {
            if (index > 0) {
                builder.append(' ');
            }
            builder.append(words[index]);
        }
        return builder.toString().trim();
    }

    private void recordMapAccess(UUID mapIdentifier, MapModel mapModel) {
        if (mapIdentifier == null) {
            return;
        }
        LiveChatSession session = this.liveChatSessionManager.getCurrentSession();
        if (session == null) {
            return;
        }
        session.getMapIds().add(mapIdentifier.toString());
    }

    private ChatListDialog createChatListDialog() {
        return new ChatListDialog(this.owner, this.liveChatSessionManager, this.transcriptStore, this.mapRootShortTextFormatter, new ChatListDialog.ChatListHandler(){

            @Override
            public void switchTo(LiveChatSessionId sessionId) {
                LiveChatController.this.switchToSession(sessionId);
            }

            @Override
            public void close(LiveChatSessionId sessionId) {
                LiveChatController.this.closeSession(sessionId);
            }

            @Override
            public void deleteLiveSession(LiveChatSessionId sessionId) {
                LiveChatController.this.deleteLiveSessionInternal(sessionId);
            }

            @Override
            public void rename(LiveChatSessionId sessionId, String displayName) {
                LiveChatController.this.liveChatSessionManager.rename(sessionId, displayName);
            }

            @Override
            public void renameTranscript(ChatTranscriptId transcriptId, String displayName) {
                LiveChatController.this.transcriptStore.rename(transcriptId, displayName);
            }

            @Override
            public void startChatFromTranscript(ChatTranscriptId transcriptId) {
                LiveChatController.this.startChatFromTranscriptInternal(transcriptId);
            }

            @Override
            public void deleteTranscript(ChatTranscriptId transcriptId) {
                LiveChatController.this.transcriptStore.delete(transcriptId);
            }
        });
    }

    private void startChatFromTranscriptInternal(ChatTranscriptId transcriptId) {
        if (transcriptId == null) {
            return;
        }
        this.persistCurrentSession();
        ChatTranscriptRecord record = this.transcriptStore.load(transcriptId);
        if (record == null) {
            return;
        }
        ChatMemory newChatMemory = this.createChatMemory();
        LiveChatSession newSession = this.liveChatSessionManager.createSession(newChatMemory, record.getDisplayName() == null || record.getDisplayName().trim().isEmpty() ? this.buildDefaultChatName() : record.getDisplayName());
        newSession.setTranscriptId(transcriptId);
        newSession.setLastActivityTimestamp(record.getTimestamp());
        newSession.setMapRootShortTextCounts(record.getMapRootShortTextCounts());
        newSession.setTranscriptEntries(record.getEntries() == null ? new ArrayList<ChatTranscriptEntry>() : new ArrayList<ChatTranscriptEntry>(record.getEntries()));
        this.seedTranscriptMemory(newSession, record);
        this.switchToSession(newSession.getId(), false, true);
    }

    private void seedTranscriptMemory(LiveChatSession session, ChatTranscriptRecord record) {
        if (session == null || record == null) {
            return;
        }
        this.transcriptMemoryMapper.seedTranscriptWithHiddenExchange(session.getChatMemory(), record.getEntries(), TRANSCRIPT_HIDDEN_SYSTEM_MESSAGE);
        AssistantProfileChatMemory memory = this.activeAssistantProfileChatMemory(session);
        if (memory != null) {
            memory.initializeUndoRedoFromMessages();
            memory.expandWindowAfterTranscriptRestoreIfUnderutilized();
        }
    }

    private AssistantProfileChatMemory activeAssistantProfileChatMemory() {
        LiveChatSession session = this.liveChatSessionManager.getCurrentSession();
        return this.activeAssistantProfileChatMemory(session);
    }

    private AssistantProfileChatMemory activeAssistantProfileChatMemory(LiveChatSession session) {
        if (session == null) {
            return null;
        }
        ChatMemory memory = session.getChatMemory();
        if (memory instanceof AssistantProfileChatMemory) {
            return (AssistantProfileChatMemory)memory;
        }
        return null;
    }

    private ChatMemory createChatMemory() {
        return AssistantProfileChatMemory.withMaxTokens(this.chatMemorySettings.getMaximumTokenCount());
    }

    private void storeTokenUsageState(LiveChatSession session) {
        if (session == null || this.tokenUsageStateSupplier == null) {
            return;
        }
        session.setTokenUsageState(this.tokenUsageStateSupplier.get());
    }

    public static interface SessionActivationHandler {
        public void activate(ChatMemory var1, boolean var2);
    }
}

