/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.base;

import com.tngtech.archunit.Internal;
import com.tngtech.archunit.base.MayResolveTypesViaReflection;
import com.tngtech.archunit.base.ResolvesTypesViaReflection;

@Internal
public class ClassLoaders {
    public static ClassLoader getCurrentClassLoader(Class<?> clazz) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        return contextClassLoader != null ? contextClassLoader : clazz.getClassLoader();
    }

    @ResolvesTypesViaReflection
    @MayResolveTypesViaReflection(reason="This is just an utility method. Callers will be checked recursively for @MayResolveTypesViaReflection")
    public static Class<?> loadClass(String className) throws ClassNotFoundException {
        try {
            return Class.forName(className, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return Class.forName(className);
        }
    }
}

