/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.navigator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceFolder;
import org.jkiss.dbeaver.model.DBPEvent;
import org.jkiss.dbeaver.model.DBPEventListener;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.navigator.DBNContainer;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNEvent;
import org.jkiss.dbeaver.model.navigator.DBNLocalFolder;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class DBNProjectDatabases
extends DBNNode
implements DBNContainer,
DBPEventListener {
    private DBPDataSourceRegistry dataSourceRegistry;
    private final List<DBNDataSource> dataSources = new ArrayList<DBNDataSource>();
    private volatile DBNNode[] children;
    private final IdentityHashMap<DBPDataSourceFolder, DBNLocalFolder> folderNodes = new IdentityHashMap();

    public DBNProjectDatabases(DBNProject parentNode, DBPDataSourceRegistry dataSourceRegistry) {
        super(parentNode);
        this.dataSourceRegistry = dataSourceRegistry;
        this.dataSourceRegistry.addDataSourceListener(this);
        List<? extends DBPDataSourceContainer> projectDataSources = this.dataSourceRegistry.getDataSources();
        for (DBPDataSourceContainer dBPDataSourceContainer : projectDataSources) {
            this.addDataSource(dBPDataSourceContainer, false, false);
        }
    }

    @Override
    public boolean isDisposed() {
        return this.dataSourceRegistry == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dispose(boolean reflect) {
        List<DBNDataSource> list = this.dataSources;
        synchronized (list) {
            for (DBNDataSource dataSource : this.dataSources) {
                DBNUtils.disposeNode(dataSource, reflect);
            }
            this.dataSources.clear();
        }
        this.folderNodes.clear();
        this.children = null;
        if (this.dataSourceRegistry != null) {
            this.dataSourceRegistry.removeDataSourceListener(this);
            this.dataSourceRegistry = null;
        }
        super.dispose(reflect);
    }

    @Override
    @NotNull
    public String getNodeType() {
        return "datasources";
    }

    @Override
    @NotNull
    public String getNodeId() {
        return "datasources";
    }

    public DBPDataSourceRegistry getDataSourceRegistry() {
        return this.dataSourceRegistry;
    }

    @Override
    @Nullable
    public Object getValueObject() {
        return this.dataSourceRegistry;
    }

    @Override
    @NotNull
    public String getChildrenType() {
        return ModelMessages.model_navigator_Connection;
    }

    @Nullable
    public Class<DBPDataSourceContainer> getChildrenClass() {
        return DBPDataSourceContainer.class;
    }

    @Override
    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.getNodeDisplayName();
    }

    @Override
    @NotNull
    public String getNodeDisplayName() {
        return "Connections";
    }

    @Override
    @Nullable
    public String getNodeDescription() {
        return this.getParentNode().getProject().getName() + ModelMessages.model_navigator__connections;
    }

    @Override
    @NotNull
    public DBNProject getParentNode() {
        return (DBNProject)super.getParentNode();
    }

    @Override
    @Nullable
    public DBPImage getNodeIcon() {
        return DBIcon.TREE_DATABASE_CATEGORY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean allowsChildren() {
        List<DBNDataSource> list = this.dataSources;
        synchronized (list) {
            return !this.dataSources.isEmpty() || !this.dataSourceRegistry.getRootFolders().isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public DBNNode[] getChildren(@NotNull DBRProgressMonitor monitor) {
        if (this.children == null && !monitor.isForceCacheUsage()) {
            ArrayList<DBNNode> childNodes = new ArrayList<DBNNode>();
            for (DBPDataSourceFolder dBPDataSourceFolder : this.dataSourceRegistry.getAllFolders()) {
                DBNLocalFolder folderNode = this.folderNodes.get(dBPDataSourceFolder);
                if (folderNode == null) {
                    folderNode = new DBNLocalFolder(this, dBPDataSourceFolder);
                    this.folderNodes.put(dBPDataSourceFolder, folderNode);
                }
                if (dBPDataSourceFolder.getParent() != null) continue;
                childNodes.add(folderNode);
            }
            List<DBNDataSource> list = this.dataSources;
            synchronized (list) {
                for (DBNDataSource dataSource : this.dataSources) {
                    if (dataSource == null || dataSource.getDataSourceContainer().isHidden() || dataSource.getDataSourceContainer().getFolder() != null) continue;
                    childNodes.add(dataSource);
                }
            }
            DBNProjectDatabases.sortNodes(childNodes);
            this.children = childNodes.toArray(new DBNNode[0]);
        }
        return this.children;
    }

    @Override
    public boolean supportsDrop(@Nullable DBNNode otherNode) {
        return otherNode == null || otherNode instanceof DBNDataSource || otherNode instanceof DBNLocalFolder && ((DBNLocalFolder)otherNode).getDataSourceRegistry() == this.dataSourceRegistry;
    }

    @Override
    public void dropNodes(@NotNull DBRProgressMonitor monitor, @NotNull Collection<DBNNode> nodes) throws DBException {
        this.moveNodesToFolder(nodes, null);
    }

    public void moveNodesToFolder(Collection<DBNNode> nodes, DBPDataSourceFolder toFolder) throws DBException {
        LinkedHashSet<DBPDataSourceRegistry> registryToRefresh = new LinkedHashSet<DBPDataSourceRegistry>();
        for (DBNNode node : nodes) {
            if (node instanceof DBNDataSource) {
                DBNDataSource dataSource = (DBNDataSource)node;
                dataSource.moveToFolder(dataSource.getOwnerProject(), toFolder);
                DBPDataSourceContainer oldContainer = dataSource.getDataSourceContainer();
                registryToRefresh.add(oldContainer.getRegistry());
                if (oldContainer.getRegistry() == this.dataSourceRegistry) continue;
                DBPDataSourceFolder srcFolder = oldContainer.getFolder();
                oldContainer.setFolder(null);
                DBPDataSourceContainer newContainer = oldContainer.createCopy(this.dataSourceRegistry);
                oldContainer.setFolder(srcFolder);
                newContainer.setFolder(toFolder);
                oldContainer.getRegistry().removeDataSource(oldContainer);
                this.dataSourceRegistry.addDataSource(newContainer);
                registryToRefresh.add(this.dataSourceRegistry);
                continue;
            }
            if (!(node instanceof DBNLocalFolder)) continue;
            DBNLocalFolder folder = (DBNLocalFolder)node;
            folder.getFolder().setParent(toFolder);
            registryToRefresh.add(folder.getDataSourceRegistry());
        }
        for (DBPDataSourceRegistry registry : registryToRefresh) {
            registry.flushConfig();
        }
        this.refreshChildren();
    }

    public void refreshChildren() {
        this.children = null;
        this.getModel().fireNodeUpdate(this, this, DBNEvent.NodeChange.STRUCT_REFRESH);
    }

    @Override
    public boolean allowsOpen() {
        return true;
    }

    @Override
    @Deprecated
    @NotNull
    public String getNodeItemPath() {
        return this.getParentNode().getNodeItemPath() + "/" + this.getNodeDisplayName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBNLocalFolder getFolderNode(DBPDataSourceFolder folder) {
        IdentityHashMap<DBPDataSourceFolder, DBNLocalFolder> identityHashMap = this.folderNodes;
        synchronized (identityHashMap) {
            DBNLocalFolder folderNode = this.folderNodes.get(folder);
            if (folderNode == null) {
                folderNode = new DBNLocalFolder(this, folder);
                this.folderNodes.put(folder, folderNode);
                this.getModel().fireNodeEvent(new DBNEvent(this, DBNEvent.Action.ADD, folderNode));
            }
            return folderNode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBNDataSource[] getDataSources() {
        List<DBNDataSource> list = this.dataSources;
        synchronized (list) {
            return this.dataSources.toArray(new DBNDataSource[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBNDataSource getDataSource(String id) {
        List<DBNDataSource> list = this.dataSources;
        synchronized (list) {
            for (DBNDataSource dataSource : this.dataSources) {
                if (!dataSource.getDataSourceContainer().getId().equals(id)) continue;
                return dataSource;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBNDataSource getDataSource(DBPDataSourceContainer ds) {
        List<DBNDataSource> list = this.dataSources;
        synchronized (list) {
            for (DBNDataSource dataSource : this.dataSources) {
                if (dataSource.getDataSourceContainer() != ds) continue;
                return dataSource;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DBNDataSource addDataSource(@NotNull DBPDataSourceContainer descriptor, boolean reflect, boolean reveal) {
        DBNDataSource newNode = new DBNDataSource(this, descriptor);
        if (!this.getModel().isNodeVisible(newNode)) {
            return null;
        }
        List<DBNDataSource> list = this.dataSources;
        synchronized (list) {
            if (this.dataSources.stream().anyMatch(node -> node.getDataSourceContainer() == descriptor)) {
                return null;
            }
            this.dataSources.add(newNode);
        }
        DBPDataSourceFolder dsFolder = descriptor.getFolder();
        if (dsFolder != null) {
            this.getFolderNode(dsFolder);
        }
        this.children = null;
        if (reflect) {
            this.getModel().fireNodeEvent(new DBNEvent(this, DBNEvent.Action.ADD, reveal ? DBNEvent.NodeChange.SELECT : DBNEvent.NodeChange.REFRESH, newNode));
        }
        return newNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeDataSource(DBPDataSourceContainer descriptor) {
        DBNDataSource removedNode = null;
        List<DBNDataSource> list = this.dataSources;
        synchronized (list) {
            Iterator<DBNDataSource> iter = this.dataSources.iterator();
            while (iter.hasNext()) {
                DBNDataSource dataSource = iter.next();
                if (dataSource.getObject() != descriptor) continue;
                iter.remove();
                removedNode = dataSource;
                break;
            }
        }
        if (removedNode != null) {
            this.children = null;
            DBNUtils.disposeNode(removedNode, true);
            this.refreshChildren();
        }
    }

    @Override
    public void handleDataSourceEvent(@NotNull DBPEvent event) {
        DBNModel model = this.getModel();
        switch (event.getAction()) {
            case OBJECT_ADD: {
                boolean parentFound;
                DBSObject dBSObject = event.getObject();
                if (dBSObject instanceof DBPDataSourceContainer) {
                    DBPDataSourceContainer container = (DBPDataSourceContainer)dBSObject;
                    this.addDataSource(container, true, event.getEnabled() != null && event.getEnabled() != false);
                    break;
                }
                if (model.getNodeByObject(event.getObject()) != null) break;
                DBNDatabaseNode parentNode = null;
                Object containerNode = event.getOptions().get("container");
                if (containerNode instanceof DBNDatabaseFolder && event.getObject().getClass().getName().equals(((DBNDatabaseFolder)containerNode).getMeta().getType())) {
                    parentNode = (DBNDatabaseNode)containerNode;
                }
                if (parentNode == null) {
                    parentNode = model.getParentNode(event.getObject());
                }
                boolean bl = parentFound = parentNode != null;
                if (parentNode == null) {
                    parentNode = model.getParentNode(event.getObject());
                    parentFound = false;
                }
                if (parentNode == null) break;
                if (parentNode.getChildNodes() == null && parentNode.hasChildren(false)) {
                    final DBNDatabaseNode nodeToLoad = parentNode;
                    AbstractJob loaderJob = new AbstractJob(this, "Load sibling nodes of new database object"){
                        {
                            super(name);
                            this.setUser(true);
                        }

                        @Override
                        @NotNull
                        protected IStatus run(@NotNull DBRProgressMonitor monitor) {
                            try {
                                nodeToLoad.getChildren(monitor);
                            }
                            catch (Exception e) {
                                return GeneralUtils.makeExceptionStatus(e);
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    loaderJob.schedule();
                    try {
                        loaderJob.join();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (!parentFound) {
                    parentNode = model.getParentNode(event.getObject());
                }
                if (parentNode == null || parentNode.getChildNodes() == null || parentNode.hasChildItem(event.getObject())) break;
                parentNode.addChildItem(event.getObject());
                break;
            }
            case OBJECT_REMOVE: {
                if (event.getObject() instanceof DBPDataSourceContainer) {
                    this.removeDataSource((DBPDataSourceContainer)event.getObject());
                    break;
                }
                DBNDatabaseNode node = model.getNodeByObject(event.getObject());
                if (node == null || !(node.getParentNode() instanceof DBNDatabaseNode)) break;
                ((DBNDatabaseNode)node.getParentNode()).removeChildItem(event.getObject());
                break;
            }
            case BEFORE_CONNECT: 
            case AFTER_CONNECT: {
                DBNDatabaseNode dbmNode = model.getNodeByObject(event.getObject());
                if (dbmNode == null) break;
                model.fireNodeUpdate(event, dbmNode, event.getAction() == DBPEvent.Action.BEFORE_CONNECT ? DBNEvent.NodeChange.BEFORE_LOAD : DBNEvent.NodeChange.AFTER_LOAD);
                break;
            }
            case OBJECT_UPDATE: 
            case OBJECT_SELECT: {
                DBNEvent.NodeChange nodeChange;
                DBNDatabaseNode dbmNode = model.getNodeByObject(event.getObject());
                if (dbmNode == null) break;
                Boolean enabled = event.getEnabled();
                Object source = event;
                if (event.getAction() == DBPEvent.Action.OBJECT_SELECT) {
                    nodeChange = DBNEvent.NodeChange.REFRESH;
                    if (enabled != null && enabled.booleanValue()) {
                        source = DBNEvent.FORCE_REFRESH;
                    }
                } else {
                    nodeChange = enabled != null ? (enabled.booleanValue() ? DBNEvent.NodeChange.LOAD : DBNEvent.NodeChange.UNLOAD) : DBNEvent.NodeChange.REFRESH;
                    if (event.getData() == DBPEvent.REORDER) {
                        dbmNode.updateChildrenOrder(false);
                    }
                }
                model.fireNodeUpdate(source, dbmNode, nodeChange);
                if (!(event.getObject() instanceof DBPDataSourceContainer)) break;
                if (enabled != null) {
                    if (enabled.booleanValue()) break;
                    dbmNode.clearNode(false);
                    break;
                }
                if (event.getAction() != DBPEvent.Action.OBJECT_UPDATE) break;
                this.children = null;
                this.getModel().fireNodeEvent(new DBNEvent(this, DBNEvent.Action.UPDATE, this));
                break;
            }
        }
    }

    @Override
    public boolean hasChildren(boolean navigableOnly) {
        return true;
    }
}

