/*
 * Decompiled with CFR 0.152.
 */
package org.cugos.wkg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.cugos.wkg.Coordinate;
import org.cugos.wkg.Curve;
import org.cugos.wkg.Dimension;

public class CompoundCurve
extends Curve {
    private final List<Curve> curves;

    public CompoundCurve(List<Curve> curves, Dimension dimension) {
        this(curves, dimension, null);
    }

    public CompoundCurve(List<Curve> curves, Dimension dimension, String srid) {
        super(dimension, srid);
        this.curves = Collections.unmodifiableList(curves);
    }

    public List<Curve> getCurves() {
        return this.curves;
    }

    @Override
    public boolean isEmpty() {
        return this.curves.isEmpty();
    }

    @Override
    public int getNumberOfCoordinates() {
        int numberOfCoordinates = 0;
        for (Curve curve : this.curves) {
            numberOfCoordinates += curve.getNumberOfCoordinates();
        }
        return numberOfCoordinates;
    }

    @Override
    public List<Coordinate> getCoordinates() {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        for (Curve curve : this.curves) {
            coordinates.addAll(curve.getCoordinates());
        }
        return Collections.unmodifiableList(coordinates);
    }

    public static CompoundCurve createEmpty() {
        return new CompoundCurve(new ArrayList<Curve>(), Dimension.Two, null);
    }
}

