/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.lsm.sql.dialect;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.model.lsm.LSMAnalyzerFactory;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.osgi.framework.Bundle;

public class LSMDialectRegistry {
    static final String EXTENSION_ID = "org.jkiss.dbeaver.lsm.dialectSyntax";
    private static final Log log = Log.getLog(LSMDialectRegistry.class);
    private static LSMDialectRegistry instance = null;
    private final Map<Class<? extends SQLDialect>, LSMAnalyzerFactory> knownLsmAnalyzerByDialects = new HashMap<Class<? extends SQLDialect>, LSMAnalyzerFactory>();

    public static synchronized LSMDialectRegistry getInstance() {
        if (instance == null) {
            instance = new LSMDialectRegistry();
            instance.loadExtensions(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private LSMDialectRegistry() {
    }

    private void loadExtensions(IExtensionRegistry registry) {
        IConfigurationElement[] extConfigs = registry.getConfigurationElementsFor(EXTENSION_ID);
        Stream.of(extConfigs).filter(e -> "lsmDialect".equals(e.getName())).forEach(this::registerLsmDialect);
    }

    private void registerLsmDialect(IConfigurationElement dialectElement) {
        Bundle bundle = Platform.getBundle((String)dialectElement.getContributor().getName());
        try {
            LSMAnalyzerFactory analyzerFactory = (LSMAnalyzerFactory)dialectElement.createExecutableExtension("analyzerFactoryClass");
            IConfigurationElement[] iConfigurationElementArray = dialectElement.getChildren("appliesTo");
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement sqlDialectRef = iConfigurationElementArray[n2];
                String dialectClassName = sqlDialectRef.getAttribute("dialectClass");
                Class dialectType = AbstractDescriptor.getObjectClass((Bundle)bundle, (String)dialectClassName, SQLDialect.class);
                this.knownLsmAnalyzerByDialects.put(dialectType, analyzerFactory);
                ++n2;
            }
        }
        catch (CoreException e) {
            log.error((Object)("Failed to register LSM dialect " + dialectElement.getAttribute("analyzerFactoryClass")), (Throwable)e);
        }
    }

    public LSMAnalyzerFactory getAnalyzerFactoryForDialect(SQLDialect dialect) {
        LSMAnalyzerFactory analyzerFactory;
        Class<?> dialectClass = dialect.getClass();
        do {
            analyzerFactory = this.knownLsmAnalyzerByDialects.get(dialectClass);
            dialectClass = dialectClass.getSuperclass();
        } while (analyzerFactory == null && dialectClass != null);
        if (analyzerFactory == null) {
            throw new IllegalStateException("Failed to resolve LSMAnalyzer for " + dialect.getDialectName() + " dialect. Illegal database driver configuration.");
        }
        return analyzerFactory;
    }
}

