/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.gis.panel.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.MenuManager;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.MenuCreator;
import org.jkiss.dbeaver.ui.gis.internal.GISMessages;
import org.jkiss.dbeaver.ui.gis.panel.GISLeafletViewer;
import org.jkiss.dbeaver.ui.gis.panel.actions.ConfigureLabelsAction;

public class ToggleLabelsAction
extends Action {
    private final GISLeafletViewer viewer;

    public ToggleLabelsAction(@NotNull GISLeafletViewer viewer) {
        super(null, 4);
        this.viewer = viewer;
        this.setText(this.getActionText());
        this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)DBIcon.SMALL_INFO));
    }

    public void run() {
        this.viewer.setShowLabels(!this.viewer.isShowLabels());
        this.setText(this.getActionText());
        this.viewer.updateToolbar();
    }

    public IMenuCreator getMenuCreator() {
        return new MenuCreator(control -> {
            MenuManager manager = new MenuManager();
            manager.setRemoveAllWhenShown(true);
            manager.addMenuListener(m -> manager.add((IAction)new ConfigureLabelsAction(this.viewer)));
            return manager;
        });
    }

    @NotNull
    private String getActionText() {
        return this.viewer.isShowLabels() ? GISMessages.panel_hide_labels_action_label : GISMessages.panel_show_labels_action_label;
    }
}

