/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cluster;

import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch.cluster.PutWeightedRoutingResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public final class PutWeightedRoutingRequest
extends RequestBase
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, PutWeightedRoutingRequest> {
    @Nonnull
    private final String attribute;
    @Nullable
    private final Long version;
    @Nonnull
    private final Map<String, String> weights;
    public static final JsonpDeserializer<PutWeightedRoutingRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutWeightedRoutingRequest::setupPutWeightedRoutingRequestDeserializer);
    public static final Endpoint<PutWeightedRoutingRequest, PutWeightedRoutingResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutWeightedRoutingRequest, PutWeightedRoutingResponse>(request -> "PUT", request -> {
        StringBuilder buf = new StringBuilder();
        buf.append("/_cluster/routing/awareness/");
        SimpleEndpoint.pathEncode(request.attribute, buf);
        buf.append("/weights");
        return buf.toString();
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutWeightedRoutingResponse._DESERIALIZER);

    private PutWeightedRoutingRequest(Builder builder) {
        super(builder);
        this.attribute = ApiTypeHelper.requireNonNull(builder.attribute, this, "attribute");
        this.version = builder.version;
        this.weights = ApiTypeHelper.unmodifiable(builder.weights);
    }

    public static PutWeightedRoutingRequest of(Function<Builder, ObjectBuilder<PutWeightedRoutingRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final String attribute() {
        return this.attribute;
    }

    @Nullable
    public final Long version() {
        return this.version;
    }

    @Nonnull
    public final Map<String, String> weights() {
        return this.weights;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.version != null) {
            generator.writeKey("_version");
            generator.write(this.version.longValue());
        }
        if (ApiTypeHelper.isDefined(this.weights)) {
            generator.writeKey("weights");
            generator.writeStartObject();
            for (Map.Entry<String, String> item0 : this.weights.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue());
            }
            generator.writeEnd();
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupPutWeightedRoutingRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "_version");
        op.add(Builder::weights, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "weights");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.attribute.hashCode();
        result = 31 * result + Objects.hashCode(this.version);
        result = 31 * result + Objects.hashCode(this.weights);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PutWeightedRoutingRequest other = (PutWeightedRoutingRequest)o;
        return this.attribute.equals(other.attribute) && Objects.equals(this.version, other.version) && Objects.equals(this.weights, other.weights);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, PutWeightedRoutingRequest> {
        private String attribute;
        @Nullable
        private Long version;
        @Nullable
        private Map<String, String> weights;

        public Builder() {
        }

        private Builder(PutWeightedRoutingRequest o) {
            super(o);
            this.attribute = o.attribute;
            this.version = o.version;
            this.weights = Builder._mapCopy(o.weights);
        }

        private Builder(Builder o) {
            super(o);
            this.attribute = o.attribute;
            this.version = o.version;
            this.weights = Builder._mapCopy(o.weights);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder attribute(String value) {
            this.attribute = value;
            return this;
        }

        @Nonnull
        public final Builder version(@Nullable Long value) {
            this.version = value;
            return this;
        }

        @Nonnull
        public final Builder weights(Map<String, String> map) {
            this.weights = Builder._mapPutAll(this.weights, map);
            return this;
        }

        @Nonnull
        public final Builder weights(String key, String value) {
            this.weights = Builder._mapPut(this.weights, key, value);
            return this;
        }

        @Override
        @Nonnull
        public PutWeightedRoutingRequest build() {
            this._checkSingleUse();
            return new PutWeightedRoutingRequest(this);
        }
    }
}

