/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.mapper;

import java.util.Arrays;
import org.apache.lucene.util.VectorUtil;
import org.opensearch.knn.index.mapper.VectorTransformer;

public class NormalizeVectorTransformer
implements VectorTransformer {
    @Override
    public float[] transform(float[] vector, boolean inplaceUpdate) {
        this.validateVector(vector);
        if (inplaceUpdate) {
            return VectorUtil.l2normalize((float[])vector);
        }
        return VectorUtil.l2normalize((float[])Arrays.copyOf(vector, vector.length));
    }

    @Override
    public void transform(byte[] vector) {
        throw new UnsupportedOperationException("Byte array normalization is not supported");
    }

    private void validateVector(float[] vector) {
        if (vector == null || vector.length == 0) {
            throw new IllegalArgumentException("Vector cannot be null or empty");
        }
    }
}

