/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.consumer.group;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;

public class CsvUtils {
    private static final CsvMapper MAPPER = new CsvMapper();

    public static ObjectReader readerFor(Class<?> clazz) {
        return MAPPER.readerFor(clazz).with((FormatSchema)CsvUtils.getSchema(clazz));
    }

    public static ObjectWriter writerFor(Class<?> clazz) {
        return MAPPER.writerFor(clazz).with((FormatSchema)CsvUtils.getSchema(clazz));
    }

    private static CsvSchema getSchema(Class<?> clazz) {
        String[] fields;
        if (CsvRecordWithGroup.class == clazz) {
            fields = CsvRecordWithGroup.FIELDS;
        } else if (CsvRecordNoGroup.class == clazz) {
            fields = CsvRecordNoGroup.FIELDS;
        } else {
            throw new IllegalStateException("Unhandled class " + String.valueOf(clazz));
        }
        return MAPPER.schemaFor(clazz).sortedBy(fields);
    }

    public static class CsvRecordWithGroup {
        public static final String[] FIELDS = new String[]{"group", "topic", "partition", "offset"};
        @JsonProperty
        private String group;
        @JsonProperty
        private String topic;
        @JsonProperty
        private int partition;
        @JsonProperty
        private long offset;

        public CsvRecordWithGroup() {
        }

        public CsvRecordWithGroup(String group, String topic, int partition, long offset) {
            this.group = group;
            this.topic = topic;
            this.partition = partition;
            this.offset = offset;
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public String getGroup() {
            return this.group;
        }

        public String getTopic() {
            return this.topic;
        }

        public void setTopic(String topic) {
            this.topic = topic;
        }

        public int getPartition() {
            return this.partition;
        }

        public void setPartition(int partition) {
            this.partition = partition;
        }

        public long getOffset() {
            return this.offset;
        }

        public void setOffset(long offset) {
            this.offset = offset;
        }
    }

    public static class CsvRecordNoGroup {
        public static final String[] FIELDS = new String[]{"topic", "partition", "offset"};
        @JsonProperty
        private String topic;
        @JsonProperty
        private int partition;
        @JsonProperty
        private long offset;

        public CsvRecordNoGroup() {
        }

        public CsvRecordNoGroup(String topic, int partition, long offset) {
            this.topic = topic;
            this.partition = partition;
            this.offset = offset;
        }

        public String getTopic() {
            return this.topic;
        }

        public void setTopic(String topic) {
            this.topic = topic;
        }

        public int getPartition() {
            return this.partition;
        }

        public void setPartition(int partition) {
            this.partition = partition;
        }

        public long getOffset() {
            return this.offset;
        }

        public void setOffset(long offset) {
            this.offset = offset;
        }
    }
}

