# pylint: disable=too-many-lines,too-many-statements
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import datetime
import json
import sys
from typing import Any, Callable, Dict, Iterable, Iterator, List, Optional, Type, TypeVar
import urllib.parse

from azure.core import MatchConditions
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceModifiedError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.paging import ItemPaged
from azure.core.pipeline import PipelineResponse
from azure.core.rest import HttpRequest, HttpResponse
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict

from .. import models as _models
from .._model_base import SdkJSONEncoder, _deserialize
from .._serialization import Serializer
from .._vendor import BatchClientMixinABC, prep_if_match, prep_if_none_match

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False


def build_batch_list_applications_request(
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    maxresults: Optional[int] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/applications"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")
    if maxresults is not None:
        _params["maxresults"] = _SERIALIZER.query("maxresults", maxresults, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_get_application_request(
    application_id: str,
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/applications/{applicationId}"
    path_format_arguments = {
        "applicationId": _SERIALIZER.url("application_id", application_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_list_pool_usage_metrics_request(  # pylint: disable=name-too-long
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    maxresults: Optional[int] = None,
    starttime: Optional[datetime.datetime] = None,
    endtime: Optional[datetime.datetime] = None,
    filter: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/poolusagemetrics"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")
    if maxresults is not None:
        _params["maxresults"] = _SERIALIZER.query("maxresults", maxresults, "int")
    if starttime is not None:
        _params["startTime"] = _SERIALIZER.query("starttime", starttime, "iso-8601")
    if endtime is not None:
        _params["endtime"] = _SERIALIZER.query("endtime", endtime, "iso-8601")
    if filter is not None:
        _params["$filter"] = _SERIALIZER.query("filter", filter, "str")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_create_pool_request(
    *, time_out_in_seconds: Optional[int] = None, ocpdate: Optional[datetime.datetime] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: str = kwargs.pop("content_type")
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/pools"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["content-type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_list_pools_request(
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    maxresults: Optional[int] = None,
    filter: Optional[str] = None,
    select: Optional[List[str]] = None,
    expand: Optional[List[str]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/pools"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")
    if maxresults is not None:
        _params["maxresults"] = _SERIALIZER.query("maxresults", maxresults, "int")
    if filter is not None:
        _params["$filter"] = _SERIALIZER.query("filter", filter, "str")
    if select is not None:
        _params["$select"] = _SERIALIZER.query("select", select, "[str]", div=",")
    if expand is not None:
        _params["$expand"] = _SERIALIZER.query("expand", expand, "[str]", div=",")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_delete_pool_request(
    pool_id: str,
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    if_modified_since: Optional[datetime.datetime] = None,
    if_unmodified_since: Optional[datetime.datetime] = None,
    etag: Optional[str] = None,
    match_condition: Optional[MatchConditions] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/pools/{poolId}"
    path_format_arguments = {
        "poolId": _SERIALIZER.url("pool_id", pool_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    if if_modified_since is not None:
        _headers["If-Modified-Since"] = _SERIALIZER.header("if_modified_since", if_modified_since, "rfc-1123")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_pool_exists_request(
    pool_id: str,
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    if_modified_since: Optional[datetime.datetime] = None,
    if_unmodified_since: Optional[datetime.datetime] = None,
    etag: Optional[str] = None,
    match_condition: Optional[MatchConditions] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/pools/{poolId}"
    path_format_arguments = {
        "poolId": _SERIALIZER.url("pool_id", pool_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    if if_modified_since is not None:
        _headers["If-Modified-Since"] = _SERIALIZER.header("if_modified_since", if_modified_since, "rfc-1123")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="HEAD", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_get_pool_request(
    pool_id: str,
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    if_modified_since: Optional[datetime.datetime] = None,
    if_unmodified_since: Optional[datetime.datetime] = None,
    select: Optional[List[str]] = None,
    expand: Optional[List[str]] = None,
    etag: Optional[str] = None,
    match_condition: Optional[MatchConditions] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/pools/{poolId}"
    path_format_arguments = {
        "poolId": _SERIALIZER.url("pool_id", pool_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")
    if select is not None:
        _params["$select"] = _SERIALIZER.query("select", select, "[str]", div=",")
    if expand is not None:
        _params["$expand"] = _SERIALIZER.query("expand", expand, "[str]", div=",")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    if if_modified_since is not None:
        _headers["If-Modified-Since"] = _SERIALIZER.header("if_modified_since", if_modified_since, "rfc-1123")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_update_pool_request(
    pool_id: str,
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    if_modified_since: Optional[datetime.datetime] = None,
    if_unmodified_since: Optional[datetime.datetime] = None,
    etag: Optional[str] = None,
    match_condition: Optional[MatchConditions] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: str = kwargs.pop("content_type")
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/pools/{poolId}"
    path_format_arguments = {
        "poolId": _SERIALIZER.url("pool_id", pool_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["content-type"] = _SERIALIZER.header("content_type", content_type, "str")
    if if_modified_since is not None:
        _headers["If-Modified-Since"] = _SERIALIZER.header("if_modified_since", if_modified_since, "rfc-1123")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="PATCH", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_disable_pool_auto_scale_request(  # pylint: disable=name-too-long
    pool_id: str,
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/pools/{poolId}/disableautoscale"
    path_format_arguments = {
        "poolId": _SERIALIZER.url("pool_id", pool_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_enable_pool_auto_scale_request(  # pylint: disable=name-too-long
    pool_id: str,
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    if_modified_since: Optional[datetime.datetime] = None,
    if_unmodified_since: Optional[datetime.datetime] = None,
    etag: Optional[str] = None,
    match_condition: Optional[MatchConditions] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: str = kwargs.pop("content_type")
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/pools/{poolId}/enableautoscale"
    path_format_arguments = {
        "poolId": _SERIALIZER.url("pool_id", pool_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    if if_modified_since is not None:
        _headers["If-Modified-Since"] = _SERIALIZER.header("if_modified_since", if_modified_since, "rfc-1123")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    _headers["content-type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_evaluate_pool_auto_scale_request(  # pylint: disable=name-too-long
    pool_id: str,
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: str = kwargs.pop("content_type")
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/pools/{poolId}/evaluateautoscale"
    path_format_arguments = {
        "poolId": _SERIALIZER.url("pool_id", pool_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["content-type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_resize_pool_request(
    pool_id: str,
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    if_modified_since: Optional[datetime.datetime] = None,
    if_unmodified_since: Optional[datetime.datetime] = None,
    etag: Optional[str] = None,
    match_condition: Optional[MatchConditions] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: str = kwargs.pop("content_type")
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/pools/{poolId}/resize"
    path_format_arguments = {
        "poolId": _SERIALIZER.url("pool_id", pool_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    if if_modified_since is not None:
        _headers["If-Modified-Since"] = _SERIALIZER.header("if_modified_since", if_modified_since, "rfc-1123")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    _headers["content-type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_stop_pool_resize_request(
    pool_id: str,
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    if_modified_since: Optional[datetime.datetime] = None,
    if_unmodified_since: Optional[datetime.datetime] = None,
    etag: Optional[str] = None,
    match_condition: Optional[MatchConditions] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/pools/{poolId}/stopresize"
    path_format_arguments = {
        "poolId": _SERIALIZER.url("pool_id", pool_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    if if_modified_since is not None:
        _headers["If-Modified-Since"] = _SERIALIZER.header("if_modified_since", if_modified_since, "rfc-1123")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_replace_pool_properties_request(  # pylint: disable=name-too-long
    pool_id: str,
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: str = kwargs.pop("content_type")
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/pools/{poolId}/updateproperties"
    path_format_arguments = {
        "poolId": _SERIALIZER.url("pool_id", pool_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["content-type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_remove_nodes_request(
    pool_id: str,
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    if_modified_since: Optional[datetime.datetime] = None,
    if_unmodified_since: Optional[datetime.datetime] = None,
    etag: Optional[str] = None,
    match_condition: Optional[MatchConditions] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: str = kwargs.pop("content_type")
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/pools/{poolId}/removenodes"
    path_format_arguments = {
        "poolId": _SERIALIZER.url("pool_id", pool_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    if if_modified_since is not None:
        _headers["If-Modified-Since"] = _SERIALIZER.header("if_modified_since", if_modified_since, "rfc-1123")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    _headers["content-type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_list_supported_images_request(  # pylint: disable=name-too-long
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    maxresults: Optional[int] = None,
    filter: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/supportedimages"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")
    if maxresults is not None:
        _params["maxresults"] = _SERIALIZER.query("maxresults", maxresults, "int")
    if filter is not None:
        _params["$filter"] = _SERIALIZER.query("filter", filter, "str")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_list_pool_node_counts_request(  # pylint: disable=name-too-long
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    maxresults: Optional[int] = None,
    filter: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/nodecounts"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")
    if maxresults is not None:
        _params["maxresults"] = _SERIALIZER.query("maxresults", maxresults, "int")
    if filter is not None:
        _params["$filter"] = _SERIALIZER.query("filter", filter, "str")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_delete_job_request(
    job_id: str,
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    if_modified_since: Optional[datetime.datetime] = None,
    if_unmodified_since: Optional[datetime.datetime] = None,
    etag: Optional[str] = None,
    match_condition: Optional[MatchConditions] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/jobs/{jobId}"
    path_format_arguments = {
        "jobId": _SERIALIZER.url("job_id", job_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    if if_modified_since is not None:
        _headers["If-Modified-Since"] = _SERIALIZER.header("if_modified_since", if_modified_since, "rfc-1123")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_get_job_request(
    job_id: str,
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    if_modified_since: Optional[datetime.datetime] = None,
    if_unmodified_since: Optional[datetime.datetime] = None,
    select: Optional[List[str]] = None,
    expand: Optional[List[str]] = None,
    etag: Optional[str] = None,
    match_condition: Optional[MatchConditions] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/jobs/{jobId}"
    path_format_arguments = {
        "jobId": _SERIALIZER.url("job_id", job_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")
    if select is not None:
        _params["$select"] = _SERIALIZER.query("select", select, "[str]", div=",")
    if expand is not None:
        _params["$expand"] = _SERIALIZER.query("expand", expand, "[str]", div=",")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    if if_modified_since is not None:
        _headers["If-Modified-Since"] = _SERIALIZER.header("if_modified_since", if_modified_since, "rfc-1123")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_update_job_request(
    job_id: str,
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    if_modified_since: Optional[datetime.datetime] = None,
    if_unmodified_since: Optional[datetime.datetime] = None,
    etag: Optional[str] = None,
    match_condition: Optional[MatchConditions] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: str = kwargs.pop("content_type")
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/jobs/{jobId}"
    path_format_arguments = {
        "jobId": _SERIALIZER.url("job_id", job_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["content-type"] = _SERIALIZER.header("content_type", content_type, "str")
    if if_modified_since is not None:
        _headers["If-Modified-Since"] = _SERIALIZER.header("if_modified_since", if_modified_since, "rfc-1123")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="PATCH", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_replace_job_request(
    job_id: str,
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    if_modified_since: Optional[datetime.datetime] = None,
    if_unmodified_since: Optional[datetime.datetime] = None,
    etag: Optional[str] = None,
    match_condition: Optional[MatchConditions] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: str = kwargs.pop("content_type")
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/jobs/{jobId}"
    path_format_arguments = {
        "jobId": _SERIALIZER.url("job_id", job_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["content-type"] = _SERIALIZER.header("content_type", content_type, "str")
    if if_modified_since is not None:
        _headers["If-Modified-Since"] = _SERIALIZER.header("if_modified_since", if_modified_since, "rfc-1123")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_disable_job_request(
    job_id: str,
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    if_modified_since: Optional[datetime.datetime] = None,
    if_unmodified_since: Optional[datetime.datetime] = None,
    etag: Optional[str] = None,
    match_condition: Optional[MatchConditions] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: str = kwargs.pop("content_type")
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/jobs/{jobId}/disable"
    path_format_arguments = {
        "jobId": _SERIALIZER.url("job_id", job_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    if if_modified_since is not None:
        _headers["If-Modified-Since"] = _SERIALIZER.header("if_modified_since", if_modified_since, "rfc-1123")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    _headers["content-type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_enable_job_request(
    job_id: str,
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    if_modified_since: Optional[datetime.datetime] = None,
    if_unmodified_since: Optional[datetime.datetime] = None,
    etag: Optional[str] = None,
    match_condition: Optional[MatchConditions] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/jobs/{jobId}/enable"
    path_format_arguments = {
        "jobId": _SERIALIZER.url("job_id", job_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    if if_modified_since is not None:
        _headers["If-Modified-Since"] = _SERIALIZER.header("if_modified_since", if_modified_since, "rfc-1123")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_terminate_job_request(
    job_id: str,
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    if_modified_since: Optional[datetime.datetime] = None,
    if_unmodified_since: Optional[datetime.datetime] = None,
    etag: Optional[str] = None,
    match_condition: Optional[MatchConditions] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: str = kwargs.pop("content_type")
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/jobs/{jobId}/terminate"
    path_format_arguments = {
        "jobId": _SERIALIZER.url("job_id", job_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    if if_modified_since is not None:
        _headers["If-Modified-Since"] = _SERIALIZER.header("if_modified_since", if_modified_since, "rfc-1123")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    _headers["content-type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_create_job_request(
    *, time_out_in_seconds: Optional[int] = None, ocpdate: Optional[datetime.datetime] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: str = kwargs.pop("content_type")
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/jobs"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["content-type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_list_jobs_request(
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    maxresults: Optional[int] = None,
    filter: Optional[str] = None,
    select: Optional[List[str]] = None,
    expand: Optional[List[str]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/jobs"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")
    if maxresults is not None:
        _params["maxresults"] = _SERIALIZER.query("maxresults", maxresults, "int")
    if filter is not None:
        _params["$filter"] = _SERIALIZER.query("filter", filter, "str")
    if select is not None:
        _params["$select"] = _SERIALIZER.query("select", select, "[str]", div=",")
    if expand is not None:
        _params["$expand"] = _SERIALIZER.query("expand", expand, "[str]", div=",")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_list_jobs_from_schedule_request(  # pylint: disable=name-too-long
    job_schedule_id: str,
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    maxresults: Optional[int] = None,
    filter: Optional[str] = None,
    select: Optional[List[str]] = None,
    expand: Optional[List[str]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/jobschedules/{jobScheduleId}/jobs"
    path_format_arguments = {
        "jobScheduleId": _SERIALIZER.url("job_schedule_id", job_schedule_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")
    if maxresults is not None:
        _params["maxresults"] = _SERIALIZER.query("maxresults", maxresults, "int")
    if filter is not None:
        _params["$filter"] = _SERIALIZER.query("filter", filter, "str")
    if select is not None:
        _params["$select"] = _SERIALIZER.query("select", select, "[str]", div=",")
    if expand is not None:
        _params["$expand"] = _SERIALIZER.query("expand", expand, "[str]", div=",")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_list_job_preparation_and_release_task_status_request(  # pylint: disable=name-too-long
    job_id: str,
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    maxresults: Optional[int] = None,
    filter: Optional[str] = None,
    select: Optional[List[str]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/jobs/{jobId}/jobpreparationandreleasetaskstatus"
    path_format_arguments = {
        "jobId": _SERIALIZER.url("job_id", job_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")
    if maxresults is not None:
        _params["maxresults"] = _SERIALIZER.query("maxresults", maxresults, "int")
    if filter is not None:
        _params["$filter"] = _SERIALIZER.query("filter", filter, "str")
    if select is not None:
        _params["$select"] = _SERIALIZER.query("select", select, "[str]", div=",")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_get_job_task_counts_request(
    job_id: str,
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/jobs/{jobId}/taskcounts"
    path_format_arguments = {
        "jobId": _SERIALIZER.url("job_id", job_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_job_schedule_exists_request(
    job_schedule_id: str,
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    if_modified_since: Optional[datetime.datetime] = None,
    if_unmodified_since: Optional[datetime.datetime] = None,
    etag: Optional[str] = None,
    match_condition: Optional[MatchConditions] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/jobschedules/{jobScheduleId}"
    path_format_arguments = {
        "jobScheduleId": _SERIALIZER.url("job_schedule_id", job_schedule_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    if if_modified_since is not None:
        _headers["If-Modified-Since"] = _SERIALIZER.header("if_modified_since", if_modified_since, "rfc-1123")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="HEAD", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_delete_job_schedule_request(
    job_schedule_id: str,
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    if_modified_since: Optional[datetime.datetime] = None,
    if_unmodified_since: Optional[datetime.datetime] = None,
    etag: Optional[str] = None,
    match_condition: Optional[MatchConditions] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/jobschedules/{jobScheduleId}"
    path_format_arguments = {
        "jobScheduleId": _SERIALIZER.url("job_schedule_id", job_schedule_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    if if_modified_since is not None:
        _headers["If-Modified-Since"] = _SERIALIZER.header("if_modified_since", if_modified_since, "rfc-1123")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_get_job_schedule_request(
    job_schedule_id: str,
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    if_modified_since: Optional[datetime.datetime] = None,
    if_unmodified_since: Optional[datetime.datetime] = None,
    select: Optional[List[str]] = None,
    expand: Optional[List[str]] = None,
    etag: Optional[str] = None,
    match_condition: Optional[MatchConditions] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/jobschedules/{jobScheduleId}"
    path_format_arguments = {
        "jobScheduleId": _SERIALIZER.url("job_schedule_id", job_schedule_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")
    if select is not None:
        _params["$select"] = _SERIALIZER.query("select", select, "[str]", div=",")
    if expand is not None:
        _params["$expand"] = _SERIALIZER.query("expand", expand, "[str]", div=",")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    if if_modified_since is not None:
        _headers["If-Modified-Since"] = _SERIALIZER.header("if_modified_since", if_modified_since, "rfc-1123")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_update_job_schedule_request(
    job_schedule_id: str,
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    if_modified_since: Optional[datetime.datetime] = None,
    if_unmodified_since: Optional[datetime.datetime] = None,
    etag: Optional[str] = None,
    match_condition: Optional[MatchConditions] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: str = kwargs.pop("content_type")
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/jobschedules/{jobScheduleId}"
    path_format_arguments = {
        "jobScheduleId": _SERIALIZER.url("job_schedule_id", job_schedule_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["content-type"] = _SERIALIZER.header("content_type", content_type, "str")
    if if_modified_since is not None:
        _headers["If-Modified-Since"] = _SERIALIZER.header("if_modified_since", if_modified_since, "rfc-1123")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="PATCH", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_replace_job_schedule_request(
    job_schedule_id: str,
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    if_modified_since: Optional[datetime.datetime] = None,
    if_unmodified_since: Optional[datetime.datetime] = None,
    etag: Optional[str] = None,
    match_condition: Optional[MatchConditions] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: str = kwargs.pop("content_type")
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/jobschedules/{jobScheduleId}"
    path_format_arguments = {
        "jobScheduleId": _SERIALIZER.url("job_schedule_id", job_schedule_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["content-type"] = _SERIALIZER.header("content_type", content_type, "str")
    if if_modified_since is not None:
        _headers["If-Modified-Since"] = _SERIALIZER.header("if_modified_since", if_modified_since, "rfc-1123")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_disable_job_schedule_request(
    job_schedule_id: str,
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    if_modified_since: Optional[datetime.datetime] = None,
    if_unmodified_since: Optional[datetime.datetime] = None,
    etag: Optional[str] = None,
    match_condition: Optional[MatchConditions] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/jobschedules/{jobScheduleId}/disable"
    path_format_arguments = {
        "jobScheduleId": _SERIALIZER.url("job_schedule_id", job_schedule_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    if if_modified_since is not None:
        _headers["If-Modified-Since"] = _SERIALIZER.header("if_modified_since", if_modified_since, "rfc-1123")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_enable_job_schedule_request(
    job_schedule_id: str,
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    if_modified_since: Optional[datetime.datetime] = None,
    if_unmodified_since: Optional[datetime.datetime] = None,
    etag: Optional[str] = None,
    match_condition: Optional[MatchConditions] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/jobschedules/{jobScheduleId}/enable"
    path_format_arguments = {
        "jobScheduleId": _SERIALIZER.url("job_schedule_id", job_schedule_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    if if_modified_since is not None:
        _headers["If-Modified-Since"] = _SERIALIZER.header("if_modified_since", if_modified_since, "rfc-1123")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_terminate_job_schedule_request(  # pylint: disable=name-too-long
    job_schedule_id: str,
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    if_modified_since: Optional[datetime.datetime] = None,
    if_unmodified_since: Optional[datetime.datetime] = None,
    etag: Optional[str] = None,
    match_condition: Optional[MatchConditions] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/jobschedules/{jobScheduleId}/terminate"
    path_format_arguments = {
        "jobScheduleId": _SERIALIZER.url("job_schedule_id", job_schedule_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    if if_modified_since is not None:
        _headers["If-Modified-Since"] = _SERIALIZER.header("if_modified_since", if_modified_since, "rfc-1123")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_create_job_schedule_request(
    *, time_out_in_seconds: Optional[int] = None, ocpdate: Optional[datetime.datetime] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: str = kwargs.pop("content_type")
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/jobschedules"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["content-type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_list_job_schedules_request(
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    maxresults: Optional[int] = None,
    filter: Optional[str] = None,
    select: Optional[List[str]] = None,
    expand: Optional[List[str]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/jobschedules"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")
    if maxresults is not None:
        _params["maxresults"] = _SERIALIZER.query("maxresults", maxresults, "int")
    if filter is not None:
        _params["$filter"] = _SERIALIZER.query("filter", filter, "str")
    if select is not None:
        _params["$select"] = _SERIALIZER.query("select", select, "[str]", div=",")
    if expand is not None:
        _params["$expand"] = _SERIALIZER.query("expand", expand, "[str]", div=",")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_create_task_request(
    job_id: str,
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: str = kwargs.pop("content_type")
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/jobs/{jobId}/tasks"
    path_format_arguments = {
        "jobId": _SERIALIZER.url("job_id", job_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["content-type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_list_tasks_request(
    job_id: str,
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    maxresults: Optional[int] = None,
    filter: Optional[str] = None,
    select: Optional[List[str]] = None,
    expand: Optional[List[str]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/jobs/{jobId}/tasks"
    path_format_arguments = {
        "jobId": _SERIALIZER.url("job_id", job_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")
    if maxresults is not None:
        _params["maxresults"] = _SERIALIZER.query("maxresults", maxresults, "int")
    if filter is not None:
        _params["$filter"] = _SERIALIZER.query("filter", filter, "str")
    if select is not None:
        _params["$select"] = _SERIALIZER.query("select", select, "[str]", div=",")
    if expand is not None:
        _params["$expand"] = _SERIALIZER.query("expand", expand, "[str]", div=",")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_create_task_collection_request(  # pylint: disable=name-too-long
    job_id: str,
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: str = kwargs.pop("content_type")
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/jobs/{jobId}/addtaskcollection"
    path_format_arguments = {
        "jobId": _SERIALIZER.url("job_id", job_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["content-type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_delete_task_request(
    job_id: str,
    task_id: str,
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    if_modified_since: Optional[datetime.datetime] = None,
    if_unmodified_since: Optional[datetime.datetime] = None,
    etag: Optional[str] = None,
    match_condition: Optional[MatchConditions] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/jobs/{jobId}/tasks/{taskId}"
    path_format_arguments = {
        "jobId": _SERIALIZER.url("job_id", job_id, "str"),
        "taskId": _SERIALIZER.url("task_id", task_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    if if_modified_since is not None:
        _headers["If-Modified-Since"] = _SERIALIZER.header("if_modified_since", if_modified_since, "rfc-1123")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_get_task_request(
    job_id: str,
    task_id: str,
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    if_modified_since: Optional[datetime.datetime] = None,
    if_unmodified_since: Optional[datetime.datetime] = None,
    select: Optional[List[str]] = None,
    expand: Optional[List[str]] = None,
    etag: Optional[str] = None,
    match_condition: Optional[MatchConditions] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/jobs/{jobId}/tasks/{taskId}"
    path_format_arguments = {
        "jobId": _SERIALIZER.url("job_id", job_id, "str"),
        "taskId": _SERIALIZER.url("task_id", task_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")
    if select is not None:
        _params["$select"] = _SERIALIZER.query("select", select, "[str]", div=",")
    if expand is not None:
        _params["$expand"] = _SERIALIZER.query("expand", expand, "[str]", div=",")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    if if_modified_since is not None:
        _headers["If-Modified-Since"] = _SERIALIZER.header("if_modified_since", if_modified_since, "rfc-1123")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_replace_task_request(
    job_id: str,
    task_id: str,
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    if_modified_since: Optional[datetime.datetime] = None,
    if_unmodified_since: Optional[datetime.datetime] = None,
    etag: Optional[str] = None,
    match_condition: Optional[MatchConditions] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: str = kwargs.pop("content_type")
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/jobs/{jobId}/tasks/{taskId}"
    path_format_arguments = {
        "jobId": _SERIALIZER.url("job_id", job_id, "str"),
        "taskId": _SERIALIZER.url("task_id", task_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["content-type"] = _SERIALIZER.header("content_type", content_type, "str")
    if if_modified_since is not None:
        _headers["If-Modified-Since"] = _SERIALIZER.header("if_modified_since", if_modified_since, "rfc-1123")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_list_sub_tasks_request(
    job_id: str,
    task_id: str,
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    select: Optional[List[str]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/jobs/{jobId}/tasks/{taskId}/subtasksinfo"
    path_format_arguments = {
        "jobId": _SERIALIZER.url("job_id", job_id, "str"),
        "taskId": _SERIALIZER.url("task_id", task_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")
    if select is not None:
        _params["$select"] = _SERIALIZER.query("select", select, "[str]", div=",")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_terminate_task_request(
    job_id: str,
    task_id: str,
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    if_modified_since: Optional[datetime.datetime] = None,
    if_unmodified_since: Optional[datetime.datetime] = None,
    etag: Optional[str] = None,
    match_condition: Optional[MatchConditions] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/jobs/{jobId}/tasks/{taskId}/terminate"
    path_format_arguments = {
        "jobId": _SERIALIZER.url("job_id", job_id, "str"),
        "taskId": _SERIALIZER.url("task_id", task_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    if if_modified_since is not None:
        _headers["If-Modified-Since"] = _SERIALIZER.header("if_modified_since", if_modified_since, "rfc-1123")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_reactivate_task_request(
    job_id: str,
    task_id: str,
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    if_modified_since: Optional[datetime.datetime] = None,
    if_unmodified_since: Optional[datetime.datetime] = None,
    etag: Optional[str] = None,
    match_condition: Optional[MatchConditions] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/jobs/{jobId}/tasks/{taskId}/reactivate"
    path_format_arguments = {
        "jobId": _SERIALIZER.url("job_id", job_id, "str"),
        "taskId": _SERIALIZER.url("task_id", task_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    if if_modified_since is not None:
        _headers["If-Modified-Since"] = _SERIALIZER.header("if_modified_since", if_modified_since, "rfc-1123")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_delete_task_file_request(
    job_id: str,
    task_id: str,
    file_path: str,
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    recursive: Optional[bool] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/jobs/{jobId}/tasks/{taskId}/files/{filePath}"
    path_format_arguments = {
        "jobId": _SERIALIZER.url("job_id", job_id, "str"),
        "taskId": _SERIALIZER.url("task_id", task_id, "str"),
        "filePath": _SERIALIZER.url("file_path", file_path, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")
    if recursive is not None:
        _params["recursive"] = _SERIALIZER.query("recursive", recursive, "bool")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_get_task_file_request(
    job_id: str,
    task_id: str,
    file_path: str,
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    if_modified_since: Optional[datetime.datetime] = None,
    if_unmodified_since: Optional[datetime.datetime] = None,
    ocp_range: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/octet-stream")

    # Construct URL
    _url = "/jobs/{jobId}/tasks/{taskId}/files/{filePath}"
    path_format_arguments = {
        "jobId": _SERIALIZER.url("job_id", job_id, "str"),
        "taskId": _SERIALIZER.url("task_id", task_id, "str"),
        "filePath": _SERIALIZER.url("file_path", file_path, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    if if_modified_since is not None:
        _headers["If-Modified-Since"] = _SERIALIZER.header("if_modified_since", if_modified_since, "rfc-1123")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    if ocp_range is not None:
        _headers["ocp-range"] = _SERIALIZER.header("ocp_range", ocp_range, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_get_task_file_properties_request(  # pylint: disable=name-too-long
    job_id: str,
    task_id: str,
    file_path: str,
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    if_modified_since: Optional[datetime.datetime] = None,
    if_unmodified_since: Optional[datetime.datetime] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/jobs/{jobId}/tasks/{taskId}/files/{filePath}"
    path_format_arguments = {
        "jobId": _SERIALIZER.url("job_id", job_id, "str"),
        "taskId": _SERIALIZER.url("task_id", task_id, "str"),
        "filePath": _SERIALIZER.url("file_path", file_path, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    if if_modified_since is not None:
        _headers["If-Modified-Since"] = _SERIALIZER.header("if_modified_since", if_modified_since, "rfc-1123")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="HEAD", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_list_task_files_request(
    job_id: str,
    task_id: str,
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    maxresults: Optional[int] = None,
    filter: Optional[str] = None,
    recursive: Optional[bool] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/jobs/{jobId}/tasks/{taskId}/files"
    path_format_arguments = {
        "jobId": _SERIALIZER.url("job_id", job_id, "str"),
        "taskId": _SERIALIZER.url("task_id", task_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")
    if maxresults is not None:
        _params["maxresults"] = _SERIALIZER.query("maxresults", maxresults, "int")
    if filter is not None:
        _params["$filter"] = _SERIALIZER.query("filter", filter, "str")
    if recursive is not None:
        _params["recursive"] = _SERIALIZER.query("recursive", recursive, "bool")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_create_node_user_request(
    pool_id: str,
    node_id: str,
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: str = kwargs.pop("content_type")
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/pools/{poolId}/nodes/{nodeId}/users"
    path_format_arguments = {
        "poolId": _SERIALIZER.url("pool_id", pool_id, "str"),
        "nodeId": _SERIALIZER.url("node_id", node_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["content-type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_delete_node_user_request(
    pool_id: str,
    node_id: str,
    user_name: str,
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/pools/{poolId}/nodes/{nodeId}/users/{userName}"
    path_format_arguments = {
        "poolId": _SERIALIZER.url("pool_id", pool_id, "str"),
        "nodeId": _SERIALIZER.url("node_id", node_id, "str"),
        "userName": _SERIALIZER.url("user_name", user_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_replace_node_user_request(
    pool_id: str,
    node_id: str,
    user_name: str,
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: str = kwargs.pop("content_type")
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/pools/{poolId}/nodes/{nodeId}/users/{userName}"
    path_format_arguments = {
        "poolId": _SERIALIZER.url("pool_id", pool_id, "str"),
        "nodeId": _SERIALIZER.url("node_id", node_id, "str"),
        "userName": _SERIALIZER.url("user_name", user_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["content-type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_get_node_request(
    pool_id: str,
    node_id: str,
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    select: Optional[List[str]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/pools/{poolId}/nodes/{nodeId}"
    path_format_arguments = {
        "poolId": _SERIALIZER.url("pool_id", pool_id, "str"),
        "nodeId": _SERIALIZER.url("node_id", node_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")
    if select is not None:
        _params["$select"] = _SERIALIZER.query("select", select, "[str]", div=",")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_reboot_node_request(
    pool_id: str,
    node_id: str,
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: str = kwargs.pop("content_type")
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/pools/{poolId}/nodes/{nodeId}/reboot"
    path_format_arguments = {
        "poolId": _SERIALIZER.url("pool_id", pool_id, "str"),
        "nodeId": _SERIALIZER.url("node_id", node_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["content-type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_disable_node_scheduling_request(  # pylint: disable=name-too-long
    pool_id: str,
    node_id: str,
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: str = kwargs.pop("content_type")
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/pools/{poolId}/nodes/{nodeId}/disablescheduling"
    path_format_arguments = {
        "poolId": _SERIALIZER.url("pool_id", pool_id, "str"),
        "nodeId": _SERIALIZER.url("node_id", node_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["content-type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_enable_node_scheduling_request(  # pylint: disable=name-too-long
    pool_id: str,
    node_id: str,
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/pools/{poolId}/nodes/{nodeId}/enablescheduling"
    path_format_arguments = {
        "poolId": _SERIALIZER.url("pool_id", pool_id, "str"),
        "nodeId": _SERIALIZER.url("node_id", node_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_get_node_remote_login_settings_request(  # pylint: disable=name-too-long
    pool_id: str,
    node_id: str,
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/pools/{poolId}/nodes/{nodeId}/remoteloginsettings"
    path_format_arguments = {
        "poolId": _SERIALIZER.url("pool_id", pool_id, "str"),
        "nodeId": _SERIALIZER.url("node_id", node_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_upload_node_logs_request(
    pool_id: str,
    node_id: str,
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: str = kwargs.pop("content_type")
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/pools/{poolId}/nodes/{nodeId}/uploadbatchservicelogs"
    path_format_arguments = {
        "poolId": _SERIALIZER.url("pool_id", pool_id, "str"),
        "nodeId": _SERIALIZER.url("node_id", node_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["content-type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_list_nodes_request(
    pool_id: str,
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    maxresults: Optional[int] = None,
    filter: Optional[str] = None,
    select: Optional[List[str]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/pools/{poolId}/nodes"
    path_format_arguments = {
        "poolId": _SERIALIZER.url("pool_id", pool_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")
    if maxresults is not None:
        _params["maxresults"] = _SERIALIZER.query("maxresults", maxresults, "int")
    if filter is not None:
        _params["$filter"] = _SERIALIZER.query("filter", filter, "str")
    if select is not None:
        _params["$select"] = _SERIALIZER.query("select", select, "[str]", div=",")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_get_node_extension_request(
    pool_id: str,
    node_id: str,
    extension_name: str,
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    select: Optional[List[str]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/pools/{poolId}/nodes/{nodeId}/extensions/{extensionName}"
    path_format_arguments = {
        "poolId": _SERIALIZER.url("pool_id", pool_id, "str"),
        "nodeId": _SERIALIZER.url("node_id", node_id, "str"),
        "extensionName": _SERIALIZER.url("extension_name", extension_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")
    if select is not None:
        _params["$select"] = _SERIALIZER.query("select", select, "[str]", div=",")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_list_node_extensions_request(
    pool_id: str,
    node_id: str,
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    maxresults: Optional[int] = None,
    select: Optional[List[str]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/pools/{poolId}/nodes/{nodeId}/extensions"
    path_format_arguments = {
        "poolId": _SERIALIZER.url("pool_id", pool_id, "str"),
        "nodeId": _SERIALIZER.url("node_id", node_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")
    if maxresults is not None:
        _params["maxresults"] = _SERIALIZER.query("maxresults", maxresults, "int")
    if select is not None:
        _params["$select"] = _SERIALIZER.query("select", select, "[str]", div=",")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_delete_node_file_request(
    pool_id: str,
    node_id: str,
    file_path: str,
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    recursive: Optional[bool] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/pools/{poolId}/nodes/{nodeId}/files/{filePath}"
    path_format_arguments = {
        "poolId": _SERIALIZER.url("pool_id", pool_id, "str"),
        "nodeId": _SERIALIZER.url("node_id", node_id, "str"),
        "filePath": _SERIALIZER.url("file_path", file_path, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")
    if recursive is not None:
        _params["recursive"] = _SERIALIZER.query("recursive", recursive, "bool")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_get_node_file_request(
    pool_id: str,
    node_id: str,
    file_path: str,
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    if_modified_since: Optional[datetime.datetime] = None,
    if_unmodified_since: Optional[datetime.datetime] = None,
    ocp_range: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/octet-stream")

    # Construct URL
    _url = "/pools/{poolId}/nodes/{nodeId}/files/{filePath}"
    path_format_arguments = {
        "poolId": _SERIALIZER.url("pool_id", pool_id, "str"),
        "nodeId": _SERIALIZER.url("node_id", node_id, "str"),
        "filePath": _SERIALIZER.url("file_path", file_path, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    if if_modified_since is not None:
        _headers["If-Modified-Since"] = _SERIALIZER.header("if_modified_since", if_modified_since, "rfc-1123")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    if ocp_range is not None:
        _headers["ocp-range"] = _SERIALIZER.header("ocp_range", ocp_range, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_get_node_file_properties_request(  # pylint: disable=name-too-long
    pool_id: str,
    node_id: str,
    file_path: str,
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    if_modified_since: Optional[datetime.datetime] = None,
    if_unmodified_since: Optional[datetime.datetime] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/pools/{poolId}/nodes/{nodeId}/files/{filePath}"
    path_format_arguments = {
        "poolId": _SERIALIZER.url("pool_id", pool_id, "str"),
        "nodeId": _SERIALIZER.url("node_id", node_id, "str"),
        "filePath": _SERIALIZER.url("file_path", file_path, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    if if_modified_since is not None:
        _headers["If-Modified-Since"] = _SERIALIZER.header("if_modified_since", if_modified_since, "rfc-1123")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="HEAD", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_list_node_files_request(
    pool_id: str,
    node_id: str,
    *,
    time_out_in_seconds: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    maxresults: Optional[int] = None,
    filter: Optional[str] = None,
    recursive: Optional[bool] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-02-01.19.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/pools/{poolId}/nodes/{nodeId}/files"
    path_format_arguments = {
        "poolId": _SERIALIZER.url("pool_id", pool_id, "str"),
        "nodeId": _SERIALIZER.url("node_id", node_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if time_out_in_seconds is not None:
        _params["timeOut"] = _SERIALIZER.query("time_out_in_seconds", time_out_in_seconds, "int")
    if maxresults is not None:
        _params["maxresults"] = _SERIALIZER.query("maxresults", maxresults, "int")
    if filter is not None:
        _params["$filter"] = _SERIALIZER.query("filter", filter, "str")
    if recursive is not None:
        _params["recursive"] = _SERIALIZER.query("recursive", recursive, "bool")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


class BatchClientOperationsMixin(BatchClientMixinABC):  # pylint: disable=too-many-public-methods

    @distributed_trace
    def list_applications(
        self,
        *,
        time_out_in_seconds: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        maxresults: Optional[int] = None,
        **kwargs: Any
    ) -> Iterable["_models.BatchApplication"]:
        """Lists all of the applications available in the specified Account.

        This operation returns only Applications and versions that are available for
        use on Compute Nodes; that is, that can be used in an Package reference. For
        administrator information about applications and versions that are not yet
        available to Compute Nodes, use the Azure portal or the Azure Resource Manager
        API.

        :keyword time_out_in_seconds: The maximum time that the server can spend processing the
         request, in seconds. The default is 30 seconds. If the value is larger than 30, the default
         will be used instead.". Default value is None.
        :paramtype time_out_in_seconds: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword maxresults: The maximum number of items to return in the response. A maximum of 1000
         applications can be returned. Default value is None.
        :paramtype maxresults: int
        :return: An iterator like instance of BatchApplication
        :rtype: ~azure.core.paging.ItemPaged[~azure.batch.models.BatchApplication]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "displayName": "str",  # The display name for the application. Required.
                    "id": "str",  # A string that uniquely identifies the application within the
                      Account. Required.
                    "versions": [
                        "str"  # The list of available versions of the application. Required.
                    ]
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.BatchApplication]] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_batch_list_applications_request(
                    time_out_in_seconds=time_out_in_seconds,
                    ocpdate=ocpdate,
                    maxresults=maxresults,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.BatchApplication], deserialized["value"])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("odata.nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                if _stream:
                    response.read()  # Load the body in memory and close the socket
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _deserialize(_models.BatchError, response.json())
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def get_application(
        self,
        application_id: str,
        *,
        time_out_in_seconds: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> _models.BatchApplication:
        """Gets information about the specified Application.

        This operation returns only Applications and versions that are available for
        use on Compute Nodes; that is, that can be used in an Package reference. For
        administrator information about Applications and versions that are not yet
        available to Compute Nodes, use the Azure portal or the Azure Resource Manager
        API.

        :param application_id: The ID of the Application. Required.
        :type application_id: str
        :keyword time_out_in_seconds: The maximum time that the server can spend processing the
         request, in seconds. The default is 30 seconds. If the value is larger than 30, the default
         will be used instead.". Default value is None.
        :paramtype time_out_in_seconds: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :return: BatchApplication. The BatchApplication is compatible with MutableMapping
        :rtype: ~azure.batch.models.BatchApplication
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "displayName": "str",  # The display name for the application. Required.
                    "id": "str",  # A string that uniquely identifies the application within the
                      Account. Required.
                    "versions": [
                        "str"  # The list of available versions of the application. Required.
                    ]
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.BatchApplication] = kwargs.pop("cls", None)

        _request = build_batch_get_application_request(
            application_id=application_id,
            time_out_in_seconds=time_out_in_seconds,
            ocpdate=ocpdate,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.BatchError, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.BatchApplication, response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_pool_usage_metrics(
        self,
        *,
        time_out_in_seconds: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        maxresults: Optional[int] = None,
        starttime: Optional[datetime.datetime] = None,
        endtime: Optional[datetime.datetime] = None,
        filter: Optional[str] = None,
        **kwargs: Any
    ) -> Iterable["_models.BatchPoolUsageMetrics"]:
        # pylint: disable=line-too-long
        """Lists the usage metrics, aggregated by Pool across individual time intervals,
        for the specified Account.

        If you do not specify a $filter clause including a poolId, the response
        includes all Pools that existed in the Account in the time range of the
        returned aggregation intervals. If you do not specify a $filter clause
        including a startTime or endTime these filters default to the start and end
        times of the last aggregation interval currently available; that is, only the
        last aggregation interval is returned.

        :keyword time_out_in_seconds: The maximum time that the server can spend processing the
         request, in seconds. The default is 30 seconds. If the value is larger than 30, the default
         will be used instead.". Default value is None.
        :paramtype time_out_in_seconds: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword maxresults: The maximum number of items to return in the response. A maximum of 1000
         applications can be returned. Default value is None.
        :paramtype maxresults: int
        :keyword starttime: The earliest time from which to include metrics. This must be at least two
         and
         a half hours before the current time. If not specified this defaults to the
         start time of the last aggregation interval currently available. Default value is None.
        :paramtype starttime: ~datetime.datetime
        :keyword endtime: The latest time from which to include metrics. This must be at least two
         hours
         before the current time. If not specified this defaults to the end time of the
         last aggregation interval currently available. Default value is None.
        :paramtype endtime: ~datetime.datetime
        :keyword filter: An OData $filter clause. For more information on constructing this filter, see
        https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-account-usage-metrics.
         Default value is None.
        :paramtype filter: str
        :return: An iterator like instance of BatchPoolUsageMetrics
        :rtype: ~azure.core.paging.ItemPaged[~azure.batch.models.BatchPoolUsageMetrics]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "endTime": "2020-02-20 00:00:00",  # The end time of the aggregation interval
                      covered by this entry. Required.
                    "poolId": "str",  # The ID of the Pool whose metrics are aggregated in this
                      entry. Required.
                    "startTime": "2020-02-20 00:00:00",  # The start time of the aggregation
                      interval covered by this entry. Required.
                    "totalCoreHours": 0.0,  # The total core hours used in the Pool during this
                      aggregation interval. Required.
                    "vmSize": "str"  # The size of virtual machines in the Pool. All VMs in a
                      Pool are the same size. For information about available sizes of virtual machines
                      in Pools, see Choose a VM size for Compute Nodes in an Azure Batch Pool
                      (https://docs.microsoft.com/azure/batch/batch-pool-vm-sizes). Required.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.BatchPoolUsageMetrics]] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_batch_list_pool_usage_metrics_request(
                    time_out_in_seconds=time_out_in_seconds,
                    ocpdate=ocpdate,
                    maxresults=maxresults,
                    starttime=starttime,
                    endtime=endtime,
                    filter=filter,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.BatchPoolUsageMetrics], deserialized["value"])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("odata.nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                if _stream:
                    response.read()  # Load the body in memory and close the socket
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _deserialize(_models.BatchError, response.json())
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def create_pool(  # pylint: disable=inconsistent-return-statements
        self,
        pool: _models.BatchPoolCreateContent,
        *,
        time_out_in_seconds: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        # pylint: disable=line-too-long
        """Creates a Pool to the specified Account.

        When naming Pools, avoid including sensitive information such as user names or
        secret project names. This information may appear in telemetry logs accessible
        to Microsoft Support engineers.

        :param pool: The Pool to be created. Required.
        :type pool: ~azure.batch.models.BatchPoolCreateContent
        :keyword time_out_in_seconds: The maximum time that the server can spend processing the
         request, in seconds. The default is 30 seconds. If the value is larger than 30, the default
         will be used instead.". Default value is None.
        :paramtype time_out_in_seconds: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                pool = {
                    "id": "str",  # A string that uniquely identifies the Pool within the
                      Account. The ID can contain any combination of alphanumeric characters including
                      hyphens and underscores, and cannot contain more than 64 characters. The ID is
                      case-preserving and case-insensitive (that is, you may not have two Pool IDs
                      within an Account that differ only by case). Required.
                    "vmSize": "str",  # The size of virtual machines in the Pool. All virtual
                      machines in a Pool are the same size. For information about available VM sizes
                      for Pools using Images from the Virtual Machines Marketplace (pools created with
                      virtualMachineConfiguration), see Sizes for Virtual Machines (Linux)
                      (https://azure.microsoft.com/documentation/articles/virtual-machines-linux-sizes/)
                      or Sizes for Virtual Machines (Windows)
                      (https://azure.microsoft.com/documentation/articles/virtual-machines-windows-sizes/).
                      Batch supports all Azure VM sizes except STANDARD_A0 and those with premium
                      storage (STANDARD_GS, STANDARD_DS, and STANDARD_DSV2 series). Required.
                    "applicationPackageReferences": [
                        {
                            "applicationId": "str",  # The ID of the application to
                              deploy. When creating a pool, the package's application ID must be fully
                              qualified
                              (/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/applications/{applicationName}).
                              Required.
                            "version": "str"  # Optional. The version of the application
                              to deploy. If omitted, the default version is deployed. If this is
                              omitted on a Pool, and no default version is specified for this
                              application, the request fails with the error code
                              InvalidApplicationPackageReferences and HTTP status code 409. If this is
                              omitted on a Task, and no default version is specified for this
                              application, the Task fails with a pre-processing error.
                        }
                    ],
                    "autoScaleEvaluationInterval": "1 day, 0:00:00",  # Optional. The time
                      interval at which to automatically adjust the Pool size according to the
                      autoscale formula. The default value is 15 minutes. The minimum and maximum value
                      are 5 minutes and 168 hours respectively. If you specify a value less than 5
                      minutes or greater than 168 hours, the Batch service returns an error; if you are
                      calling the REST API directly, the HTTP status code is 400 (Bad Request).
                    "autoScaleFormula": "str",  # Optional. A formula for the desired number of
                      Compute Nodes in the Pool. This property must not be specified if enableAutoScale
                      is set to false. It is required if enableAutoScale is set to true. The formula is
                      checked for validity before the Pool is created. If the formula is not valid, the
                      Batch service rejects the request with detailed error information. For more
                      information about specifying this formula, see 'Automatically scale Compute Nodes
                      in an Azure Batch Pool'
                      (https://azure.microsoft.com/documentation/articles/batch-automatic-scaling/).
                    "displayName": "str",  # Optional. The display name for the Pool. The display
                      name need not be unique and can contain any Unicode characters up to a maximum
                      length of 1024.
                    "enableAutoScale": bool,  # Optional. Whether the Pool size should
                      automatically adjust over time. If false, at least one of targetDedicatedNodes
                      and targetLowPriorityNodes must be specified. If true, the autoScaleFormula
                      property is required and the Pool automatically resizes according to the formula.
                      The default value is false.
                    "enableInterNodeCommunication": bool,  # Optional. Whether the Pool permits
                      direct communication between Compute Nodes. Enabling inter-node communication
                      limits the maximum size of the Pool due to deployment restrictions on the Compute
                      Nodes of the Pool. This may result in the Pool not reaching its desired size. The
                      default value is false.
                    "metadata": [
                        {
                            "name": "str",  # The name of the metadata item. Required.
                            "value": "str"  # The value of the metadata item. Required.
                        }
                    ],
                    "mountConfiguration": [
                        {
                            "azureBlobFileSystemConfiguration": {
                                "accountName": "str",  # The Azure Storage Account
                                  name. Required.
                                "containerName": "str",  # The Azure Blob Storage
                                  Container name. Required.
                                "relativeMountPath": "str",  # The relative path on
                                  the compute node where the file system will be mounted. All file
                                  systems are mounted relative to the Batch mounts directory,
                                  accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
                                  Required.
                                "accountKey": "str",  # Optional. The Azure Storage
                                  Account key. This property is mutually exclusive with both sasKey and
                                  identity; exactly one must be specified.
                                "blobfuseOptions": "str",  # Optional. Additional
                                  command line options to pass to the mount command. These are 'net
                                  use' options in Windows and 'mount' options in Linux.
                                "identityReference": {
                                    "resourceId": "str"  # Optional. The ARM
                                      resource id of the user assigned identity.
                                },
                                "sasKey": "str"  # Optional. The Azure Storage SAS
                                  token. This property is mutually exclusive with both accountKey and
                                  identity; exactly one must be specified.
                            },
                            "azureFileShareConfiguration": {
                                "accountKey": "str",  # The Azure Storage account
                                  key. Required.
                                "accountName": "str",  # The Azure Storage account
                                  name. Required.
                                "azureFileUrl": "str",  # The Azure Files URL. This
                                  is of the form 'https://{account}.file.core.windows.net/'. Required.
                                "relativeMountPath": "str",  # The relative path on
                                  the compute node where the file system will be mounted. All file
                                  systems are mounted relative to the Batch mounts directory,
                                  accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
                                  Required.
                                "mountOptions": "str"  # Optional. Additional command
                                  line options to pass to the mount command. These are 'net use'
                                  options in Windows and 'mount' options in Linux.
                            },
                            "cifsMountConfiguration": {
                                "password": "str",  # The password to use for
                                  authentication against the CIFS file system. Required.
                                "relativeMountPath": "str",  # The relative path on
                                  the compute node where the file system will be mounted. All file
                                  systems are mounted relative to the Batch mounts directory,
                                  accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
                                  Required.
                                "source": "str",  # The URI of the file system to
                                  mount. Required.
                                "username": "str",  # The user to use for
                                  authentication against the CIFS file system. Required.
                                "mountOptions": "str"  # Optional. Additional command
                                  line options to pass to the mount command. These are 'net use'
                                  options in Windows and 'mount' options in Linux.
                            },
                            "nfsMountConfiguration": {
                                "relativeMountPath": "str",  # The relative path on
                                  the compute node where the file system will be mounted. All file
                                  systems are mounted relative to the Batch mounts directory,
                                  accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
                                  Required.
                                "source": "str",  # The URI of the file system to
                                  mount. Required.
                                "mountOptions": "str"  # Optional. Additional command
                                  line options to pass to the mount command. These are 'net use'
                                  options in Windows and 'mount' options in Linux.
                            }
                        }
                    ],
                    "networkConfiguration": {
                        "dynamicVNetAssignmentScope": "str",  # Optional. The scope of
                          dynamic vnet assignment. Known values are: "none" and "job".
                        "enableAcceleratedNetworking": bool,  # Optional. Whether this pool
                          should enable accelerated networking. Accelerated networking enables single
                          root I/O virtualization (SR-IOV) to a VM, which may lead to improved
                          networking performance. For more details, see:
                          https://learn.microsoft.com/azure/virtual-network/accelerated-networking-overview.
                        "endpointConfiguration": {
                            "inboundNATPools": [
                                {
                                    "backendPort": 0,  # The port number on the
                                      Compute Node. This must be unique within a Batch Pool. Acceptable
                                      values are between 1 and 65535 except for 22, 3389, 29876 and
                                      29877 as these are reserved. If any reserved values are provided
                                      the request fails with HTTP status code 400. Required.
                                    "frontendPortRangeEnd": 0,  # The last port
                                      number in the range of external ports that will be used to
                                      provide inbound access to the backendPort on individual Compute
                                      Nodes. Acceptable values range between 1 and 65534 except ports
                                      from 50000 to 55000 which are reserved by the Batch service. All
                                      ranges within a Pool must be distinct and cannot overlap. Each
                                      range must contain at least 40 ports. If any reserved or
                                      overlapping values are provided the request fails with HTTP
                                      status code 400. Required.
                                    "frontendPortRangeStart": 0,  # The first
                                      port number in the range of external ports that will be used to
                                      provide inbound access to the backendPort on individual Compute
                                      Nodes. Acceptable values range between 1 and 65534 except ports
                                      from 50000 to 55000 which are reserved. All ranges within a Pool
                                      must be distinct and cannot overlap. Each range must contain at
                                      least 40 ports. If any reserved or overlapping values are
                                      provided the request fails with HTTP status code 400. Required.
                                    "name": "str",  # The name of the endpoint.
                                      The name must be unique within a Batch Pool, can contain letters,
                                      numbers, underscores, periods, and hyphens. Names must start with
                                      a letter or number, must end with a letter, number, or
                                      underscore, and cannot exceed 77 characters.  If any invalid
                                      values are provided the request fails with HTTP status code 400.
                                      Required.
                                    "protocol": "str",  # The protocol of the
                                      endpoint. Required. Known values are: "tcp" and "udp".
                                    "networkSecurityGroupRules": [
                                        {
                                            "access": "str",  # The
                                              action that should be taken for a specified IP address,
                                              subnet range or tag. Required. Known values are: "allow"
                                              and "deny".
                                            "priority": 0,  # The
                                              priority for this rule. Priorities within a Pool must be
                                              unique and are evaluated in order of priority. The lower
                                              the number the higher the priority. For example, rules
                                              could be specified with order numbers of 150, 250, and
                                              350. The rule with the order number of 150 takes
                                              precedence over the rule that has an order of 250.
                                              Allowed priorities are 150 to 4096. If any reserved or
                                              duplicate values are provided the request fails with HTTP
                                              status code 400. Required.
                                            "sourceAddressPrefix": "str",
                                              # The source address prefix or tag to match for the rule.
                                              Valid values are a single IP address (i.e. 10.10.10.10),
                                              IP subnet (i.e. 192.168.1.0/24), default tag, or * (for
                                              all addresses).  If any other values are provided the
                                              request fails with HTTP status code 400. Required.
                                            "sourcePortRanges": [
                                                "str"  # Optional.
                                                  The source port ranges to match for the rule. Valid
                                                  values are '"" *' (for all ports 0 - 65535), a
                                                  specific port (i.e. 22), or a port range (i.e.
                                                  100-200). The ports must be in the range of 0 to
                                                  65535. Each entry in this collection must not overlap
                                                  any other entry (either a range or an individual
                                                  port). If any other values are provided the request
                                                  fails with HTTP status code 400. The default value is
                                                  '*"" '.
                                            ]
                                        }
                                    ]
                                }
                            ]
                        },
                        "publicIPAddressConfiguration": {
                            "ipAddressIds": [
                                "str"  # Optional. The list of public IPs which the
                                  Batch service will use when provisioning Compute Nodes. The number of
                                  IPs specified here limits the maximum size of the Pool - 100
                                  dedicated nodes or 100 Spot/Low-priority nodes can be allocated for
                                  each public IP. For example, a pool needing 250 dedicated VMs would
                                  need at least 3 public IPs specified. Each element of this collection
                                  is of the form:
                                  /subscriptions/{subscription}/resourceGroups/{group}/providers/Microsoft.Network/publicIPAddresses/{ip}.
                            ],
                            "provision": "str"  # Optional. The provisioning type for
                              Public IP Addresses for the Pool. The default value is BatchManaged.
                              Known values are: "batchmanaged", "usermanaged", and
                              "nopublicipaddresses".
                        },
                        "subnetId": "str"  # Optional. The ARM resource identifier of the
                          virtual network subnet which the Compute Nodes of the Pool will join. This is
                          of the form
                          /subscriptions/{subscription}/resourceGroups/{group}/providers/{provider}/virtualNetworks/{network}/subnets/{subnet}.
                          The virtual network must be in the same region and subscription as the Azure
                          Batch Account. The specified subnet should have enough free IP addresses to
                          accommodate the number of Compute Nodes in the Pool. If the subnet doesn't
                          have enough free IP addresses, the Pool will partially allocate Nodes and a
                          resize error will occur. The 'MicrosoftAzureBatch' service principal must
                          have the 'Classic Virtual Machine Contributor' Role-Based Access Control
                          (RBAC) role for the specified VNet. The specified subnet must allow
                          communication from the Azure Batch service to be able to schedule Tasks on
                          the Nodes. This can be verified by checking if the specified VNet has any
                          associated Network Security Groups (NSG). If communication to the Nodes in
                          the specified subnet is denied by an NSG, then the Batch service will set the
                          state of the Compute Nodes to unusable. For Pools created with
                          virtualMachineConfiguration only ARM virtual networks
                          ('Microsoft.Network/virtualNetworks') are supported. If the specified VNet
                          has any associated Network Security Groups (NSG), then a few reserved system
                          ports must be enabled for inbound communication. For Pools created with a
                          virtual machine configuration, enable ports 29876 and 29877, as well as port
                          22 for Linux and port 3389 for Windows. Also enable outbound connections to
                          Azure Storage on port 443. For more details see:
                          https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration.
                    },
                    "resizeTimeout": "1 day, 0:00:00",  # Optional. The timeout for allocation of
                      Compute Nodes to the Pool. This timeout applies only to manual scaling; it has no
                      effect when enableAutoScale is set to true. The default value is 15 minutes. The
                      minimum value is 5 minutes. If you specify a value less than 5 minutes, the Batch
                      service returns an error; if you are calling the REST API directly, the HTTP
                      status code is 400 (Bad Request).
                    "resourceTags": {
                        "str": "str"  # Optional. The user-specified tags associated with the
                          pool. The user-defined tags to be associated with the Azure Batch Pool. When
                          specified, these tags are propagated to the backing Azure resources
                          associated with the pool. This property can only be specified when the Batch
                          account was created with the poolAllocationMode property set to
                          'UserSubscription'.
                    },
                    "startTask": {
                        "commandLine": "str",  # The command line of the StartTask. The
                          command line does not run under a shell, and therefore cannot take advantage
                          of shell features such as environment variable expansion. If you want to take
                          advantage of such features, you should invoke the shell in the command line,
                          for example using "cmd /c MyCommand" in Windows or "/bin/sh -c MyCommand" in
                          Linux. If the command line refers to file paths, it should use a relative
                          path (relative to the Task working directory), or use the Batch provided
                          environment variable
                          (https://docs.microsoft.com/en-us/azure/batch/batch-compute-node-environment-variables).
                          Required.
                        "containerSettings": {
                            "imageName": "str",  # The Image to use to create the
                              container in which the Task will run. This is the full Image reference,
                              as would be specified to "docker pull". If no tag is provided as part of
                              the Image name, the tag ":latest" is used as a default. Required.
                            "containerRunOptions": "str",  # Optional. Additional options
                              to the container create command. These additional options are supplied as
                              arguments to the "docker create" command, in addition to those controlled
                              by the Batch Service.
                            "registry": {
                                "identityReference": {
                                    "resourceId": "str"  # Optional. The ARM
                                      resource id of the user assigned identity.
                                },
                                "password": "str",  # Optional. The password to log
                                  into the registry server.
                                "registryServer": "str",  # Optional. The registry
                                  URL. If omitted, the default is "docker.io".
                                "username": "str"  # Optional. The user name to log
                                  into the registry server.
                            },
                            "workingDirectory": "str"  # Optional. The location of the
                              container Task working directory. The default is 'taskWorkingDirectory'.
                              Known values are: "taskWorkingDirectory" and "containerImageDefault".
                        },
                        "environmentSettings": [
                            {
                                "name": "str",  # The name of the environment
                                  variable. Required.
                                "value": "str"  # Optional. The value of the
                                  environment variable.
                            }
                        ],
                        "maxTaskRetryCount": 0,  # Optional. The maximum number of times the
                          Task may be retried. The Batch service retries a Task if its exit code is
                          nonzero. Note that this value specifically controls the number of retries.
                          The Batch service will try the Task once, and may then retry up to this
                          limit. For example, if the maximum retry count is 3, Batch tries the Task up
                          to 4 times (one initial try and 3 retries). If the maximum retry count is 0,
                          the Batch service does not retry the Task. If the maximum retry count is -1,
                          the Batch service retries the Task without limit, however this is not
                          recommended for a start task or any task. The default value is 0 (no
                          retries).
                        "resourceFiles": [
                            {
                                "autoStorageContainerName": "str",  # Optional. The
                                  storage container name in the auto storage Account. The
                                  autoStorageContainerName, storageContainerUrl and httpUrl properties
                                  are mutually exclusive and one of them must be specified.
                                "blobPrefix": "str",  # Optional. The blob prefix to
                                  use when downloading blobs from an Azure Storage container. Only the
                                  blobs whose names begin with the specified prefix will be downloaded.
                                  The property is valid only when autoStorageContainerName or
                                  storageContainerUrl is used. This prefix can be a partial filename or
                                  a subdirectory. If a prefix is not specified, all the files in the
                                  container will be downloaded.
                                "fileMode": "str",  # Optional. The file permission
                                  mode attribute in octal format. This property applies only to files
                                  being downloaded to Linux Compute Nodes. It will be ignored if it is
                                  specified for a resourceFile which will be downloaded to a Windows
                                  Compute Node. If this property is not specified for a Linux Compute
                                  Node, then a default value of 0770 is applied to the file.
                                "filePath": "str",  # Optional. The location on the
                                  Compute Node to which to download the file(s), relative to the Task's
                                  working directory. If the httpUrl property is specified, the filePath
                                  is required and describes the path which the file will be downloaded
                                  to, including the filename. Otherwise, if the
                                  autoStorageContainerName or storageContainerUrl property is
                                  specified, filePath is optional and is the directory to download the
                                  files to. In the case where filePath is used as a directory, any
                                  directory structure already associated with the input data will be
                                  retained in full and appended to the specified filePath directory.
                                  The specified relative path cannot break out of the Task's working
                                  directory (for example by using '..').
                                "httpUrl": "str",  # Optional. The URL of the file to
                                  download. The autoStorageContainerName, storageContainerUrl and
                                  httpUrl properties are mutually exclusive and one of them must be
                                  specified. If the URL points to Azure Blob Storage, it must be
                                  readable from compute nodes. There are three ways to get such a URL
                                  for a blob in Azure storage: include a Shared Access Signature (SAS)
                                  granting read permissions on the blob, use a managed identity with
                                  read permission, or set the ACL for the blob or its container to
                                  allow public access.
                                "identityReference": {
                                    "resourceId": "str"  # Optional. The ARM
                                      resource id of the user assigned identity.
                                },
                                "storageContainerUrl": "str"  # Optional. The URL of
                                  the blob container within Azure Blob Storage. The
                                  autoStorageContainerName, storageContainerUrl and httpUrl properties
                                  are mutually exclusive and one of them must be specified. This URL
                                  must be readable and listable from compute nodes. There are three
                                  ways to get such a URL for a container in Azure storage: include a
                                  Shared Access Signature (SAS) granting read and list permissions on
                                  the container, use a managed identity with read and list permissions,
                                  or set the ACL for the container to allow public access.
                            }
                        ],
                        "userIdentity": {
                            "autoUser": {
                                "elevationLevel": "str",  # Optional. The elevation
                                  level of the auto user. The default value is nonAdmin. Known values
                                  are: "nonadmin" and "admin".
                                "scope": "str"  # Optional. The scope for the auto
                                  user. The default value is pool. If the pool is running Windows, a
                                  value of Task should be specified if stricter isolation between tasks
                                  is required, such as if the task mutates the registry in a way which
                                  could impact other tasks. Known values are: "task" and "pool".
                            },
                            "username": "str"  # Optional. The name of the user identity
                              under which the Task is run. The userName and autoUser properties are
                              mutually exclusive; you must specify one but not both.
                        },
                        "waitForSuccess": bool  # Optional. Whether the Batch service should
                          wait for the StartTask to complete successfully (that is, to exit with exit
                          code 0) before scheduling any Tasks on the Compute Node. If true and the
                          StartTask fails on a Node, the Batch service retries the StartTask up to its
                          maximum retry count (maxTaskRetryCount). If the Task has still not completed
                          successfully after all retries, then the Batch service marks the Node
                          unusable, and will not schedule Tasks to it. This condition can be detected
                          via the Compute Node state and failure info details. If false, the Batch
                          service will not wait for the StartTask to complete. In this case, other
                          Tasks can start executing on the Compute Node while the StartTask is still
                          running; and even if the StartTask fails, new Tasks will continue to be
                          scheduled on the Compute Node. The default is true.
                    },
                    "targetDedicatedNodes": 0,  # Optional. The desired number of dedicated
                      Compute Nodes in the Pool. This property must not be specified if enableAutoScale
                      is set to true. If enableAutoScale is set to false, then you must set either
                      targetDedicatedNodes, targetLowPriorityNodes, or both.
                    "targetLowPriorityNodes": 0,  # Optional. The desired number of
                      Spot/Low-priority Compute Nodes in the Pool. This property must not be specified
                      if enableAutoScale is set to true. If enableAutoScale is set to false, then you
                      must set either targetDedicatedNodes, targetLowPriorityNodes, or both.
                    "targetNodeCommunicationMode": "str",  # Optional. The desired node
                      communication mode for the pool. If omitted, the default value is Default. Known
                      values are: "default", "classic", and "simplified".
                    "taskSchedulingPolicy": {
                        "nodeFillType": "str"  # How Tasks are distributed across Compute
                          Nodes in a Pool. If not specified, the default is spread. Required. Known
                          values are: "spread" and "pack".
                    },
                    "taskSlotsPerNode": 0,  # Optional. The number of task slots that can be used
                      to run concurrent tasks on a single compute node in the pool. The default value
                      is 1. The maximum value is the smaller of 4 times the number of cores of the
                      vmSize of the pool or 256.
                    "upgradePolicy": {
                        "mode": "str",  # Specifies the mode of an upgrade to virtual
                          machines in the scale set.:code:`<br />`:code:`<br />` Possible values
                          are::code:`<br />`:code:`<br />` **Manual** - You  control the application of
                          updates to virtual machines in the scale set. You do this by using the
                          manualUpgrade action.:code:`<br />`:code:`<br />` **Automatic** - All virtual
                          machines in the scale set are automatically updated at the same
                          time.:code:`<br />`:code:`<br />` **Rolling** - Scale set performs updates in
                          batches with an optional pause time in between. Required. Known values are:
                          "automatic", "manual", and "rolling".
                        "automaticOSUpgradePolicy": {
                            "disableAutomaticRollback": bool,  # Optional. Whether OS
                              image rollback feature should be disabled.
                            "enableAutomaticOSUpgrade": bool,  # Optional. Indicates
                              whether OS upgrades should automatically be applied to scale set
                              instances in a rolling fashion when a newer version of the OS image
                              becomes available. :code:`<br />`:code:`<br />` If this is set to true
                              for Windows based pools, `WindowsConfiguration.enableAutomaticUpdates
                              <https://learn.microsoft.com/en-us/rest/api/batchservice/pool/add?tabs=HTTP#windowsconfiguration>`_
                              cannot be set to true.
                            "osRollingUpgradeDeferral": bool,  # Optional. Defer OS
                              upgrades on the TVMs if they are running tasks.
                            "useRollingUpgradePolicy": bool  # Optional. Indicates
                              whether rolling upgrade policy should be used during Auto OS Upgrade.
                              Auto OS Upgrade will fallback to the default policy if no policy is
                              defined on the VMSS.
                        },
                        "rollingUpgradePolicy": {
                            "enableCrossZoneUpgrade": bool,  # Optional. Allow VMSS to
                              ignore AZ boundaries when constructing upgrade batches. Take into
                              consideration the Update Domain and maxBatchInstancePercent to determine
                              the batch size. This field is able to be set to true or false only when
                              using NodePlacementConfiguration as Zonal.
                            "maxBatchInstancePercent": 0,  # Optional. The maximum
                              percent of total virtual machine instances that will be upgraded
                              simultaneously by the rolling upgrade in one batch. As this is a maximum,
                              unhealthy instances in previous or future batches can cause the
                              percentage of instances in a batch to decrease to ensure higher
                              reliability. The value of this field should be between 5 and 100,
                              inclusive. If both maxBatchInstancePercent and
                              maxUnhealthyInstancePercent are assigned with value, the value of
                              maxBatchInstancePercent should not be more than
                              maxUnhealthyInstancePercent.
                            "maxUnhealthyInstancePercent": 0,  # Optional. The maximum
                              percentage of the total virtual machine instances in the scale set that
                              can be simultaneously unhealthy, either as a result of being upgraded, or
                              by being found in an unhealthy state by the virtual machine health checks
                              before the rolling upgrade aborts. This constraint will be checked prior
                              to starting any batch. The value of this field should be between 5 and
                              100, inclusive. If both maxBatchInstancePercent and
                              maxUnhealthyInstancePercent are assigned with value, the value of
                              maxBatchInstancePercent should not be more than
                              maxUnhealthyInstancePercent.
                            "maxUnhealthyUpgradedInstancePercent": 0,  # Optional. The
                              maximum percentage of upgraded virtual machine instances that can be
                              found to be in an unhealthy state. This check will happen after each
                              batch is upgraded. If this percentage is ever exceeded, the rolling
                              update aborts. The value of this field should be between 0 and 100,
                              inclusive.
                            "pauseTimeBetweenBatches": "1 day, 0:00:00",  # Optional. The
                              wait time between completing the update for all virtual machines in one
                              batch and starting the next batch. The time duration should be specified
                              in ISO 8601 format..
                            "prioritizeUnhealthyInstances": bool,  # Optional. Upgrade
                              all unhealthy instances in a scale set before any healthy instances.
                            "rollbackFailedInstancesOnPolicyBreach": bool  # Optional.
                              Rollback failed instances to previous model if the Rolling Upgrade policy
                              is violated.
                        }
                    },
                    "userAccounts": [
                        {
                            "name": "str",  # The name of the user Account. Names can
                              contain any Unicode characters up to a maximum length of 20. Required.
                            "password": "str",  # The password for the user Account.
                              Required.
                            "elevationLevel": "str",  # Optional. The elevation level of
                              the user Account. The default value is nonAdmin. Known values are:
                              "nonadmin" and "admin".
                            "linuxUserConfiguration": {
                                "gid": 0,  # Optional. The group ID for the user
                                  Account. The uid and gid properties must be specified together or not
                                  at all. If not specified the underlying operating system picks the
                                  gid.
                                "sshPrivateKey": "str",  # Optional. The SSH private
                                  key for the user Account. The private key must not be password
                                  protected. The private key is used to automatically configure
                                  asymmetric-key based authentication for SSH between Compute Nodes in
                                  a Linux Pool when the Pool's enableInterNodeCommunication property is
                                  true (it is ignored if enableInterNodeCommunication is false). It
                                  does this by placing the key pair into the user's .ssh directory. If
                                  not specified, password-less SSH is not configured between Compute
                                  Nodes (no modification of the user's .ssh directory is done).
                                "uid": 0  # Optional. The user ID of the user
                                  Account. The uid and gid properties must be specified together or not
                                  at all. If not specified the underlying operating system picks the
                                  uid.
                            },
                            "windowsUserConfiguration": {
                                "loginMode": "str"  # Optional. The login mode for
                                  the user. The default value for VirtualMachineConfiguration Pools is
                                  'batch'. Known values are: "batch" and "interactive".
                            }
                        }
                    ],
                    "virtualMachineConfiguration": {
                        "imageReference": {
                            "exactVersion": "str",  # Optional. The specific version of
                              the platform image or marketplace image used to create the node. This
                              read-only field differs from 'version' only if the value specified for
                              'version' when the pool was created was 'latest'.
                            "offer": "str",  # Optional. The offer type of the Azure
                              Virtual Machines Marketplace Image. For example, UbuntuServer or
                              WindowsServer.
                            "publisher": "str",  # Optional. The publisher of the Azure
                              Virtual Machines Marketplace Image. For example, Canonical or
                              MicrosoftWindowsServer.
                            "sku": "str",  # Optional. The SKU of the Azure Virtual
                              Machines Marketplace Image. For example, 18.04-LTS or 2019-Datacenter.
                            "version": "str",  # Optional. The version of the Azure
                              Virtual Machines Marketplace Image. A value of 'latest' can be specified
                              to select the latest version of an Image. If omitted, the default is
                              'latest'.
                            "virtualMachineImageId": "str"  # Optional. The ARM resource
                              identifier of the Azure Compute Gallery Image. Compute Nodes in the Pool
                              will be created using this Image Id. This is of the form
                              /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/galleries/{galleryName}/images/{imageDefinitionName}/versions/{VersionId}
                              or
                              /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/galleries/{galleryName}/images/{imageDefinitionName}
                              for always defaulting to the latest image version. This property is
                              mutually exclusive with other ImageReference properties. The Azure
                              Compute Gallery Image must have replicas in the same region and must be
                              in the same subscription as the Azure Batch account. If the image version
                              is not specified in the imageId, the latest version will be used. For
                              information about the firewall settings for the Batch Compute Node agent
                              to communicate with the Batch service see
                              https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration.
                        },
                        "nodeAgentSKUId": "str",  # The SKU of the Batch Compute Node agent
                          to be provisioned on Compute Nodes in the Pool. The Batch Compute Node agent
                          is a program that runs on each Compute Node in the Pool, and provides the
                          command-and-control interface between the Compute Node and the Batch service.
                          There are different implementations of the Compute Node agent, known as SKUs,
                          for different operating systems. You must specify a Compute Node agent SKU
                          which matches the selected Image reference. To get the list of supported
                          Compute Node agent SKUs along with their list of verified Image references,
                          see the 'List supported Compute Node agent SKUs' operation. Required.
                        "containerConfiguration": {
                            "type": "str",  # The container technology to be used.
                              Required. Known values are: "dockerCompatible" and "criCompatible".
                            "containerImageNames": [
                                "str"  # Optional. The collection of container Image
                                  names. This is the full Image reference, as would be specified to
                                  "docker pull". An Image will be sourced from the default Docker
                                  registry unless the Image is fully qualified with an alternative
                                  registry.
                            ],
                            "containerRegistries": [
                                {
                                    "identityReference": {
                                        "resourceId": "str"  # Optional. The
                                          ARM resource id of the user assigned identity.
                                    },
                                    "password": "str",  # Optional. The password
                                      to log into the registry server.
                                    "registryServer": "str",  # Optional. The
                                      registry URL. If omitted, the default is "docker.io".
                                    "username": "str"  # Optional. The user name
                                      to log into the registry server.
                                }
                            ]
                        },
                        "dataDisks": [
                            {
                                "diskSizeGB": 0,  # The initial disk size in
                                  gigabytes. Required.
                                "lun": 0,  # The logical unit number. The
                                  logicalUnitNumber is used to uniquely identify each data disk. If
                                  attaching multiple disks, each should have a distinct
                                  logicalUnitNumber. The value must be between 0 and 63, inclusive.
                                  Required.
                                "caching": "str",  # Optional. The type of caching to
                                  be enabled for the data disks. The default value for caching is
                                  readwrite. For information about the caching options see:
                                  https://blogs.msdn.microsoft.com/windowsazurestorage/2012/06/27/exploring-windows-azure-drives-disks-and-images/.
                                  Known values are: "none", "readonly", and "readwrite".
                                "storageAccountType": "str"  # Optional. The storage
                                  Account type to be used for the data disk. If omitted, the default is
                                  "standard_lrs". Known values are: "standard_lrs", "premium_lrs", and
                                  "standardssd_lrs".
                            }
                        ],
                        "diskEncryptionConfiguration": {
                            "targets": [
                                "str"  # Optional. The list of disk targets Batch
                                  Service will encrypt on the compute node. If omitted, no disks on the
                                  compute nodes in the pool will be encrypted. On Linux pool, only
                                  "TemporaryDisk" is supported; on Windows pool, "OsDisk" and
                                  "TemporaryDisk" must be specified.
                            ]
                        },
                        "extensions": [
                            {
                                "name": "str",  # The name of the virtual machine
                                  extension. Required.
                                "publisher": "str",  # The name of the extension
                                  handler publisher. Required.
                                "type": "str",  # The type of the extension.
                                  Required.
                                "autoUpgradeMinorVersion": bool,  # Optional.
                                  Indicates whether the extension should use a newer minor version if
                                  one is available at deployment time. Once deployed, however, the
                                  extension will not upgrade minor versions unless redeployed, even
                                  with this property set to true.
                                "enableAutomaticUpgrade": bool,  # Optional.
                                  Indicates whether the extension should be automatically upgraded by
                                  the platform if there is a newer version of the extension available.
                                "protectedSettings": {
                                    "str": "str"  # Optional. The extension can
                                      contain either protectedSettings or protectedSettingsFromKeyVault
                                      or no protected settings at all.
                                },
                                "provisionAfterExtensions": [
                                    "str"  # Optional. The collection of
                                      extension names. Collection of extension names after which this
                                      extension needs to be provisioned.
                                ],
                                "settings": {
                                    "str": "str"  # Optional. JSON formatted
                                      public settings for the extension.
                                },
                                "typeHandlerVersion": "str"  # Optional. The version
                                  of script handler.
                            }
                        ],
                        "licenseType": "str",  # Optional. This only applies to Images that
                          contain the Windows operating system, and should only be used when you hold
                          valid on-premises licenses for the Compute Nodes which will be deployed. If
                          omitted, no on-premises licensing discount is applied. Values are:
                          Windows_Server - The on-premises license is for Windows Server.
                          Windows_Client - The on-premises license is for Windows Client.
                        "nodePlacementConfiguration": {
                            "policy": "str"  # Optional. Node placement Policy type on
                              Batch Pools. Allocation policy used by Batch Service to provision the
                              nodes. If not specified, Batch will use the regional policy. Known values
                              are: "regional" and "zonal".
                        },
                        "osDisk": {
                            "caching": "str",  # Optional. Specifies the caching
                              requirements. Possible values are: None, ReadOnly, ReadWrite. The default
                              values are: None for Standard storage. ReadOnly for Premium storage.
                              Known values are: "none", "readonly", and "readwrite".
                            "diskSizeGB": 0,  # Optional. The initial disk size in GB
                              when creating new OS disk.
                            "ephemeralOSDiskSettings": {
                                "placement": "str"  # Optional. Specifies the
                                  ephemeral disk placement for operating system disk for all VMs in the
                                  pool. This property can be used by user in the request to choose the
                                  location e.g., cache disk space for Ephemeral OS disk provisioning.
                                  For more information on Ephemeral OS disk size requirements, please
                                  refer to Ephemeral OS disk size requirements for Windows VMs at
                                  https://docs.microsoft.com/en-us/azure/virtual-machines/windows/ephemeral-os-disks#size-requirements
                                  and Linux VMs at
                                  https://docs.microsoft.com/en-us/azure/virtual-machines/linux/ephemeral-os-disks#size-requirements.
                                  "cachedisk"
                            },
                            "managedDisk": {
                                "storageAccountType": "str"  # The storage account
                                  type for managed disk. Required. Known values are: "standard_lrs",
                                  "premium_lrs", and "standardssd_lrs".
                            },
                            "writeAcceleratorEnabled": bool  # Optional. Specifies
                              whether writeAccelerator should be enabled or disabled on the disk.
                        },
                        "securityProfile": {
                            "encryptionAtHost": bool,  # This property can be used by
                              user in the request to enable or disable the Host Encryption for the
                              virtual machine or virtual machine scale set. This will enable the
                              encryption for all the disks including Resource/Temp disk at host itself.
                              Required.
                            "securityType": "str",  # Specifies the SecurityType of the
                              virtual machine. It has to be set to any specified value to enable
                              UefiSettings. Required. "trustedLaunch"
                            "uefiSettings": {
                                "secureBootEnabled": bool,  # Optional. Specifies
                                  whether secure boot should be enabled on the virtual machine.
                                "vTpmEnabled": bool  # Optional. Specifies whether
                                  vTPM should be enabled on the virtual machine.
                            }
                        },
                        "serviceArtifactReference": {
                            "id": "str"  # The service artifact reference id of
                              ServiceArtifactReference. The service artifact reference id in the form
                              of
                              /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/galleries/{galleryName}/serviceArtifacts/{serviceArtifactName}/vmArtifactsProfiles/{vmArtifactsProfilesName}.
                              Required.
                        },
                        "windowsConfiguration": {
                            "enableAutomaticUpdates": bool  # Optional. Whether automatic
                              updates are enabled on the virtual machine. If omitted, the default value
                              is true.
                        }
                    }
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: str = kwargs.pop(
            "content_type", _headers.pop("content-type", "application/json; odata=minimalmetadata")
        )
        cls: ClsType[None] = kwargs.pop("cls", None)

        _content = json.dumps(pool, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_batch_create_pool_request(
            time_out_in_seconds=time_out_in_seconds,
            ocpdate=ocpdate,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.BatchError, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["DataServiceId"] = self._deserialize("str", response.headers.get("DataServiceId"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def list_pools(
        self,
        *,
        time_out_in_seconds: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        maxresults: Optional[int] = None,
        filter: Optional[str] = None,
        select: Optional[List[str]] = None,
        expand: Optional[List[str]] = None,
        **kwargs: Any
    ) -> Iterable["_models.BatchPool"]:
        # pylint: disable=line-too-long
        """Lists all of the Pools in the specified Account.

        Lists all of the Pools in the specified Account.

        :keyword time_out_in_seconds: The maximum time that the server can spend processing the
         request, in seconds. The default is 30 seconds. If the value is larger than 30, the default
         will be used instead.". Default value is None.
        :paramtype time_out_in_seconds: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword maxresults: The maximum number of items to return in the response. A maximum of 1000
         applications can be returned. Default value is None.
        :paramtype maxresults: int
        :keyword filter: An OData $filter clause. For more information on constructing this filter, see
         https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-pools.
         Default value is None.
        :paramtype filter: str
        :keyword select: An OData $select clause. Default value is None.
        :paramtype select: list[str]
        :keyword expand: An OData $expand clause. Default value is None.
        :paramtype expand: list[str]
        :return: An iterator like instance of BatchPool
        :rtype: ~azure.core.paging.ItemPaged[~azure.batch.models.BatchPool]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "allocationState": "str",  # Optional. Whether the Pool is resizing. Known
                      values are: "steady", "resizing", and "stopping".
                    "allocationStateTransitionTime": "2020-02-20 00:00:00",  # Optional. The time
                      at which the Pool entered its current allocation state.
                    "applicationPackageReferences": [
                        {
                            "applicationId": "str",  # The ID of the application to
                              deploy. When creating a pool, the package's application ID must be fully
                              qualified
                              (/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/applications/{applicationName}).
                              Required.
                            "version": "str"  # Optional. The version of the application
                              to deploy. If omitted, the default version is deployed. If this is
                              omitted on a Pool, and no default version is specified for this
                              application, the request fails with the error code
                              InvalidApplicationPackageReferences and HTTP status code 409. If this is
                              omitted on a Task, and no default version is specified for this
                              application, the Task fails with a pre-processing error.
                        }
                    ],
                    "autoScaleEvaluationInterval": "1 day, 0:00:00",  # Optional. The time
                      interval at which to automatically adjust the Pool size according to the
                      autoscale formula. This property is set only if the Pool automatically scales,
                      i.e. enableAutoScale is true.
                    "autoScaleFormula": "str",  # Optional. A formula for the desired number of
                      Compute Nodes in the Pool. This property is set only if the Pool automatically
                      scales, i.e. enableAutoScale is true.
                    "autoScaleRun": {
                        "timestamp": "2020-02-20 00:00:00",  # The time at which the
                          autoscale formula was last evaluated. Required.
                        "error": {
                            "code": "str",  # Optional. An identifier for the autoscale
                              error. Codes are invariant and are intended to be consumed
                              programmatically.
                            "message": "str",  # Optional. A message describing the
                              autoscale error, intended to be suitable for display in a user interface.
                            "values": [
                                {
                                    "name": "str",  # Optional. The name in the
                                      name-value pair.
                                    "value": "str"  # Optional. The value in the
                                      name-value pair.
                                }
                            ]
                        },
                        "results": "str"  # Optional. The final values of all variables used
                          in the evaluation of the autoscale formula. Each variable value is returned
                          in the form $variable=value, and variables are separated by semicolons.
                    },
                    "creationTime": "2020-02-20 00:00:00",  # Optional. The creation time of the
                      Pool.
                    "currentDedicatedNodes": 0,  # Optional. The number of dedicated Compute
                      Nodes currently in the Pool.
                    "currentLowPriorityNodes": 0,  # Optional. The number of Spot/Low-priority
                      Compute Nodes currently in the Pool. Spot/Low-priority Compute Nodes which have
                      been preempted are included in this count.
                    "currentNodeCommunicationMode": "str",  # Optional. The current state of the
                      pool communication mode. Known values are: "default", "classic", and
                      "simplified".
                    "displayName": "str",  # Optional. The display name for the Pool. The display
                      name need not be unique and can contain any Unicode characters up to a maximum
                      length of 1024.
                    "eTag": "str",  # Optional. The ETag of the Pool. This is an opaque string.
                      You can use it to detect whether the Pool has changed between requests. In
                      particular, you can be pass the ETag when updating a Pool to specify that your
                      changes should take effect only if nobody else has modified the Pool in the
                      meantime.
                    "enableAutoScale": bool,  # Optional. Whether the Pool size should
                      automatically adjust over time. If false, at least one of targetDedicatedNodes
                      and targetLowPriorityNodes must be specified. If true, the autoScaleFormula
                      property is required and the Pool automatically resizes according to the formula.
                      The default value is false.
                    "enableInterNodeCommunication": bool,  # Optional. Whether the Pool permits
                      direct communication between Compute Nodes. This imposes restrictions on which
                      Compute Nodes can be assigned to the Pool. Specifying this value can reduce the
                      chance of the requested number of Compute Nodes to be allocated in the Pool.
                    "id": "str",  # Optional. A string that uniquely identifies the Pool within
                      the Account. The ID can contain any combination of alphanumeric characters
                      including hyphens and underscores, and cannot contain more than 64 characters.
                      The ID is case-preserving and case-insensitive (that is, you may not have two IDs
                      within an Account that differ only by case).
                    "identity": {
                        "type": "str",  # The identity of the Batch pool, if configured. The
                          list of user identities associated with the Batch pool. The user identity
                          dictionary key references will be ARM resource ids in the form:
                          '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
                          Required. Known values are: "UserAssigned" and "None".
                        "userAssignedIdentities": [
                            {
                                "resourceId": "str",  # The ARM resource id of the
                                  user assigned identity. Required.
                                "clientId": "str",  # Optional. The client id of the
                                  user assigned identity.
                                "principalId": "str"  # Optional. The principal id of
                                  the user assigned identity.
                            }
                        ]
                    },
                    "lastModified": "2020-02-20 00:00:00",  # Optional. The last modified time of
                      the Pool. This is the last time at which the Pool level data, such as the
                      targetDedicatedNodes or enableAutoscale settings, changed. It does not factor in
                      node-level changes such as a Compute Node changing state.
                    "metadata": [
                        {
                            "name": "str",  # The name of the metadata item. Required.
                            "value": "str"  # The value of the metadata item. Required.
                        }
                    ],
                    "mountConfiguration": [
                        {
                            "azureBlobFileSystemConfiguration": {
                                "accountName": "str",  # The Azure Storage Account
                                  name. Required.
                                "containerName": "str",  # The Azure Blob Storage
                                  Container name. Required.
                                "relativeMountPath": "str",  # The relative path on
                                  the compute node where the file system will be mounted. All file
                                  systems are mounted relative to the Batch mounts directory,
                                  accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
                                  Required.
                                "accountKey": "str",  # Optional. The Azure Storage
                                  Account key. This property is mutually exclusive with both sasKey and
                                  identity; exactly one must be specified.
                                "blobfuseOptions": "str",  # Optional. Additional
                                  command line options to pass to the mount command. These are 'net
                                  use' options in Windows and 'mount' options in Linux.
                                "identityReference": {
                                    "resourceId": "str"  # Optional. The ARM
                                      resource id of the user assigned identity.
                                },
                                "sasKey": "str"  # Optional. The Azure Storage SAS
                                  token. This property is mutually exclusive with both accountKey and
                                  identity; exactly one must be specified.
                            },
                            "azureFileShareConfiguration": {
                                "accountKey": "str",  # The Azure Storage account
                                  key. Required.
                                "accountName": "str",  # The Azure Storage account
                                  name. Required.
                                "azureFileUrl": "str",  # The Azure Files URL. This
                                  is of the form 'https://{account}.file.core.windows.net/'. Required.
                                "relativeMountPath": "str",  # The relative path on
                                  the compute node where the file system will be mounted. All file
                                  systems are mounted relative to the Batch mounts directory,
                                  accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
                                  Required.
                                "mountOptions": "str"  # Optional. Additional command
                                  line options to pass to the mount command. These are 'net use'
                                  options in Windows and 'mount' options in Linux.
                            },
                            "cifsMountConfiguration": {
                                "password": "str",  # The password to use for
                                  authentication against the CIFS file system. Required.
                                "relativeMountPath": "str",  # The relative path on
                                  the compute node where the file system will be mounted. All file
                                  systems are mounted relative to the Batch mounts directory,
                                  accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
                                  Required.
                                "source": "str",  # The URI of the file system to
                                  mount. Required.
                                "username": "str",  # The user to use for
                                  authentication against the CIFS file system. Required.
                                "mountOptions": "str"  # Optional. Additional command
                                  line options to pass to the mount command. These are 'net use'
                                  options in Windows and 'mount' options in Linux.
                            },
                            "nfsMountConfiguration": {
                                "relativeMountPath": "str",  # The relative path on
                                  the compute node where the file system will be mounted. All file
                                  systems are mounted relative to the Batch mounts directory,
                                  accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
                                  Required.
                                "source": "str",  # The URI of the file system to
                                  mount. Required.
                                "mountOptions": "str"  # Optional. Additional command
                                  line options to pass to the mount command. These are 'net use'
                                  options in Windows and 'mount' options in Linux.
                            }
                        }
                    ],
                    "networkConfiguration": {
                        "dynamicVNetAssignmentScope": "str",  # Optional. The scope of
                          dynamic vnet assignment. Known values are: "none" and "job".
                        "enableAcceleratedNetworking": bool,  # Optional. Whether this pool
                          should enable accelerated networking. Accelerated networking enables single
                          root I/O virtualization (SR-IOV) to a VM, which may lead to improved
                          networking performance. For more details, see:
                          https://learn.microsoft.com/azure/virtual-network/accelerated-networking-overview.
                        "endpointConfiguration": {
                            "inboundNATPools": [
                                {
                                    "backendPort": 0,  # The port number on the
                                      Compute Node. This must be unique within a Batch Pool. Acceptable
                                      values are between 1 and 65535 except for 22, 3389, 29876 and
                                      29877 as these are reserved. If any reserved values are provided
                                      the request fails with HTTP status code 400. Required.
                                    "frontendPortRangeEnd": 0,  # The last port
                                      number in the range of external ports that will be used to
                                      provide inbound access to the backendPort on individual Compute
                                      Nodes. Acceptable values range between 1 and 65534 except ports
                                      from 50000 to 55000 which are reserved by the Batch service. All
                                      ranges within a Pool must be distinct and cannot overlap. Each
                                      range must contain at least 40 ports. If any reserved or
                                      overlapping values are provided the request fails with HTTP
                                      status code 400. Required.
                                    "frontendPortRangeStart": 0,  # The first
                                      port number in the range of external ports that will be used to
                                      provide inbound access to the backendPort on individual Compute
                                      Nodes. Acceptable values range between 1 and 65534 except ports
                                      from 50000 to 55000 which are reserved. All ranges within a Pool
                                      must be distinct and cannot overlap. Each range must contain at
                                      least 40 ports. If any reserved or overlapping values are
                                      provided the request fails with HTTP status code 400. Required.
                                    "name": "str",  # The name of the endpoint.
                                      The name must be unique within a Batch Pool, can contain letters,
                                      numbers, underscores, periods, and hyphens. Names must start with
                                      a letter or number, must end with a letter, number, or
                                      underscore, and cannot exceed 77 characters.  If any invalid
                                      values are provided the request fails with HTTP status code 400.
                                      Required.
                                    "protocol": "str",  # The protocol of the
                                      endpoint. Required. Known values are: "tcp" and "udp".
                                    "networkSecurityGroupRules": [
                                        {
                                            "access": "str",  # The
                                              action that should be taken for a specified IP address,
                                              subnet range or tag. Required. Known values are: "allow"
                                              and "deny".
                                            "priority": 0,  # The
                                              priority for this rule. Priorities within a Pool must be
                                              unique and are evaluated in order of priority. The lower
                                              the number the higher the priority. For example, rules
                                              could be specified with order numbers of 150, 250, and
                                              350. The rule with the order number of 150 takes
                                              precedence over the rule that has an order of 250.
                                              Allowed priorities are 150 to 4096. If any reserved or
                                              duplicate values are provided the request fails with HTTP
                                              status code 400. Required.
                                            "sourceAddressPrefix": "str",
                                              # The source address prefix or tag to match for the rule.
                                              Valid values are a single IP address (i.e. 10.10.10.10),
                                              IP subnet (i.e. 192.168.1.0/24), default tag, or * (for
                                              all addresses).  If any other values are provided the
                                              request fails with HTTP status code 400. Required.
                                            "sourcePortRanges": [
                                                "str"  # Optional.
                                                  The source port ranges to match for the rule. Valid
                                                  values are '"" *' (for all ports 0 - 65535), a
                                                  specific port (i.e. 22), or a port range (i.e.
                                                  100-200). The ports must be in the range of 0 to
                                                  65535. Each entry in this collection must not overlap
                                                  any other entry (either a range or an individual
                                                  port). If any other values are provided the request
                                                  fails with HTTP status code 400. The default value is
                                                  '*"" '.
                                            ]
                                        }
                                    ]
                                }
                            ]
                        },
                        "publicIPAddressConfiguration": {
                            "ipAddressIds": [
                                "str"  # Optional. The list of public IPs which the
                                  Batch service will use when provisioning Compute Nodes. The number of
                                  IPs specified here limits the maximum size of the Pool - 100
                                  dedicated nodes or 100 Spot/Low-priority nodes can be allocated for
                                  each public IP. For example, a pool needing 250 dedicated VMs would
                                  need at least 3 public IPs specified. Each element of this collection
                                  is of the form:
                                  /subscriptions/{subscription}/resourceGroups/{group}/providers/Microsoft.Network/publicIPAddresses/{ip}.
                            ],
                            "provision": "str"  # Optional. The provisioning type for
                              Public IP Addresses for the Pool. The default value is BatchManaged.
                              Known values are: "batchmanaged", "usermanaged", and
                              "nopublicipaddresses".
                        },
                        "subnetId": "str"  # Optional. The ARM resource identifier of the
                          virtual network subnet which the Compute Nodes of the Pool will join. This is
                          of the form
                          /subscriptions/{subscription}/resourceGroups/{group}/providers/{provider}/virtualNetworks/{network}/subnets/{subnet}.
                          The virtual network must be in the same region and subscription as the Azure
                          Batch Account. The specified subnet should have enough free IP addresses to
                          accommodate the number of Compute Nodes in the Pool. If the subnet doesn't
                          have enough free IP addresses, the Pool will partially allocate Nodes and a
                          resize error will occur. The 'MicrosoftAzureBatch' service principal must
                          have the 'Classic Virtual Machine Contributor' Role-Based Access Control
                          (RBAC) role for the specified VNet. The specified subnet must allow
                          communication from the Azure Batch service to be able to schedule Tasks on
                          the Nodes. This can be verified by checking if the specified VNet has any
                          associated Network Security Groups (NSG). If communication to the Nodes in
                          the specified subnet is denied by an NSG, then the Batch service will set the
                          state of the Compute Nodes to unusable. For Pools created with
                          virtualMachineConfiguration only ARM virtual networks
                          ('Microsoft.Network/virtualNetworks') are supported. If the specified VNet
                          has any associated Network Security Groups (NSG), then a few reserved system
                          ports must be enabled for inbound communication. For Pools created with a
                          virtual machine configuration, enable ports 29876 and 29877, as well as port
                          22 for Linux and port 3389 for Windows. Also enable outbound connections to
                          Azure Storage on port 443. For more details see:
                          https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration.
                    },
                    "resizeErrors": [
                        {
                            "code": "str",  # Optional. An identifier for the Pool resize
                              error. Codes are invariant and are intended to be consumed
                              programmatically.
                            "message": "str",  # Optional. A message describing the Pool
                              resize error, intended to be suitable for display in a user interface.
                            "values": [
                                {
                                    "name": "str",  # Optional. The name in the
                                      name-value pair.
                                    "value": "str"  # Optional. The value in the
                                      name-value pair.
                                }
                            ]
                        }
                    ],
                    "resizeTimeout": "1 day, 0:00:00",  # Optional. The timeout for allocation of
                      Compute Nodes to the Pool. This is the timeout for the most recent resize
                      operation. (The initial sizing when the Pool is created counts as a resize.) The
                      default value is 15 minutes.
                    "resourceTags": {
                        "str": "str"  # Optional. The user-specified tags associated with the
                          pool. The user-defined tags to be associated with the Azure Batch Pool. When
                          specified, these tags are propagated to the backing Azure resources
                          associated with the pool. This property can only be specified when the Batch
                          account was created with the poolAllocationMode property set to
                          'UserSubscription'.
                    },
                    "startTask": {
                        "commandLine": "str",  # The command line of the StartTask. The
                          command line does not run under a shell, and therefore cannot take advantage
                          of shell features such as environment variable expansion. If you want to take
                          advantage of such features, you should invoke the shell in the command line,
                          for example using "cmd /c MyCommand" in Windows or "/bin/sh -c MyCommand" in
                          Linux. If the command line refers to file paths, it should use a relative
                          path (relative to the Task working directory), or use the Batch provided
                          environment variable
                          (https://docs.microsoft.com/en-us/azure/batch/batch-compute-node-environment-variables).
                          Required.
                        "containerSettings": {
                            "imageName": "str",  # The Image to use to create the
                              container in which the Task will run. This is the full Image reference,
                              as would be specified to "docker pull". If no tag is provided as part of
                              the Image name, the tag ":latest" is used as a default. Required.
                            "containerRunOptions": "str",  # Optional. Additional options
                              to the container create command. These additional options are supplied as
                              arguments to the "docker create" command, in addition to those controlled
                              by the Batch Service.
                            "registry": {
                                "identityReference": {
                                    "resourceId": "str"  # Optional. The ARM
                                      resource id of the user assigned identity.
                                },
                                "password": "str",  # Optional. The password to log
                                  into the registry server.
                                "registryServer": "str",  # Optional. The registry
                                  URL. If omitted, the default is "docker.io".
                                "username": "str"  # Optional. The user name to log
                                  into the registry server.
                            },
                            "workingDirectory": "str"  # Optional. The location of the
                              container Task working directory. The default is 'taskWorkingDirectory'.
                              Known values are: "taskWorkingDirectory" and "containerImageDefault".
                        },
                        "environmentSettings": [
                            {
                                "name": "str",  # The name of the environment
                                  variable. Required.
                                "value": "str"  # Optional. The value of the
                                  environment variable.
                            }
                        ],
                        "maxTaskRetryCount": 0,  # Optional. The maximum number of times the
                          Task may be retried. The Batch service retries a Task if its exit code is
                          nonzero. Note that this value specifically controls the number of retries.
                          The Batch service will try the Task once, and may then retry up to this
                          limit. For example, if the maximum retry count is 3, Batch tries the Task up
                          to 4 times (one initial try and 3 retries). If the maximum retry count is 0,
                          the Batch service does not retry the Task. If the maximum retry count is -1,
                          the Batch service retries the Task without limit, however this is not
                          recommended for a start task or any task. The default value is 0 (no
                          retries).
                        "resourceFiles": [
                            {
                                "autoStorageContainerName": "str",  # Optional. The
                                  storage container name in the auto storage Account. The
                                  autoStorageContainerName, storageContainerUrl and httpUrl properties
                                  are mutually exclusive and one of them must be specified.
                                "blobPrefix": "str",  # Optional. The blob prefix to
                                  use when downloading blobs from an Azure Storage container. Only the
                                  blobs whose names begin with the specified prefix will be downloaded.
                                  The property is valid only when autoStorageContainerName or
                                  storageContainerUrl is used. This prefix can be a partial filename or
                                  a subdirectory. If a prefix is not specified, all the files in the
                                  container will be downloaded.
                                "fileMode": "str",  # Optional. The file permission
                                  mode attribute in octal format. This property applies only to files
                                  being downloaded to Linux Compute Nodes. It will be ignored if it is
                                  specified for a resourceFile which will be downloaded to a Windows
                                  Compute Node. If this property is not specified for a Linux Compute
                                  Node, then a default value of 0770 is applied to the file.
                                "filePath": "str",  # Optional. The location on the
                                  Compute Node to which to download the file(s), relative to the Task's
                                  working directory. If the httpUrl property is specified, the filePath
                                  is required and describes the path which the file will be downloaded
                                  to, including the filename. Otherwise, if the
                                  autoStorageContainerName or storageContainerUrl property is
                                  specified, filePath is optional and is the directory to download the
                                  files to. In the case where filePath is used as a directory, any
                                  directory structure already associated with the input data will be
                                  retained in full and appended to the specified filePath directory.
                                  The specified relative path cannot break out of the Task's working
                                  directory (for example by using '..').
                                "httpUrl": "str",  # Optional. The URL of the file to
                                  download. The autoStorageContainerName, storageContainerUrl and
                                  httpUrl properties are mutually exclusive and one of them must be
                                  specified. If the URL points to Azure Blob Storage, it must be
                                  readable from compute nodes. There are three ways to get such a URL
                                  for a blob in Azure storage: include a Shared Access Signature (SAS)
                                  granting read permissions on the blob, use a managed identity with
                                  read permission, or set the ACL for the blob or its container to
                                  allow public access.
                                "identityReference": {
                                    "resourceId": "str"  # Optional. The ARM
                                      resource id of the user assigned identity.
                                },
                                "storageContainerUrl": "str"  # Optional. The URL of
                                  the blob container within Azure Blob Storage. The
                                  autoStorageContainerName, storageContainerUrl and httpUrl properties
                                  are mutually exclusive and one of them must be specified. This URL
                                  must be readable and listable from compute nodes. There are three
                                  ways to get such a URL for a container in Azure storage: include a
                                  Shared Access Signature (SAS) granting read and list permissions on
                                  the container, use a managed identity with read and list permissions,
                                  or set the ACL for the container to allow public access.
                            }
                        ],
                        "userIdentity": {
                            "autoUser": {
                                "elevationLevel": "str",  # Optional. The elevation
                                  level of the auto user. The default value is nonAdmin. Known values
                                  are: "nonadmin" and "admin".
                                "scope": "str"  # Optional. The scope for the auto
                                  user. The default value is pool. If the pool is running Windows, a
                                  value of Task should be specified if stricter isolation between tasks
                                  is required, such as if the task mutates the registry in a way which
                                  could impact other tasks. Known values are: "task" and "pool".
                            },
                            "username": "str"  # Optional. The name of the user identity
                              under which the Task is run. The userName and autoUser properties are
                              mutually exclusive; you must specify one but not both.
                        },
                        "waitForSuccess": bool  # Optional. Whether the Batch service should
                          wait for the StartTask to complete successfully (that is, to exit with exit
                          code 0) before scheduling any Tasks on the Compute Node. If true and the
                          StartTask fails on a Node, the Batch service retries the StartTask up to its
                          maximum retry count (maxTaskRetryCount). If the Task has still not completed
                          successfully after all retries, then the Batch service marks the Node
                          unusable, and will not schedule Tasks to it. This condition can be detected
                          via the Compute Node state and failure info details. If false, the Batch
                          service will not wait for the StartTask to complete. In this case, other
                          Tasks can start executing on the Compute Node while the StartTask is still
                          running; and even if the StartTask fails, new Tasks will continue to be
                          scheduled on the Compute Node. The default is true.
                    },
                    "state": "str",  # Optional. The current state of the Pool. Known values are:
                      "active" and "deleting".
                    "stateTransitionTime": "2020-02-20 00:00:00",  # Optional. The time at which
                      the Pool entered its current state.
                    "stats": {
                        "lastUpdateTime": "2020-02-20 00:00:00",  # The time at which the
                          statistics were last updated. All statistics are limited to the range between
                          startTime and lastUpdateTime. Required.
                        "startTime": "2020-02-20 00:00:00",  # The start time of the time
                          range covered by the statistics. Required.
                        "url": "str",  # The URL for the statistics. Required.
                        "resourceStats": {
                            "avgCPUPercentage": 0.0,  # The average CPU usage across all
                              Compute Nodes in the Pool (percentage per node). Required.
                            "avgDiskGiB": 0.0,  # The average used disk space in GiB
                              across all Compute Nodes in the Pool. Required.
                            "avgMemoryGiB": 0.0,  # The average memory usage in GiB
                              across all Compute Nodes in the Pool. Required.
                            "diskReadGiB": 0.0,  # The total amount of data in GiB of
                              disk reads across all Compute Nodes in the Pool. Required.
                            "diskReadIOps": 0,  # The total number of disk read
                              operations across all Compute Nodes in the Pool. Required.
                            "diskWriteGiB": 0.0,  # The total amount of data in GiB of
                              disk writes across all Compute Nodes in the Pool. Required.
                            "diskWriteIOps": 0,  # The total number of disk write
                              operations across all Compute Nodes in the Pool. Required.
                            "lastUpdateTime": "2020-02-20 00:00:00",  # The time at which
                              the statistics were last updated. All statistics are limited to the range
                              between startTime and lastUpdateTime. Required.
                            "networkReadGiB": 0.0,  # The total amount of data in GiB of
                              network reads across all Compute Nodes in the Pool. Required.
                            "networkWriteGiB": 0.0,  # The total amount of data in GiB of
                              network writes across all Compute Nodes in the Pool. Required.
                            "peakDiskGiB": 0.0,  # The peak used disk space in GiB across
                              all Compute Nodes in the Pool. Required.
                            "peakMemoryGiB": 0.0,  # The peak memory usage in GiB across
                              all Compute Nodes in the Pool. Required.
                            "startTime": "2020-02-20 00:00:00"  # The start time of the
                              time range covered by the statistics. Required.
                        },
                        "usageStats": {
                            "dedicatedCoreTime": "1 day, 0:00:00",  # The aggregated
                              wall-clock time of the dedicated Compute Node cores being part of the
                              Pool. Required.
                            "lastUpdateTime": "2020-02-20 00:00:00",  # The time at which
                              the statistics were last updated. All statistics are limited to the range
                              between startTime and lastUpdateTime. Required.
                            "startTime": "2020-02-20 00:00:00"  # The start time of the
                              time range covered by the statistics. Required.
                        }
                    },
                    "targetDedicatedNodes": 0,  # Optional. The desired number of dedicated
                      Compute Nodes in the Pool.
                    "targetLowPriorityNodes": 0,  # Optional. The desired number of
                      Spot/Low-priority Compute Nodes in the Pool.
                    "targetNodeCommunicationMode": "str",  # Optional. The desired node
                      communication mode for the pool. If omitted, the default value is Default. Known
                      values are: "default", "classic", and "simplified".
                    "taskSchedulingPolicy": {
                        "nodeFillType": "str"  # How Tasks are distributed across Compute
                          Nodes in a Pool. If not specified, the default is spread. Required. Known
                          values are: "spread" and "pack".
                    },
                    "taskSlotsPerNode": 0,  # Optional. The number of task slots that can be used
                      to run concurrent tasks on a single compute node in the pool. The default value
                      is 1. The maximum value is the smaller of 4 times the number of cores of the
                      vmSize of the pool or 256.
                    "upgradePolicy": {
                        "mode": "str",  # Specifies the mode of an upgrade to virtual
                          machines in the scale set.:code:`<br />`:code:`<br />` Possible values
                          are::code:`<br />`:code:`<br />` **Manual** - You  control the application of
                          updates to virtual machines in the scale set. You do this by using the
                          manualUpgrade action.:code:`<br />`:code:`<br />` **Automatic** - All virtual
                          machines in the scale set are automatically updated at the same
                          time.:code:`<br />`:code:`<br />` **Rolling** - Scale set performs updates in
                          batches with an optional pause time in between. Required. Known values are:
                          "automatic", "manual", and "rolling".
                        "automaticOSUpgradePolicy": {
                            "disableAutomaticRollback": bool,  # Optional. Whether OS
                              image rollback feature should be disabled.
                            "enableAutomaticOSUpgrade": bool,  # Optional. Indicates
                              whether OS upgrades should automatically be applied to scale set
                              instances in a rolling fashion when a newer version of the OS image
                              becomes available. :code:`<br />`:code:`<br />` If this is set to true
                              for Windows based pools, `WindowsConfiguration.enableAutomaticUpdates
                              <https://learn.microsoft.com/en-us/rest/api/batchservice/pool/add?tabs=HTTP#windowsconfiguration>`_
                              cannot be set to true.
                            "osRollingUpgradeDeferral": bool,  # Optional. Defer OS
                              upgrades on the TVMs if they are running tasks.
                            "useRollingUpgradePolicy": bool  # Optional. Indicates
                              whether rolling upgrade policy should be used during Auto OS Upgrade.
                              Auto OS Upgrade will fallback to the default policy if no policy is
                              defined on the VMSS.
                        },
                        "rollingUpgradePolicy": {
                            "enableCrossZoneUpgrade": bool,  # Optional. Allow VMSS to
                              ignore AZ boundaries when constructing upgrade batches. Take into
                              consideration the Update Domain and maxBatchInstancePercent to determine
                              the batch size. This field is able to be set to true or false only when
                              using NodePlacementConfiguration as Zonal.
                            "maxBatchInstancePercent": 0,  # Optional. The maximum
                              percent of total virtual machine instances that will be upgraded
                              simultaneously by the rolling upgrade in one batch. As this is a maximum,
                              unhealthy instances in previous or future batches can cause the
                              percentage of instances in a batch to decrease to ensure higher
                              reliability. The value of this field should be between 5 and 100,
                              inclusive. If both maxBatchInstancePercent and
                              maxUnhealthyInstancePercent are assigned with value, the value of
                              maxBatchInstancePercent should not be more than
                              maxUnhealthyInstancePercent.
                            "maxUnhealthyInstancePercent": 0,  # Optional. The maximum
                              percentage of the total virtual machine instances in the scale set that
                              can be simultaneously unhealthy, either as a result of being upgraded, or
                              by being found in an unhealthy state by the virtual machine health checks
                              before the rolling upgrade aborts. This constraint will be checked prior
                              to starting any batch. The value of this field should be between 5 and
                              100, inclusive. If both maxBatchInstancePercent and
                              maxUnhealthyInstancePercent are assigned with value, the value of
                              maxBatchInstancePercent should not be more than
                              maxUnhealthyInstancePercent.
                            "maxUnhealthyUpgradedInstancePercent": 0,  # Optional. The
                              maximum percentage of upgraded virtual machine instances that can be
                              found to be in an unhealthy state. This check will happen after each
                              batch is upgraded. If this percentage is ever exceeded, the rolling
                              update aborts. The value of this field should be between 0 and 100,
                              inclusive.
                            "pauseTimeBetweenBatches": "1 day, 0:00:00",  # Optional. The
                              wait time between completing the update for all virtual machines in one
                              batch and starting the next batch. The time duration should be specified
                              in ISO 8601 format..
                            "prioritizeUnhealthyInstances": bool,  # Optional. Upgrade
                              all unhealthy instances in a scale set before any healthy instances.
                            "rollbackFailedInstancesOnPolicyBreach": bool  # Optional.
                              Rollback failed instances to previous model if the Rolling Upgrade policy
                              is violated.
                        }
                    },
                    "url": "str",  # Optional. The URL of the Pool.
                    "userAccounts": [
                        {
                            "name": "str",  # The name of the user Account. Names can
                              contain any Unicode characters up to a maximum length of 20. Required.
                            "password": "str",  # The password for the user Account.
                              Required.
                            "elevationLevel": "str",  # Optional. The elevation level of
                              the user Account. The default value is nonAdmin. Known values are:
                              "nonadmin" and "admin".
                            "linuxUserConfiguration": {
                                "gid": 0,  # Optional. The group ID for the user
                                  Account. The uid and gid properties must be specified together or not
                                  at all. If not specified the underlying operating system picks the
                                  gid.
                                "sshPrivateKey": "str",  # Optional. The SSH private
                                  key for the user Account. The private key must not be password
                                  protected. The private key is used to automatically configure
                                  asymmetric-key based authentication for SSH between Compute Nodes in
                                  a Linux Pool when the Pool's enableInterNodeCommunication property is
                                  true (it is ignored if enableInterNodeCommunication is false). It
                                  does this by placing the key pair into the user's .ssh directory. If
                                  not specified, password-less SSH is not configured between Compute
                                  Nodes (no modification of the user's .ssh directory is done).
                                "uid": 0  # Optional. The user ID of the user
                                  Account. The uid and gid properties must be specified together or not
                                  at all. If not specified the underlying operating system picks the
                                  uid.
                            },
                            "windowsUserConfiguration": {
                                "loginMode": "str"  # Optional. The login mode for
                                  the user. The default value for VirtualMachineConfiguration Pools is
                                  'batch'. Known values are: "batch" and "interactive".
                            }
                        }
                    ],
                    "virtualMachineConfiguration": {
                        "imageReference": {
                            "exactVersion": "str",  # Optional. The specific version of
                              the platform image or marketplace image used to create the node. This
                              read-only field differs from 'version' only if the value specified for
                              'version' when the pool was created was 'latest'.
                            "offer": "str",  # Optional. The offer type of the Azure
                              Virtual Machines Marketplace Image. For example, UbuntuServer or
                              WindowsServer.
                            "publisher": "str",  # Optional. The publisher of the Azure
                              Virtual Machines Marketplace Image. For example, Canonical or
                              MicrosoftWindowsServer.
                            "sku": "str",  # Optional. The SKU of the Azure Virtual
                              Machines Marketplace Image. For example, 18.04-LTS or 2019-Datacenter.
                            "version": "str",  # Optional. The version of the Azure
                              Virtual Machines Marketplace Image. A value of 'latest' can be specified
                              to select the latest version of an Image. If omitted, the default is
                              'latest'.
                            "virtualMachineImageId": "str"  # Optional. The ARM resource
                              identifier of the Azure Compute Gallery Image. Compute Nodes in the Pool
                              will be created using this Image Id. This is of the form
                              /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/galleries/{galleryName}/images/{imageDefinitionName}/versions/{VersionId}
                              or
                              /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/galleries/{galleryName}/images/{imageDefinitionName}
                              for always defaulting to the latest image version. This property is
                              mutually exclusive with other ImageReference properties. The Azure
                              Compute Gallery Image must have replicas in the same region and must be
                              in the same subscription as the Azure Batch account. If the image version
                              is not specified in the imageId, the latest version will be used. For
                              information about the firewall settings for the Batch Compute Node agent
                              to communicate with the Batch service see
                              https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration.
                        },
                        "nodeAgentSKUId": "str",  # The SKU of the Batch Compute Node agent
                          to be provisioned on Compute Nodes in the Pool. The Batch Compute Node agent
                          is a program that runs on each Compute Node in the Pool, and provides the
                          command-and-control interface between the Compute Node and the Batch service.
                          There are different implementations of the Compute Node agent, known as SKUs,
                          for different operating systems. You must specify a Compute Node agent SKU
                          which matches the selected Image reference. To get the list of supported
                          Compute Node agent SKUs along with their list of verified Image references,
                          see the 'List supported Compute Node agent SKUs' operation. Required.
                        "containerConfiguration": {
                            "type": "str",  # The container technology to be used.
                              Required. Known values are: "dockerCompatible" and "criCompatible".
                            "containerImageNames": [
                                "str"  # Optional. The collection of container Image
                                  names. This is the full Image reference, as would be specified to
                                  "docker pull". An Image will be sourced from the default Docker
                                  registry unless the Image is fully qualified with an alternative
                                  registry.
                            ],
                            "containerRegistries": [
                                {
                                    "identityReference": {
                                        "resourceId": "str"  # Optional. The
                                          ARM resource id of the user assigned identity.
                                    },
                                    "password": "str",  # Optional. The password
                                      to log into the registry server.
                                    "registryServer": "str",  # Optional. The
                                      registry URL. If omitted, the default is "docker.io".
                                    "username": "str"  # Optional. The user name
                                      to log into the registry server.
                                }
                            ]
                        },
                        "dataDisks": [
                            {
                                "diskSizeGB": 0,  # The initial disk size in
                                  gigabytes. Required.
                                "lun": 0,  # The logical unit number. The
                                  logicalUnitNumber is used to uniquely identify each data disk. If
                                  attaching multiple disks, each should have a distinct
                                  logicalUnitNumber. The value must be between 0 and 63, inclusive.
                                  Required.
                                "caching": "str",  # Optional. The type of caching to
                                  be enabled for the data disks. The default value for caching is
                                  readwrite. For information about the caching options see:
                                  https://blogs.msdn.microsoft.com/windowsazurestorage/2012/06/27/exploring-windows-azure-drives-disks-and-images/.
                                  Known values are: "none", "readonly", and "readwrite".
                                "storageAccountType": "str"  # Optional. The storage
                                  Account type to be used for the data disk. If omitted, the default is
                                  "standard_lrs". Known values are: "standard_lrs", "premium_lrs", and
                                  "standardssd_lrs".
                            }
                        ],
                        "diskEncryptionConfiguration": {
                            "targets": [
                                "str"  # Optional. The list of disk targets Batch
                                  Service will encrypt on the compute node. If omitted, no disks on the
                                  compute nodes in the pool will be encrypted. On Linux pool, only
                                  "TemporaryDisk" is supported; on Windows pool, "OsDisk" and
                                  "TemporaryDisk" must be specified.
                            ]
                        },
                        "extensions": [
                            {
                                "name": "str",  # The name of the virtual machine
                                  extension. Required.
                                "publisher": "str",  # The name of the extension
                                  handler publisher. Required.
                                "type": "str",  # The type of the extension.
                                  Required.
                                "autoUpgradeMinorVersion": bool,  # Optional.
                                  Indicates whether the extension should use a newer minor version if
                                  one is available at deployment time. Once deployed, however, the
                                  extension will not upgrade minor versions unless redeployed, even
                                  with this property set to true.
                                "enableAutomaticUpgrade": bool,  # Optional.
                                  Indicates whether the extension should be automatically upgraded by
                                  the platform if there is a newer version of the extension available.
                                "protectedSettings": {
                                    "str": "str"  # Optional. The extension can
                                      contain either protectedSettings or protectedSettingsFromKeyVault
                                      or no protected settings at all.
                                },
                                "provisionAfterExtensions": [
                                    "str"  # Optional. The collection of
                                      extension names. Collection of extension names after which this
                                      extension needs to be provisioned.
                                ],
                                "settings": {
                                    "str": "str"  # Optional. JSON formatted
                                      public settings for the extension.
                                },
                                "typeHandlerVersion": "str"  # Optional. The version
                                  of script handler.
                            }
                        ],
                        "licenseType": "str",  # Optional. This only applies to Images that
                          contain the Windows operating system, and should only be used when you hold
                          valid on-premises licenses for the Compute Nodes which will be deployed. If
                          omitted, no on-premises licensing discount is applied. Values are:
                          Windows_Server - The on-premises license is for Windows Server.
                          Windows_Client - The on-premises license is for Windows Client.
                        "nodePlacementConfiguration": {
                            "policy": "str"  # Optional. Node placement Policy type on
                              Batch Pools. Allocation policy used by Batch Service to provision the
                              nodes. If not specified, Batch will use the regional policy. Known values
                              are: "regional" and "zonal".
                        },
                        "osDisk": {
                            "caching": "str",  # Optional. Specifies the caching
                              requirements. Possible values are: None, ReadOnly, ReadWrite. The default
                              values are: None for Standard storage. ReadOnly for Premium storage.
                              Known values are: "none", "readonly", and "readwrite".
                            "diskSizeGB": 0,  # Optional. The initial disk size in GB
                              when creating new OS disk.
                            "ephemeralOSDiskSettings": {
                                "placement": "str"  # Optional. Specifies the
                                  ephemeral disk placement for operating system disk for all VMs in the
                                  pool. This property can be used by user in the request to choose the
                                  location e.g., cache disk space for Ephemeral OS disk provisioning.
                                  For more information on Ephemeral OS disk size requirements, please
                                  refer to Ephemeral OS disk size requirements for Windows VMs at
                                  https://docs.microsoft.com/en-us/azure/virtual-machines/windows/ephemeral-os-disks#size-requirements
                                  and Linux VMs at
                                  https://docs.microsoft.com/en-us/azure/virtual-machines/linux/ephemeral-os-disks#size-requirements.
                                  "cachedisk"
                            },
                            "managedDisk": {
                                "storageAccountType": "str"  # The storage account
                                  type for managed disk. Required. Known values are: "standard_lrs",
                                  "premium_lrs", and "standardssd_lrs".
                            },
                            "writeAcceleratorEnabled": bool  # Optional. Specifies
                              whether writeAccelerator should be enabled or disabled on the disk.
                        },
                        "securityProfile": {
                            "encryptionAtHost": bool,  # This property can be used by
                              user in the request to enable or disable the Host Encryption for the
                              virtual machine or virtual machine scale set. This will enable the
                              encryption for all the disks including Resource/Temp disk at host itself.
                              Required.
                            "securityType": "str",  # Specifies the SecurityType of the
                              virtual machine. It has to be set to any specified value to enable
                              UefiSettings. Required. "trustedLaunch"
                            "uefiSettings": {
                                "secureBootEnabled": bool,  # Optional. Specifies
                                  whether secure boot should be enabled on the virtual machine.
                                "vTpmEnabled": bool  # Optional. Specifies whether
                                  vTPM should be enabled on the virtual machine.
                            }
                        },
                        "serviceArtifactReference": {
                            "id": "str"  # The service artifact reference id of
                              ServiceArtifactReference. The service artifact reference id in the form
                              of
                              /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/galleries/{galleryName}/serviceArtifacts/{serviceArtifactName}/vmArtifactsProfiles/{vmArtifactsProfilesName}.
                              Required.
                        },
                        "windowsConfiguration": {
                            "enableAutomaticUpdates": bool  # Optional. Whether automatic
                              updates are enabled on the virtual machine. If omitted, the default value
                              is true.
                        }
                    },
                    "vmSize": "str"  # Optional. The size of virtual machines in the Pool. All
                      virtual machines in a Pool are the same size. For information about available
                      sizes of virtual machines in Pools, see Choose a VM size for Compute Nodes in an
                      Azure Batch Pool (https://docs.microsoft.com/azure/batch/batch-pool-vm-sizes).
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.BatchPool]] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_batch_list_pools_request(
                    time_out_in_seconds=time_out_in_seconds,
                    ocpdate=ocpdate,
                    maxresults=maxresults,
                    filter=filter,
                    select=select,
                    expand=expand,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.BatchPool], deserialized["value"])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("odata.nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                if _stream:
                    response.read()  # Load the body in memory and close the socket
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _deserialize(_models.BatchError, response.json())
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def delete_pool(  # pylint: disable=inconsistent-return-statements
        self,
        pool_id: str,
        *,
        time_out_in_seconds: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        if_modified_since: Optional[datetime.datetime] = None,
        if_unmodified_since: Optional[datetime.datetime] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> None:
        """Deletes a Pool from the specified Account.

        When you request that a Pool be deleted, the following actions occur: the Pool
        state is set to deleting; any ongoing resize operation on the Pool are stopped;
        the Batch service starts resizing the Pool to zero Compute Nodes; any Tasks
        running on existing Compute Nodes are terminated and requeued (as if a resize
        Pool operation had been requested with the default requeue option); finally,
        the Pool is removed from the system. Because running Tasks are requeued, the
        user can rerun these Tasks by updating their Job to target a different Pool.
        The Tasks can then run on the new Pool. If you want to override the requeue
        behavior, then you should call resize Pool explicitly to shrink the Pool to
        zero size before deleting the Pool. If you call an Update, Patch or Delete API
        on a Pool in the deleting state, it will fail with HTTP status code 409 with
        error code PoolBeingDeleted.

        :param pool_id: The ID of the Pool to get. Required.
        :type pool_id: str
        :keyword time_out_in_seconds: The maximum time that the server can spend processing the
         request, in seconds. The default is 30 seconds. If the value is larger than 30, the default
         will be used instead.". Default value is None.
        :paramtype time_out_in_seconds: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword if_modified_since: A timestamp indicating the last modified time of the resource known
         to the
         client. The operation will be performed only if the resource on the service has
         been modified since the specified time. Default value is None.
        :paramtype if_modified_since: ~datetime.datetime
        :keyword if_unmodified_since: A timestamp indicating the last modified time of the resource
         known to the
         client. The operation will be performed only if the resource on the service has
         not been modified since the specified time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_batch_delete_pool_request(
            pool_id=pool_id,
            time_out_in_seconds=time_out_in_seconds,
            ocpdate=ocpdate,
            if_modified_since=if_modified_since,
            if_unmodified_since=if_unmodified_since,
            etag=etag,
            match_condition=match_condition,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.BatchError, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def pool_exists(
        self,
        pool_id: str,
        *,
        time_out_in_seconds: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        if_modified_since: Optional[datetime.datetime] = None,
        if_unmodified_since: Optional[datetime.datetime] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> bool:
        """Gets basic properties of a Pool.

        :param pool_id: The ID of the Pool to get. Required.
        :type pool_id: str
        :keyword time_out_in_seconds: The maximum time that the server can spend processing the
         request, in seconds. The default is 30 seconds. If the value is larger than 30, the default
         will be used instead.". Default value is None.
        :paramtype time_out_in_seconds: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword if_modified_since: A timestamp indicating the last modified time of the resource known
         to the
         client. The operation will be performed only if the resource on the service has
         been modified since the specified time. Default value is None.
        :paramtype if_modified_since: ~datetime.datetime
        :keyword if_unmodified_since: A timestamp indicating the last modified time of the resource
         known to the
         client. The operation will be performed only if the resource on the service has
         not been modified since the specified time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: bool
        :rtype: bool
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_batch_pool_exists_request(
            pool_id=pool_id,
            time_out_in_seconds=time_out_in_seconds,
            ocpdate=ocpdate,
            if_modified_since=if_modified_since,
            if_unmodified_since=if_unmodified_since,
            etag=etag,
            match_condition=match_condition,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 404]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.BatchError, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        if response.status_code == 200:
            response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
            response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
            response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
            response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore
        return 200 <= response.status_code <= 299

    @distributed_trace
    def get_pool(
        self,
        pool_id: str,
        *,
        time_out_in_seconds: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        if_modified_since: Optional[datetime.datetime] = None,
        if_unmodified_since: Optional[datetime.datetime] = None,
        select: Optional[List[str]] = None,
        expand: Optional[List[str]] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models.BatchPool:
        # pylint: disable=line-too-long
        """Gets information about the specified Pool.

        :param pool_id: The ID of the Pool to get. Required.
        :type pool_id: str
        :keyword time_out_in_seconds: The maximum time that the server can spend processing the
         request, in seconds. The default is 30 seconds. If the value is larger than 30, the default
         will be used instead.". Default value is None.
        :paramtype time_out_in_seconds: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword if_modified_since: A timestamp indicating the last modified time of the resource known
         to the
         client. The operation will be performed only if the resource on the service has
         been modified since the specified time. Default value is None.
        :paramtype if_modified_since: ~datetime.datetime
        :keyword if_unmodified_since: A timestamp indicating the last modified time of the resource
         known to the
         client. The operation will be performed only if the resource on the service has
         not been modified since the specified time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword select: An OData $select clause. Default value is None.
        :paramtype select: list[str]
        :keyword expand: An OData $expand clause. Default value is None.
        :paramtype expand: list[str]
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: BatchPool. The BatchPool is compatible with MutableMapping
        :rtype: ~azure.batch.models.BatchPool
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "allocationState": "str",  # Optional. Whether the Pool is resizing. Known
                      values are: "steady", "resizing", and "stopping".
                    "allocationStateTransitionTime": "2020-02-20 00:00:00",  # Optional. The time
                      at which the Pool entered its current allocation state.
                    "applicationPackageReferences": [
                        {
                            "applicationId": "str",  # The ID of the application to
                              deploy. When creating a pool, the package's application ID must be fully
                              qualified
                              (/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/applications/{applicationName}).
                              Required.
                            "version": "str"  # Optional. The version of the application
                              to deploy. If omitted, the default version is deployed. If this is
                              omitted on a Pool, and no default version is specified for this
                              application, the request fails with the error code
                              InvalidApplicationPackageReferences and HTTP status code 409. If this is
                              omitted on a Task, and no default version is specified for this
                              application, the Task fails with a pre-processing error.
                        }
                    ],
                    "autoScaleEvaluationInterval": "1 day, 0:00:00",  # Optional. The time
                      interval at which to automatically adjust the Pool size according to the
                      autoscale formula. This property is set only if the Pool automatically scales,
                      i.e. enableAutoScale is true.
                    "autoScaleFormula": "str",  # Optional. A formula for the desired number of
                      Compute Nodes in the Pool. This property is set only if the Pool automatically
                      scales, i.e. enableAutoScale is true.
                    "autoScaleRun": {
                        "timestamp": "2020-02-20 00:00:00",  # The time at which the
                          autoscale formula was last evaluated. Required.
                        "error": {
                            "code": "str",  # Optional. An identifier for the autoscale
                              error. Codes are invariant and are intended to be consumed
                              programmatically.
                            "message": "str",  # Optional. A message describing the
                              autoscale error, intended to be suitable for display in a user interface.
                            "values": [
                                {
                                    "name": "str",  # Optional. The name in the
                                      name-value pair.
                                    "value": "str"  # Optional. The value in the
                                      name-value pair.
                                }
                            ]
                        },
                        "results": "str"  # Optional. The final values of all variables used
                          in the evaluation of the autoscale formula. Each variable value is returned
                          in the form $variable=value, and variables are separated by semicolons.
                    },
                    "creationTime": "2020-02-20 00:00:00",  # Optional. The creation time of the
                      Pool.
                    "currentDedicatedNodes": 0,  # Optional. The number of dedicated Compute
                      Nodes currently in the Pool.
                    "currentLowPriorityNodes": 0,  # Optional. The number of Spot/Low-priority
                      Compute Nodes currently in the Pool. Spot/Low-priority Compute Nodes which have
                      been preempted are included in this count.
                    "currentNodeCommunicationMode": "str",  # Optional. The current state of the
                      pool communication mode. Known values are: "default", "classic", and
                      "simplified".
                    "displayName": "str",  # Optional. The display name for the Pool. The display
                      name need not be unique and can contain any Unicode characters up to a maximum
                      length of 1024.
                    "eTag": "str",  # Optional. The ETag of the Pool. This is an opaque string.
                      You can use it to detect whether the Pool has changed between requests. In
                      particular, you can be pass the ETag when updating a Pool to specify that your
                      changes should take effect only if nobody else has modified the Pool in the
                      meantime.
                    "enableAutoScale": bool,  # Optional. Whether the Pool size should
                      automatically adjust over time. If false, at least one of targetDedicatedNodes
                      and targetLowPriorityNodes must be specified. If true, the autoScaleFormula
                      property is required and the Pool automatically resizes according to the formula.
                      The default value is false.
                    "enableInterNodeCommunication": bool,  # Optional. Whether the Pool permits
                      direct communication between Compute Nodes. This imposes restrictions on which
                      Compute Nodes can be assigned to the Pool. Specifying this value can reduce the
                      chance of the requested number of Compute Nodes to be allocated in the Pool.
                    "id": "str",  # Optional. A string that uniquely identifies the Pool within
                      the Account. The ID can contain any combination of alphanumeric characters
                      including hyphens and underscores, and cannot contain more than 64 characters.
                      The ID is case-preserving and case-insensitive (that is, you may not have two IDs
                      within an Account that differ only by case).
                    "identity": {
                        "type": "str",  # The identity of the Batch pool, if configured. The
                          list of user identities associated with the Batch pool. The user identity
                          dictionary key references will be ARM resource ids in the form:
                          '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
                          Required. Known values are: "UserAssigned" and "None".
                        "userAssignedIdentities": [
                            {
                                "resourceId": "str",  # The ARM resource id of the
                                  user assigned identity. Required.
                                "clientId": "str",  # Optional. The client id of the
                                  user assigned identity.
                                "principalId": "str"  # Optional. The principal id of
                                  the user assigned identity.
                            }
                        ]
                    },
                    "lastModified": "2020-02-20 00:00:00",  # Optional. The last modified time of
                      the Pool. This is the last time at which the Pool level data, such as the
                      targetDedicatedNodes or enableAutoscale settings, changed. It does not factor in
                      node-level changes such as a Compute Node changing state.
                    "metadata": [
                        {
                            "name": "str",  # The name of the metadata item. Required.
                            "value": "str"  # The value of the metadata item. Required.
                        }
                    ],
                    "mountConfiguration": [
                        {
                            "azureBlobFileSystemConfiguration": {
                                "accountName": "str",  # The Azure Storage Account
                                  name. Required.
                                "containerName": "str",  # The Azure Blob Storage
                                  Container name. Required.
                                "relativeMountPath": "str",  # The relative path on
                                  the compute node where the file system will be mounted. All file
                                  systems are mounted relative to the Batch mounts directory,
                                  accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
                                  Required.
                                "accountKey": "str",  # Optional. The Azure Storage
                                  Account key. This property is mutually exclusive with both sasKey and
                                  identity; exactly one must be specified.
                                "blobfuseOptions": "str",  # Optional. Additional
                                  command line options to pass to the mount command. These are 'net
                                  use' options in Windows and 'mount' options in Linux.
                                "identityReference": {
                                    "resourceId": "str"  # Optional. The ARM
                                      resource id of the user assigned identity.
                                },
                                "sasKey": "str"  # Optional. The Azure Storage SAS
                                  token. This property is mutually exclusive with both accountKey and
                                  identity; exactly one must be specified.
                            },
                            "azureFileShareConfiguration": {
                                "accountKey": "str",  # The Azure Storage account
                                  key. Required.
                                "accountName": "str",  # The Azure Storage account
                                  name. Required.
                                "azureFileUrl": "str",  # The Azure Files URL. This
                                  is of the form 'https://{account}.file.core.windows.net/'. Required.
                                "relativeMountPath": "str",  # The relative path on
                                  the compute node where the file system will be mounted. All file
                                  systems are mounted relative to the Batch mounts directory,
                                  accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
                                  Required.
                                "mountOptions": "str"  # Optional. Additional command
                                  line options to pass to the mount command. These are 'net use'
                                  options in Windows and 'mount' options in Linux.
                            },
                            "cifsMountConfiguration": {
                                "password": "str",  # The password to use for
                                  authentication against the CIFS file system. Required.
                                "relativeMountPath": "str",  # The relative path on
                                  the compute node where the file system will be mounted. All file
                                  systems are mounted relative to the Batch mounts directory,
                                  accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
                                  Required.
                                "source": "str",  # The URI of the file system to
                                  mount. Required.
                                "username": "str",  # The user to use for
                                  authentication against the CIFS file system. Required.
                                "mountOptions": "str"  # Optional. Additional command
                                  line options to pass to the mount command. These are 'net use'
                                  options in Windows and 'mount' options in Linux.
                            },
                            "nfsMountConfiguration": {
                                "relativeMountPath": "str",  # The relative path on
                                  the compute node where the file system will be mounted. All file
                                  systems are mounted relative to the Batch mounts directory,
                                  accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
                                  Required.
                                "source": "str",  # The URI of the file system to
                                  mount. Required.
                                "mountOptions": "str"  # Optional. Additional command
                                  line options to pass to the mount command. These are 'net use'
                                  options in Windows and 'mount' options in Linux.
                            }
                        }
                    ],
                    "networkConfiguration": {
                        "dynamicVNetAssignmentScope": "str",  # Optional. The scope of
                          dynamic vnet assignment. Known values are: "none" and "job".
                        "enableAcceleratedNetworking": bool,  # Optional. Whether this pool
                          should enable accelerated networking. Accelerated networking enables single
                          root I/O virtualization (SR-IOV) to a VM, which may lead to improved
                          networking performance. For more details, see:
                          https://learn.microsoft.com/azure/virtual-network/accelerated-networking-overview.
                        "endpointConfiguration": {
                            "inboundNATPools": [
                                {
                                    "backendPort": 0,  # The port number on the
                                      Compute Node. This must be unique within a Batch Pool. Acceptable
                                      values are between 1 and 65535 except for 22, 3389, 29876 and
                                      29877 as these are reserved. If any reserved values are provided
                                      the request fails with HTTP status code 400. Required.
                                    "frontendPortRangeEnd": 0,  # The last port
                                      number in the range of external ports that will be used to
                                      provide inbound access to the backendPort on individual Compute
                                      Nodes. Acceptable values range between 1 and 65534 except ports
                                      from 50000 to 55000 which are reserved by the Batch service. All
                                      ranges within a Pool must be distinct and cannot overlap. Each
                                      range must contain at least 40 ports. If any reserved or
                                      overlapping values are provided the request fails with HTTP
                                      status code 400. Required.
                                    "frontendPortRangeStart": 0,  # The first
                                      port number in the range of external ports that will be used to
                                      provide inbound access to the backendPort on individual Compute
                                      Nodes. Acceptable values range between 1 and 65534 except ports
                                      from 50000 to 55000 which are reserved. All ranges within a Pool
                                      must be distinct and cannot overlap. Each range must contain at
                                      least 40 ports. If any reserved or overlapping values are
                                      provided the request fails with HTTP status code 400. Required.
                                    "name": "str",  # The name of the endpoint.
                                      The name must be unique within a Batch Pool, can contain letters,
                                      numbers, underscores, periods, and hyphens. Names must start with
                                      a letter or number, must end with a letter, number, or
                                      underscore, and cannot exceed 77 characters.  If any invalid
                                      values are provided the request fails with HTTP status code 400.
                                      Required.
                                    "protocol": "str",  # The protocol of the
                                      endpoint. Required. Known values are: "tcp" and "udp".
                                    "networkSecurityGroupRules": [
                                        {
                                            "access": "str",  # The
                                              action that should be taken for a specified IP address,
                                              subnet range or tag. Required. Known values are: "allow"
                                              and "deny".
                                            "priority": 0,  # The
                                              priority for this rule. Priorities within a Pool must be
                                              unique and are evaluated in order of priority. The lower
                                              the number the higher the priority. For example, rules
                                              could be specified with order numbers of 150, 250, and
                                              350. The rule with the order number of 150 takes
                                              precedence over the rule that has an order of 250.
                                              Allowed priorities are 150 to 4096. If any reserved or
                                              duplicate values are provided the request fails with HTTP
                                              status code 400. Required.
                                            "sourceAddressPrefix": "str",
                                              # The source address prefix or tag to match for the rule.
                                              Valid values are a single IP address (i.e. 10.10.10.10),
                                              IP subnet (i.e. 192.168.1.0/24), default tag, or * (for
                                              all addresses).  If any other values are provided the
                                              request fails with HTTP status code 400. Required.
                                            "sourcePortRanges": [
                                                "str"  # Optional.
                                                  The source port ranges to match for the rule. Valid
                                                  values are '"" *' (for all ports 0 - 65535), a
                                                  specific port (i.e. 22), or a port range (i.e.
                                                  100-200). The ports must be in the range of 0 to
                                                  65535. Each entry in this collection must not overlap
                                                  any other entry (either a range or an individual
                                                  port). If any other values are provided the request
                                                  fails with HTTP status code 400. The default value is
                                                  '*"" '.
                                            ]
                                        }
                                    ]
                                }
                            ]
                        },
                        "publicIPAddressConfiguration": {
                            "ipAddressIds": [
                                "str"  # Optional. The list of public IPs which the
                                  Batch service will use when provisioning Compute Nodes. The number of
                                  IPs specified here limits the maximum size of the Pool - 100
                                  dedicated nodes or 100 Spot/Low-priority nodes can be allocated for
                                  each public IP. For example, a pool needing 250 dedicated VMs would
                                  need at least 3 public IPs specified. Each element of this collection
                                  is of the form:
                                  /subscriptions/{subscription}/resourceGroups/{group}/providers/Microsoft.Network/publicIPAddresses/{ip}.
                            ],
                            "provision": "str"  # Optional. The provisioning type for
                              Public IP Addresses for the Pool. The default value is BatchManaged.
                              Known values are: "batchmanaged", "usermanaged", and
                              "nopublicipaddresses".
                        },
                        "subnetId": "str"  # Optional. The ARM resource identifier of the
                          virtual network subnet which the Compute Nodes of the Pool will join. This is
                          of the form
                          /subscriptions/{subscription}/resourceGroups/{group}/providers/{provider}/virtualNetworks/{network}/subnets/{subnet}.
                          The virtual network must be in the same region and subscription as the Azure
                          Batch Account. The specified subnet should have enough free IP addresses to
                          accommodate the number of Compute Nodes in the Pool. If the subnet doesn't
                          have enough free IP addresses, the Pool will partially allocate Nodes and a
                          resize error will occur. The 'MicrosoftAzureBatch' service principal must
                          have the 'Classic Virtual Machine Contributor' Role-Based Access Control
                          (RBAC) role for the specified VNet. The specified subnet must allow
                          communication from the Azure Batch service to be able to schedule Tasks on
                          the Nodes. This can be verified by checking if the specified VNet has any
                          associated Network Security Groups (NSG). If communication to the Nodes in
                          the specified subnet is denied by an NSG, then the Batch service will set the
                          state of the Compute Nodes to unusable. For Pools created with
                          virtualMachineConfiguration only ARM virtual networks
                          ('Microsoft.Network/virtualNetworks') are supported. If the specified VNet
                          has any associated Network Security Groups (NSG), then a few reserved system
                          ports must be enabled for inbound communication. For Pools created with a
                          virtual machine configuration, enable ports 29876 and 29877, as well as port
                          22 for Linux and port 3389 for Windows. Also enable outbound connections to
                          Azure Storage on port 443. For more details see:
                          https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration.
                    },
                    "resizeErrors": [
                        {
                            "code": "str",  # Optional. An identifier for the Pool resize
                              error. Codes are invariant and are intended to be consumed
                              programmatically.
                            "message": "str",  # Optional. A message describing the Pool
                              resize error, intended to be suitable for display in a user interface.
                            "values": [
                                {
                                    "name": "str",  # Optional. The name in the
                                      name-value pair.
                                    "value": "str"  # Optional. The value in the
                                      name-value pair.
                                }
                            ]
                        }
                    ],
                    "resizeTimeout": "1 day, 0:00:00",  # Optional. The timeout for allocation of
                      Compute Nodes to the Pool. This is the timeout for the most recent resize
                      operation. (The initial sizing when the Pool is created counts as a resize.) The
                      default value is 15 minutes.
                    "resourceTags": {
                        "str": "str"  # Optional. The user-specified tags associated with the
                          pool. The user-defined tags to be associated with the Azure Batch Pool. When
                          specified, these tags are propagated to the backing Azure resources
                          associated with the pool. This property can only be specified when the Batch
                          account was created with the poolAllocationMode property set to
                          'UserSubscription'.
                    },
                    "startTask": {
                        "commandLine": "str",  # The command line of the StartTask. The
                          command line does not run under a shell, and therefore cannot take advantage
                          of shell features such as environment variable expansion. If you want to take
                          advantage of such features, you should invoke the shell in the command line,
                          for example using "cmd /c MyCommand" in Windows or "/bin/sh -c MyCommand" in
                          Linux. If the command line refers to file paths, it should use a relative
                          path (relative to the Task working directory), or use the Batch provided
                          environment variable
                          (https://docs.microsoft.com/en-us/azure/batch/batch-compute-node-environment-variables).
                          Required.
                        "containerSettings": {
                            "imageName": "str",  # The Image to use to create the
                              container in which the Task will run. This is the full Image reference,
                              as would be specified to "docker pull". If no tag is provided as part of
                              the Image name, the tag ":latest" is used as a default. Required.
                            "containerRunOptions": "str",  # Optional. Additional options
                              to the container create command. These additional options are supplied as
                              arguments to the "docker create" command, in addition to those controlled
                              by the Batch Service.
                            "registry": {
                                "identityReference": {
                                    "resourceId": "str"  # Optional. The ARM
                                      resource id of the user assigned identity.
                                },
                                "password": "str",  # Optional. The password to log
                                  into the registry server.
                                "registryServer": "str",  # Optional. The registry
                                  URL. If omitted, the default is "docker.io".
                                "username": "str"  # Optional. The user name to log
                                  into the registry server.
                            },
                            "workingDirectory": "str"  # Optional. The location of the
                              container Task working directory. The default is 'taskWorkingDirectory'.
                              Known values are: "taskWorkingDirectory" and "containerImageDefault".
                        },
                        "environmentSettings": [
                            {
                                "name": "str",  # The name of the environment
                                  variable. Required.
                                "value": "str"  # Optional. The value of the
                                  environment variable.
                            }
                        ],
                        "maxTaskRetryCount": 0,  # Optional. The maximum number of times the
                          Task may be retried. The Batch service retries a Task if its exit code is
                          nonzero. Note that this value specifically controls the number of retries.
                          The Batch service will try the Task once, and may then retry up to this
                          limit. For example, if the maximum retry count is 3, Batch tries the Task up
                          to 4 times (one initial try and 3 retries). If the maximum retry count is 0,
                          the Batch service does not retry the Task. If the maximum retry count is -1,
                          the Batch service retries the Task without limit, however this is not
                          recommended for a start task or any task. The default value is 0 (no
                          retries).
                        "resourceFiles": [
                            {
                                "autoStorageContainerName": "str",  # Optional. The
                                  storage container name in the auto storage Account. The
                                  autoStorageContainerName, storageContainerUrl and httpUrl properties
                                  are mutually exclusive and one of them must be specified.
                                "blobPrefix": "str",  # Optional. The blob prefix to
                                  use when downloading blobs from an Azure Storage container. Only the
                                  blobs whose names begin with the specified prefix will be downloaded.
                                  The property is valid only when autoStorageContainerName or
                                  storageContainerUrl is used. This prefix can be a partial filename or
                                  a subdirectory. If a prefix is not specified, all the files in the
                                  container will be downloaded.
                                "fileMode": "str",  # Optional. The file permission
                                  mode attribute in octal format. This property applies only to files
                                  being downloaded to Linux Compute Nodes. It will be ignored if it is
                                  specified for a resourceFile which will be downloaded to a Windows
                                  Compute Node. If this property is not specified for a Linux Compute
                                  Node, then a default value of 0770 is applied to the file.
                                "filePath": "str",  # Optional. The location on the
                                  Compute Node to which to download the file(s), relative to the Task's
                                  working directory. If the httpUrl property is specified, the filePath
                                  is required and describes the path which the file will be downloaded
                                  to, including the filename. Otherwise, if the
                                  autoStorageContainerName or storageContainerUrl property is
                                  specified, filePath is optional and is the directory to download the
                                  files to. In the case where filePath is used as a directory, any
                                  directory structure already associated with the input data will be
                                  retained in full and appended to the specified filePath directory.
                                  The specified relative path cannot break out of the Task's working
                                  directory (for example by using '..').
                                "httpUrl": "str",  # Optional. The URL of the file to
                                  download. The autoStorageContainerName, storageContainerUrl and
                                  httpUrl properties are mutually exclusive and one of them must be
                                  specified. If the URL points to Azure Blob Storage, it must be
                                  readable from compute nodes. There are three ways to get such a URL
                                  for a blob in Azure storage: include a Shared Access Signature (SAS)
                                  granting read permissions on the blob, use a managed identity with
                                  read permission, or set the ACL for the blob or its container to
                                  allow public access.
                                "identityReference": {
                                    "resourceId": "str"  # Optional. The ARM
                                      resource id of the user assigned identity.
                                },
                                "storageContainerUrl": "str"  # Optional. The URL of
                                  the blob container within Azure Blob Storage. The
                                  autoStorageContainerName, storageContainerUrl and httpUrl properties
                                  are mutually exclusive and one of them must be specified. This URL
                                  must be readable and listable from compute nodes. There are three
                                  ways to get such a URL for a container in Azure storage: include a
                                  Shared Access Signature (SAS) granting read and list permissions on
                                  the container, use a managed identity with read and list permissions,
                                  or set the ACL for the container to allow public access.
                            }
                        ],
                        "userIdentity": {
                            "autoUser": {
                                "elevationLevel": "str",  # Optional. The elevation
                                  level of the auto user. The default value is nonAdmin. Known values
                                  are: "nonadmin" and "admin".
                                "scope": "str"  # Optional. The scope for the auto
                                  user. The default value is pool. If the pool is running Windows, a
                                  value of Task should be specified if stricter isolation between tasks
                                  is required, such as if the task mutates the registry in a way which
                                  could impact other tasks. Known values are: "task" and "pool".
                            },
                            "username": "str"  # Optional. The name of the user identity
                              under which the Task is run. The userName and autoUser properties are
                              mutually exclusive; you must specify one but not both.
                        },
                        "waitForSuccess": bool  # Optional. Whether the Batch service should
                          wait for the StartTask to complete successfully (that is, to exit with exit
                          code 0) before scheduling any Tasks on the Compute Node. If true and the
                          StartTask fails on a Node, the Batch service retries the StartTask up to its
                          maximum retry count (maxTaskRetryCount). If the Task has still not completed
                          successfully after all retries, then the Batch service marks the Node
                          unusable, and will not schedule Tasks to it. This condition can be detected
                          via the Compute Node state and failure info details. If false, the Batch
                          service will not wait for the StartTask to complete. In this case, other
                          Tasks can start executing on the Compute Node while the StartTask is still
                          running; and even if the StartTask fails, new Tasks will continue to be
                          scheduled on the Compute Node. The default is true.
                    },
                    "state": "str",  # Optional. The current state of the Pool. Known values are:
                      "active" and "deleting".
                    "stateTransitionTime": "2020-02-20 00:00:00",  # Optional. The time at which
                      the Pool entered its current state.
                    "stats": {
                        "lastUpdateTime": "2020-02-20 00:00:00",  # The time at which the
                          statistics were last updated. All statistics are limited to the range between
                          startTime and lastUpdateTime. Required.
                        "startTime": "2020-02-20 00:00:00",  # The start time of the time
                          range covered by the statistics. Required.
                        "url": "str",  # The URL for the statistics. Required.
                        "resourceStats": {
                            "avgCPUPercentage": 0.0,  # The average CPU usage across all
                              Compute Nodes in the Pool (percentage per node). Required.
                            "avgDiskGiB": 0.0,  # The average used disk space in GiB
                              across all Compute Nodes in the Pool. Required.
                            "avgMemoryGiB": 0.0,  # The average memory usage in GiB
                              across all Compute Nodes in the Pool. Required.
                            "diskReadGiB": 0.0,  # The total amount of data in GiB of
                              disk reads across all Compute Nodes in the Pool. Required.
                            "diskReadIOps": 0,  # The total number of disk read
                              operations across all Compute Nodes in the Pool. Required.
                            "diskWriteGiB": 0.0,  # The total amount of data in GiB of
                              disk writes across all Compute Nodes in the Pool. Required.
                            "diskWriteIOps": 0,  # The total number of disk write
                              operations across all Compute Nodes in the Pool. Required.
                            "lastUpdateTime": "2020-02-20 00:00:00",  # The time at which
                              the statistics were last updated. All statistics are limited to the range
                              between startTime and lastUpdateTime. Required.
                            "networkReadGiB": 0.0,  # The total amount of data in GiB of
                              network reads across all Compute Nodes in the Pool. Required.
                            "networkWriteGiB": 0.0,  # The total amount of data in GiB of
                              network writes across all Compute Nodes in the Pool. Required.
                            "peakDiskGiB": 0.0,  # The peak used disk space in GiB across
                              all Compute Nodes in the Pool. Required.
                            "peakMemoryGiB": 0.0,  # The peak memory usage in GiB across
                              all Compute Nodes in the Pool. Required.
                            "startTime": "2020-02-20 00:00:00"  # The start time of the
                              time range covered by the statistics. Required.
                        },
                        "usageStats": {
                            "dedicatedCoreTime": "1 day, 0:00:00",  # The aggregated
                              wall-clock time of the dedicated Compute Node cores being part of the
                              Pool. Required.
                            "lastUpdateTime": "2020-02-20 00:00:00",  # The time at which
                              the statistics were last updated. All statistics are limited to the range
                              between startTime and lastUpdateTime. Required.
                            "startTime": "2020-02-20 00:00:00"  # The start time of the
                              time range covered by the statistics. Required.
                        }
                    },
                    "targetDedicatedNodes": 0,  # Optional. The desired number of dedicated
                      Compute Nodes in the Pool.
                    "targetLowPriorityNodes": 0,  # Optional. The desired number of
                      Spot/Low-priority Compute Nodes in the Pool.
                    "targetNodeCommunicationMode": "str",  # Optional. The desired node
                      communication mode for the pool. If omitted, the default value is Default. Known
                      values are: "default", "classic", and "simplified".
                    "taskSchedulingPolicy": {
                        "nodeFillType": "str"  # How Tasks are distributed across Compute
                          Nodes in a Pool. If not specified, the default is spread. Required. Known
                          values are: "spread" and "pack".
                    },
                    "taskSlotsPerNode": 0,  # Optional. The number of task slots that can be used
                      to run concurrent tasks on a single compute node in the pool. The default value
                      is 1. The maximum value is the smaller of 4 times the number of cores of the
                      vmSize of the pool or 256.
                    "upgradePolicy": {
                        "mode": "str",  # Specifies the mode of an upgrade to virtual
                          machines in the scale set.:code:`<br />`:code:`<br />` Possible values
                          are::code:`<br />`:code:`<br />` **Manual** - You  control the application of
                          updates to virtual machines in the scale set. You do this by using the
                          manualUpgrade action.:code:`<br />`:code:`<br />` **Automatic** - All virtual
                          machines in the scale set are automatically updated at the same
                          time.:code:`<br />`:code:`<br />` **Rolling** - Scale set performs updates in
                          batches with an optional pause time in between. Required. Known values are:
                          "automatic", "manual", and "rolling".
                        "automaticOSUpgradePolicy": {
                            "disableAutomaticRollback": bool,  # Optional. Whether OS
                              image rollback feature should be disabled.
                            "enableAutomaticOSUpgrade": bool,  # Optional. Indicates
                              whether OS upgrades should automatically be applied to scale set
                              instances in a rolling fashion when a newer version of the OS image
                              becomes available. :code:`<br />`:code:`<br />` If this is set to true
                              for Windows based pools, `WindowsConfiguration.enableAutomaticUpdates
                              <https://learn.microsoft.com/en-us/rest/api/batchservice/pool/add?tabs=HTTP#windowsconfiguration>`_
                              cannot be set to true.
                            "osRollingUpgradeDeferral": bool,  # Optional. Defer OS
                              upgrades on the TVMs if they are running tasks.
                            "useRollingUpgradePolicy": bool  # Optional. Indicates
                              whether rolling upgrade policy should be used during Auto OS Upgrade.
                              Auto OS Upgrade will fallback to the default policy if no policy is
                              defined on the VMSS.
                        },
                        "rollingUpgradePolicy": {
                            "enableCrossZoneUpgrade": bool,  # Optional. Allow VMSS to
                              ignore AZ boundaries when constructing upgrade batches. Take into
                              consideration the Update Domain and maxBatchInstancePercent to determine
                              the batch size. This field is able to be set to true or false only when
                              using NodePlacementConfiguration as Zonal.
                            "maxBatchInstancePercent": 0,  # Optional. The maximum
                              percent of total virtual machine instances that will be upgraded
                              simultaneously by the rolling upgrade in one batch. As this is a maximum,
                              unhealthy instances in previous or future batches can cause the
                              percentage of instances in a batch to decrease to ensure higher
                              reliability. The value of this field should be between 5 and 100,
                              inclusive. If both maxBatchInstancePercent and
                              maxUnhealthyInstancePercent are assigned with value, the value of
                              maxBatchInstancePercent should not be more than
                              maxUnhealthyInstancePercent.
                            "maxUnhealthyInstancePercent": 0,  # Optional. The maximum
                              percentage of the total virtual machine instances in the scale set that
                              can be simultaneously unhealthy, either as a result of being upgraded, or
                              by being found in an unhealthy state by the virtual machine health checks
                              before the rolling upgrade aborts. This constraint will be checked prior
                              to starting any batch. The value of this field should be between 5 and
                              100, inclusive. If both maxBatchInstancePercent and
                              maxUnhealthyInstancePercent are assigned with value, the value of
                              maxBatchInstancePercent should not be more than
                              maxUnhealthyInstancePercent.
                            "maxUnhealthyUpgradedInstancePercent": 0,  # Optional. The
                              maximum percentage of upgraded virtual machine instances that can be
                              found to be in an unhealthy state. This check will happen after each
                              batch is upgraded. If this percentage is ever exceeded, the rolling
                              update aborts. The value of this field should be between 0 and 100,
                              inclusive.
                            "pauseTimeBetweenBatches": "1 day, 0:00:00",  # Optional. The
                              wait time between completing the update for all virtual machines in one
                              batch and starting the next batch. The time duration should be specified
                              in ISO 8601 format..
                            "prioritizeUnhealthyInstances": bool,  # Optional. Upgrade
                              all unhealthy instances in a scale set before any healthy instances.
                            "rollbackFailedInstancesOnPolicyBreach": bool  # Optional.
                              Rollback failed instances to previous model if the Rolling Upgrade policy
                              is violated.
                        }
                    },
                    "url": "str",  # Optional. The URL of the Pool.
                    "userAccounts": [
                        {
                            "name": "str",  # The name of the user Account. Names can
                              contain any Unicode characters up to a maximum length of 20. Required.
                            "password": "str",  # The password for the user Account.
                              Required.
                            "elevationLevel": "str",  # Optional. The elevation level of
                              the user Account. The default value is nonAdmin. Known values are:
                              "nonadmin" and "admin".
                            "linuxUserConfiguration": {
                                "gid": 0,  # Optional. The group ID for the user
                                  Account. The uid and gid properties must be specified together or not
                                  at all. If not specified the underlying operating system picks the
                                  gid.
                                "sshPrivateKey": "str",  # Optional. The SSH private
                                  key for the user Account. The private key must not be password
                                  protected. The private key is used to automatically configure
                                  asymmetric-key based authentication for SSH between Compute Nodes in
                                  a Linux Pool when the Pool's enableInterNodeCommunication property is
                                  true (it is ignored if enableInterNodeCommunication is false). It
                                  does this by placing the key pair into the user's .ssh directory. If
                                  not specified, password-less SSH is not configured between Compute
                                  Nodes (no modification of the user's .ssh directory is done).
                                "uid": 0  # Optional. The user ID of the user
                                  Account. The uid and gid properties must be specified together or not
                                  at all. If not specified the underlying operating system picks the
                                  uid.
                            },
                            "windowsUserConfiguration": {
                                "loginMode": "str"  # Optional. The login mode for
                                  the user. The default value for VirtualMachineConfiguration Pools is
                                  'batch'. Known values are: "batch" and "interactive".
                            }
                        }
                    ],
                    "virtualMachineConfiguration": {
                        "imageReference": {
                            "exactVersion": "str",  # Optional. The specific version of
                              the platform image or marketplace image used to create the node. This
                              read-only field differs from 'version' only if the value specified for
                              'version' when the pool was created was 'latest'.
                            "offer": "str",  # Optional. The offer type of the Azure
                              Virtual Machines Marketplace Image. For example, UbuntuServer or
                              WindowsServer.
                            "publisher": "str",  # Optional. The publisher of the Azure
                              Virtual Machines Marketplace Image. For example, Canonical or
                              MicrosoftWindowsServer.
                            "sku": "str",  # Optional. The SKU of the Azure Virtual
                              Machines Marketplace Image. For example, 18.04-LTS or 2019-Datacenter.
                            "version": "str",  # Optional. The version of the Azure
                              Virtual Machines Marketplace Image. A value of 'latest' can be specified
                              to select the latest version of an Image. If omitted, the default is
                              'latest'.
                            "virtualMachineImageId": "str"  # Optional. The ARM resource
                              identifier of the Azure Compute Gallery Image. Compute Nodes in the Pool
                              will be created using this Image Id. This is of the form
                              /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/galleries/{galleryName}/images/{imageDefinitionName}/versions/{VersionId}
                              or
                              /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/galleries/{galleryName}/images/{imageDefinitionName}
                              for always defaulting to the latest image version. This property is
                              mutually exclusive with other ImageReference properties. The Azure
                              Compute Gallery Image must have replicas in the same region and must be
                              in the same subscription as the Azure Batch account. If the image version
                              is not specified in the imageId, the latest version will be used. For
                              information about the firewall settings for the Batch Compute Node agent
                              to communicate with the Batch service see
                              https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration.
                        },
                        "nodeAgentSKUId": "str",  # The SKU of the Batch Compute Node agent
                          to be provisioned on Compute Nodes in the Pool. The Batch Compute Node agent
                          is a program that runs on each Compute Node in the Pool, and provides the
                          command-and-control interface between the Compute Node and the Batch service.
                          There are different implementations of the Compute Node agent, known as SKUs,
                          for different operating systems. You must specify a Compute Node agent SKU
                          which matches the selected Image reference. To get the list of supported
                          Compute Node agent SKUs along with their list of verified Image references,
                          see the 'List supported Compute Node agent SKUs' operation. Required.
                        "containerConfiguration": {
                            "type": "str",  # The container technology to be used.
                              Required. Known values are: "dockerCompatible" and "criCompatible".
                            "containerImageNames": [
                                "str"  # Optional. The collection of container Image
                                  names. This is the full Image reference, as would be specified to
                                  "docker pull". An Image will be sourced from the default Docker
                                  registry unless the Image is fully qualified with an alternative
                                  registry.
                            ],
                            "containerRegistries": [
                                {
                                    "identityReference": {
                                        "resourceId": "str"  # Optional. The
                                          ARM resource id of the user assigned identity.
                                    },
                                    "password": "str",  # Optional. The password
                                      to log into the registry server.
                                    "registryServer": "str",  # Optional. The
                                      registry URL. If omitted, the default is "docker.io".
                                    "username": "str"  # Optional. The user name
                                      to log into the registry server.
                                }
                            ]
                        },
                        "dataDisks": [
                            {
                                "diskSizeGB": 0,  # The initial disk size in
                                  gigabytes. Required.
                                "lun": 0,  # The logical unit number. The
                                  logicalUnitNumber is used to uniquely identify each data disk. If
                                  attaching multiple disks, each should have a distinct
                                  logicalUnitNumber. The value must be between 0 and 63, inclusive.
                                  Required.
                                "caching": "str",  # Optional. The type of caching to
                                  be enabled for the data disks. The default value for caching is
                                  readwrite. For information about the caching options see:
                                  https://blogs.msdn.microsoft.com/windowsazurestorage/2012/06/27/exploring-windows-azure-drives-disks-and-images/.
                                  Known values are: "none", "readonly", and "readwrite".
                                "storageAccountType": "str"  # Optional. The storage
                                  Account type to be used for the data disk. If omitted, the default is
                                  "standard_lrs". Known values are: "standard_lrs", "premium_lrs", and
                                  "standardssd_lrs".
                            }
                        ],
                        "diskEncryptionConfiguration": {
                            "targets": [
                                "str"  # Optional. The list of disk targets Batch
                                  Service will encrypt on the compute node. If omitted, no disks on the
                                  compute nodes in the pool will be encrypted. On Linux pool, only
                                  "TemporaryDisk" is supported; on Windows pool, "OsDisk" and
                                  "TemporaryDisk" must be specified.
                            ]
                        },
                        "extensions": [
                            {
                                "name": "str",  # The name of the virtual machine
                                  extension. Required.
                                "publisher": "str",  # The name of the extension
                                  handler publisher. Required.
                                "type": "str",  # The type of the extension.
                                  Required.
                                "autoUpgradeMinorVersion": bool,  # Optional.
                                  Indicates whether the extension should use a newer minor version if
                                  one is available at deployment time. Once deployed, however, the
                                  extension will not upgrade minor versions unless redeployed, even
                                  with this property set to true.
                                "enableAutomaticUpgrade": bool,  # Optional.
                                  Indicates whether the extension should be automatically upgraded by
                                  the platform if there is a newer version of the extension available.
                                "protectedSettings": {
                                    "str": "str"  # Optional. The extension can
                                      contain either protectedSettings or protectedSettingsFromKeyVault
                                      or no protected settings at all.
                                },
                                "provisionAfterExtensions": [
                                    "str"  # Optional. The collection of
                                      extension names. Collection of extension names after which this
                                      extension needs to be provisioned.
                                ],
                                "settings": {
                                    "str": "str"  # Optional. JSON formatted
                                      public settings for the extension.
                                },
                                "typeHandlerVersion": "str"  # Optional. The version
                                  of script handler.
                            }
                        ],
                        "licenseType": "str",  # Optional. This only applies to Images that
                          contain the Windows operating system, and should only be used when you hold
                          valid on-premises licenses for the Compute Nodes which will be deployed. If
                          omitted, no on-premises licensing discount is applied. Values are:
                          Windows_Server - The on-premises license is for Windows Server.
                          Windows_Client - The on-premises license is for Windows Client.
                        "nodePlacementConfiguration": {
                            "policy": "str"  # Optional. Node placement Policy type on
                              Batch Pools. Allocation policy used by Batch Service to provision the
                              nodes. If not specified, Batch will use the regional policy. Known values
                              are: "regional" and "zonal".
                        },
                        "osDisk": {
                            "caching": "str",  # Optional. Specifies the caching
                              requirements. Possible values are: None, ReadOnly, ReadWrite. The default
                              values are: None for Standard storage. ReadOnly for Premium storage.
                              Known values are: "none", "readonly", and "readwrite".
                            "diskSizeGB": 0,  # Optional. The initial disk size in GB
                              when creating new OS disk.
                            "ephemeralOSDiskSettings": {
                                "placement": "str"  # Optional. Specifies the
                                  ephemeral disk placement for operating system disk for all VMs in the
                                  pool. This property can be used by user in the request to choose the
                                  location e.g., cache disk space for Ephemeral OS disk provisioning.
                                  For more information on Ephemeral OS disk size requirements, please
                                  refer to Ephemeral OS disk size requirements for Windows VMs at
                                  https://docs.microsoft.com/en-us/azure/virtual-machines/windows/ephemeral-os-disks#size-requirements
                                  and Linux VMs at
                                  https://docs.microsoft.com/en-us/azure/virtual-machines/linux/ephemeral-os-disks#size-requirements.
                                  "cachedisk"
                            },
                            "managedDisk": {
                                "storageAccountType": "str"  # The storage account
                                  type for managed disk. Required. Known values are: "standard_lrs",
                                  "premium_lrs", and "standardssd_lrs".
                            },
                            "writeAcceleratorEnabled": bool  # Optional. Specifies
                              whether writeAccelerator should be enabled or disabled on the disk.
                        },
                        "securityProfile": {
                            "encryptionAtHost": bool,  # This property can be used by
                              user in the request to enable or disable the Host Encryption for the
                              virtual machine or virtual machine scale set. This will enable the
                              encryption for all the disks including Resource/Temp disk at host itself.
                              Required.
                            "securityType": "str",  # Specifies the SecurityType of the
                              virtual machine. It has to be set to any specified value to enable
                              UefiSettings. Required. "trustedLaunch"
                            "uefiSettings": {
                                "secureBootEnabled": bool,  # Optional. Specifies
                                  whether secure boot should be enabled on the virtual machine.
                                "vTpmEnabled": bool  # Optional. Specifies whether
                                  vTPM should be enabled on the virtual machine.
                            }
                        },
                        "serviceArtifactReference": {
                            "id": "str"  # The service artifact reference id of
                              ServiceArtifactReference. The service artifact reference id in the form
                              of
                              /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/galleries/{galleryName}/serviceArtifacts/{serviceArtifactName}/vmArtifactsProfiles/{vmArtifactsProfilesName}.
                              Required.
                        },
                        "windowsConfiguration": {
                            "enableAutomaticUpdates": bool  # Optional. Whether automatic
                              updates are enabled on the virtual machine. If omitted, the default value
                              is true.
                        }
                    },
                    "vmSize": "str"  # Optional. The size of virtual machines in the Pool. All
                      virtual machines in a Pool are the same size. For information about available
                      sizes of virtual machines in Pools, see Choose a VM size for Compute Nodes in an
                      Azure Batch Pool (https://docs.microsoft.com/azure/batch/batch-pool-vm-sizes).
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.BatchPool] = kwargs.pop("cls", None)

        _request = build_batch_get_pool_request(
            pool_id=pool_id,
            time_out_in_seconds=time_out_in_seconds,
            ocpdate=ocpdate,
            if_modified_since=if_modified_since,
            if_unmodified_since=if_unmodified_since,
            select=select,
            expand=expand,
            etag=etag,
            match_condition=match_condition,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.BatchError, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.BatchPool, response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def update_pool(  # pylint: disable=inconsistent-return-statements
        self,
        pool_id: str,
        pool: _models.BatchPoolUpdateContent,
        *,
        time_out_in_seconds: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        if_modified_since: Optional[datetime.datetime] = None,
        if_unmodified_since: Optional[datetime.datetime] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> None:
        # pylint: disable=line-too-long
        """Updates the properties of the specified Pool.

        This only replaces the Pool properties specified in the request. For example,
        if the Pool has a StartTask associated with it, and a request does not specify
        a StartTask element, then the Pool keeps the existing StartTask.

        :param pool_id: The ID of the Pool to get. Required.
        :type pool_id: str
        :param pool: The pool properties to update. Required.
        :type pool: ~azure.batch.models.BatchPoolUpdateContent
        :keyword time_out_in_seconds: The maximum time that the server can spend processing the
         request, in seconds. The default is 30 seconds. If the value is larger than 30, the default
         will be used instead.". Default value is None.
        :paramtype time_out_in_seconds: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword if_modified_since: A timestamp indicating the last modified time of the resource known
         to the
         client. The operation will be performed only if the resource on the service has
         been modified since the specified time. Default value is None.
        :paramtype if_modified_since: ~datetime.datetime
        :keyword if_unmodified_since: A timestamp indicating the last modified time of the resource
         known to the
         client. The operation will be performed only if the resource on the service has
         not been modified since the specified time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                pool = {
                    "applicationPackageReferences": [
                        {
                            "applicationId": "str",  # The ID of the application to
                              deploy. When creating a pool, the package's application ID must be fully
                              qualified
                              (/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/applications/{applicationName}).
                              Required.
                            "version": "str"  # Optional. The version of the application
                              to deploy. If omitted, the default version is deployed. If this is
                              omitted on a Pool, and no default version is specified for this
                              application, the request fails with the error code
                              InvalidApplicationPackageReferences and HTTP status code 409. If this is
                              omitted on a Task, and no default version is specified for this
                              application, the Task fails with a pre-processing error.
                        }
                    ],
                    "metadata": [
                        {
                            "name": "str",  # The name of the metadata item. Required.
                            "value": "str"  # The value of the metadata item. Required.
                        }
                    ],
                    "startTask": {
                        "commandLine": "str",  # The command line of the StartTask. The
                          command line does not run under a shell, and therefore cannot take advantage
                          of shell features such as environment variable expansion. If you want to take
                          advantage of such features, you should invoke the shell in the command line,
                          for example using "cmd /c MyCommand" in Windows or "/bin/sh -c MyCommand" in
                          Linux. If the command line refers to file paths, it should use a relative
                          path (relative to the Task working directory), or use the Batch provided
                          environment variable
                          (https://docs.microsoft.com/en-us/azure/batch/batch-compute-node-environment-variables).
                          Required.
                        "containerSettings": {
                            "imageName": "str",  # The Image to use to create the
                              container in which the Task will run. This is the full Image reference,
                              as would be specified to "docker pull". If no tag is provided as part of
                              the Image name, the tag ":latest" is used as a default. Required.
                            "containerRunOptions": "str",  # Optional. Additional options
                              to the container create command. These additional options are supplied as
                              arguments to the "docker create" command, in addition to those controlled
                              by the Batch Service.
                            "registry": {
                                "identityReference": {
                                    "resourceId": "str"  # Optional. The ARM
                                      resource id of the user assigned identity.
                                },
                                "password": "str",  # Optional. The password to log
                                  into the registry server.
                                "registryServer": "str",  # Optional. The registry
                                  URL. If omitted, the default is "docker.io".
                                "username": "str"  # Optional. The user name to log
                                  into the registry server.
                            },
                            "workingDirectory": "str"  # Optional. The location of the
                              container Task working directory. The default is 'taskWorkingDirectory'.
                              Known values are: "taskWorkingDirectory" and "containerImageDefault".
                        },
                        "environmentSettings": [
                            {
                                "name": "str",  # The name of the environment
                                  variable. Required.
                                "value": "str"  # Optional. The value of the
                                  environment variable.
                            }
                        ],
                        "maxTaskRetryCount": 0,  # Optional. The maximum number of times the
                          Task may be retried. The Batch service retries a Task if its exit code is
                          nonzero. Note that this value specifically controls the number of retries.
                          The Batch service will try the Task once, and may then retry up to this
                          limit. For example, if the maximum retry count is 3, Batch tries the Task up
                          to 4 times (one initial try and 3 retries). If the maximum retry count is 0,
                          the Batch service does not retry the Task. If the maximum retry count is -1,
                          the Batch service retries the Task without limit, however this is not
                          recommended for a start task or any task. The default value is 0 (no
                          retries).
                        "resourceFiles": [
                            {
                                "autoStorageContainerName": "str",  # Optional. The
                                  storage container name in the auto storage Account. The
                                  autoStorageContainerName, storageContainerUrl and httpUrl properties
                                  are mutually exclusive and one of them must be specified.
                                "blobPrefix": "str",  # Optional. The blob prefix to
                                  use when downloading blobs from an Azure Storage container. Only the
                                  blobs whose names begin with the specified prefix will be downloaded.
                                  The property is valid only when autoStorageContainerName or
                                  storageContainerUrl is used. This prefix can be a partial filename or
                                  a subdirectory. If a prefix is not specified, all the files in the
                                  container will be downloaded.
                                "fileMode": "str",  # Optional. The file permission
                                  mode attribute in octal format. This property applies only to files
                                  being downloaded to Linux Compute Nodes. It will be ignored if it is
                                  specified for a resourceFile which will be downloaded to a Windows
                                  Compute Node. If this property is not specified for a Linux Compute
                                  Node, then a default value of 0770 is applied to the file.
                                "filePath": "str",  # Optional. The location on the
                                  Compute Node to which to download the file(s), relative to the Task's
                                  working directory. If the httpUrl property is specified, the filePath
                                  is required and describes the path which the file will be downloaded
                                  to, including the filename. Otherwise, if the
                                  autoStorageContainerName or storageContainerUrl property is
                                  specified, filePath is optional and is the directory to download the
                                  files to. In the case where filePath is used as a directory, any
                                  directory structure already associated with the input data will be
                                  retained in full and appended to the specified filePath directory.
                                  The specified relative path cannot break out of the Task's working
                                  directory (for example by using '..').
                                "httpUrl": "str",  # Optional. The URL of the file to
                                  download. The autoStorageContainerName, storageContainerUrl and
                                  httpUrl properties are mutually exclusive and one of them must be
                                  specified. If the URL points to Azure Blob Storage, it must be
                                  readable from compute nodes. There are three ways to get such a URL
                                  for a blob in Azure storage: include a Shared Access Signature (SAS)
                                  granting read permissions on the blob, use a managed identity with
                                  read permission, or set the ACL for the blob or its container to
                                  allow public access.
                                "identityReference": {
                                    "resourceId": "str"  # Optional. The ARM
                                      resource id of the user assigned identity.
                                },
                                "storageContainerUrl": "str"  # Optional. The URL of
                                  the blob container within Azure Blob Storage. The
                                  autoStorageContainerName, storageContainerUrl and httpUrl properties
                                  are mutually exclusive and one of them must be specified. This URL
                                  must be readable and listable from compute nodes. There are three
                                  ways to get such a URL for a container in Azure storage: include a
                                  Shared Access Signature (SAS) granting read and list permissions on
                                  the container, use a managed identity with read and list permissions,
                                  or set the ACL for the container to allow public access.
                            }
                        ],
                        "userIdentity": {
                            "autoUser": {
                                "elevationLevel": "str",  # Optional. The elevation
                                  level of the auto user. The default value is nonAdmin. Known values
                                  are: "nonadmin" and "admin".
                                "scope": "str"  # Optional. The scope for the auto
                                  user. The default value is pool. If the pool is running Windows, a
                                  value of Task should be specified if stricter isolation between tasks
                                  is required, such as if the task mutates the registry in a way which
                                  could impact other tasks. Known values are: "task" and "pool".
                            },
                            "username": "str"  # Optional. The name of the user identity
                              under which the Task is run. The userName and autoUser properties are
                              mutually exclusive; you must specify one but not both.
                        },
                        "waitForSuccess": bool  # Optional. Whether the Batch service should
                          wait for the StartTask to complete successfully (that is, to exit with exit
                          code 0) before scheduling any Tasks on the Compute Node. If true and the
                          StartTask fails on a Node, the Batch service retries the StartTask up to its
                          maximum retry count (maxTaskRetryCount). If the Task has still not completed
                          successfully after all retries, then the Batch service marks the Node
                          unusable, and will not schedule Tasks to it. This condition can be detected
                          via the Compute Node state and failure info details. If false, the Batch
                          service will not wait for the StartTask to complete. In this case, other
                          Tasks can start executing on the Compute Node while the StartTask is still
                          running; and even if the StartTask fails, new Tasks will continue to be
                          scheduled on the Compute Node. The default is true.
                    },
                    "targetNodeCommunicationMode": "str"  # Optional. The desired node
                      communication mode for the pool. If this element is present, it replaces the
                      existing targetNodeCommunicationMode configured on the Pool. If omitted, any
                      existing metadata is left unchanged. Known values are: "default", "classic", and
                      "simplified".
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: str = kwargs.pop(
            "content_type", _headers.pop("content-type", "application/json; odata=minimalmetadata")
        )
        cls: ClsType[None] = kwargs.pop("cls", None)

        _content = json.dumps(pool, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_batch_update_pool_request(
            pool_id=pool_id,
            time_out_in_seconds=time_out_in_seconds,
            ocpdate=ocpdate,
            if_modified_since=if_modified_since,
            if_unmodified_since=if_unmodified_since,
            etag=etag,
            match_condition=match_condition,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.BatchError, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["DataServiceId"] = self._deserialize("str", response.headers.get("DataServiceId"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def disable_pool_auto_scale(  # pylint: disable=inconsistent-return-statements
        self,
        pool_id: str,
        *,
        time_out_in_seconds: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """Disables automatic scaling for a Pool.

        Disables automatic scaling for a Pool.

        :param pool_id: The ID of the Pool on which to disable automatic scaling. Required.
        :type pool_id: str
        :keyword time_out_in_seconds: The maximum time that the server can spend processing the
         request, in seconds. The default is 30 seconds. If the value is larger than 30, the default
         will be used instead.". Default value is None.
        :paramtype time_out_in_seconds: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_batch_disable_pool_auto_scale_request(
            pool_id=pool_id,
            time_out_in_seconds=time_out_in_seconds,
            ocpdate=ocpdate,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.BatchError, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["DataServiceId"] = self._deserialize("str", response.headers.get("DataServiceId"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def enable_pool_auto_scale(  # pylint: disable=inconsistent-return-statements
        self,
        pool_id: str,
        content: _models.BatchPoolEnableAutoScaleContent,
        *,
        time_out_in_seconds: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        if_modified_since: Optional[datetime.datetime] = None,
        if_unmodified_since: Optional[datetime.datetime] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> None:
        # pylint: disable=line-too-long
        """Enables automatic scaling for a Pool.

        You cannot enable automatic scaling on a Pool if a resize operation is in
        progress on the Pool. If automatic scaling of the Pool is currently disabled,
        you must specify a valid autoscale formula as part of the request. If automatic
        scaling of the Pool is already enabled, you may specify a new autoscale formula
        and/or a new evaluation interval. You cannot call this API for the same Pool
        more than once every 30 seconds.

        :param pool_id: The ID of the Pool to get. Required.
        :type pool_id: str
        :param content: The options to use for enabling automatic scaling. Required.
        :type content: ~azure.batch.models.BatchPoolEnableAutoScaleContent
        :keyword time_out_in_seconds: The maximum time that the server can spend processing the
         request, in seconds. The default is 30 seconds. If the value is larger than 30, the default
         will be used instead.". Default value is None.
        :paramtype time_out_in_seconds: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword if_modified_since: A timestamp indicating the last modified time of the resource known
         to the
         client. The operation will be performed only if the resource on the service has
         been modified since the specified time. Default value is None.
        :paramtype if_modified_since: ~datetime.datetime
        :keyword if_unmodified_since: A timestamp indicating the last modified time of the resource
         known to the
         client. The operation will be performed only if the resource on the service has
         not been modified since the specified time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                content = {
                    "autoScaleEvaluationInterval": "1 day, 0:00:00",  # Optional. The time
                      interval at which to automatically adjust the Pool size according to the
                      autoscale formula. The default value is 15 minutes. The minimum and maximum value
                      are 5 minutes and 168 hours respectively. If you specify a value less than 5
                      minutes or greater than 168 hours, the Batch service rejects the request with an
                      invalid property value error; if you are calling the REST API directly, the HTTP
                      status code is 400 (Bad Request). If you specify a new interval, then the
                      existing autoscale evaluation schedule will be stopped and a new autoscale
                      evaluation schedule will be started, with its starting time being the time when
                      this request was issued.
                    "autoScaleFormula": "str"  # Optional. The formula for the desired number of
                      Compute Nodes in the Pool. The formula is checked for validity before it is
                      applied to the Pool. If the formula is not valid, the Batch service rejects the
                      request with detailed error information. For more information about specifying
                      this formula, see Automatically scale Compute Nodes in an Azure Batch Pool
                      (https://azure.microsoft.com/en-us/documentation/articles/batch-automatic-scaling).
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: str = kwargs.pop(
            "content_type", _headers.pop("content-type", "application/json; odata=minimalmetadata")
        )
        cls: ClsType[None] = kwargs.pop("cls", None)

        _content = json.dumps(content, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_batch_enable_pool_auto_scale_request(
            pool_id=pool_id,
            time_out_in_seconds=time_out_in_seconds,
            ocpdate=ocpdate,
            if_modified_since=if_modified_since,
            if_unmodified_since=if_unmodified_since,
            etag=etag,
            match_condition=match_condition,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.BatchError, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["DataServiceId"] = self._deserialize("str", response.headers.get("DataServiceId"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def evaluate_pool_auto_scale(
        self,
        pool_id: str,
        content: _models.BatchPoolEvaluateAutoScaleContent,
        *,
        time_out_in_seconds: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> _models.AutoScaleRun:
        # pylint: disable=line-too-long
        """Gets the result of evaluating an automatic scaling formula on the Pool.

        This API is primarily for validating an autoscale formula, as it simply returns
        the result without applying the formula to the Pool. The Pool must have auto
        scaling enabled in order to evaluate a formula.

        :param pool_id: The ID of the Pool on which to evaluate the automatic scaling formula.
         Required.
        :type pool_id: str
        :param content: The options to use for evaluating the automatic scaling formula. Required.
        :type content: ~azure.batch.models.BatchPoolEvaluateAutoScaleContent
        :keyword time_out_in_seconds: The maximum time that the server can spend processing the
         request, in seconds. The default is 30 seconds. If the value is larger than 30, the default
         will be used instead.". Default value is None.
        :paramtype time_out_in_seconds: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :return: AutoScaleRun. The AutoScaleRun is compatible with MutableMapping
        :rtype: ~azure.batch.models.AutoScaleRun
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                content = {
                    "autoScaleFormula": "str"  # The formula for the desired number of Compute
                      Nodes in the Pool. The formula is validated and its results calculated, but it is
                      not applied to the Pool. To apply the formula to the Pool, 'Enable automatic
                      scaling on a Pool'. For more information about specifying this formula, see
                      Automatically scale Compute Nodes in an Azure Batch Pool
                      (https://azure.microsoft.com/en-us/documentation/articles/batch-automatic-scaling).
                      Required.
                }

                # response body for status code(s): 200
                response == {
                    "timestamp": "2020-02-20 00:00:00",  # The time at which the autoscale
                      formula was last evaluated. Required.
                    "error": {
                        "code": "str",  # Optional. An identifier for the autoscale error.
                          Codes are invariant and are intended to be consumed programmatically.
                        "message": "str",  # Optional. A message describing the autoscale
                          error, intended to be suitable for display in a user interface.
                        "values": [
                            {
                                "name": "str",  # Optional. The name in the
                                  name-value pair.
                                "value": "str"  # Optional. The value in the
                                  name-value pair.
                            }
                        ]
                    },
                    "results": "str"  # Optional. The final values of all variables used in the
                      evaluation of the autoscale formula. Each variable value is returned in the form
                      $variable=value, and variables are separated by semicolons.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: str = kwargs.pop(
            "content_type", _headers.pop("content-type", "application/json; odata=minimalmetadata")
        )
        cls: ClsType[_models.AutoScaleRun] = kwargs.pop("cls", None)

        _content = json.dumps(content, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_batch_evaluate_pool_auto_scale_request(
            pool_id=pool_id,
            time_out_in_seconds=time_out_in_seconds,
            ocpdate=ocpdate,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.BatchError, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["DataServiceId"] = self._deserialize("str", response.headers.get("DataServiceId"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AutoScaleRun, response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def resize_pool(  # pylint: disable=inconsistent-return-statements
        self,
        pool_id: str,
        content: _models.BatchPoolResizeContent,
        *,
        time_out_in_seconds: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        if_modified_since: Optional[datetime.datetime] = None,
        if_unmodified_since: Optional[datetime.datetime] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> None:
        # pylint: disable=line-too-long
        """Changes the number of Compute Nodes that are assigned to a Pool.

        You can only resize a Pool when its allocation state is steady. If the Pool is
        already resizing, the request fails with status code 409. When you resize a
        Pool, the Pool's allocation state changes from steady to resizing. You cannot
        resize Pools which are configured for automatic scaling. If you try to do this,
        the Batch service returns an error 409. If you resize a Pool downwards, the
        Batch service chooses which Compute Nodes to remove. To remove specific Compute
        Nodes, use the Pool remove Compute Nodes API instead.

        :param pool_id: The ID of the Pool to get. Required.
        :type pool_id: str
        :param content: The options to use for resizing the pool. Required.
        :type content: ~azure.batch.models.BatchPoolResizeContent
        :keyword time_out_in_seconds: The maximum time that the server can spend processing the
         request, in seconds. The default is 30 seconds. If the value is larger than 30, the default
         will be used instead.". Default value is None.
        :paramtype time_out_in_seconds: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword if_modified_since: A timestamp indicating the last modified time of the resource known
         to the
         client. The operation will be performed only if the resource on the service has
         been modified since the specified time. Default value is None.
        :paramtype if_modified_since: ~datetime.datetime
        :keyword if_unmodified_since: A timestamp indicating the last modified time of the resource
         known to the
         client. The operation will be performed only if the resource on the service has
         not been modified since the specified time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                content = {
                    "nodeDeallocationOption": "str",  # Optional. Determines what to do with a
                      Compute Node and its running task(s) if the Pool size is decreasing. The default
                      value is requeue. Known values are: "requeue", "terminate", "taskcompletion", and
                      "retaineddata".
                    "resizeTimeout": "1 day, 0:00:00",  # Optional. The timeout for allocation of
                      Nodes to the Pool or removal of Compute Nodes from the Pool. The default value is
                      15 minutes. The minimum value is 5 minutes. If you specify a value less than 5
                      minutes, the Batch service returns an error; if you are calling the REST API
                      directly, the HTTP status code is 400 (Bad Request).
                    "targetDedicatedNodes": 0,  # Optional. The desired number of dedicated
                      Compute Nodes in the Pool.
                    "targetLowPriorityNodes": 0  # Optional. The desired number of
                      Spot/Low-priority Compute Nodes in the Pool.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: str = kwargs.pop(
            "content_type", _headers.pop("content-type", "application/json; odata=minimalmetadata")
        )
        cls: ClsType[None] = kwargs.pop("cls", None)

        _content = json.dumps(content, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_batch_resize_pool_request(
            pool_id=pool_id,
            time_out_in_seconds=time_out_in_seconds,
            ocpdate=ocpdate,
            if_modified_since=if_modified_since,
            if_unmodified_since=if_unmodified_since,
            etag=etag,
            match_condition=match_condition,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.BatchError, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["DataServiceId"] = self._deserialize("str", response.headers.get("DataServiceId"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def stop_pool_resize(  # pylint: disable=inconsistent-return-statements
        self,
        pool_id: str,
        *,
        time_out_in_seconds: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        if_modified_since: Optional[datetime.datetime] = None,
        if_unmodified_since: Optional[datetime.datetime] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> None:
        """Stops an ongoing resize operation on the Pool.

        This does not restore the Pool to its previous state before the resize
        operation: it only stops any further changes being made, and the Pool maintains
        its current state. After stopping, the Pool stabilizes at the number of Compute
        Nodes it was at when the stop operation was done. During the stop operation,
        the Pool allocation state changes first to stopping and then to steady. A
        resize operation need not be an explicit resize Pool request; this API can also
        be used to halt the initial sizing of the Pool when it is created.

        :param pool_id: The ID of the Pool to get. Required.
        :type pool_id: str
        :keyword time_out_in_seconds: The maximum time that the server can spend processing the
         request, in seconds. The default is 30 seconds. If the value is larger than 30, the default
         will be used instead.". Default value is None.
        :paramtype time_out_in_seconds: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword if_modified_since: A timestamp indicating the last modified time of the resource known
         to the
         client. The operation will be performed only if the resource on the service has
         been modified since the specified time. Default value is None.
        :paramtype if_modified_since: ~datetime.datetime
        :keyword if_unmodified_since: A timestamp indicating the last modified time of the resource
         known to the
         client. The operation will be performed only if the resource on the service has
         not been modified since the specified time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_batch_stop_pool_resize_request(
            pool_id=pool_id,
            time_out_in_seconds=time_out_in_seconds,
            ocpdate=ocpdate,
            if_modified_since=if_modified_since,
            if_unmodified_since=if_unmodified_since,
            etag=etag,
            match_condition=match_condition,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.BatchError, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["DataServiceId"] = self._deserialize("str", response.headers.get("DataServiceId"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def replace_pool_properties(  # pylint: disable=inconsistent-return-statements
        self,
        pool_id: str,
        pool: _models.BatchPoolReplaceContent,
        *,
        time_out_in_seconds: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        # pylint: disable=line-too-long
        """Updates the properties of the specified Pool.

        This fully replaces all the updatable properties of the Pool. For example, if
        the Pool has a StartTask associated with it and if StartTask is not specified
        with this request, then the Batch service will remove the existing StartTask.

        :param pool_id: The ID of the Pool to update. Required.
        :type pool_id: str
        :param pool: The options to use for replacing properties on the pool. Required.
        :type pool: ~azure.batch.models.BatchPoolReplaceContent
        :keyword time_out_in_seconds: The maximum time that the server can spend processing the
         request, in seconds. The default is 30 seconds. If the value is larger than 30, the default
         will be used instead.". Default value is None.
        :paramtype time_out_in_seconds: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                pool = {
                    "applicationPackageReferences": [
                        {
                            "applicationId": "str",  # The ID of the application to
                              deploy. When creating a pool, the package's application ID must be fully
                              qualified
                              (/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/applications/{applicationName}).
                              Required.
                            "version": "str"  # Optional. The version of the application
                              to deploy. If omitted, the default version is deployed. If this is
                              omitted on a Pool, and no default version is specified for this
                              application, the request fails with the error code
                              InvalidApplicationPackageReferences and HTTP status code 409. If this is
                              omitted on a Task, and no default version is specified for this
                              application, the Task fails with a pre-processing error.
                        }
                    ],
                    "metadata": [
                        {
                            "name": "str",  # The name of the metadata item. Required.
                            "value": "str"  # The value of the metadata item. Required.
                        }
                    ],
                    "startTask": {
                        "commandLine": "str",  # The command line of the StartTask. The
                          command line does not run under a shell, and therefore cannot take advantage
                          of shell features such as environment variable expansion. If you want to take
                          advantage of such features, you should invoke the shell in the command line,
                          for example using "cmd /c MyCommand" in Windows or "/bin/sh -c MyCommand" in
                          Linux. If the command line refers to file paths, it should use a relative
                          path (relative to the Task working directory), or use the Batch provided
                          environment variable
                          (https://docs.microsoft.com/en-us/azure/batch/batch-compute-node-environment-variables).
                          Required.
                        "containerSettings": {
                            "imageName": "str",  # The Image to use to create the
                              container in which the Task will run. This is the full Image reference,
                              as would be specified to "docker pull". If no tag is provided as part of
                              the Image name, the tag ":latest" is used as a default. Required.
                            "containerRunOptions": "str",  # Optional. Additional options
                              to the container create command. These additional options are supplied as
                              arguments to the "docker create" command, in addition to those controlled
                              by the Batch Service.
                            "registry": {
                                "identityReference": {
                                    "resourceId": "str"  # Optional. The ARM
                                      resource id of the user assigned identity.
                                },
                                "password": "str",  # Optional. The password to log
                                  into the registry server.
                                "registryServer": "str",  # Optional. The registry
                                  URL. If omitted, the default is "docker.io".
                                "username": "str"  # Optional. The user name to log
                                  into the registry server.
                            },
                            "workingDirectory": "str"  # Optional. The location of the
                              container Task working directory. The default is 'taskWorkingDirectory'.
                              Known values are: "taskWorkingDirectory" and "containerImageDefault".
                        },
                        "environmentSettings": [
                            {
                                "name": "str",  # The name of the environment
                                  variable. Required.
                                "value": "str"  # Optional. The value of the
                                  environment variable.
                            }
                        ],
                        "maxTaskRetryCount": 0,  # Optional. The maximum number of times the
                          Task may be retried. The Batch service retries a Task if its exit code is
                          nonzero. Note that this value specifically controls the number of retries.
                          The Batch service will try the Task once, and may then retry up to this
                          limit. For example, if the maximum retry count is 3, Batch tries the Task up
                          to 4 times (one initial try and 3 retries). If the maximum retry count is 0,
                          the Batch service does not retry the Task. If the maximum retry count is -1,
                          the Batch service retries the Task without limit, however this is not
                          recommended for a start task or any task. The default value is 0 (no
                          retries).
                        "resourceFiles": [
                            {
                                "autoStorageContainerName": "str",  # Optional. The
                                  storage container name in the auto storage Account. The
                                  autoStorageContainerName, storageContainerUrl and httpUrl properties
                                  are mutually exclusive and one of them must be specified.
                                "blobPrefix": "str",  # Optional. The blob prefix to
                                  use when downloading blobs from an Azure Storage container. Only the
                                  blobs whose names begin with the specified prefix will be downloaded.
                                  The property is valid only when autoStorageContainerName or
                                  storageContainerUrl is used. This prefix can be a partial filename or
                                  a subdirectory. If a prefix is not specified, all the files in the
                                  container will be downloaded.
                                "fileMode": "str",  # Optional. The file permission
                                  mode attribute in octal format. This property applies only to files
                                  being downloaded to Linux Compute Nodes. It will be ignored if it is
                                  specified for a resourceFile which will be downloaded to a Windows
                                  Compute Node. If this property is not specified for a Linux Compute
                                  Node, then a default value of 0770 is applied to the file.
                                "filePath": "str",  # Optional. The location on the
                                  Compute Node to which to download the file(s), relative to the Task's
                                  working directory. If the httpUrl property is specified, the filePath
                                  is required and describes the path which the file will be downloaded
                                  to, including the filename. Otherwise, if the
                                  autoStorageContainerName or storageContainerUrl property is
                                  specified, filePath is optional and is the directory to download the
                                  files to. In the case where filePath is used as a directory, any
                                  directory structure already associated with the input data will be
                                  retained in full and appended to the specified filePath directory.
                                  The specified relative path cannot break out of the Task's working
                                  directory (for example by using '..').
                                "httpUrl": "str",  # Optional. The URL of the file to
                                  download. The autoStorageContainerName, storageContainerUrl and
                                  httpUrl properties are mutually exclusive and one of them must be
                                  specified. If the URL points to Azure Blob Storage, it must be
                                  readable from compute nodes. There are three ways to get such a URL
                                  for a blob in Azure storage: include a Shared Access Signature (SAS)
                                  granting read permissions on the blob, use a managed identity with
                                  read permission, or set the ACL for the blob or its container to
                                  allow public access.
                                "identityReference": {
                                    "resourceId": "str"  # Optional. The ARM
                                      resource id of the user assigned identity.
                                },
                                "storageContainerUrl": "str"  # Optional. The URL of
                                  the blob container within Azure Blob Storage. The
                                  autoStorageContainerName, storageContainerUrl and httpUrl properties
                                  are mutually exclusive and one of them must be specified. This URL
                                  must be readable and listable from compute nodes. There are three
                                  ways to get such a URL for a container in Azure storage: include a
                                  Shared Access Signature (SAS) granting read and list permissions on
                                  the container, use a managed identity with read and list permissions,
                                  or set the ACL for the container to allow public access.
                            }
                        ],
                        "userIdentity": {
                            "autoUser": {
                                "elevationLevel": "str",  # Optional. The elevation
                                  level of the auto user. The default value is nonAdmin. Known values
                                  are: "nonadmin" and "admin".
                                "scope": "str"  # Optional. The scope for the auto
                                  user. The default value is pool. If the pool is running Windows, a
                                  value of Task should be specified if stricter isolation between tasks
                                  is required, such as if the task mutates the registry in a way which
                                  could impact other tasks. Known values are: "task" and "pool".
                            },
                            "username": "str"  # Optional. The name of the user identity
                              under which the Task is run. The userName and autoUser properties are
                              mutually exclusive; you must specify one but not both.
                        },
                        "waitForSuccess": bool  # Optional. Whether the Batch service should
                          wait for the StartTask to complete successfully (that is, to exit with exit
                          code 0) before scheduling any Tasks on the Compute Node. If true and the
                          StartTask fails on a Node, the Batch service retries the StartTask up to its
                          maximum retry count (maxTaskRetryCount). If the Task has still not completed
                          successfully after all retries, then the Batch service marks the Node
                          unusable, and will not schedule Tasks to it. This condition can be detected
                          via the Compute Node state and failure info details. If false, the Batch
                          service will not wait for the StartTask to complete. In this case, other
                          Tasks can start executing on the Compute Node while the StartTask is still
                          running; and even if the StartTask fails, new Tasks will continue to be
                          scheduled on the Compute Node. The default is true.
                    },
                    "targetNodeCommunicationMode": "str"  # Optional. The desired node
                      communication mode for the pool. This setting replaces any existing
                      targetNodeCommunication setting on the Pool. If omitted, the existing setting is
                      default. Known values are: "default", "classic", and "simplified".
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: str = kwargs.pop(
            "content_type", _headers.pop("content-type", "application/json; odata=minimalmetadata")
        )
        cls: ClsType[None] = kwargs.pop("cls", None)

        _content = json.dumps(pool, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_batch_replace_pool_properties_request(
            pool_id=pool_id,
            time_out_in_seconds=time_out_in_seconds,
            ocpdate=ocpdate,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.BatchError, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["DataServiceId"] = self._deserialize("str", response.headers.get("DataServiceId"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def remove_nodes(  # pylint: disable=inconsistent-return-statements
        self,
        pool_id: str,
        content: _models.BatchNodeRemoveContent,
        *,
        time_out_in_seconds: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        if_modified_since: Optional[datetime.datetime] = None,
        if_unmodified_since: Optional[datetime.datetime] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> None:
        # pylint: disable=line-too-long
        """Removes Compute Nodes from the specified Pool.

        This operation can only run when the allocation state of the Pool is steady.
        When this operation runs, the allocation state changes from steady to resizing.
        Each request may remove up to 100 nodes.

        :param pool_id: The ID of the Pool to get. Required.
        :type pool_id: str
        :param content: The options to use for removing the node. Required.
        :type content: ~azure.batch.models.BatchNodeRemoveContent
        :keyword time_out_in_seconds: The maximum time that the server can spend processing the
         request, in seconds. The default is 30 seconds. If the value is larger than 30, the default
         will be used instead.". Default value is None.
        :paramtype time_out_in_seconds: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword if_modified_since: A timestamp indicating the last modified time of the resource known
         to the
         client. The operation will be performed only if the resource on the service has
         been modified since the specified time. Default value is None.
        :paramtype if_modified_since: ~datetime.datetime
        :keyword if_unmodified_since: A timestamp indicating the last modified time of the resource
         known to the
         client. The operation will be performed only if the resource on the service has
         not been modified since the specified time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                content = {
                    "nodeList": [
                        "str"  # A list containing the IDs of the Compute Nodes to be removed
                          from the specified Pool. A maximum of 100 nodes may be removed per request.
                          Required.
                    ],
                    "nodeDeallocationOption": "str",  # Optional. Determines what to do with a
                      Compute Node and its running task(s) after it has been selected for deallocation.
                      The default value is requeue. Known values are: "requeue", "terminate",
                      "taskcompletion", and "retaineddata".
                    "resizeTimeout": "1 day, 0:00:00"  # Optional. The timeout for removal of
                      Compute Nodes to the Pool. The default value is 15 minutes. The minimum value is
                      5 minutes. If you specify a value less than 5 minutes, the Batch service returns
                      an error; if you are calling the REST API directly, the HTTP status code is 400
                      (Bad Request).
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: str = kwargs.pop(
            "content_type", _headers.pop("content-type", "application/json; odata=minimalmetadata")
        )
        cls: ClsType[None] = kwargs.pop("cls", None)

        _content = json.dumps(content, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_batch_remove_nodes_request(
            pool_id=pool_id,
            time_out_in_seconds=time_out_in_seconds,
            ocpdate=ocpdate,
            if_modified_since=if_modified_since,
            if_unmodified_since=if_unmodified_since,
            etag=etag,
            match_condition=match_condition,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.BatchError, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["DataServiceId"] = self._deserialize("str", response.headers.get("DataServiceId"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def list_supported_images(
        self,
        *,
        time_out_in_seconds: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        maxresults: Optional[int] = None,
        filter: Optional[str] = None,
        **kwargs: Any
    ) -> Iterable["_models.BatchSupportedImage"]:
        # pylint: disable=line-too-long
        """Lists all Virtual Machine Images supported by the Azure Batch service.

        Lists all Virtual Machine Images supported by the Azure Batch service.

        :keyword time_out_in_seconds: The maximum time that the server can spend processing the
         request, in seconds. The default is 30 seconds. If the value is larger than 30, the default
         will be used instead.". Default value is None.
        :paramtype time_out_in_seconds: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword maxresults: The maximum number of items to return in the response. A maximum of 1000
         applications can be returned. Default value is None.
        :paramtype maxresults: int
        :keyword filter: An OData $filter clause. For more information on constructing this filter, see
        https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-support-images.
         Default value is None.
        :paramtype filter: str
        :return: An iterator like instance of BatchSupportedImage
        :rtype: ~azure.core.paging.ItemPaged[~azure.batch.models.BatchSupportedImage]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "imageReference": {
                        "exactVersion": "str",  # Optional. The specific version of the
                          platform image or marketplace image used to create the node. This read-only
                          field differs from 'version' only if the value specified for 'version' when
                          the pool was created was 'latest'.
                        "offer": "str",  # Optional. The offer type of the Azure Virtual
                          Machines Marketplace Image. For example, UbuntuServer or WindowsServer.
                        "publisher": "str",  # Optional. The publisher of the Azure Virtual
                          Machines Marketplace Image. For example, Canonical or MicrosoftWindowsServer.
                        "sku": "str",  # Optional. The SKU of the Azure Virtual Machines
                          Marketplace Image. For example, 18.04-LTS or 2019-Datacenter.
                        "version": "str",  # Optional. The version of the Azure Virtual
                          Machines Marketplace Image. A value of 'latest' can be specified to select
                          the latest version of an Image. If omitted, the default is 'latest'.
                        "virtualMachineImageId": "str"  # Optional. The ARM resource
                          identifier of the Azure Compute Gallery Image. Compute Nodes in the Pool will
                          be created using this Image Id. This is of the form
                          /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/galleries/{galleryName}/images/{imageDefinitionName}/versions/{VersionId}
                          or
                          /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/galleries/{galleryName}/images/{imageDefinitionName}
                          for always defaulting to the latest image version. This property is mutually
                          exclusive with other ImageReference properties. The Azure Compute Gallery
                          Image must have replicas in the same region and must be in the same
                          subscription as the Azure Batch account. If the image version is not
                          specified in the imageId, the latest version will be used. For information
                          about the firewall settings for the Batch Compute Node agent to communicate
                          with the Batch service see
                          https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration.
                    },
                    "nodeAgentSKUId": "str",  # The ID of the Compute Node agent SKU which the
                      Image supports. Required.
                    "osType": "str",  # The type of operating system (e.g. Windows or Linux) of
                      the Image. Required. Known values are: "linux" and "windows".
                    "verificationType": "str",  # Whether the Azure Batch service actively
                      verifies that the Image is compatible with the associated Compute Node agent SKU.
                      Required. Known values are: "verified" and "unverified".
                    "batchSupportEndOfLife": "2020-02-20 00:00:00",  # Optional. The time when
                      the Azure Batch service will stop accepting create Pool requests for the Image.
                    "capabilities": [
                        "str"  # Optional. The capabilities or features which the Image
                          supports. Not every capability of the Image is listed. Capabilities in this
                          list are considered of special interest and are generally related to
                          integration with other features in the Azure Batch service.
                    ]
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.BatchSupportedImage]] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_batch_list_supported_images_request(
                    time_out_in_seconds=time_out_in_seconds,
                    ocpdate=ocpdate,
                    maxresults=maxresults,
                    filter=filter,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.BatchSupportedImage], deserialized["value"])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("odata.nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                if _stream:
                    response.read()  # Load the body in memory and close the socket
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _deserialize(_models.BatchError, response.json())
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def list_pool_node_counts(
        self,
        *,
        time_out_in_seconds: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        maxresults: Optional[int] = None,
        filter: Optional[str] = None,
        **kwargs: Any
    ) -> Iterable["_models.BatchPoolNodeCounts"]:
        """Gets the number of Compute Nodes in each state, grouped by Pool. Note that the
        numbers returned may not always be up to date. If you need exact node counts,
        use a list query.

        :keyword time_out_in_seconds: The maximum time that the server can spend processing the
         request, in seconds. The default is 30 seconds. If the value is larger than 30, the default
         will be used instead.". Default value is None.
        :paramtype time_out_in_seconds: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword maxresults: The maximum number of items to return in the response. A maximum of 1000
         applications can be returned. Default value is None.
        :paramtype maxresults: int
        :keyword filter: An OData $filter clause. For more information on constructing this filter, see
        https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-support-images.
         Default value is None.
        :paramtype filter: str
        :return: An iterator like instance of BatchPoolNodeCounts
        :rtype: ~azure.core.paging.ItemPaged[~azure.batch.models.BatchPoolNodeCounts]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "poolId": "str",  # The ID of the Pool. Required.
                    "dedicated": {
                        "creating": 0,  # The number of Compute Nodes in the creating state.
                          Required.
                        "idle": 0,  # The number of Compute Nodes in the idle state.
                          Required.
                        "leavingPool": 0,  # The number of Compute Nodes in the leavingPool
                          state. Required.
                        "offline": 0,  # The number of Compute Nodes in the offline state.
                          Required.
                        "preempted": 0,  # The number of Compute Nodes in the preempted
                          state. Required.
                        "rebooting": 0,  # The count of Compute Nodes in the rebooting state.
                          Required.
                        "reimaging": 0,  # The number of Compute Nodes in the reimaging
                          state. Required.
                        "running": 0,  # The number of Compute Nodes in the running state.
                          Required.
                        "startTaskFailed": 0,  # The number of Compute Nodes in the
                          startTaskFailed state. Required.
                        "starting": 0,  # The number of Compute Nodes in the starting state.
                          Required.
                        "total": 0,  # The total number of Compute Nodes. Required.
                        "unknown": 0,  # The number of Compute Nodes in the unknown state.
                          Required.
                        "unusable": 0,  # The number of Compute Nodes in the unusable state.
                          Required.
                        "upgradingOS": 0,  # The number of Compute Nodes in the upgradingOS
                          state. Required.
                        "waitingForStartTask": 0  # The number of Compute Nodes in the
                          waitingForStartTask state. Required.
                    },
                    "lowPriority": {
                        "creating": 0,  # The number of Compute Nodes in the creating state.
                          Required.
                        "idle": 0,  # The number of Compute Nodes in the idle state.
                          Required.
                        "leavingPool": 0,  # The number of Compute Nodes in the leavingPool
                          state. Required.
                        "offline": 0,  # The number of Compute Nodes in the offline state.
                          Required.
                        "preempted": 0,  # The number of Compute Nodes in the preempted
                          state. Required.
                        "rebooting": 0,  # The count of Compute Nodes in the rebooting state.
                          Required.
                        "reimaging": 0,  # The number of Compute Nodes in the reimaging
                          state. Required.
                        "running": 0,  # The number of Compute Nodes in the running state.
                          Required.
                        "startTaskFailed": 0,  # The number of Compute Nodes in the
                          startTaskFailed state. Required.
                        "starting": 0,  # The number of Compute Nodes in the starting state.
                          Required.
                        "total": 0,  # The total number of Compute Nodes. Required.
                        "unknown": 0,  # The number of Compute Nodes in the unknown state.
                          Required.
                        "unusable": 0,  # The number of Compute Nodes in the unusable state.
                          Required.
                        "upgradingOS": 0,  # The number of Compute Nodes in the upgradingOS
                          state. Required.
                        "waitingForStartTask": 0  # The number of Compute Nodes in the
                          waitingForStartTask state. Required.
                    }
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.BatchPoolNodeCounts]] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_batch_list_pool_node_counts_request(
                    time_out_in_seconds=time_out_in_seconds,
                    ocpdate=ocpdate,
                    maxresults=maxresults,
                    filter=filter,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.BatchPoolNodeCounts], deserialized["value"])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("odata.nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                if _stream:
                    response.read()  # Load the body in memory and close the socket
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _deserialize(_models.BatchError, response.json())
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def delete_job(  # pylint: disable=inconsistent-return-statements
        self,
        job_id: str,
        *,
        time_out_in_seconds: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        if_modified_since: Optional[datetime.datetime] = None,
        if_unmodified_since: Optional[datetime.datetime] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> None:
        """Deletes a Job.

        Deleting a Job also deletes all Tasks that are part of that Job, and all Job
        statistics. This also overrides the retention period for Task data; that is, if
        the Job contains Tasks which are still retained on Compute Nodes, the Batch
        services deletes those Tasks' working directories and all their contents.  When
        a Delete Job request is received, the Batch service sets the Job to the
        deleting state. All update operations on a Job that is in deleting state will
        fail with status code 409 (Conflict), with additional information indicating
        that the Job is being deleted.

        :param job_id: The ID of the Job to delete. Required.
        :type job_id: str
        :keyword time_out_in_seconds: The maximum time that the server can spend processing the
         request, in seconds. The default is 30 seconds. If the value is larger than 30, the default
         will be used instead.". Default value is None.
        :paramtype time_out_in_seconds: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword if_modified_since: A timestamp indicating the last modified time of the resource known
         to the
         client. The operation will be performed only if the resource on the service has
         been modified since the specified time. Default value is None.
        :paramtype if_modified_since: ~datetime.datetime
        :keyword if_unmodified_since: A timestamp indicating the last modified time of the resource
         known to the
         client. The operation will be performed only if the resource on the service has
         not been modified since the specified time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_batch_delete_job_request(
            job_id=job_id,
            time_out_in_seconds=time_out_in_seconds,
            ocpdate=ocpdate,
            if_modified_since=if_modified_since,
            if_unmodified_since=if_unmodified_since,
            etag=etag,
            match_condition=match_condition,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.BatchError, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def get_job(
        self,
        job_id: str,
        *,
        time_out_in_seconds: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        if_modified_since: Optional[datetime.datetime] = None,
        if_unmodified_since: Optional[datetime.datetime] = None,
        select: Optional[List[str]] = None,
        expand: Optional[List[str]] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models.BatchJob:
        # pylint: disable=line-too-long
        """Gets information about the specified Job.

        Gets information about the specified Job.

        :param job_id: The ID of the Job. Required.
        :type job_id: str
        :keyword time_out_in_seconds: The maximum time that the server can spend processing the
         request, in seconds. The default is 30 seconds. If the value is larger than 30, the default
         will be used instead.". Default value is None.
        :paramtype time_out_in_seconds: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword if_modified_since: A timestamp indicating the last modified time of the resource known
         to the
         client. The operation will be performed only if the resource on the service has
         been modified since the specified time. Default value is None.
        :paramtype if_modified_since: ~datetime.datetime
        :keyword if_unmodified_since: A timestamp indicating the last modified time of the resource
         known to the
         client. The operation will be performed only if the resource on the service has
         not been modified since the specified time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword select: An OData $select clause. Default value is None.
        :paramtype select: list[str]
        :keyword expand: An OData $expand clause. Default value is None.
        :paramtype expand: list[str]
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: BatchJob. The BatchJob is compatible with MutableMapping
        :rtype: ~azure.batch.models.BatchJob
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "poolInfo": {
                        "autoPoolSpecification": {
                            "poolLifetimeOption": "str",  # The minimum lifetime of
                              created auto Pools, and how multiple Jobs on a schedule are assigned to
                              Pools. Required. Known values are: "jobschedule" and "job".
                            "autoPoolIdPrefix": "str",  # Optional. A prefix to be added
                              to the unique identifier when a Pool is automatically created. The Batch
                              service assigns each auto Pool a unique identifier on creation. To
                              distinguish between Pools created for different purposes, you can specify
                              this element to add a prefix to the ID that is assigned. The prefix can
                              be up to 20 characters long.
                            "keepAlive": bool,  # Optional. Whether to keep an auto Pool
                              alive after its lifetime expires. If false, the Batch service deletes the
                              Pool once its lifetime (as determined by the poolLifetimeOption setting)
                              expires; that is, when the Job or Job Schedule completes. If true, the
                              Batch service does not delete the Pool automatically. It is up to the
                              user to delete auto Pools created with this option.
                            "pool": {
                                "vmSize": "str",  # The size of the virtual machines
                                  in the Pool. All virtual machines in a Pool are the same size. For
                                  information about available sizes of virtual machines in Pools, see
                                  Choose a VM size for Compute Nodes in an Azure Batch Pool
                                  (https://docs.microsoft.com/azure/batch/batch-pool-vm-sizes).
                                  Required.
                                "applicationPackageReferences": [
                                    {
                                        "applicationId": "str",  # The ID of
                                          the application to deploy. When creating a pool, the
                                          package's application ID must be fully qualified
                                          (/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/applications/{applicationName}).
                                          Required.
                                        "version": "str"  # Optional. The
                                          version of the application to deploy. If omitted, the default
                                          version is deployed. If this is omitted on a Pool, and no
                                          default version is specified for this application, the
                                          request fails with the error code
                                          InvalidApplicationPackageReferences and HTTP status code 409.
                                          If this is omitted on a Task, and no default version is
                                          specified for this application, the Task fails with a
                                          pre-processing error.
                                    }
                                ],
                                "autoScaleEvaluationInterval": "1 day, 0:00:00",  #
                                  Optional. The time interval at which to automatically adjust the Pool
                                  size according to the autoscale formula. The default value is 15
                                  minutes. The minimum and maximum value are 5 minutes and 168 hours
                                  respectively. If you specify a value less than 5 minutes or greater
                                  than 168 hours, the Batch service rejects the request with an invalid
                                  property value error; if you are calling the REST API directly, the
                                  HTTP status code is 400 (Bad Request).
                                "autoScaleFormula": "str",  # Optional. The formula
                                  for the desired number of Compute Nodes in the Pool. This property
                                  must not be specified if enableAutoScale is set to false. It is
                                  required if enableAutoScale is set to true. The formula is checked
                                  for validity before the Pool is created. If the formula is not valid,
                                  the Batch service rejects the request with detailed error
                                  information.
                                "displayName": "str",  # Optional. The display name
                                  for the Pool. The display name need not be unique and can contain any
                                  Unicode characters up to a maximum length of 1024.
                                "enableAutoScale": bool,  # Optional. Whether the
                                  Pool size should automatically adjust over time. If false, at least
                                  one of targetDedicatedNodes and targetLowPriorityNodes must be
                                  specified. If true, the autoScaleFormula element is required. The
                                  Pool automatically resizes according to the formula. The default
                                  value is false.
                                "enableInterNodeCommunication": bool,  # Optional.
                                  Whether the Pool permits direct communication between Compute Nodes.
                                  Enabling inter-node communication limits the maximum size of the Pool
                                  due to deployment restrictions on the Compute Nodes of the Pool. This
                                  may result in the Pool not reaching its desired size. The default
                                  value is false.
                                "metadata": [
                                    {
                                        "name": "str",  # The name of the
                                          metadata item. Required.
                                        "value": "str"  # The value of the
                                          metadata item. Required.
                                    }
                                ],
                                "mountConfiguration": [
                                    {
                                        "azureBlobFileSystemConfiguration": {
                                            "accountName": "str",  # The
                                              Azure Storage Account name. Required.
                                            "containerName": "str",  #
                                              The Azure Blob Storage Container name. Required.
                                            "relativeMountPath": "str",
                                              # The relative path on the compute node where the file
                                              system will be mounted. All file systems are mounted
                                              relative to the Batch mounts directory, accessible via
                                              the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
                                              Required.
                                            "accountKey": "str",  #
                                              Optional. The Azure Storage Account key. This property is
                                              mutually exclusive with both sasKey and identity; exactly
                                              one must be specified.
                                            "blobfuseOptions": "str",  #
                                              Optional. Additional command line options to pass to the
                                              mount command. These are 'net use' options in Windows and
                                              'mount' options in Linux.
                                            "identityReference": {
                                                "resourceId": "str"
                                                  # Optional. The ARM resource id of the user assigned
                                                  identity.
                                            },
                                            "sasKey": "str"  # Optional.
                                              The Azure Storage SAS token. This property is mutually
                                              exclusive with both accountKey and identity; exactly one
                                              must be specified.
                                        },
                                        "azureFileShareConfiguration": {
                                            "accountKey": "str",  # The
                                              Azure Storage account key. Required.
                                            "accountName": "str",  # The
                                              Azure Storage account name. Required.
                                            "azureFileUrl": "str",  # The
                                              Azure Files URL. This is of the form
                                              'https://{account}.file.core.windows.net/'. Required.
                                            "relativeMountPath": "str",
                                              # The relative path on the compute node where the file
                                              system will be mounted. All file systems are mounted
                                              relative to the Batch mounts directory, accessible via
                                              the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
                                              Required.
                                            "mountOptions": "str"  #
                                              Optional. Additional command line options to pass to the
                                              mount command. These are 'net use' options in Windows and
                                              'mount' options in Linux.
                                        },
                                        "cifsMountConfiguration": {
                                            "password": "str",  # The
                                              password to use for authentication against the CIFS file
                                              system. Required.
                                            "relativeMountPath": "str",
                                              # The relative path on the compute node where the file
                                              system will be mounted. All file systems are mounted
                                              relative to the Batch mounts directory, accessible via
                                              the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
                                              Required.
                                            "source": "str",  # The URI
                                              of the file system to mount. Required.
                                            "username": "str",  # The
                                              user to use for authentication against the CIFS file
                                              system. Required.
                                            "mountOptions": "str"  #
                                              Optional. Additional command line options to pass to the
                                              mount command. These are 'net use' options in Windows and
                                              'mount' options in Linux.
                                        },
                                        "nfsMountConfiguration": {
                                            "relativeMountPath": "str",
                                              # The relative path on the compute node where the file
                                              system will be mounted. All file systems are mounted
                                              relative to the Batch mounts directory, accessible via
                                              the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
                                              Required.
                                            "source": "str",  # The URI
                                              of the file system to mount. Required.
                                            "mountOptions": "str"  #
                                              Optional. Additional command line options to pass to the
                                              mount command. These are 'net use' options in Windows and
                                              'mount' options in Linux.
                                        }
                                    }
                                ],
                                "networkConfiguration": {
                                    "dynamicVNetAssignmentScope": "str",  #
                                      Optional. The scope of dynamic vnet assignment. Known values are:
                                      "none" and "job".
                                    "enableAcceleratedNetworking": bool,  #
                                      Optional. Whether this pool should enable accelerated networking.
                                      Accelerated networking enables single root I/O virtualization
                                      (SR-IOV) to a VM, which may lead to improved networking
                                      performance. For more details, see:
                                      https://learn.microsoft.com/azure/virtual-network/accelerated-networking-overview.
                                    "endpointConfiguration": {
                                        "inboundNATPools": [
                                            {
                                                "backendPort": 0,  #
                                                  The port number on the Compute Node. This must be
                                                  unique within a Batch Pool. Acceptable values are
                                                  between 1 and 65535 except for 22, 3389, 29876 and
                                                  29877 as these are reserved. If any reserved values
                                                  are provided the request fails with HTTP status code
                                                  400. Required.
                "frontendPortRangeEnd": 0,  # The last port number in
                                                  the range of external ports that will be used to
                                                  provide inbound access to the backendPort on
                                                  individual Compute Nodes. Acceptable values range
                                                  between 1 and 65534 except ports from 50000 to 55000
                                                  which are reserved by the Batch service. All ranges
                                                  within a Pool must be distinct and cannot overlap.
                                                  Each range must contain at least 40 ports. If any
                                                  reserved or overlapping values are provided the
                                                  request fails with HTTP status code 400. Required.
                "frontendPortRangeStart": 0,  # The first port number
                                                  in the range of external ports that will be used to
                                                  provide inbound access to the backendPort on
                                                  individual Compute Nodes. Acceptable values range
                                                  between 1 and 65534 except ports from 50000 to 55000
                                                  which are reserved. All ranges within a Pool must be
                                                  distinct and cannot overlap. Each range must contain
                                                  at least 40 ports. If any reserved or overlapping
                                                  values are provided the request fails with HTTP
                                                  status code 400. Required.
                                                "name": "str",  # The
                                                  name of the endpoint. The name must be unique within
                                                  a Batch Pool, can contain letters, numbers,
                                                  underscores, periods, and hyphens. Names must start
                                                  with a letter or number, must end with a letter,
                                                  number, or underscore, and cannot exceed 77
                                                  characters.  If any invalid values are provided the
                                                  request fails with HTTP status code 400. Required.
                                                "protocol": "str",  #
                                                  The protocol of the endpoint. Required. Known values
                                                  are: "tcp" and "udp".
                "networkSecurityGroupRules": [
                                                    {
                "access": "str",  # The action that should be
                                                          taken for a specified IP address, subnet
                                                          range or tag. Required. Known values are:
                                                          "allow" and "deny".
                "priority": 0,  # The priority for this rule.
                                                          Priorities within a Pool must be unique and
                                                          are evaluated in order of priority. The lower
                                                          the number the higher the priority. For
                                                          example, rules could be specified with order
                                                          numbers of 150, 250, and 350. The rule with
                                                          the order number of 150 takes precedence over
                                                          the rule that has an order of 250. Allowed
                                                          priorities are 150 to 4096. If any reserved
                                                          or duplicate values are provided the request
                                                          fails with HTTP status code 400. Required.
                "sourceAddressPrefix": "str",  # The source
                                                          address prefix or tag to match for the rule.
                                                          Valid values are a single IP address (i.e.
                                                          10.10.10.10), IP subnet (i.e.
                                                          192.168.1.0/24), default tag, or * (for all
                                                          addresses).  If any other values are provided
                                                          the request fails with HTTP status code 400.
                                                          Required.
                "sourcePortRanges": [
                "str"  # Optional. The source port ranges
                                                              to match for the rule. Valid values are
                                                              '"" *' (for all ports 0 - 65535), a
                                                              specific port (i.e. 22), or a port range
                                                              (i.e. 100-200). The ports must be in the
                                                              range of 0 to 65535. Each entry in this
                                                              collection must not overlap any other
                                                              entry (either a range or an individual
                                                              port). If any other values are provided
                                                              the request fails with HTTP status code
                                                              400. The default value is '*"" '.
                                                        ]
                                                    }
                                                ]
                                            }
                                        ]
                                    },
                                    "publicIPAddressConfiguration": {
                                        "ipAddressIds": [
                                            "str"  # Optional. The list
                                              of public IPs which the Batch service will use when
                                              provisioning Compute Nodes. The number of IPs specified
                                              here limits the maximum size of the Pool - 100 dedicated
                                              nodes or 100 Spot/Low-priority nodes can be allocated for
                                              each public IP. For example, a pool needing 250 dedicated
                                              VMs would need at least 3 public IPs specified. Each
                                              element of this collection is of the form:
                                              /subscriptions/{subscription}/resourceGroups/{group}/providers/Microsoft.Network/publicIPAddresses/{ip}.
                                        ],
                                        "provision": "str"  # Optional. The
                                          provisioning type for Public IP Addresses for the Pool. The
                                          default value is BatchManaged. Known values are:
                                          "batchmanaged", "usermanaged", and "nopublicipaddresses".
                                    },
                                    "subnetId": "str"  # Optional. The ARM
                                      resource identifier of the virtual network subnet which the
                                      Compute Nodes of the Pool will join. This is of the form
                                      /subscriptions/{subscription}/resourceGroups/{group}/providers/{provider}/virtualNetworks/{network}/subnets/{subnet}.
                                      The virtual network must be in the same region and subscription
                                      as the Azure Batch Account. The specified subnet should have
                                      enough free IP addresses to accommodate the number of Compute
                                      Nodes in the Pool. If the subnet doesn't have enough free IP
                                      addresses, the Pool will partially allocate Nodes and a resize
                                      error will occur. The 'MicrosoftAzureBatch' service principal
                                      must have the 'Classic Virtual Machine Contributor' Role-Based
                                      Access Control (RBAC) role for the specified VNet. The specified
                                      subnet must allow communication from the Azure Batch service to
                                      be able to schedule Tasks on the Nodes. This can be verified by
                                      checking if the specified VNet has any associated Network
                                      Security Groups (NSG). If communication to the Nodes in the
                                      specified subnet is denied by an NSG, then the Batch service will
                                      set the state of the Compute Nodes to unusable. For Pools created
                                      with virtualMachineConfiguration only ARM virtual networks
                                      ('Microsoft.Network/virtualNetworks') are supported. If the
                                      specified VNet has any associated Network Security Groups (NSG),
                                      then a few reserved system ports must be enabled for inbound
                                      communication. For Pools created with a virtual machine
                                      configuration, enable ports 29876 and 29877, as well as port 22
                                      for Linux and port 3389 for Windows. Also enable outbound
                                      connections to Azure Storage on port 443. For more details see:
                                      https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration.
                                },
                                "resizeTimeout": "1 day, 0:00:00",  # Optional. The
                                  timeout for allocation of Compute Nodes to the Pool. This timeout
                                  applies only to manual scaling; it has no effect when enableAutoScale
                                  is set to true. The default value is 15 minutes. The minimum value is
                                  5 minutes. If you specify a value less than 5 minutes, the Batch
                                  service rejects the request with an error; if you are calling the
                                  REST API directly, the HTTP status code is 400 (Bad Request).
                                "resourceTags": "str",  # Optional. The
                                  user-specified tags associated with the pool.The user-defined tags to
                                  be associated with the Azure Batch Pool. When specified, these tags
                                  are propagated to the backing Azure resources associated with the
                                  pool. This property can only be specified when the Batch account was
                                  created with the poolAllocationMode property set to
                                  'UserSubscription'.
                                "startTask": {
                                    "commandLine": "str",  # The command line of
                                      the StartTask. The command line does not run under a shell, and
                                      therefore cannot take advantage of shell features such as
                                      environment variable expansion. If you want to take advantage of
                                      such features, you should invoke the shell in the command line,
                                      for example using "cmd /c MyCommand" in Windows or "/bin/sh -c
                                      MyCommand" in Linux. If the command line refers to file paths, it
                                      should use a relative path (relative to the Task working
                                      directory), or use the Batch provided environment variable
                                      (https://docs.microsoft.com/en-us/azure/batch/batch-compute-node-environment-variables).
                                      Required.
                                    "containerSettings": {
                                        "imageName": "str",  # The Image to
                                          use to create the container in which the Task will run. This
                                          is the full Image reference, as would be specified to "docker
                                          pull". If no tag is provided as part of the Image name, the
                                          tag ":latest" is used as a default. Required.
                                        "containerRunOptions": "str",  #
                                          Optional. Additional options to the container create command.
                                          These additional options are supplied as arguments to the
                                          "docker create" command, in addition to those controlled by
                                          the Batch Service.
                                        "registry": {
                                            "identityReference": {
                                                "resourceId": "str"
                                                  # Optional. The ARM resource id of the user assigned
                                                  identity.
                                            },
                                            "password": "str",  #
                                              Optional. The password to log into the registry server.
                                            "registryServer": "str",  #
                                              Optional. The registry URL. If omitted, the default is
                                              "docker.io".
                                            "username": "str"  #
                                              Optional. The user name to log into the registry server.
                                        },
                                        "workingDirectory": "str"  #
                                          Optional. The location of the container Task working
                                          directory. The default is 'taskWorkingDirectory'. Known
                                          values are: "taskWorkingDirectory" and
                                          "containerImageDefault".
                                    },
                                    "environmentSettings": [
                                        {
                                            "name": "str",  # The name of
                                              the environment variable. Required.
                                            "value": "str"  # Optional.
                                              The value of the environment variable.
                                        }
                                    ],
                                    "maxTaskRetryCount": 0,  # Optional. The
                                      maximum number of times the Task may be retried. The Batch
                                      service retries a Task if its exit code is nonzero. Note that
                                      this value specifically controls the number of retries. The Batch
                                      service will try the Task once, and may then retry up to this
                                      limit. For example, if the maximum retry count is 3, Batch tries
                                      the Task up to 4 times (one initial try and 3 retries). If the
                                      maximum retry count is 0, the Batch service does not retry the
                                      Task. If the maximum retry count is -1, the Batch service retries
                                      the Task without limit, however this is not recommended for a
                                      start task or any task. The default value is 0 (no retries).
                                    "resourceFiles": [
                                        {
                                            "autoStorageContainerName":
                                              "str",  # Optional. The storage container name in the
                                              auto storage Account. The autoStorageContainerName,
                                              storageContainerUrl and httpUrl properties are mutually
                                              exclusive and one of them must be specified.
                                            "blobPrefix": "str",  #
                                              Optional. The blob prefix to use when downloading blobs
                                              from an Azure Storage container. Only the blobs whose
                                              names begin with the specified prefix will be downloaded.
                                              The property is valid only when autoStorageContainerName
                                              or storageContainerUrl is used. This prefix can be a
                                              partial filename or a subdirectory. If a prefix is not
                                              specified, all the files in the container will be
                                              downloaded.
                                            "fileMode": "str",  #
                                              Optional. The file permission mode attribute in octal
                                              format. This property applies only to files being
                                              downloaded to Linux Compute Nodes. It will be ignored if
                                              it is specified for a resourceFile which will be
                                              downloaded to a Windows Compute Node. If this property is
                                              not specified for a Linux Compute Node, then a default
                                              value of 0770 is applied to the file.
                                            "filePath": "str",  #
                                              Optional. The location on the Compute Node to which to
                                              download the file(s), relative to the Task's working
                                              directory. If the httpUrl property is specified, the
                                              filePath is required and describes the path which the
                                              file will be downloaded to, including the filename.
                                              Otherwise, if the autoStorageContainerName or
                                              storageContainerUrl property is specified, filePath is
                                              optional and is the directory to download the files to.
                                              In the case where filePath is used as a directory, any
                                              directory structure already associated with the input
                                              data will be retained in full and appended to the
                                              specified filePath directory. The specified relative path
                                              cannot break out of the Task's working directory (for
                                              example by using '..').
                                            "httpUrl": "str",  #
                                              Optional. The URL of the file to download. The
                                              autoStorageContainerName, storageContainerUrl and httpUrl
                                              properties are mutually exclusive and one of them must be
                                              specified. If the URL points to Azure Blob Storage, it
                                              must be readable from compute nodes. There are three ways
                                              to get such a URL for a blob in Azure storage: include a
                                              Shared Access Signature (SAS) granting read permissions
                                              on the blob, use a managed identity with read permission,
                                              or set the ACL for the blob or its container to allow
                                              public access.
                                            "identityReference": {
                                                "resourceId": "str"
                                                  # Optional. The ARM resource id of the user assigned
                                                  identity.
                                            },
                                            "storageContainerUrl": "str"
                                              # Optional. The URL of the blob container within Azure
                                              Blob Storage. The autoStorageContainerName,
                                              storageContainerUrl and httpUrl properties are mutually
                                              exclusive and one of them must be specified. This URL
                                              must be readable and listable from compute nodes. There
                                              are three ways to get such a URL for a container in Azure
                                              storage: include a Shared Access Signature (SAS) granting
                                              read and list permissions on the container, use a managed
                                              identity with read and list permissions, or set the ACL
                                              for the container to allow public access.
                                        }
                                    ],
                                    "userIdentity": {
                                        "autoUser": {
                                            "elevationLevel": "str",  #
                                              Optional. The elevation level of the auto user. The
                                              default value is nonAdmin. Known values are: "nonadmin"
                                              and "admin".
                                            "scope": "str"  # Optional.
                                              The scope for the auto user. The default value is pool.
                                              If the pool is running Windows, a value of Task should be
                                              specified if stricter isolation between tasks is
                                              required, such as if the task mutates the registry in a
                                              way which could impact other tasks. Known values are:
                                              "task" and "pool".
                                        },
                                        "username": "str"  # Optional. The
                                          name of the user identity under which the Task is run. The
                                          userName and autoUser properties are mutually exclusive; you
                                          must specify one but not both.
                                    },
                                    "waitForSuccess": bool  # Optional. Whether
                                      the Batch service should wait for the StartTask to complete
                                      successfully (that is, to exit with exit code 0) before
                                      scheduling any Tasks on the Compute Node. If true and the
                                      StartTask fails on a Node, the Batch service retries the
                                      StartTask up to its maximum retry count (maxTaskRetryCount). If
                                      the Task has still not completed successfully after all retries,
                                      then the Batch service marks the Node unusable, and will not
                                      schedule Tasks to it. This condition can be detected via the
                                      Compute Node state and failure info details. If false, the Batch
                                      service will not wait for the StartTask to complete. In this
                                      case, other Tasks can start executing on the Compute Node while
                                      the StartTask is still running; and even if the StartTask fails,
                                      new Tasks will continue to be scheduled on the Compute Node. The
                                      default is true.
                                },
                                "targetDedicatedNodes": 0,  # Optional. The desired
                                  number of dedicated Compute Nodes in the Pool. This property must not
                                  be specified if enableAutoScale is set to true. If enableAutoScale is
                                  set to false, then you must set either targetDedicatedNodes,
                                  targetLowPriorityNodes, or both.
                                "targetLowPriorityNodes": 0,  # Optional. The desired
                                  number of Spot/Low-priority Compute Nodes in the Pool. This property
                                  must not be specified if enableAutoScale is set to true. If
                                  enableAutoScale is set to false, then you must set either
                                  targetDedicatedNodes, targetLowPriorityNodes, or both.
                                "targetNodeCommunicationMode": "str",  # Optional.
                                  The desired node communication mode for the pool. If omitted, the
                                  default value is Default. Known values are: "default", "classic", and
                                  "simplified".
                                "taskSchedulingPolicy": {
                                    "nodeFillType": "str"  # How Tasks are
                                      distributed across Compute Nodes in a Pool. If not specified, the
                                      default is spread. Required. Known values are: "spread" and
                                      "pack".
                                },
                                "taskSlotsPerNode": 0,  # Optional. The number of
                                  task slots that can be used to run concurrent tasks on a single
                                  compute node in the pool. The default value is 1. The maximum value
                                  is the smaller of 4 times the number of cores of the vmSize of the
                                  pool or 256.
                                "upgradePolicy": {
                                    "mode": "str",  # Specifies the mode of an
                                      upgrade to virtual machines in the scale set.:code:`<br
                                      />`:code:`<br />` Possible values are::code:`<br />`:code:`<br
                                      />` **Manual** - You  control the application of updates to
                                      virtual machines in the scale set. You do this by using the
                                      manualUpgrade action.:code:`<br />`:code:`<br />` **Automatic** -
                                      All virtual machines in the scale set are automatically updated
                                      at the same time.:code:`<br />`:code:`<br />` **Rolling** - Scale
                                      set performs updates in batches with an optional pause time in
                                      between. Required. Known values are: "automatic", "manual", and
                                      "rolling".
                                    "automaticOSUpgradePolicy": {
                                        "disableAutomaticRollback": bool,  #
                                          Optional. Whether OS image rollback feature should be
                                          disabled.
                                        "enableAutomaticOSUpgrade": bool,  #
                                          Optional. Indicates whether OS upgrades should automatically
                                          be applied to scale set instances in a rolling fashion when a
                                          newer version of the OS image becomes available. :code:`<br
                                          />`:code:`<br />` If this is set to true for Windows based
                                          pools, `WindowsConfiguration.enableAutomaticUpdates
                                          <https://learn.microsoft.com/en-us/rest/api/batchservice/pool/add?tabs=HTTP#windowsconfiguration>`_
                                          cannot be set to true.
                                        "osRollingUpgradeDeferral": bool,  #
                                          Optional. Defer OS upgrades on the TVMs if they are running
                                          tasks.
                                        "useRollingUpgradePolicy": bool  #
                                          Optional. Indicates whether rolling upgrade policy should be
                                          used during Auto OS Upgrade. Auto OS Upgrade will fallback to
                                          the default policy if no policy is defined on the VMSS.
                                    },
                                    "rollingUpgradePolicy": {
                                        "enableCrossZoneUpgrade": bool,  #
                                          Optional. Allow VMSS to ignore AZ boundaries when
                                          constructing upgrade batches. Take into consideration the
                                          Update Domain and maxBatchInstancePercent to determine the
                                          batch size. This field is able to be set to true or false
                                          only when using NodePlacementConfiguration as Zonal.
                                        "maxBatchInstancePercent": 0,  #
                                          Optional. The maximum percent of total virtual machine
                                          instances that will be upgraded simultaneously by the rolling
                                          upgrade in one batch. As this is a maximum, unhealthy
                                          instances in previous or future batches can cause the
                                          percentage of instances in a batch to decrease to ensure
                                          higher reliability. The value of this field should be between
                                          5 and 100, inclusive. If both maxBatchInstancePercent and
                                          maxUnhealthyInstancePercent are assigned with value, the
                                          value of maxBatchInstancePercent should not be more than
                                          maxUnhealthyInstancePercent.
                                        "maxUnhealthyInstancePercent": 0,  #
                                          Optional. The maximum percentage of the total virtual machine
                                          instances in the scale set that can be simultaneously
                                          unhealthy, either as a result of being upgraded, or by being
                                          found in an unhealthy state by the virtual machine health
                                          checks before the rolling upgrade aborts. This constraint
                                          will be checked prior to starting any batch. The value of
                                          this field should be between 5 and 100, inclusive. If both
                                          maxBatchInstancePercent and maxUnhealthyInstancePercent are
                                          assigned with value, the value of maxBatchInstancePercent
                                          should not be more than maxUnhealthyInstancePercent.
                "maxUnhealthyUpgradedInstancePercent": 0,  # Optional. The
                                          maximum percentage of upgraded virtual machine instances that
                                          can be found to be in an unhealthy state. This check will
                                          happen after each batch is upgraded. If this percentage is
                                          ever exceeded, the rolling update aborts. The value of this
                                          field should be between 0 and 100, inclusive.
                                        "pauseTimeBetweenBatches": "1 day,
                                          0:00:00",  # Optional. The wait time between completing the
                                          update for all virtual machines in one batch and starting the
                                          next batch. The time duration should be specified in ISO 8601
                                          format..
                                        "prioritizeUnhealthyInstances": bool,
                                          # Optional. Upgrade all unhealthy instances in a scale set
                                          before any healthy instances.
                "rollbackFailedInstancesOnPolicyBreach": bool  # Optional.
                                          Rollback failed instances to previous model if the Rolling
                                          Upgrade policy is violated.
                                    }
                                },
                                "userAccounts": [
                                    {
                                        "name": "str",  # The name of the
                                          user Account. Names can contain any Unicode characters up to
                                          a maximum length of 20. Required.
                                        "password": "str",  # The password
                                          for the user Account. Required.
                                        "elevationLevel": "str",  # Optional.
                                          The elevation level of the user Account. The default value is
                                          nonAdmin. Known values are: "nonadmin" and "admin".
                                        "linuxUserConfiguration": {
                                            "gid": 0,  # Optional. The
                                              group ID for the user Account. The uid and gid properties
                                              must be specified together or not at all. If not
                                              specified the underlying operating system picks the gid.
                                            "sshPrivateKey": "str",  #
                                              Optional. The SSH private key for the user Account. The
                                              private key must not be password protected. The private
                                              key is used to automatically configure asymmetric-key
                                              based authentication for SSH between Compute Nodes in a
                                              Linux Pool when the Pool's enableInterNodeCommunication
                                              property is true (it is ignored if
                                              enableInterNodeCommunication is false). It does this by
                                              placing the key pair into the user's .ssh directory. If
                                              not specified, password-less SSH is not configured
                                              between Compute Nodes (no modification of the user's .ssh
                                              directory is done).
                                            "uid": 0  # Optional. The
                                              user ID of the user Account. The uid and gid properties
                                              must be specified together or not at all. If not
                                              specified the underlying operating system picks the uid.
                                        },
                                        "windowsUserConfiguration": {
                                            "loginMode": "str"  #
                                              Optional. The login mode for the user. The default value
                                              for VirtualMachineConfiguration Pools is 'batch'. Known
                                              values are: "batch" and "interactive".
                                        }
                                    }
                                ],
                                "virtualMachineConfiguration": {
                                    "imageReference": {
                                        "exactVersion": "str",  # Optional.
                                          The specific version of the platform image or marketplace
                                          image used to create the node. This read-only field differs
                                          from 'version' only if the value specified for 'version' when
                                          the pool was created was 'latest'.
                                        "offer": "str",  # Optional. The
                                          offer type of the Azure Virtual Machines Marketplace Image.
                                          For example, UbuntuServer or WindowsServer.
                                        "publisher": "str",  # Optional. The
                                          publisher of the Azure Virtual Machines Marketplace Image.
                                          For example, Canonical or MicrosoftWindowsServer.
                                        "sku": "str",  # Optional. The SKU of
                                          the Azure Virtual Machines Marketplace Image. For example,
                                          18.04-LTS or 2019-Datacenter.
                                        "version": "str",  # Optional. The
                                          version of the Azure Virtual Machines Marketplace Image. A
                                          value of 'latest' can be specified to select the latest
                                          version of an Image. If omitted, the default is 'latest'.
                                        "virtualMachineImageId": "str"  #
                                          Optional. The ARM resource identifier of the Azure Compute
                                          Gallery Image. Compute Nodes in the Pool will be created
                                          using this Image Id. This is of the form
                                          /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/galleries/{galleryName}/images/{imageDefinitionName}/versions/{VersionId}
                                          or
                                          /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/galleries/{galleryName}/images/{imageDefinitionName}
                                          for always defaulting to the latest image version. This
                                          property is mutually exclusive with other ImageReference
                                          properties. The Azure Compute Gallery Image must have
                                          replicas in the same region and must be in the same
                                          subscription as the Azure Batch account. If the image version
                                          is not specified in the imageId, the latest version will be
                                          used. For information about the firewall settings for the
                                          Batch Compute Node agent to communicate with the Batch
                                          service see
                                          https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration.
                                    },
                                    "nodeAgentSKUId": "str",  # The SKU of the
                                      Batch Compute Node agent to be provisioned on Compute Nodes in
                                      the Pool. The Batch Compute Node agent is a program that runs on
                                      each Compute Node in the Pool, and provides the
                                      command-and-control interface between the Compute Node and the
                                      Batch service. There are different implementations of the Compute
                                      Node agent, known as SKUs, for different operating systems. You
                                      must specify a Compute Node agent SKU which matches the selected
                                      Image reference. To get the list of supported Compute Node agent
                                      SKUs along with their list of verified Image references, see the
                                      'List supported Compute Node agent SKUs' operation. Required.
                                    "containerConfiguration": {
                                        "type": "str",  # The container
                                          technology to be used. Required. Known values are:
                                          "dockerCompatible" and "criCompatible".
                                        "containerImageNames": [
                                            "str"  # Optional. The
                                              collection of container Image names. This is the full
                                              Image reference, as would be specified to "docker pull".
                                              An Image will be sourced from the default Docker registry
                                              unless the Image is fully qualified with an alternative
                                              registry.
                                        ],
                                        "containerRegistries": [
                                            {
                                                "identityReference":
                                                  {
                                                    "resourceId":
                                                      "str"  # Optional. The ARM resource id of the
                                                      user assigned identity.
                                                },
                                                "password": "str",  #
                                                  Optional. The password to log into the registry
                                                  server.
                                                "registryServer":
                                                  "str",  # Optional. The registry URL. If omitted, the
                                                  default is "docker.io".
                                                "username": "str"  #
                                                  Optional. The user name to log into the registry
                                                  server.
                                            }
                                        ]
                                    },
                                    "dataDisks": [
                                        {
                                            "diskSizeGB": 0,  # The
                                              initial disk size in gigabytes. Required.
                                            "lun": 0,  # The logical unit
                                              number. The logicalUnitNumber is used to uniquely
                                              identify each data disk. If attaching multiple disks,
                                              each should have a distinct logicalUnitNumber. The value
                                              must be between 0 and 63, inclusive. Required.
                                            "caching": "str",  #
                                              Optional. The type of caching to be enabled for the data
                                              disks. The default value for caching is readwrite. For
                                              information about the caching options see:
                                              https://blogs.msdn.microsoft.com/windowsazurestorage/2012/06/27/exploring-windows-azure-drives-disks-and-images/.
                                              Known values are: "none", "readonly", and "readwrite".
                                            "storageAccountType": "str"
                                              # Optional. The storage Account type to be used for the
                                              data disk. If omitted, the default is "standard_lrs".
                                              Known values are: "standard_lrs", "premium_lrs", and
                                              "standardssd_lrs".
                                        }
                                    ],
                                    "diskEncryptionConfiguration": {
                                        "targets": [
                                            "str"  # Optional. The list
                                              of disk targets Batch Service will encrypt on the compute
                                              node. If omitted, no disks on the compute nodes in the
                                              pool will be encrypted. On Linux pool, only
                                              "TemporaryDisk" is supported; on Windows pool, "OsDisk"
                                              and "TemporaryDisk" must be specified.
                                        ]
                                    },
                                    "extensions": [
                                        {
                                            "name": "str",  # The name of
                                              the virtual machine extension. Required.
                                            "publisher": "str",  # The
                                              name of the extension handler publisher. Required.
                                            "type": "str",  # The type of
                                              the extension. Required.
                                            "autoUpgradeMinorVersion":
                                              bool,  # Optional. Indicates whether the extension should
                                              use a newer minor version if one is available at
                                              deployment time. Once deployed, however, the extension
                                              will not upgrade minor versions unless redeployed, even
                                              with this property set to true.
                                            "enableAutomaticUpgrade":
                                              bool,  # Optional. Indicates whether the extension should
                                              be automatically upgraded by the platform if there is a
                                              newer version of the extension available.
                                            "protectedSettings": {
                                                "str": "str"  #
                                                  Optional. The extension can contain either
                                                  protectedSettings or protectedSettingsFromKeyVault or
                                                  no protected settings at all.
                                            },
                                            "provisionAfterExtensions": [
                                                "str"  # Optional.
                                                  The collection of extension names. Collection of
                                                  extension names after which this extension needs to
                                                  be provisioned.
                                            ],
                                            "settings": {
                                                "str": "str"  #
                                                  Optional. JSON formatted public settings for the
                                                  extension.
                                            },
                                            "typeHandlerVersion": "str"
                                              # Optional. The version of script handler.
                                        }
                                    ],
                                    "licenseType": "str",  # Optional. This only
                                      applies to Images that contain the Windows operating system, and
                                      should only be used when you hold valid on-premises licenses for
                                      the Compute Nodes which will be deployed. If omitted, no
                                      on-premises licensing discount is applied. Values are:
                                      Windows_Server - The on-premises license is for Windows Server.
                                      Windows_Client - The on-premises license is for Windows Client.
                                    "nodePlacementConfiguration": {
                                        "policy": "str"  # Optional. Node
                                          placement Policy type on Batch Pools. Allocation policy used
                                          by Batch Service to provision the nodes. If not specified,
                                          Batch will use the regional policy. Known values are:
                                          "regional" and "zonal".
                                    },
                                    "osDisk": {
                                        "caching": "str",  # Optional.
                                          Specifies the caching requirements. Possible values are:
                                          None, ReadOnly, ReadWrite. The default values are: None for
                                          Standard storage. ReadOnly for Premium storage. Known values
                                          are: "none", "readonly", and "readwrite".
                                        "diskSizeGB": 0,  # Optional. The
                                          initial disk size in GB when creating new OS disk.
                                        "ephemeralOSDiskSettings": {
                                            "placement": "str"  #
                                              Optional. Specifies the ephemeral disk placement for
                                              operating system disk for all VMs in the pool. This
                                              property can be used by user in the request to choose the
                                              location e.g., cache disk space for Ephemeral OS disk
                                              provisioning. For more information on Ephemeral OS disk
                                              size requirements, please refer to Ephemeral OS disk size
                                              requirements for Windows VMs at
                                              https://docs.microsoft.com/en-us/azure/virtual-machines/windows/ephemeral-os-disks#size-requirements
                                              and Linux VMs at
                                              https://docs.microsoft.com/en-us/azure/virtual-machines/linux/ephemeral-os-disks#size-requirements.
                                              "cachedisk"
                                        },
                                        "managedDisk": {
                                            "storageAccountType": "str"
                                              # The storage account type for managed disk. Required.
                                              Known values are: "standard_lrs", "premium_lrs", and
                                              "standardssd_lrs".
                                        },
                                        "writeAcceleratorEnabled": bool  #
                                          Optional. Specifies whether writeAccelerator should be
                                          enabled or disabled on the disk.
                                    },
                                    "securityProfile": {
                                        "encryptionAtHost": bool,  # This
                                          property can be used by user in the request to enable or
                                          disable the Host Encryption for the virtual machine or
                                          virtual machine scale set. This will enable the encryption
                                          for all the disks including Resource/Temp disk at host
                                          itself. Required.
                                        "securityType": "str",  # Specifies
                                          the SecurityType of the virtual machine. It has to be set to
                                          any specified value to enable UefiSettings. Required.
                                          "trustedLaunch"
                                        "uefiSettings": {
                                            "secureBootEnabled": bool,  #
                                              Optional. Specifies whether secure boot should be enabled
                                              on the virtual machine.
                                            "vTpmEnabled": bool  #
                                              Optional. Specifies whether vTPM should be enabled on the
                                              virtual machine.
                                        }
                                    },
                                    "serviceArtifactReference": {
                                        "id": "str"  # The service artifact
                                          reference id of ServiceArtifactReference. The service
                                          artifact reference id in the form of
                                          /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/galleries/{galleryName}/serviceArtifacts/{serviceArtifactName}/vmArtifactsProfiles/{vmArtifactsProfilesName}.
                                          Required.
                                    },
                                    "windowsConfiguration": {
                                        "enableAutomaticUpdates": bool  #
                                          Optional. Whether automatic updates are enabled on the
                                          virtual machine. If omitted, the default value is true.
                                    }
                                }
                            }
                        },
                        "poolId": "str"  # Optional. The ID of an existing Pool. All the
                          Tasks of the Job will run on the specified Pool. You must ensure that the
                          Pool referenced by this property exists. If the Pool does not exist at the
                          time the Batch service tries to schedule a Job, no Tasks for the Job will run
                          until you create a Pool with that id. Note that the Batch service will not
                          reject the Job request; it will simply not run Tasks until the Pool exists.
                          You must specify either the Pool ID or the auto Pool specification, but not
                          both.
                    },
                    "allowTaskPreemption": bool,  # Optional. Whether Tasks in this job can be
                      preempted by other high priority jobs. If the value is set to True, other high
                      priority jobs submitted to the system will take precedence and will be able
                      requeue tasks from this job. You can update a job's allowTaskPreemption after it
                      has been created using the update job API.
                    "commonEnvironmentSettings": [
                        {
                            "name": "str",  # The name of the environment variable.
                              Required.
                            "value": "str"  # Optional. The value of the environment
                              variable.
                        }
                    ],
                    "constraints": {
                        "maxTaskRetryCount": 0,  # Optional. The maximum number of times each
                          Task may be retried. The Batch service retries a Task if its exit code is
                          nonzero. Note that this value specifically controls the number of retries.
                          The Batch service will try each Task once, and may then retry up to this
                          limit. For example, if the maximum retry count is 3, Batch tries a Task up to
                          4 times (one initial try and 3 retries). If the maximum retry count is 0, the
                          Batch service does not retry Tasks. If the maximum retry count is -1, the
                          Batch service retries Tasks without limit. The default value is 0 (no
                          retries).
                        "maxWallClockTime": "1 day, 0:00:00"  # Optional. The maximum elapsed
                          time that the Job may run, measured from the time the Job is created. If the
                          Job does not complete within the time limit, the Batch service terminates it
                          and any Tasks that are still running. In this case, the termination reason
                          will be MaxWallClockTimeExpiry. If this property is not specified, there is
                          no time limit on how long the Job may run.
                    },
                    "creationTime": "2020-02-20 00:00:00",  # Optional. The creation time of the
                      Job.
                    "displayName": "str",  # Optional. The display name for the Job.
                    "eTag": "str",  # Optional. The ETag of the Job. This is an opaque string.
                      You can use it to detect whether the Job has changed between requests. In
                      particular, you can be pass the ETag when updating a Job to specify that your
                      changes should take effect only if nobody else has modified the Job in the
                      meantime.
                    "executionInfo": {
                        "startTime": "2020-02-20 00:00:00",  # The start time of the Job.
                          This is the time at which the Job was created. Required.
                        "endTime": "2020-02-20 00:00:00",  # Optional. The completion time of
                          the Job. This property is set only if the Job is in the completed state.
                        "poolId": "str",  # Optional. The ID of the Pool to which this Job is
                          assigned. This element contains the actual Pool where the Job is assigned.
                          When you get Job details from the service, they also contain a poolInfo
                          element, which contains the Pool configuration data from when the Job was
                          added or updated. That poolInfo element may also contain a poolId element. If
                          it does, the two IDs are the same. If it does not, it means the Job ran on an
                          auto Pool, and this property contains the ID of that auto Pool.
                        "schedulingError": {
                            "category": "str",  # The category of the Job scheduling
                              error. Required. Known values are: "usererror" and "servererror".
                            "code": "str",  # Optional. An identifier for the Job
                              scheduling error. Codes are invariant and are intended to be consumed
                              programmatically.
                            "details": [
                                {
                                    "name": "str",  # Optional. The name in the
                                      name-value pair.
                                    "value": "str"  # Optional. The value in the
                                      name-value pair.
                                }
                            ],
                            "message": "str"  # Optional. A message describing the Job
                              scheduling error, intended to be suitable for display in a user
                              interface.
                        },
                        "terminateReason": "str"  # Optional. A string describing the reason
                          the Job ended. This property is set only if the Job is in the completed
                          state. If the Batch service terminates the Job, it sets the reason as
                          follows: JMComplete - the Job Manager Task completed, and killJobOnCompletion
                          was set to true. MaxWallClockTimeExpiry - the Job reached its
                          maxWallClockTime constraint. TerminateJobSchedule - the Job ran as part of a
                          schedule, and the schedule terminated. AllTasksComplete - the Job's
                          onAllTasksComplete attribute is set to terminatejob, and all Tasks in the Job
                          are complete. TaskFailed - the Job's onTaskFailure attribute is set to
                          performExitOptionsJobAction, and a Task in the Job failed with an exit
                          condition that specified a jobAction of terminatejob. Any other string is a
                          user-defined reason specified in a call to the 'Terminate a Job' operation.
                    },
                    "id": "str",  # Optional. A string that uniquely identifies the Job within
                      the Account. The ID is case-preserving and case-insensitive (that is, you may not
                      have two IDs within an Account that differ only by case).
                    "jobManagerTask": {
                        "commandLine": "str",  # The command line of the Job Manager Task.
                          The command line does not run under a shell, and therefore cannot take
                          advantage of shell features such as environment variable expansion. If you
                          want to take advantage of such features, you should invoke the shell in the
                          command line, for example using "cmd /c MyCommand" in Windows or "/bin/sh -c
                          MyCommand" in Linux. If the command line refers to file paths, it should use
                          a relative path (relative to the Task working directory), or use the Batch
                          provided environment variable
                          (https://docs.microsoft.com/en-us/azure/batch/batch-compute-node-environment-variables).
                          Required.
                        "id": "str",  # A string that uniquely identifies the Job Manager
                          Task within the Job. The ID can contain any combination of alphanumeric
                          characters including hyphens and underscores and cannot contain more than 64
                          characters. Required.
                        "allowLowPriorityNode": bool,  # Optional. Whether the Job Manager
                          Task may run on a Spot/Low-priority Compute Node. The default value is true.
                        "applicationPackageReferences": [
                            {
                                "applicationId": "str",  # The ID of the application
                                  to deploy. When creating a pool, the package's application ID must be
                                  fully qualified
                                  (/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/applications/{applicationName}).
                                  Required.
                                "version": "str"  # Optional. The version of the
                                  application to deploy. If omitted, the default version is deployed.
                                  If this is omitted on a Pool, and no default version is specified for
                                  this application, the request fails with the error code
                                  InvalidApplicationPackageReferences and HTTP status code 409. If this
                                  is omitted on a Task, and no default version is specified for this
                                  application, the Task fails with a pre-processing error.
                            }
                        ],
                        "authenticationTokenSettings": {
                            "access": [
                                "str"  # Optional. The Batch resources to which the
                                  token grants access. The authentication token grants access to a
                                  limited set of Batch service operations. Currently the only supported
                                  value for the access property is 'job', which grants access to all
                                  operations related to the Job which contains the Task.
                            ]
                        },
                        "constraints": {
                            "maxTaskRetryCount": 0,  # Optional. The maximum number of
                              times the Task may be retried. The Batch service retries a Task if its
                              exit code is nonzero. Note that this value specifically controls the
                              number of retries for the Task executable due to a nonzero exit code. The
                              Batch service will try the Task once, and may then retry up to this
                              limit. For example, if the maximum retry count is 3, Batch tries the Task
                              up to 4 times (one initial try and 3 retries). If the maximum retry count
                              is 0, the Batch service does not retry the Task after the first attempt.
                              If the maximum retry count is -1, the Batch service retries the Task
                              without limit, however this is not recommended for a start task or any
                              task. The default value is 0 (no retries).
                            "maxWallClockTime": "1 day, 0:00:00",  # Optional. The
                              maximum elapsed time that the Task may run, measured from the time the
                              Task starts. If the Task does not complete within the time limit, the
                              Batch service terminates it. If this is not specified, there is no time
                              limit on how long the Task may run.
                            "retentionTime": "1 day, 0:00:00"  # Optional. The minimum
                              time to retain the Task directory on the Compute Node where it ran, from
                              the time it completes execution. After this time, the Batch service may
                              delete the Task directory and all its contents. The default is 7 days,
                              i.e. the Task directory will be retained for 7 days unless the Compute
                              Node is removed or the Job is deleted.
                        },
                        "containerSettings": {
                            "imageName": "str",  # The Image to use to create the
                              container in which the Task will run. This is the full Image reference,
                              as would be specified to "docker pull". If no tag is provided as part of
                              the Image name, the tag ":latest" is used as a default. Required.
                            "containerRunOptions": "str",  # Optional. Additional options
                              to the container create command. These additional options are supplied as
                              arguments to the "docker create" command, in addition to those controlled
                              by the Batch Service.
                            "registry": {
                                "identityReference": {
                                    "resourceId": "str"  # Optional. The ARM
                                      resource id of the user assigned identity.
                                },
                                "password": "str",  # Optional. The password to log
                                  into the registry server.
                                "registryServer": "str",  # Optional. The registry
                                  URL. If omitted, the default is "docker.io".
                                "username": "str"  # Optional. The user name to log
                                  into the registry server.
                            },
                            "workingDirectory": "str"  # Optional. The location of the
                              container Task working directory. The default is 'taskWorkingDirectory'.
                              Known values are: "taskWorkingDirectory" and "containerImageDefault".
                        },
                        "displayName": "str",  # Optional. The display name of the Job
                          Manager Task. It need not be unique and can contain any Unicode characters up
                          to a maximum length of 1024.
                        "environmentSettings": [
                            {
                                "name": "str",  # The name of the environment
                                  variable. Required.
                                "value": "str"  # Optional. The value of the
                                  environment variable.
                            }
                        ],
                        "killJobOnCompletion": bool,  # Optional. Whether completion of the
                          Job Manager Task signifies completion of the entire Job. If true, when the
                          Job Manager Task completes, the Batch service marks the Job as complete. If
                          any Tasks are still running at this time (other than Job Release), those
                          Tasks are terminated. If false, the completion of the Job Manager Task does
                          not affect the Job status. In this case, you should either use the
                          onAllTasksComplete attribute to terminate the Job, or have a client or user
                          terminate the Job explicitly. An example of this is if the Job Manager
                          creates a set of Tasks but then takes no further role in their execution. The
                          default value is true. If you are using the onAllTasksComplete and
                          onTaskFailure attributes to control Job lifetime, and using the Job Manager
                          Task only to create the Tasks for the Job (not to monitor progress), then it
                          is important to set killJobOnCompletion to false.
                        "outputFiles": [
                            {
                                "destination": {
                                    "container": {
                                        "containerUrl": "str",  # The URL of
                                          the container within Azure Blob Storage to which to upload
                                          the file(s). If not using a managed identity, the URL must
                                          include a Shared Access Signature (SAS) granting write
                                          permissions to the container. Required.
                                        "identityReference": {
                                            "resourceId": "str"  #
                                              Optional. The ARM resource id of the user assigned
                                              identity.
                                        },
                                        "path": "str",  # Optional. The
                                          destination blob or virtual directory within the Azure
                                          Storage container. If filePattern refers to a specific file
                                          (i.e. contains no wildcards), then path is the name of the
                                          blob to which to upload that file. If filePattern contains
                                          one or more wildcards (and therefore may match multiple
                                          files), then path is the name of the blob virtual directory
                                          (which is prepended to each blob name) to which to upload the
                                          file(s). If omitted, file(s) are uploaded to the root of the
                                          container with a blob name matching their file name.
                                        "uploadHeaders": [
                                            {
                                                "name": "str",  # The
                                                  case-insensitive name of the header to be used while
                                                  uploading output files. Required.
                                                "value": "str"  #
                                                  Optional. The value of the header to be used while
                                                  uploading output files.
                                            }
                                        ]
                                    }
                                },
                                "filePattern": "str",  # A pattern indicating which
                                  file(s) to upload. Both relative and absolute paths are supported.
                                  Relative paths are relative to the Task working directory. The
                                  following wildcards are supported: * matches 0 or more characters
                                  (for example pattern abc* would match abc or abcdef), ** matches any
                                  directory, ? matches any single character, [abc] matches one
                                  character in the brackets, and [a-c] matches one character in the
                                  range. Brackets can include a negation to match any character not
                                  specified (for example [!abc] matches any character but a, b, or c).
                                  If a file name starts with "." it is ignored by default but may be
                                  matched by specifying it explicitly (for example *.gif will not match
                                  .a.gif, but .*.gif will). A simple example: **"" *.txt matches any
                                  file that does not start in '.' and ends with .txt in the Task
                                  working directory or any subdirectory. If the filename contains a
                                  wildcard character it can be escaped using brackets (for example
                                  abc["" *] would match a file named abc*"" ). Note that both and / are
                                  treated as directory separators on Windows, but only / is on Linux.
                                  Environment variables (%var% on Windows or $var on Linux) are
                                  expanded prior to the pattern being applied. Required.
                                "uploadOptions": {
                                    "uploadCondition": "str"  # The conditions
                                      under which the Task output file or set of files should be
                                      uploaded. The default is taskcompletion. Required. Known values
                                      are: "tasksuccess", "taskfailure", and "taskcompletion".
                                }
                            }
                        ],
                        "requiredSlots": 0,  # Optional. The number of scheduling slots that
                          the Task requires to run. The default is 1. A Task can only be scheduled to
                          run on a compute node if the node has enough free scheduling slots available.
                          For multi-instance Tasks, this property is not supported and must not be
                          specified.
                        "resourceFiles": [
                            {
                                "autoStorageContainerName": "str",  # Optional. The
                                  storage container name in the auto storage Account. The
                                  autoStorageContainerName, storageContainerUrl and httpUrl properties
                                  are mutually exclusive and one of them must be specified.
                                "blobPrefix": "str",  # Optional. The blob prefix to
                                  use when downloading blobs from an Azure Storage container. Only the
                                  blobs whose names begin with the specified prefix will be downloaded.
                                  The property is valid only when autoStorageContainerName or
                                  storageContainerUrl is used. This prefix can be a partial filename or
                                  a subdirectory. If a prefix is not specified, all the files in the
                                  container will be downloaded.
                                "fileMode": "str",  # Optional. The file permission
                                  mode attribute in octal format. This property applies only to files
                                  being downloaded to Linux Compute Nodes. It will be ignored if it is
                                  specified for a resourceFile which will be downloaded to a Windows
                                  Compute Node. If this property is not specified for a Linux Compute
                                  Node, then a default value of 0770 is applied to the file.
                                "filePath": "str",  # Optional. The location on the
                                  Compute Node to which to download the file(s), relative to the Task's
                                  working directory. If the httpUrl property is specified, the filePath
                                  is required and describes the path which the file will be downloaded
                                  to, including the filename. Otherwise, if the
                                  autoStorageContainerName or storageContainerUrl property is
                                  specified, filePath is optional and is the directory to download the
                                  files to. In the case where filePath is used as a directory, any
                                  directory structure already associated with the input data will be
                                  retained in full and appended to the specified filePath directory.
                                  The specified relative path cannot break out of the Task's working
                                  directory (for example by using '..').
                                "httpUrl": "str",  # Optional. The URL of the file to
                                  download. The autoStorageContainerName, storageContainerUrl and
                                  httpUrl properties are mutually exclusive and one of them must be
                                  specified. If the URL points to Azure Blob Storage, it must be
                                  readable from compute nodes. There are three ways to get such a URL
                                  for a blob in Azure storage: include a Shared Access Signature (SAS)
                                  granting read permissions on the blob, use a managed identity with
                                  read permission, or set the ACL for the blob or its container to
                                  allow public access.
                                "identityReference": {
                                    "resourceId": "str"  # Optional. The ARM
                                      resource id of the user assigned identity.
                                },
                                "storageContainerUrl": "str"  # Optional. The URL of
                                  the blob container within Azure Blob Storage. The
                                  autoStorageContainerName, storageContainerUrl and httpUrl properties
                                  are mutually exclusive and one of them must be specified. This URL
                                  must be readable and listable from compute nodes. There are three
                                  ways to get such a URL for a container in Azure storage: include a
                                  Shared Access Signature (SAS) granting read and list permissions on
                                  the container, use a managed identity with read and list permissions,
                                  or set the ACL for the container to allow public access.
                            }
                        ],
                        "runExclusive": bool,  # Optional. Whether the Job Manager Task
                          requires exclusive use of the Compute Node where it runs. If true, no other
                          Tasks will run on the same Node for as long as the Job Manager is running. If
                          false, other Tasks can run simultaneously with the Job Manager on a Compute
                          Node. The Job Manager Task counts normally against the Compute Node's
                          concurrent Task limit, so this is only relevant if the Compute Node allows
                          multiple concurrent Tasks. The default value is true.
                        "userIdentity": {
                            "autoUser": {
                                "elevationLevel": "str",  # Optional. The elevation
                                  level of the auto user. The default value is nonAdmin. Known values
                                  are: "nonadmin" and "admin".
                                "scope": "str"  # Optional. The scope for the auto
                                  user. The default value is pool. If the pool is running Windows, a
                                  value of Task should be specified if stricter isolation between tasks
                                  is required, such as if the task mutates the registry in a way which
                                  could impact other tasks. Known values are: "task" and "pool".
                            },
                            "username": "str"  # Optional. The name of the user identity
                              under which the Task is run. The userName and autoUser properties are
                              mutually exclusive; you must specify one but not both.
                        }
                    },
                    "jobPreparationTask": {
                        "commandLine": "str",  # The command line of the Job Preparation
                          Task. The command line does not run under a shell, and therefore cannot take
                          advantage of shell features such as environment variable expansion. If you
                          want to take advantage of such features, you should invoke the shell in the
                          command line, for example using "cmd /c MyCommand" in Windows or "/bin/sh -c
                          MyCommand" in Linux. If the command line refers to file paths, it should use
                          a relative path (relative to the Task working directory), or use the Batch
                          provided environment variable
                          (https://docs.microsoft.com/en-us/azure/batch/batch-compute-node-environment-variables).
                          Required.
                        "constraints": {
                            "maxTaskRetryCount": 0,  # Optional. The maximum number of
                              times the Task may be retried. The Batch service retries a Task if its
                              exit code is nonzero. Note that this value specifically controls the
                              number of retries for the Task executable due to a nonzero exit code. The
                              Batch service will try the Task once, and may then retry up to this
                              limit. For example, if the maximum retry count is 3, Batch tries the Task
                              up to 4 times (one initial try and 3 retries). If the maximum retry count
                              is 0, the Batch service does not retry the Task after the first attempt.
                              If the maximum retry count is -1, the Batch service retries the Task
                              without limit, however this is not recommended for a start task or any
                              task. The default value is 0 (no retries).
                            "maxWallClockTime": "1 day, 0:00:00",  # Optional. The
                              maximum elapsed time that the Task may run, measured from the time the
                              Task starts. If the Task does not complete within the time limit, the
                              Batch service terminates it. If this is not specified, there is no time
                              limit on how long the Task may run.
                            "retentionTime": "1 day, 0:00:00"  # Optional. The minimum
                              time to retain the Task directory on the Compute Node where it ran, from
                              the time it completes execution. After this time, the Batch service may
                              delete the Task directory and all its contents. The default is 7 days,
                              i.e. the Task directory will be retained for 7 days unless the Compute
                              Node is removed or the Job is deleted.
                        },
                        "containerSettings": {
                            "imageName": "str",  # The Image to use to create the
                              container in which the Task will run. This is the full Image reference,
                              as would be specified to "docker pull". If no tag is provided as part of
                              the Image name, the tag ":latest" is used as a default. Required.
                            "containerRunOptions": "str",  # Optional. Additional options
                              to the container create command. These additional options are supplied as
                              arguments to the "docker create" command, in addition to those controlled
                              by the Batch Service.
                            "registry": {
                                "identityReference": {
                                    "resourceId": "str"  # Optional. The ARM
                                      resource id of the user assigned identity.
                                },
                                "password": "str",  # Optional. The password to log
                                  into the registry server.
                                "registryServer": "str",  # Optional. The registry
                                  URL. If omitted, the default is "docker.io".
                                "username": "str"  # Optional. The user name to log
                                  into the registry server.
                            },
                            "workingDirectory": "str"  # Optional. The location of the
                              container Task working directory. The default is 'taskWorkingDirectory'.
                              Known values are: "taskWorkingDirectory" and "containerImageDefault".
                        },
                        "environmentSettings": [
                            {
                                "name": "str",  # The name of the environment
                                  variable. Required.
                                "value": "str"  # Optional. The value of the
                                  environment variable.
                            }
                        ],
                        "id": "str",  # Optional. A string that uniquely identifies the Job
                          Preparation Task within the Job. The ID can contain any combination of
                          alphanumeric characters including hyphens and underscores and cannot contain
                          more than 64 characters. If you do not specify this property, the Batch
                          service assigns a default value of 'jobpreparation'. No other Task in the Job
                          can have the same ID as the Job Preparation Task. If you try to submit a Task
                          with the same id, the Batch service rejects the request with error code
                          TaskIdSameAsJobPreparationTask; if you are calling the REST API directly, the
                          HTTP status code is 409 (Conflict).
                        "rerunOnNodeRebootAfterSuccess": bool,  # Optional. Whether the Batch
                          service should rerun the Job Preparation Task after a Compute Node reboots.
                          The Job Preparation Task is always rerun if a Compute Node is reimaged, or if
                          the Job Preparation Task did not complete (e.g. because the reboot occurred
                          while the Task was running). Therefore, you should always write a Job
                          Preparation Task to be idempotent and to behave correctly if run multiple
                          times. The default value is true.
                        "resourceFiles": [
                            {
                                "autoStorageContainerName": "str",  # Optional. The
                                  storage container name in the auto storage Account. The
                                  autoStorageContainerName, storageContainerUrl and httpUrl properties
                                  are mutually exclusive and one of them must be specified.
                                "blobPrefix": "str",  # Optional. The blob prefix to
                                  use when downloading blobs from an Azure Storage container. Only the
                                  blobs whose names begin with the specified prefix will be downloaded.
                                  The property is valid only when autoStorageContainerName or
                                  storageContainerUrl is used. This prefix can be a partial filename or
                                  a subdirectory. If a prefix is not specified, all the files in the
                                  container will be downloaded.
                                "fileMode": "str",  # Optional. The file permission
                                  mode attribute in octal format. This property applies only to files
                                  being downloaded to Linux Compute Nodes. It will be ignored if it is
                                  specified for a resourceFile which will be downloaded to a Windows
                                  Compute Node. If this property is not specified for a Linux Compute
                                  Node, then a default value of 0770 is applied to the file.
                                "filePath": "str",  # Optional. The location on the
                                  Compute Node to which to download the file(s), relative to the Task's
                                  working directory. If the httpUrl property is specified, the filePath
                                  is required and describes the path which the file will be downloaded
                                  to, including the filename. Otherwise, if the
                                  autoStorageContainerName or storageContainerUrl property is
                                  specified, filePath is optional and is the directory to download the
                                  files to. In the case where filePath is used as a directory, any
                                  directory structure already associated with the input data will be
                                  retained in full and appended to the specified filePath directory.
                                  The specified relative path cannot break out of the Task's working
                                  directory (for example by using '..').
                                "httpUrl": "str",  # Optional. The URL of the file to
                                  download. The autoStorageContainerName, storageContainerUrl and
                                  httpUrl properties are mutually exclusive and one of them must be
                                  specified. If the URL points to Azure Blob Storage, it must be
                                  readable from compute nodes. There are three ways to get such a URL
                                  for a blob in Azure storage: include a Shared Access Signature (SAS)
                                  granting read permissions on the blob, use a managed identity with
                                  read permission, or set the ACL for the blob or its container to
                                  allow public access.
                                "identityReference": {
                                    "resourceId": "str"  # Optional. The ARM
                                      resource id of the user assigned identity.
                                },
                                "storageContainerUrl": "str"  # Optional. The URL of
                                  the blob container within Azure Blob Storage. The
                                  autoStorageContainerName, storageContainerUrl and httpUrl properties
                                  are mutually exclusive and one of them must be specified. This URL
                                  must be readable and listable from compute nodes. There are three
                                  ways to get such a URL for a container in Azure storage: include a
                                  Shared Access Signature (SAS) granting read and list permissions on
                                  the container, use a managed identity with read and list permissions,
                                  or set the ACL for the container to allow public access.
                            }
                        ],
                        "userIdentity": {
                            "autoUser": {
                                "elevationLevel": "str",  # Optional. The elevation
                                  level of the auto user. The default value is nonAdmin. Known values
                                  are: "nonadmin" and "admin".
                                "scope": "str"  # Optional. The scope for the auto
                                  user. The default value is pool. If the pool is running Windows, a
                                  value of Task should be specified if stricter isolation between tasks
                                  is required, such as if the task mutates the registry in a way which
                                  could impact other tasks. Known values are: "task" and "pool".
                            },
                            "username": "str"  # Optional. The name of the user identity
                              under which the Task is run. The userName and autoUser properties are
                              mutually exclusive; you must specify one but not both.
                        },
                        "waitForSuccess": bool  # Optional. Whether the Batch service should
                          wait for the Job Preparation Task to complete successfully before scheduling
                          any other Tasks of the Job on the Compute Node. A Job Preparation Task has
                          completed successfully if it exits with exit code 0. If true and the Job
                          Preparation Task fails on a Node, the Batch service retries the Job
                          Preparation Task up to its maximum retry count (as specified in the
                          constraints element). If the Task has still not completed successfully after
                          all retries, then the Batch service will not schedule Tasks of the Job to the
                          Node. The Node remains active and eligible to run Tasks of other Jobs. If
                          false, the Batch service will not wait for the Job Preparation Task to
                          complete. In this case, other Tasks of the Job can start executing on the
                          Compute Node while the Job Preparation Task is still running; and even if the
                          Job Preparation Task fails, new Tasks will continue to be scheduled on the
                          Compute Node. The default value is true.
                    },
                    "jobReleaseTask": {
                        "commandLine": "str",  # The command line of the Job Release Task.
                          The command line does not run under a shell, and therefore cannot take
                          advantage of shell features such as environment variable expansion. If you
                          want to take advantage of such features, you should invoke the shell in the
                          command line, for example using "cmd /c MyCommand" in Windows or "/bin/sh -c
                          MyCommand" in Linux. If the command line refers to file paths, it should use
                          a relative path (relative to the Task working directory), or use the Batch
                          provided environment variable
                          (https://docs.microsoft.com/en-us/azure/batch/batch-compute-node-environment-variables).
                          Required.
                        "containerSettings": {
                            "imageName": "str",  # The Image to use to create the
                              container in which the Task will run. This is the full Image reference,
                              as would be specified to "docker pull". If no tag is provided as part of
                              the Image name, the tag ":latest" is used as a default. Required.
                            "containerRunOptions": "str",  # Optional. Additional options
                              to the container create command. These additional options are supplied as
                              arguments to the "docker create" command, in addition to those controlled
                              by the Batch Service.
                            "registry": {
                                "identityReference": {
                                    "resourceId": "str"  # Optional. The ARM
                                      resource id of the user assigned identity.
                                },
                                "password": "str",  # Optional. The password to log
                                  into the registry server.
                                "registryServer": "str",  # Optional. The registry
                                  URL. If omitted, the default is "docker.io".
                                "username": "str"  # Optional. The user name to log
                                  into the registry server.
                            },
                            "workingDirectory": "str"  # Optional. The location of the
                              container Task working directory. The default is 'taskWorkingDirectory'.
                              Known values are: "taskWorkingDirectory" and "containerImageDefault".
                        },
                        "environmentSettings": [
                            {
                                "name": "str",  # The name of the environment
                                  variable. Required.
                                "value": "str"  # Optional. The value of the
                                  environment variable.
                            }
                        ],
                        "id": "str",  # Optional. A string that uniquely identifies the Job
                          Release Task within the Job. The ID can contain any combination of
                          alphanumeric characters including hyphens and underscores and cannot contain
                          more than 64 characters. If you do not specify this property, the Batch
                          service assigns a default value of 'jobrelease'. No other Task in the Job can
                          have the same ID as the Job Release Task. If you try to submit a Task with
                          the same id, the Batch service rejects the request with error code
                          TaskIdSameAsJobReleaseTask; if you are calling the REST API directly, the
                          HTTP status code is 409 (Conflict).
                        "maxWallClockTime": "1 day, 0:00:00",  # Optional. The maximum
                          elapsed time that the Job Release Task may run on a given Compute Node,
                          measured from the time the Task starts. If the Task does not complete within
                          the time limit, the Batch service terminates it. The default value is 15
                          minutes. You may not specify a timeout longer than 15 minutes. If you do, the
                          Batch service rejects it with an error; if you are calling the REST API
                          directly, the HTTP status code is 400 (Bad Request).
                        "resourceFiles": [
                            {
                                "autoStorageContainerName": "str",  # Optional. The
                                  storage container name in the auto storage Account. The
                                  autoStorageContainerName, storageContainerUrl and httpUrl properties
                                  are mutually exclusive and one of them must be specified.
                                "blobPrefix": "str",  # Optional. The blob prefix to
                                  use when downloading blobs from an Azure Storage container. Only the
                                  blobs whose names begin with the specified prefix will be downloaded.
                                  The property is valid only when autoStorageContainerName or
                                  storageContainerUrl is used. This prefix can be a partial filename or
                                  a subdirectory. If a prefix is not specified, all the files in the
                                  container will be downloaded.
                                "fileMode": "str",  # Optional. The file permission
                                  mode attribute in octal format. This property applies only to files
                                  being downloaded to Linux Compute Nodes. It will be ignored if it is
                                  specified for a resourceFile which will be downloaded to a Windows
                                  Compute Node. If this property is not specified for a Linux Compute
                                  Node, then a default value of 0770 is applied to the file.
                                "filePath": "str",  # Optional. The location on the
                                  Compute Node to which to download the file(s), relative to the Task's
                                  working directory. If the httpUrl property is specified, the filePath
                                  is required and describes the path which the file will be downloaded
                                  to, including the filename. Otherwise, if the
                                  autoStorageContainerName or storageContainerUrl property is
                                  specified, filePath is optional and is the directory to download the
                                  files to. In the case where filePath is used as a directory, any
                                  directory structure already associated with the input data will be
                                  retained in full and appended to the specified filePath directory.
                                  The specified relative path cannot break out of the Task's working
                                  directory (for example by using '..').
                                "httpUrl": "str",  # Optional. The URL of the file to
                                  download. The autoStorageContainerName, storageContainerUrl and
                                  httpUrl properties are mutually exclusive and one of them must be
                                  specified. If the URL points to Azure Blob Storage, it must be
                                  readable from compute nodes. There are three ways to get such a URL
                                  for a blob in Azure storage: include a Shared Access Signature (SAS)
                                  granting read permissions on the blob, use a managed identity with
                                  read permission, or set the ACL for the blob or its container to
                                  allow public access.
                                "identityReference": {
                                    "resourceId": "str"  # Optional. The ARM
                                      resource id of the user assigned identity.
                                },
                                "storageContainerUrl": "str"  # Optional. The URL of
                                  the blob container within Azure Blob Storage. The
                                  autoStorageContainerName, storageContainerUrl and httpUrl properties
                                  are mutually exclusive and one of them must be specified. This URL
                                  must be readable and listable from compute nodes. There are three
                                  ways to get such a URL for a container in Azure storage: include a
                                  Shared Access Signature (SAS) granting read and list permissions on
                                  the container, use a managed identity with read and list permissions,
                                  or set the ACL for the container to allow public access.
                            }
                        ],
                        "retentionTime": "1 day, 0:00:00",  # Optional. The minimum time to
                          retain the Task directory for the Job Release Task on the Compute Node. After
                          this time, the Batch service may delete the Task directory and all its
                          contents. The default is 7 days, i.e. the Task directory will be retained for
                          7 days unless the Compute Node is removed or the Job is deleted.
                        "userIdentity": {
                            "autoUser": {
                                "elevationLevel": "str",  # Optional. The elevation
                                  level of the auto user. The default value is nonAdmin. Known values
                                  are: "nonadmin" and "admin".
                                "scope": "str"  # Optional. The scope for the auto
                                  user. The default value is pool. If the pool is running Windows, a
                                  value of Task should be specified if stricter isolation between tasks
                                  is required, such as if the task mutates the registry in a way which
                                  could impact other tasks. Known values are: "task" and "pool".
                            },
                            "username": "str"  # Optional. The name of the user identity
                              under which the Task is run. The userName and autoUser properties are
                              mutually exclusive; you must specify one but not both.
                        }
                    },
                    "lastModified": "2020-02-20 00:00:00",  # Optional. The last modified time of
                      the Job. This is the last time at which the Job level data, such as the Job state
                      or priority, changed. It does not factor in task-level changes such as adding new
                      Tasks or Tasks changing state.
                    "maxParallelTasks": 0,  # Optional. The maximum number of tasks that can be
                      executed in parallel for the job. The value of maxParallelTasks must be -1 or
                      greater than 0 if specified. If not specified, the default value is -1, which
                      means there's no limit to the number of tasks that can be run at once. You can
                      update a job's maxParallelTasks after it has been created using the update job
                      API.
                    "metadata": [
                        {
                            "name": "str",  # The name of the metadata item. Required.
                            "value": "str"  # The value of the metadata item. Required.
                        }
                    ],
                    "networkConfiguration": {
                        "subnetId": "str"  # The ARM resource identifier of the virtual
                          network subnet which Compute Nodes running Tasks from the Job will join for
                          the duration of the Task. This will only work with a
                          VirtualMachineConfiguration Pool. The virtual network must be in the same
                          region and subscription as the Azure Batch Account. The specified subnet
                          should have enough free IP addresses to accommodate the number of Compute
                          Nodes which will run Tasks from the Job. This can be up to the number of
                          Compute Nodes in the Pool. The 'MicrosoftAzureBatch' service principal must
                          have the 'Classic Virtual Machine Contributor' Role-Based Access Control
                          (RBAC) role for the specified VNet so that Azure Batch service can schedule
                          Tasks on the Nodes. This can be verified by checking if the specified VNet
                          has any associated Network Security Groups (NSG). If communication to the
                          Nodes in the specified subnet is denied by an NSG, then the Batch service
                          will set the state of the Compute Nodes to unusable. This is of the form
                          /subscriptions/{subscription}/resourceGroups/{group}/providers/{provider}/virtualNetworks/{network}/subnets/{subnet}.
                          If the specified VNet has any associated Network Security Groups (NSG), then
                          a few reserved system ports must be enabled for inbound communication from
                          the Azure Batch service. For Pools created with a Virtual Machine
                          configuration, enable ports 29876 and 29877, as well as port 22 for Linux and
                          port 3389 for Windows. Port 443 is also required to be open for outbound
                          connections for communications to Azure Storage. For more details see:
                          https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration.
                          Required.
                    },
                    "onAllTasksComplete": "str",  # Optional. The action the Batch service should
                      take when all Tasks in the Job are in the completed state. The default is
                      noaction. Known values are: "noaction" and "terminatejob".
                    "onTaskFailure": "str",  # Optional. The action the Batch service should take
                      when any Task in the Job fails. A Task is considered to have failed if has a
                      failureInfo. A failureInfo is set if the Task completes with a non-zero exit code
                      after exhausting its retry count, or if there was an error starting the Task, for
                      example due to a resource file download error. The default is noaction. Known
                      values are: "noaction" and "performexitoptionsjobaction".
                    "previousState": "str",  # Optional. The previous state of the Job. This
                      property is not set if the Job is in its initial Active state. Known values are:
                      "active", "disabling", "disabled", "enabling", "terminating", "completed", and
                      "deleting".
                    "previousStateTransitionTime": "2020-02-20 00:00:00",  # Optional. The time
                      at which the Job entered its previous state. This property is not set if the Job
                      is in its initial Active state.
                    "priority": 0,  # Optional. The priority of the Job. Priority values can
                      range from -1000 to 1000, with -1000 being the lowest priority and 1000 being the
                      highest priority. The default value is 0.
                    "state": "str",  # Optional. The current state of the Job. Known values are:
                      "active", "disabling", "disabled", "enabling", "terminating", "completed", and
                      "deleting".
                    "stateTransitionTime": "2020-02-20 00:00:00",  # Optional. The time at which
                      the Job entered its current state.
                    "stats": {
                        "kernelCPUTime": "1 day, 0:00:00",  # The total kernel mode CPU time
                          (summed across all cores and all Compute Nodes) consumed by all Tasks in the
                          Job. Required.
                        "lastUpdateTime": "2020-02-20 00:00:00",  # The time at which the
                          statistics were last updated. All statistics are limited to the range between
                          startTime and lastUpdateTime. Required.
                        "numFailedTasks": 0,  # The total number of Tasks in the Job that
                          failed during the given time range. A Task fails if it exhausts its maximum
                          retry count without returning exit code 0. Required.
                        "numSucceededTasks": 0,  # The total number of Tasks successfully
                          completed in the Job during the given time range. A Task completes
                          successfully if it returns exit code 0. Required.
                        "numTaskRetries": 0,  # The total number of retries on all the Tasks
                          in the Job during the given time range. Required.
                        "readIOGiB": 0.0,  # The total amount of data in GiB read from disk
                          by all Tasks in the Job. Required.
                        "readIOps": 0,  # The total number of disk read operations made by
                          all Tasks in the Job. Required.
                        "startTime": "2020-02-20 00:00:00",  # The start time of the time
                          range covered by the statistics. Required.
                        "url": "str",  # The URL of the statistics. Required.
                        "userCPUTime": "1 day, 0:00:00",  # The total user mode CPU time
                          (summed across all cores and all Compute Nodes) consumed by all Tasks in the
                          Job. Required.
                        "waitTime": "1 day, 0:00:00",  # The total wait time of all Tasks in
                          the Job. The wait time for a Task is defined as the elapsed time between the
                          creation of the Task and the start of Task execution. (If the Task is retried
                          due to failures, the wait time is the time to the most recent Task
                          execution.) This value is only reported in the Account lifetime statistics;
                          it is not included in the Job statistics. Required.
                        "wallClockTime": "1 day, 0:00:00",  # The total wall clock time of
                          all Tasks in the Job.  The wall clock time is the elapsed time from when the
                          Task started running on a Compute Node to when it finished (or to the last
                          time the statistics were updated, if the Task had not finished by then). If a
                          Task was retried, this includes the wall clock time of all the Task retries.
                          Required.
                        "writeIOGiB": 0.0,  # The total amount of data in GiB written to disk
                          by all Tasks in the Job. Required.
                        "writeIOps": 0  # The total number of disk write operations made by
                          all Tasks in the Job. Required.
                    },
                    "url": "str",  # Optional. The URL of the Job.
                    "usesTaskDependencies": bool  # Optional. Whether Tasks in the Job can define
                      dependencies on each other. The default is false.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.BatchJob] = kwargs.pop("cls", None)

        _request = build_batch_get_job_request(
            job_id=job_id,
            time_out_in_seconds=time_out_in_seconds,
            ocpdate=ocpdate,
            if_modified_since=if_modified_since,
            if_unmodified_since=if_unmodified_since,
            select=select,
            expand=expand,
            etag=etag,
            match_condition=match_condition,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.BatchError, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.BatchJob, response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def update_job(  # pylint: disable=inconsistent-return-statements
        self,
        job_id: str,
        job: _models.BatchJobUpdateContent,
        *,
        time_out_in_seconds: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        if_modified_since: Optional[datetime.datetime] = None,
        if_unmodified_since: Optional[datetime.datetime] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> None:
        # pylint: disable=line-too-long
        """Updates the properties of the specified Job.

        This replaces only the Job properties specified in the request. For example, if
        the Job has constraints, and a request does not specify the constraints
        element, then the Job keeps the existing constraints.

        :param job_id: The ID of the Job whose properties you want to update. Required.
        :type job_id: str
        :param job: The options to use for updating the Job. Required.
        :type job: ~azure.batch.models.BatchJobUpdateContent
        :keyword time_out_in_seconds: The maximum time that the server can spend processing the
         request, in seconds. The default is 30 seconds. If the value is larger than 30, the default
         will be used instead.". Default value is None.
        :paramtype time_out_in_seconds: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword if_modified_since: A timestamp indicating the last modified time of the resource known
         to the
         client. The operation will be performed only if the resource on the service has
         been modified since the specified time. Default value is None.
        :paramtype if_modified_since: ~datetime.datetime
        :keyword if_unmodified_since: A timestamp indicating the last modified time of the resource
         known to the
         client. The operation will be performed only if the resource on the service has
         not been modified since the specified time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                job = {
                    "allowTaskPreemption": bool,  # Optional. Whether Tasks in this job can be
                      preempted by other high priority jobs. If the value is set to True, other high
                      priority jobs submitted to the system will take precedence and will be able
                      requeue tasks from this job. You can update a job's allowTaskPreemption after it
                      has been created using the update job API.
                    "constraints": {
                        "maxTaskRetryCount": 0,  # Optional. The maximum number of times each
                          Task may be retried. The Batch service retries a Task if its exit code is
                          nonzero. Note that this value specifically controls the number of retries.
                          The Batch service will try each Task once, and may then retry up to this
                          limit. For example, if the maximum retry count is 3, Batch tries a Task up to
                          4 times (one initial try and 3 retries). If the maximum retry count is 0, the
                          Batch service does not retry Tasks. If the maximum retry count is -1, the
                          Batch service retries Tasks without limit. The default value is 0 (no
                          retries).
                        "maxWallClockTime": "1 day, 0:00:00"  # Optional. The maximum elapsed
                          time that the Job may run, measured from the time the Job is created. If the
                          Job does not complete within the time limit, the Batch service terminates it
                          and any Tasks that are still running. In this case, the termination reason
                          will be MaxWallClockTimeExpiry. If this property is not specified, there is
                          no time limit on how long the Job may run.
                    },
                    "maxParallelTasks": 0,  # Optional. The maximum number of tasks that can be
                      executed in parallel for the job. The value of maxParallelTasks must be -1 or
                      greater than 0 if specified. If not specified, the default value is -1, which
                      means there's no limit to the number of tasks that can be run at once. You can
                      update a job's maxParallelTasks after it has been created using the update job
                      API.
                    "metadata": [
                        {
                            "name": "str",  # The name of the metadata item. Required.
                            "value": "str"  # The value of the metadata item. Required.
                        }
                    ],
                    "onAllTasksComplete": "str",  # Optional. The action the Batch service should
                      take when all Tasks in the Job are in the completed state. If omitted, the
                      completion behavior is left unchanged. You may not change the value from
                      terminatejob to noaction - that is, once you have engaged automatic Job
                      termination, you cannot turn it off again. If you try to do this, the request
                      fails with an 'invalid property value' error response; if you are calling the
                      REST API directly, the HTTP status code is 400 (Bad Request). Known values are:
                      "noaction" and "terminatejob".
                    "poolInfo": {
                        "autoPoolSpecification": {
                            "poolLifetimeOption": "str",  # The minimum lifetime of
                              created auto Pools, and how multiple Jobs on a schedule are assigned to
                              Pools. Required. Known values are: "jobschedule" and "job".
                            "autoPoolIdPrefix": "str",  # Optional. A prefix to be added
                              to the unique identifier when a Pool is automatically created. The Batch
                              service assigns each auto Pool a unique identifier on creation. To
                              distinguish between Pools created for different purposes, you can specify
                              this element to add a prefix to the ID that is assigned. The prefix can
                              be up to 20 characters long.
                            "keepAlive": bool,  # Optional. Whether to keep an auto Pool
                              alive after its lifetime expires. If false, the Batch service deletes the
                              Pool once its lifetime (as determined by the poolLifetimeOption setting)
                              expires; that is, when the Job or Job Schedule completes. If true, the
                              Batch service does not delete the Pool automatically. It is up to the
                              user to delete auto Pools created with this option.
                            "pool": {
                                "vmSize": "str",  # The size of the virtual machines
                                  in the Pool. All virtual machines in a Pool are the same size. For
                                  information about available sizes of virtual machines in Pools, see
                                  Choose a VM size for Compute Nodes in an Azure Batch Pool
                                  (https://docs.microsoft.com/azure/batch/batch-pool-vm-sizes).
                                  Required.
                                "applicationPackageReferences": [
                                    {
                                        "applicationId": "str",  # The ID of
                                          the application to deploy. When creating a pool, the
                                          package's application ID must be fully qualified
                                          (/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/applications/{applicationName}).
                                          Required.
                                        "version": "str"  # Optional. The
                                          version of the application to deploy. If omitted, the default
                                          version is deployed. If this is omitted on a Pool, and no
                                          default version is specified for this application, the
                                          request fails with the error code
                                          InvalidApplicationPackageReferences and HTTP status code 409.
                                          If this is omitted on a Task, and no default version is
                                          specified for this application, the Task fails with a
                                          pre-processing error.
                                    }
                                ],
                                "autoScaleEvaluationInterval": "1 day, 0:00:00",  #
                                  Optional. The time interval at which to automatically adjust the Pool
                                  size according to the autoscale formula. The default value is 15
                                  minutes. The minimum and maximum value are 5 minutes and 168 hours
                                  respectively. If you specify a value less than 5 minutes or greater
                                  than 168 hours, the Batch service rejects the request with an invalid
                                  property value error; if you are calling the REST API directly, the
                                  HTTP status code is 400 (Bad Request).
                                "autoScaleFormula": "str",  # Optional. The formula
                                  for the desired number of Compute Nodes in the Pool. This property
                                  must not be specified if enableAutoScale is set to false. It is
                                  required if enableAutoScale is set to true. The formula is checked
                                  for validity before the Pool is created. If the formula is not valid,
                                  the Batch service rejects the request with detailed error
                                  information.
                                "displayName": "str",  # Optional. The display name
                                  for the Pool. The display name need not be unique and can contain any
                                  Unicode characters up to a maximum length of 1024.
                                "enableAutoScale": bool,  # Optional. Whether the
                                  Pool size should automatically adjust over time. If false, at least
                                  one of targetDedicatedNodes and targetLowPriorityNodes must be
                                  specified. If true, the autoScaleFormula element is required. The
                                  Pool automatically resizes according to the formula. The default
                                  value is false.
                                "enableInterNodeCommunication": bool,  # Optional.
                                  Whether the Pool permits direct communication between Compute Nodes.
                                  Enabling inter-node communication limits the maximum size of the Pool
                                  due to deployment restrictions on the Compute Nodes of the Pool. This
                                  may result in the Pool not reaching its desired size. The default
                                  value is false.
                                "metadata": [
                                    {
                                        "name": "str",  # The name of the
                                          metadata item. Required.
                                        "value": "str"  # The value of the
                                          metadata item. Required.
                                    }
                                ],
                                "mountConfiguration": [
                                    {
                                        "azureBlobFileSystemConfiguration": {
                                            "accountName": "str",  # The
                                              Azure Storage Account name. Required.
                                            "containerName": "str",  #
                                              The Azure Blob Storage Container name. Required.
                                            "relativeMountPath": "str",
                                              # The relative path on the compute node where the file
                                              system will be mounted. All file systems are mounted
                                              relative to the Batch mounts directory, accessible via
                                              the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
                                              Required.
                                            "accountKey": "str",  #
                                              Optional. The Azure Storage Account key. This property is
                                              mutually exclusive with both sasKey and identity; exactly
                                              one must be specified.
                                            "blobfuseOptions": "str",  #
                                              Optional. Additional command line options to pass to the
                                              mount command. These are 'net use' options in Windows and
                                              'mount' options in Linux.
                                            "identityReference": {
                                                "resourceId": "str"
                                                  # Optional. The ARM resource id of the user assigned
                                                  identity.
                                            },
                                            "sasKey": "str"  # Optional.
                                              The Azure Storage SAS token. This property is mutually
                                              exclusive with both accountKey and identity; exactly one
                                              must be specified.
                                        },
                                        "azureFileShareConfiguration": {
                                            "accountKey": "str",  # The
                                              Azure Storage account key. Required.
                                            "accountName": "str",  # The
                                              Azure Storage account name. Required.
                                            "azureFileUrl": "str",  # The
                                              Azure Files URL. This is of the form
                                              'https://{account}.file.core.windows.net/'. Required.
                                            "relativeMountPath": "str",
                                              # The relative path on the compute node where the file
                                              system will be mounted. All file systems are mounted
                                              relative to the Batch mounts directory, accessible via
                                              the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
                                              Required.
                                            "mountOptions": "str"  #
                                              Optional. Additional command line options to pass to the
                                              mount command. These are 'net use' options in Windows and
                                              'mount' options in Linux.
                                        },
                                        "cifsMountConfiguration": {
                                            "password": "str",  # The
                                              password to use for authentication against the CIFS file
                                              system. Required.
                                            "relativeMountPath": "str",
                                              # The relative path on the compute node where the file
                                              system will be mounted. All file systems are mounted
                                              relative to the Batch mounts directory, accessible via
                                              the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
                                              Required.
                                            "source": "str",  # The URI
                                              of the file system to mount. Required.
                                            "username": "str",  # The
                                              user to use for authentication against the CIFS file
                                              system. Required.
                                            "mountOptions": "str"  #
                                              Optional. Additional command line options to pass to the
                                              mount command. These are 'net use' options in Windows and
                                              'mount' options in Linux.
                                        },
                                        "nfsMountConfiguration": {
                                            "relativeMountPath": "str",
                                              # The relative path on the compute node where the file
                                              system will be mounted. All file systems are mounted
                                              relative to the Batch mounts directory, accessible via
                                              the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
                                              Required.
                                            "source": "str",  # The URI
                                              of the file system to mount. Required.
                                            "mountOptions": "str"  #
                                              Optional. Additional command line options to pass to the
                                              mount command. These are 'net use' options in Windows and
                                              'mount' options in Linux.
                                        }
                                    }
                                ],
                                "networkConfiguration": {
                                    "dynamicVNetAssignmentScope": "str",  #
                                      Optional. The scope of dynamic vnet assignment. Known values are:
                                      "none" and "job".
                                    "enableAcceleratedNetworking": bool,  #
                                      Optional. Whether this pool should enable accelerated networking.
                                      Accelerated networking enables single root I/O virtualization
                                      (SR-IOV) to a VM, which may lead to improved networking
                                      performance. For more details, see:
                                      https://learn.microsoft.com/azure/virtual-network/accelerated-networking-overview.
                                    "endpointConfiguration": {
                                        "inboundNATPools": [
                                            {
                                                "backendPort": 0,  #
                                                  The port number on the Compute Node. This must be
                                                  unique within a Batch Pool. Acceptable values are
                                                  between 1 and 65535 except for 22, 3389, 29876 and
                                                  29877 as these are reserved. If any reserved values
                                                  are provided the request fails with HTTP status code
                                                  400. Required.
                "frontendPortRangeEnd": 0,  # The last port number in
                                                  the range of external ports that will be used to
                                                  provide inbound access to the backendPort on
                                                  individual Compute Nodes. Acceptable values range
                                                  between 1 and 65534 except ports from 50000 to 55000
                                                  which are reserved by the Batch service. All ranges
                                                  within a Pool must be distinct and cannot overlap.
                                                  Each range must contain at least 40 ports. If any
                                                  reserved or overlapping values are provided the
                                                  request fails with HTTP status code 400. Required.
                "frontendPortRangeStart": 0,  # The first port number
                                                  in the range of external ports that will be used to
                                                  provide inbound access to the backendPort on
                                                  individual Compute Nodes. Acceptable values range
                                                  between 1 and 65534 except ports from 50000 to 55000
                                                  which are reserved. All ranges within a Pool must be
                                                  distinct and cannot overlap. Each range must contain
                                                  at least 40 ports. If any reserved or overlapping
                                                  values are provided the request fails with HTTP
                                                  status code 400. Required.
                                                "name": "str",  # The
                                                  name of the endpoint. The name must be unique within
                                                  a Batch Pool, can contain letters, numbers,
                                                  underscores, periods, and hyphens. Names must start
                                                  with a letter or number, must end with a letter,
                                                  number, or underscore, and cannot exceed 77
                                                  characters.  If any invalid values are provided the
                                                  request fails with HTTP status code 400. Required.
                                                "protocol": "str",  #
                                                  The protocol of the endpoint. Required. Known values
                                                  are: "tcp" and "udp".
                "networkSecurityGroupRules": [
                                                    {
                "access": "str",  # The action that should be
                                                          taken for a specified IP address, subnet
                                                          range or tag. Required. Known values are:
                                                          "allow" and "deny".
                "priority": 0,  # The priority for this rule.
                                                          Priorities within a Pool must be unique and
                                                          are evaluated in order of priority. The lower
                                                          the number the higher the priority. For
                                                          example, rules could be specified with order
                                                          numbers of 150, 250, and 350. The rule with
                                                          the order number of 150 takes precedence over
                                                          the rule that has an order of 250. Allowed
                                                          priorities are 150 to 4096. If any reserved
                                                          or duplicate values are provided the request
                                                          fails with HTTP status code 400. Required.
                "sourceAddressPrefix": "str",  # The source
                                                          address prefix or tag to match for the rule.
                                                          Valid values are a single IP address (i.e.
                                                          10.10.10.10), IP subnet (i.e.
                                                          192.168.1.0/24), default tag, or * (for all
                                                          addresses).  If any other values are provided
                                                          the request fails with HTTP status code 400.
                                                          Required.
                "sourcePortRanges": [
                "str"  # Optional. The source port ranges
                                                              to match for the rule. Valid values are
                                                              '"" *' (for all ports 0 - 65535), a
                                                              specific port (i.e. 22), or a port range
                                                              (i.e. 100-200). The ports must be in the
                                                              range of 0 to 65535. Each entry in this
                                                              collection must not overlap any other
                                                              entry (either a range or an individual
                                                              port). If any other values are provided
                                                              the request fails with HTTP status code
                                                              400. The default value is '*"" '.
                                                        ]
                                                    }
                                                ]
                                            }
                                        ]
                                    },
                                    "publicIPAddressConfiguration": {
                                        "ipAddressIds": [
                                            "str"  # Optional. The list
                                              of public IPs which the Batch service will use when
                                              provisioning Compute Nodes. The number of IPs specified
                                              here limits the maximum size of the Pool - 100 dedicated
                                              nodes or 100 Spot/Low-priority nodes can be allocated for
                                              each public IP. For example, a pool needing 250 dedicated
                                              VMs would need at least 3 public IPs specified. Each
                                              element of this collection is of the form:
                                              /subscriptions/{subscription}/resourceGroups/{group}/providers/Microsoft.Network/publicIPAddresses/{ip}.
                                        ],
                                        "provision": "str"  # Optional. The
                                          provisioning type for Public IP Addresses for the Pool. The
                                          default value is BatchManaged. Known values are:
                                          "batchmanaged", "usermanaged", and "nopublicipaddresses".
                                    },
                                    "subnetId": "str"  # Optional. The ARM
                                      resource identifier of the virtual network subnet which the
                                      Compute Nodes of the Pool will join. This is of the form
                                      /subscriptions/{subscription}/resourceGroups/{group}/providers/{provider}/virtualNetworks/{network}/subnets/{subnet}.
                                      The virtual network must be in the same region and subscription
                                      as the Azure Batch Account. The specified subnet should have
                                      enough free IP addresses to accommodate the number of Compute
                                      Nodes in the Pool. If the subnet doesn't have enough free IP
                                      addresses, the Pool will partially allocate Nodes and a resize
                                      error will occur. The 'MicrosoftAzureBatch' service principal
                                      must have the 'Classic Virtual Machine Contributor' Role-Based
                                      Access Control (RBAC) role for the specified VNet. The specified
                                      subnet must allow communication from the Azure Batch service to
                                      be able to schedule Tasks on the Nodes. This can be verified by
                                      checking if the specified VNet has any associated Network
                                      Security Groups (NSG). If communication to the Nodes in the
                                      specified subnet is denied by an NSG, then the Batch service will
                                      set the state of the Compute Nodes to unusable. For Pools created
                                      with virtualMachineConfiguration only ARM virtual networks
                                      ('Microsoft.Network/virtualNetworks') are supported. If the
                                      specified VNet has any associated Network Security Groups (NSG),
                                      then a few reserved system ports must be enabled for inbound
                                      communication. For Pools created with a virtual machine
                                      configuration, enable ports 29876 and 29877, as well as port 22
                                      for Linux and port 3389 for Windows. Also enable outbound
                                      connections to Azure Storage on port 443. For more details see:
                                      https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration.
                                },
                                "resizeTimeout": "1 day, 0:00:00",  # Optional. The
                                  timeout for allocation of Compute Nodes to the Pool. This timeout
                                  applies only to manual scaling; it has no effect when enableAutoScale
                                  is set to true. The default value is 15 minutes. The minimum value is
                                  5 minutes. If you specify a value less than 5 minutes, the Batch
                                  service rejects the request with an error; if you are calling the
                                  REST API directly, the HTTP status code is 400 (Bad Request).
                                "resourceTags": "str",  # Optional. The
                                  user-specified tags associated with the pool.The user-defined tags to
                                  be associated with the Azure Batch Pool. When specified, these tags
                                  are propagated to the backing Azure resources associated with the
                                  pool. This property can only be specified when the Batch account was
                                  created with the poolAllocationMode property set to
                                  'UserSubscription'.
                                "startTask": {
                                    "commandLine": "str",  # The command line of
                                      the StartTask. The command line does not run under a shell, and
                                      therefore cannot take advantage of shell features such as
                                      environment variable expansion. If you want to take advantage of
                                      such features, you should invoke the shell in the command line,
                                      for example using "cmd /c MyCommand" in Windows or "/bin/sh -c
                                      MyCommand" in Linux. If the command line refers to file paths, it
                                      should use a relative path (relative to the Task working
                                      directory), or use the Batch provided environment variable
                                      (https://docs.microsoft.com/en-us/azure/batch/batch-compute-node-environment-variables).
                                      Required.
                                    "containerSettings": {
                                        "imageName": "str",  # The Image to
                                          use to create the container in which the Task will run. This
                                          is the full Image reference, as would be specified to "docker
                                          pull". If no tag is provided as part of the Image name, the
                                          tag ":latest" is used as a default. Required.
                                        "containerRunOptions": "str",  #
                                          Optional. Additional options to the container create command.
                                          These additional options are supplied as arguments to the
                                          "docker create" command, in addition to those controlled by
                                          the Batch Service.
                                        "registry": {
                                            "identityReference": {
                                                "resourceId": "str"
                                                  # Optional. The ARM resource id of the user assigned
                                                  identity.
                                            },
                                            "password": "str",  #
                                              Optional. The password to log into the registry server.
                                            "registryServer": "str",  #
                                              Optional. The registry URL. If omitted, the default is
                                              "docker.io".
                                            "username": "str"  #
                                              Optional. The user name to log into the registry server.
                                        },
                                        "workingDirectory": "str"  #
                                          Optional. The location of the container Task working
                                          directory. The default is 'taskWorkingDirectory'. Known
                                          values are: "taskWorkingDirectory" and
                                          "containerImageDefault".
                                    },
                                    "environmentSettings": [
                                        {
                                            "name": "str",  # The name of
                                              the environment variable. Required.
                                            "value": "str"  # Optional.
                                              The value of the environment variable.
                                        }
                                    ],
                                    "maxTaskRetryCount": 0,  # Optional. The
                                      maximum number of times the Task may be retried. The Batch
                                      service retries a Task if its exit code is nonzero. Note that
                                      this value specifically controls the number of retries. The Batch
                                      service will try the Task once, and may then retry up to this
                                      limit. For example, if the maximum retry count is 3, Batch tries
                                      the Task up to 4 times (one initial try and 3 retries). If the
                                      maximum retry count is 0, the Batch service does not retry the
                                      Task. If the maximum retry count is -1, the Batch service retries
                                      the Task without limit, however this is not recommended for a
                                      start task or any task. The default value is 0 (no retries).
                                    "resourceFiles": [
                                        {
                                            "autoStorageContainerName":
                                              "str",  # Optional. The storage container name in the
                                              auto storage Account. The autoStorageContainerName,
                                              storageContainerUrl and httpUrl properties are mutually
                                              exclusive and one of them must be specified.
                                            "blobPrefix": "str",  #
                                              Optional. The blob prefix to use when downloading blobs
                                              from an Azure Storage container. Only the blobs whose
                                              names begin with the specified prefix will be downloaded.
                                              The property is valid only when autoStorageContainerName
                                              or storageContainerUrl is used. This prefix can be a
                                              partial filename or a subdirectory. If a prefix is not
                                              specified, all the files in the container will be
                                              downloaded.
                                            "fileMode": "str",  #
                                              Optional. The file permission mode attribute in octal
                                              format. This property applies only to files being
                                              downloaded to Linux Compute Nodes. It will be ignored if
                                              it is specified for a resourceFile which will be
                                              downloaded to a Windows Compute Node. If this property is
                                              not specified for a Linux Compute Node, then a default
                                              value of 0770 is applied to the file.
                                            "filePath": "str",  #
                                              Optional. The location on the Compute Node to which to
                                              download the file(s), relative to the Task's working
                                              directory. If the httpUrl property is specified, the
                                              filePath is required and describes the path which the
                                              file will be downloaded to, including the filename.
                                              Otherwise, if the autoStorageContainerName or
                                              storageContainerUrl property is specified, filePath is
                                              optional and is the directory to download the files to.
                                              In the case where filePath is used as a directory, any
                                              directory structure already associated with the input
                                              data will be retained in full and appended to the
                                              specified filePath directory. The specified relative path
                                              cannot break out of the Task's working directory (for
                                              example by using '..').
                                            "httpUrl": "str",  #
                                              Optional. The URL of the file to download. The
                                              autoStorageContainerName, storageContainerUrl and httpUrl
                                              properties are mutually exclusive and one of them must be
                                              specified. If the URL points to Azure Blob Storage, it
                                              must be readable from compute nodes. There are three ways
                                              to get such a URL for a blob in Azure storage: include a
                                              Shared Access Signature (SAS) granting read permissions
                                              on the blob, use a managed identity with read permission,
                                              or set the ACL for the blob or its container to allow
                                              public access.
                                            "identityReference": {
                                                "resourceId": "str"
                                                  # Optional. The ARM resource id of the user assigned
                                                  identity.
                                            },
                                            "storageContainerUrl": "str"
                                              # Optional. The URL of the blob container within Azure
                                              Blob Storage. The autoStorageContainerName,
                                              storageContainerUrl and httpUrl properties are mutually
                                              exclusive and one of them must be specified. This URL
                                              must be readable and listable from compute nodes. There
                                              are three ways to get such a URL for a container in Azure
                                              storage: include a Shared Access Signature (SAS) granting
                                              read and list permissions on the container, use a managed
                                              identity with read and list permissions, or set the ACL
                                              for the container to allow public access.
                                        }
                                    ],
                                    "userIdentity": {
                                        "autoUser": {
                                            "elevationLevel": "str",  #
                                              Optional. The elevation level of the auto user. The
                                              default value is nonAdmin. Known values are: "nonadmin"
                                              and "admin".
                                            "scope": "str"  # Optional.
                                              The scope for the auto user. The default value is pool.
                                              If the pool is running Windows, a value of Task should be
                                              specified if stricter isolation between tasks is
                                              required, such as if the task mutates the registry in a
                                              way which could impact other tasks. Known values are:
                                              "task" and "pool".
                                        },
                                        "username": "str"  # Optional. The
                                          name of the user identity under which the Task is run. The
                                          userName and autoUser properties are mutually exclusive; you
                                          must specify one but not both.
                                    },
                                    "waitForSuccess": bool  # Optional. Whether
                                      the Batch service should wait for the StartTask to complete
                                      successfully (that is, to exit with exit code 0) before
                                      scheduling any Tasks on the Compute Node. If true and the
                                      StartTask fails on a Node, the Batch service retries the
                                      StartTask up to its maximum retry count (maxTaskRetryCount). If
                                      the Task has still not completed successfully after all retries,
                                      then the Batch service marks the Node unusable, and will not
                                      schedule Tasks to it. This condition can be detected via the
                                      Compute Node state and failure info details. If false, the Batch
                                      service will not wait for the StartTask to complete. In this
                                      case, other Tasks can start executing on the Compute Node while
                                      the StartTask is still running; and even if the StartTask fails,
                                      new Tasks will continue to be scheduled on the Compute Node. The
                                      default is true.
                                },
                                "targetDedicatedNodes": 0,  # Optional. The desired
                                  number of dedicated Compute Nodes in the Pool. This property must not
                                  be specified if enableAutoScale is set to true. If enableAutoScale is
                                  set to false, then you must set either targetDedicatedNodes,
                                  targetLowPriorityNodes, or both.
                                "targetLowPriorityNodes": 0,  # Optional. The desired
                                  number of Spot/Low-priority Compute Nodes in the Pool. This property
                                  must not be specified if enableAutoScale is set to true. If
                                  enableAutoScale is set to false, then you must set either
                                  targetDedicatedNodes, targetLowPriorityNodes, or both.
                                "targetNodeCommunicationMode": "str",  # Optional.
                                  The desired node communication mode for the pool. If omitted, the
                                  default value is Default. Known values are: "default", "classic", and
                                  "simplified".
                                "taskSchedulingPolicy": {
                                    "nodeFillType": "str"  # How Tasks are
                                      distributed across Compute Nodes in a Pool. If not specified, the
                                      default is spread. Required. Known values are: "spread" and
                                      "pack".
                                },
                                "taskSlotsPerNode": 0,  # Optional. The number of
                                  task slots that can be used to run concurrent tasks on a single
                                  compute node in the pool. The default value is 1. The maximum value
                                  is the smaller of 4 times the number of cores of the vmSize of the
                                  pool or 256.
                                "upgradePolicy": {
                                    "mode": "str",  # Specifies the mode of an
                                      upgrade to virtual machines in the scale set.:code:`<br
                                      />`:code:`<br />` Possible values are::code:`<br />`:code:`<br
                                      />` **Manual** - You  control the application of updates to
                                      virtual machines in the scale set. You do this by using the
                                      manualUpgrade action.:code:`<br />`:code:`<br />` **Automatic** -
                                      All virtual machines in the scale set are automatically updated
                                      at the same time.:code:`<br />`:code:`<br />` **Rolling** - Scale
                                      set performs updates in batches with an optional pause time in
                                      between. Required. Known values are: "automatic", "manual", and
                                      "rolling".
                                    "automaticOSUpgradePolicy": {
                                        "disableAutomaticRollback": bool,  #
                                          Optional. Whether OS image rollback feature should be
                                          disabled.
                                        "enableAutomaticOSUpgrade": bool,  #
                                          Optional. Indicates whether OS upgrades should automatically
                                          be applied to scale set instances in a rolling fashion when a
                                          newer version of the OS image becomes available. :code:`<br
                                          />`:code:`<br />` If this is set to true for Windows based
                                          pools, `WindowsConfiguration.enableAutomaticUpdates
                                          <https://learn.microsoft.com/en-us/rest/api/batchservice/pool/add?tabs=HTTP#windowsconfiguration>`_
                                          cannot be set to true.
                                        "osRollingUpgradeDeferral": bool,  #
                                          Optional. Defer OS upgrades on the TVMs if they are running
                                          tasks.
                                        "useRollingUpgradePolicy": bool  #
                                          Optional. Indicates whether rolling upgrade policy should be
                                          used during Auto OS Upgrade. Auto OS Upgrade will fallback to
                                          the default policy if no policy is defined on the VMSS.
                                    },
                                    "rollingUpgradePolicy": {
                                        "enableCrossZoneUpgrade": bool,  #
                                          Optional. Allow VMSS to ignore AZ boundaries when
                                          constructing upgrade batches. Take into consideration the
                                          Update Domain and maxBatchInstancePercent to determine the
                                          batch size. This field is able to be set to true or false
                                          only when using NodePlacementConfiguration as Zonal.
                                        "maxBatchInstancePercent": 0,  #
                                          Optional. The maximum percent of total virtual machine
                                          instances that will be upgraded simultaneously by the rolling
                                          upgrade in one batch. As this is a maximum, unhealthy
                                          instances in previous or future batches can cause the
                                          percentage of instances in a batch to decrease to ensure
                                          higher reliability. The value of this field should be between
                                          5 and 100, inclusive. If both maxBatchInstancePercent and
                                          maxUnhealthyInstancePercent are assigned with value, the
                                          value of maxBatchInstancePercent should not be more than
                                          maxUnhealthyInstancePercent.
                                        "maxUnhealthyInstancePercent": 0,  #
                                          Optional. The maximum percentage of the total virtual machine
                                          instances in the scale set that can be simultaneously
                                          unhealthy, either as a result of being upgraded, or by being
                                          found in an unhealthy state by the virtual machine health
                                          checks before the rolling upgrade aborts. This constraint
                                          will be checked prior to starting any batch. The value of
                                          this field should be between 5 and 100, inclusive. If both
                                          maxBatchInstancePercent and maxUnhealthyInstancePercent are
                                          assigned with value, the value of maxBatchInstancePercent
                                          should not be more than maxUnhealthyInstancePercent.
                "maxUnhealthyUpgradedInstancePercent": 0,  # Optional. The
                                          maximum percentage of upgraded virtual machine instances that
                                          can be found to be in an unhealthy state. This check will
                                          happen after each batch is upgraded. If this percentage is
                                          ever exceeded, the rolling update aborts. The value of this
                                          field should be between 0 and 100, inclusive.
                                        "pauseTimeBetweenBatches": "1 day,
                                          0:00:00",  # Optional. The wait time between completing the
                                          update for all virtual machines in one batch and starting the
                                          next batch. The time duration should be specified in ISO 8601
                                          format..
                                        "prioritizeUnhealthyInstances": bool,
                                          # Optional. Upgrade all unhealthy instances in a scale set
                                          before any healthy instances.
                "rollbackFailedInstancesOnPolicyBreach": bool  # Optional.
                                          Rollback failed instances to previous model if the Rolling
                                          Upgrade policy is violated.
                                    }
                                },
                                "userAccounts": [
                                    {
                                        "name": "str",  # The name of the
                                          user Account. Names can contain any Unicode characters up to
                                          a maximum length of 20. Required.
                                        "password": "str",  # The password
                                          for the user Account. Required.
                                        "elevationLevel": "str",  # Optional.
                                          The elevation level of the user Account. The default value is
                                          nonAdmin. Known values are: "nonadmin" and "admin".
                                        "linuxUserConfiguration": {
                                            "gid": 0,  # Optional. The
                                              group ID for the user Account. The uid and gid properties
                                              must be specified together or not at all. If not
                                              specified the underlying operating system picks the gid.
                                            "sshPrivateKey": "str",  #
                                              Optional. The SSH private key for the user Account. The
                                              private key must not be password protected. The private
                                              key is used to automatically configure asymmetric-key
                                              based authentication for SSH between Compute Nodes in a
                                              Linux Pool when the Pool's enableInterNodeCommunication
                                              property is true (it is ignored if
                                              enableInterNodeCommunication is false). It does this by
                                              placing the key pair into the user's .ssh directory. If
                                              not specified, password-less SSH is not configured
                                              between Compute Nodes (no modification of the user's .ssh
                                              directory is done).
                                            "uid": 0  # Optional. The
                                              user ID of the user Account. The uid and gid properties
                                              must be specified together or not at all. If not
                                              specified the underlying operating system picks the uid.
                                        },
                                        "windowsUserConfiguration": {
                                            "loginMode": "str"  #
                                              Optional. The login mode for the user. The default value
                                              for VirtualMachineConfiguration Pools is 'batch'. Known
                                              values are: "batch" and "interactive".
                                        }
                                    }
                                ],
                                "virtualMachineConfiguration": {
                                    "imageReference": {
                                        "exactVersion": "str",  # Optional.
                                          The specific version of the platform image or marketplace
                                          image used to create the node. This read-only field differs
                                          from 'version' only if the value specified for 'version' when
                                          the pool was created was 'latest'.
                                        "offer": "str",  # Optional. The
                                          offer type of the Azure Virtual Machines Marketplace Image.
                                          For example, UbuntuServer or WindowsServer.
                                        "publisher": "str",  # Optional. The
                                          publisher of the Azure Virtual Machines Marketplace Image.
                                          For example, Canonical or MicrosoftWindowsServer.
                                        "sku": "str",  # Optional. The SKU of
                                          the Azure Virtual Machines Marketplace Image. For example,
                                          18.04-LTS or 2019-Datacenter.
                                        "version": "str",  # Optional. The
                                          version of the Azure Virtual Machines Marketplace Image. A
                                          value of 'latest' can be specified to select the latest
                                          version of an Image. If omitted, the default is 'latest'.
                                        "virtualMachineImageId": "str"  #
                                          Optional. The ARM resource identifier of the Azure Compute
                                          Gallery Image. Compute Nodes in the Pool will be created
                                          using this Image Id. This is of the form
                                          /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/galleries/{galleryName}/images/{imageDefinitionName}/versions/{VersionId}
                                          or
                                          /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/galleries/{galleryName}/images/{imageDefinitionName}
                                          for always defaulting to the latest image version. This
                                          property is mutually exclusive with other ImageReference
                                          properties. The Azure Compute Gallery Image must have
                                          replicas in the same region and must be in the same
                                          subscription as the Azure Batch account. If the image version
                                          is not specified in the imageId, the latest version will be
                                          used. For information about the firewall settings for the
                                          Batch Compute Node agent to communicate with the Batch
                                          service see
                                          https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration.
                                    },
                                    "nodeAgentSKUId": "str",  # The SKU of the
                                      Batch Compute Node agent to be provisioned on Compute Nodes in
                                      the Pool. The Batch Compute Node agent is a program that runs on
                                      each Compute Node in the Pool, and provides the
                                      command-and-control interface between the Compute Node and the
                                      Batch service. There are different implementations of the Compute
                                      Node agent, known as SKUs, for different operating systems. You
                                      must specify a Compute Node agent SKU which matches the selected
                                      Image reference. To get the list of supported Compute Node agent
                                      SKUs along with their list of verified Image references, see the
                                      'List supported Compute Node agent SKUs' operation. Required.
                                    "containerConfiguration": {
                                        "type": "str",  # The container
                                          technology to be used. Required. Known values are:
                                          "dockerCompatible" and "criCompatible".
                                        "containerImageNames": [
                                            "str"  # Optional. The
                                              collection of container Image names. This is the full
                                              Image reference, as would be specified to "docker pull".
                                              An Image will be sourced from the default Docker registry
                                              unless the Image is fully qualified with an alternative
                                              registry.
                                        ],
                                        "containerRegistries": [
                                            {
                                                "identityReference":
                                                  {
                                                    "resourceId":
                                                      "str"  # Optional. The ARM resource id of the
                                                      user assigned identity.
                                                },
                                                "password": "str",  #
                                                  Optional. The password to log into the registry
                                                  server.
                                                "registryServer":
                                                  "str",  # Optional. The registry URL. If omitted, the
                                                  default is "docker.io".
                                                "username": "str"  #
                                                  Optional. The user name to log into the registry
                                                  server.
                                            }
                                        ]
                                    },
                                    "dataDisks": [
                                        {
                                            "diskSizeGB": 0,  # The
                                              initial disk size in gigabytes. Required.
                                            "lun": 0,  # The logical unit
                                              number. The logicalUnitNumber is used to uniquely
                                              identify each data disk. If attaching multiple disks,
                                              each should have a distinct logicalUnitNumber. The value
                                              must be between 0 and 63, inclusive. Required.
                                            "caching": "str",  #
                                              Optional. The type of caching to be enabled for the data
                                              disks. The default value for caching is readwrite. For
                                              information about the caching options see:
                                              https://blogs.msdn.microsoft.com/windowsazurestorage/2012/06/27/exploring-windows-azure-drives-disks-and-images/.
                                              Known values are: "none", "readonly", and "readwrite".
                                            "storageAccountType": "str"
                                              # Optional. The storage Account type to be used for the
                                              data disk. If omitted, the default is "standard_lrs".
                                              Known values are: "standard_lrs", "premium_lrs", and
                                              "standardssd_lrs".
                                        }
                                    ],
                                    "diskEncryptionConfiguration": {
                                        "targets": [
                                            "str"  # Optional. The list
                                              of disk targets Batch Service will encrypt on the compute
                                              node. If omitted, no disks on the compute nodes in the
                                              pool will be encrypted. On Linux pool, only
                                              "TemporaryDisk" is supported; on Windows pool, "OsDisk"
                                              and "TemporaryDisk" must be specified.
                                        ]
                                    },
                                    "extensions": [
                                        {
                                            "name": "str",  # The name of
                                              the virtual machine extension. Required.
                                            "publisher": "str",  # The
                                              name of the extension handler publisher. Required.
                                            "type": "str",  # The type of
                                              the extension. Required.
                                            "autoUpgradeMinorVersion":
                                              bool,  # Optional. Indicates whether the extension should
                                              use a newer minor version if one is available at
                                              deployment time. Once deployed, however, the extension
                                              will not upgrade minor versions unless redeployed, even
                                              with this property set to true.
                                            "enableAutomaticUpgrade":
                                              bool,  # Optional. Indicates whether the extension should
                                              be automatically upgraded by the platform if there is a
                                              newer version of the extension available.
                                            "protectedSettings": {
                                                "str": "str"  #
                                                  Optional. The extension can contain either
                                                  protectedSettings or protectedSettingsFromKeyVault or
                                                  no protected settings at all.
                                            },
                                            "provisionAfterExtensions": [
                                                "str"  # Optional.
                                                  The collection of extension names. Collection of
                                                  extension names after which this extension needs to
                                                  be provisioned.
                                            ],
                                            "settings": {
                                                "str": "str"  #
                                                  Optional. JSON formatted public settings for the
                                                  extension.
                                            },
                                            "typeHandlerVersion": "str"
                                              # Optional. The version of script handler.
                                        }
                                    ],
                                    "licenseType": "str",  # Optional. This only
                                      applies to Images that contain the Windows operating system, and
                                      should only be used when you hold valid on-premises licenses for
                                      the Compute Nodes which will be deployed. If omitted, no
                                      on-premises licensing discount is applied. Values are:
                                      Windows_Server - The on-premises license is for Windows Server.
                                      Windows_Client - The on-premises license is for Windows Client.
                                    "nodePlacementConfiguration": {
                                        "policy": "str"  # Optional. Node
                                          placement Policy type on Batch Pools. Allocation policy used
                                          by Batch Service to provision the nodes. If not specified,
                                          Batch will use the regional policy. Known values are:
                                          "regional" and "zonal".
                                    },
                                    "osDisk": {
                                        "caching": "str",  # Optional.
                                          Specifies the caching requirements. Possible values are:
                                          None, ReadOnly, ReadWrite. The default values are: None for
                                          Standard storage. ReadOnly for Premium storage. Known values
                                          are: "none", "readonly", and "readwrite".
                                        "diskSizeGB": 0,  # Optional. The
                                          initial disk size in GB when creating new OS disk.
                                        "ephemeralOSDiskSettings": {
                                            "placement": "str"  #
                                              Optional. Specifies the ephemeral disk placement for
                                              operating system disk for all VMs in the pool. This
                                              property can be used by user in the request to choose the
                                              location e.g., cache disk space for Ephemeral OS disk
                                              provisioning. For more information on Ephemeral OS disk
                                              size requirements, please refer to Ephemeral OS disk size
                                              requirements for Windows VMs at
                                              https://docs.microsoft.com/en-us/azure/virtual-machines/windows/ephemeral-os-disks#size-requirements
                                              and Linux VMs at
                                              https://docs.microsoft.com/en-us/azure/virtual-machines/linux/ephemeral-os-disks#size-requirements.
                                              "cachedisk"
                                        },
                                        "managedDisk": {
                                            "storageAccountType": "str"
                                              # The storage account type for managed disk. Required.
                                              Known values are: "standard_lrs", "premium_lrs", and
                                              "standardssd_lrs".
                                        },
                                        "writeAcceleratorEnabled": bool  #
                                          Optional. Specifies whether writeAccelerator should be
                                          enabled or disabled on the disk.
                                    },
                                    "securityProfile": {
                                        "encryptionAtHost": bool,  # This
                                          property can be used by user in the request to enable or
                                          disable the Host Encryption for the virtual machine or
                                          virtual machine scale set. This will enable the encryption
                                          for all the disks including Resource/Temp disk at host
                                          itself. Required.
                                        "securityType": "str",  # Specifies
                                          the SecurityType of the virtual machine. It has to be set to
                                          any specified value to enable UefiSettings. Required.
                                          "trustedLaunch"
                                        "uefiSettings": {
                                            "secureBootEnabled": bool,  #
                                              Optional. Specifies whether secure boot should be enabled
                                              on the virtual machine.
                                            "vTpmEnabled": bool  #
                                              Optional. Specifies whether vTPM should be enabled on the
                                              virtual machine.
                                        }
                                    },
                                    "serviceArtifactReference": {
                                        "id": "str"  # The service artifact
                                          reference id of ServiceArtifactReference. The service
                                          artifact reference id in the form of
                                          /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/galleries/{galleryName}/serviceArtifacts/{serviceArtifactName}/vmArtifactsProfiles/{vmArtifactsProfilesName}.
                                          Required.
                                    },
                                    "windowsConfiguration": {
                                        "enableAutomaticUpdates": bool  #
                                          Optional. Whether automatic updates are enabled on the
                                          virtual machine. If omitted, the default value is true.
                                    }
                                }
                            }
                        },
                        "poolId": "str"  # Optional. The ID of an existing Pool. All the
                          Tasks of the Job will run on the specified Pool. You must ensure that the
                          Pool referenced by this property exists. If the Pool does not exist at the
                          time the Batch service tries to schedule a Job, no Tasks for the Job will run
                          until you create a Pool with that id. Note that the Batch service will not
                          reject the Job request; it will simply not run Tasks until the Pool exists.
                          You must specify either the Pool ID or the auto Pool specification, but not
                          both.
                    },
                    "priority": 0  # Optional. The priority of the Job. Priority values can range
                      from -1000 to 1000, with -1000 being the lowest priority and 1000 being the
                      highest priority. If omitted, the priority of the Job is left unchanged.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: str = kwargs.pop(
            "content_type", _headers.pop("content-type", "application/json; odata=minimalmetadata")
        )
        cls: ClsType[None] = kwargs.pop("cls", None)

        _content = json.dumps(job, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_batch_update_job_request(
            job_id=job_id,
            time_out_in_seconds=time_out_in_seconds,
            ocpdate=ocpdate,
            if_modified_since=if_modified_since,
            if_unmodified_since=if_unmodified_since,
            etag=etag,
            match_condition=match_condition,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.BatchError, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["DataServiceId"] = self._deserialize("str", response.headers.get("DataServiceId"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def replace_job(  # pylint: disable=inconsistent-return-statements
        self,
        job_id: str,
        job: _models.BatchJob,
        *,
        time_out_in_seconds: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        if_modified_since: Optional[datetime.datetime] = None,
        if_unmodified_since: Optional[datetime.datetime] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> None:
        # pylint: disable=line-too-long
        """Updates the properties of the specified Job.

        This fully replaces all the updatable properties of the Job. For example, if
        the Job has constraints associated with it and if constraints is not specified
        with this request, then the Batch service will remove the existing constraints.

        :param job_id: The ID of the Job whose properties you want to update. Required.
        :type job_id: str
        :param job: A job with updated properties. Required.
        :type job: ~azure.batch.models.BatchJob
        :keyword time_out_in_seconds: The maximum time that the server can spend processing the
         request, in seconds. The default is 30 seconds. If the value is larger than 30, the default
         will be used instead.". Default value is None.
        :paramtype time_out_in_seconds: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword if_modified_since: A timestamp indicating the last modified time of the resource known
         to the
         client. The operation will be performed only if the resource on the service has
         been modified since the specified time. Default value is None.
        :paramtype if_modified_since: ~datetime.datetime
        :keyword if_unmodified_since: A timestamp indicating the last modified time of the resource
         known to the
         client. The operation will be performed only if the resource on the service has
         not been modified since the specified time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                job = {
                    "poolInfo": {
                        "autoPoolSpecification": {
                            "poolLifetimeOption": "str",  # The minimum lifetime of
                              created auto Pools, and how multiple Jobs on a schedule are assigned to
                              Pools. Required. Known values are: "jobschedule" and "job".
                            "autoPoolIdPrefix": "str",  # Optional. A prefix to be added
                              to the unique identifier when a Pool is automatically created. The Batch
                              service assigns each auto Pool a unique identifier on creation. To
                              distinguish between Pools created for different purposes, you can specify
                              this element to add a prefix to the ID that is assigned. The prefix can
                              be up to 20 characters long.
                            "keepAlive": bool,  # Optional. Whether to keep an auto Pool
                              alive after its lifetime expires. If false, the Batch service deletes the
                              Pool once its lifetime (as determined by the poolLifetimeOption setting)
                              expires; that is, when the Job or Job Schedule completes. If true, the
                              Batch service does not delete the Pool automatically. It is up to the
                              user to delete auto Pools created with this option.
                            "pool": {
                                "vmSize": "str",  # The size of the virtual machines
                                  in the Pool. All virtual machines in a Pool are the same size. For
                                  information about available sizes of virtual machines in Pools, see
                                  Choose a VM size for Compute Nodes in an Azure Batch Pool
                                  (https://docs.microsoft.com/azure/batch/batch-pool-vm-sizes).
                                  Required.
                                "applicationPackageReferences": [
                                    {
                                        "applicationId": "str",  # The ID of
                                          the application to deploy. When creating a pool, the
                                          package's application ID must be fully qualified
                                          (/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/applications/{applicationName}).
                                          Required.
                                        "version": "str"  # Optional. The
                                          version of the application to deploy. If omitted, the default
                                          version is deployed. If this is omitted on a Pool, and no
                                          default version is specified for this application, the
                                          request fails with the error code
                                          InvalidApplicationPackageReferences and HTTP status code 409.
                                          If this is omitted on a Task, and no default version is
                                          specified for this application, the Task fails with a
                                          pre-processing error.
                                    }
                                ],
                                "autoScaleEvaluationInterval": "1 day, 0:00:00",  #
                                  Optional. The time interval at which to automatically adjust the Pool
                                  size according to the autoscale formula. The default value is 15
                                  minutes. The minimum and maximum value are 5 minutes and 168 hours
                                  respectively. If you specify a value less than 5 minutes or greater
                                  than 168 hours, the Batch service rejects the request with an invalid
                                  property value error; if you are calling the REST API directly, the
                                  HTTP status code is 400 (Bad Request).
                                "autoScaleFormula": "str",  # Optional. The formula
                                  for the desired number of Compute Nodes in the Pool. This property
                                  must not be specified if enableAutoScale is set to false. It is
                                  required if enableAutoScale is set to true. The formula is checked
                                  for validity before the Pool is created. If the formula is not valid,
                                  the Batch service rejects the request with detailed error
                                  information.
                                "displayName": "str",  # Optional. The display name
                                  for the Pool. The display name need not be unique and can contain any
                                  Unicode characters up to a maximum length of 1024.
                                "enableAutoScale": bool,  # Optional. Whether the
                                  Pool size should automatically adjust over time. If false, at least
                                  one of targetDedicatedNodes and targetLowPriorityNodes must be
                                  specified. If true, the autoScaleFormula element is required. The
                                  Pool automatically resizes according to the formula. The default
                                  value is false.
                                "enableInterNodeCommunication": bool,  # Optional.
                                  Whether the Pool permits direct communication between Compute Nodes.
                                  Enabling inter-node communication limits the maximum size of the Pool
                                  due to deployment restrictions on the Compute Nodes of the Pool. This
                                  may result in the Pool not reaching its desired size. The default
                                  value is false.
                                "metadata": [
                                    {
                                        "name": "str",  # The name of the
                                          metadata item. Required.
                                        "value": "str"  # The value of the
                                          metadata item. Required.
                                    }
                                ],
                                "mountConfiguration": [
                                    {
                                        "azureBlobFileSystemConfiguration": {
                                            "accountName": "str",  # The
                                              Azure Storage Account name. Required.
                                            "containerName": "str",  #
                                              The Azure Blob Storage Container name. Required.
                                            "relativeMountPath": "str",
                                              # The relative path on the compute node where the file
                                              system will be mounted. All file systems are mounted
                                              relative to the Batch mounts directory, accessible via
                                              the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
                                              Required.
                                            "accountKey": "str",  #
                                              Optional. The Azure Storage Account key. This property is
                                              mutually exclusive with both sasKey and identity; exactly
                                              one must be specified.
                                            "blobfuseOptions": "str",  #
                                              Optional. Additional command line options to pass to the
                                              mount command. These are 'net use' options in Windows and
                                              'mount' options in Linux.
                                            "identityReference": {
                                                "resourceId": "str"
                                                  # Optional. The ARM resource id of the user assigned
                                                  identity.
                                            },
                                            "sasKey": "str"  # Optional.
                                              The Azure Storage SAS token. This property is mutually
                                              exclusive with both accountKey and identity; exactly one
                                              must be specified.
                                        },
                                        "azureFileShareConfiguration": {
                                            "accountKey": "str",  # The
                                              Azure Storage account key. Required.
                                            "accountName": "str",  # The
                                              Azure Storage account name. Required.
                                            "azureFileUrl": "str",  # The
                                              Azure Files URL. This is of the form
                                              'https://{account}.file.core.windows.net/'. Required.
                                            "relativeMountPath": "str",
                                              # The relative path on the compute node where the file
                                              system will be mounted. All file systems are mounted
                                              relative to the Batch mounts directory, accessible via
                                              the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
                                              Required.
                                            "mountOptions": "str"  #
                                              Optional. Additional command line options to pass to the
                                              mount command. These are 'net use' options in Windows and
                                              'mount' options in Linux.
                                        },
                                        "cifsMountConfiguration": {
                                            "password": "str",  # The
                                              password to use for authentication against the CIFS file
                                              system. Required.
                                            "relativeMountPath": "str",
                                              # The relative path on the compute node where the file
                                              system will be mounted. All file systems are mounted
                                              relative to the Batch mounts directory, accessible via
                                              the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
                                              Required.
                                            "source": "str",  # The URI
                                              of the file system to mount. Required.
                                            "username": "str",  # The
                                              user to use for authentication against the CIFS file
                                              system. Required.
                                            "mountOptions": "str"  #
                                              Optional. Additional command line options to pass to the
                                              mount command. These are 'net use' options in Windows and
                                              'mount' options in Linux.
                                        },
                                        "nfsMountConfiguration": {
                                            "relativeMountPath": "str",
                                              # The relative path on the compute node where the file
                                              system will be mounted. All file systems are mounted
                                              relative to the Batch mounts directory, accessible via
                                              the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
                                              Required.
                                            "source": "str",  # The URI
                                              of the file system to mount. Required.
                                            "mountOptions": "str"  #
                                              Optional. Additional command line options to pass to the
                                              mount command. These are 'net use' options in Windows and
                                              'mount' options in Linux.
                                        }
                                    }
                                ],
                                "networkConfiguration": {
                                    "dynamicVNetAssignmentScope": "str",  #
                                      Optional. The scope of dynamic vnet assignment. Known values are:
                                      "none" and "job".
                                    "enableAcceleratedNetworking": bool,  #
                                      Optional. Whether this pool should enable accelerated networking.
                                      Accelerated networking enables single root I/O virtualization
                                      (SR-IOV) to a VM, which may lead to improved networking
                                      performance. For more details, see:
                                      https://learn.microsoft.com/azure/virtual-network/accelerated-networking-overview.
                                    "endpointConfiguration": {
                                        "inboundNATPools": [
                                            {
                                                "backendPort": 0,  #
                                                  The port number on the Compute Node. This must be
                                                  unique within a Batch Pool. Acceptable values are
                                                  between 1 and 65535 except for 22, 3389, 29876 and
                                                  29877 as these are reserved. If any reserved values
                                                  are provided the request fails with HTTP status code
                                                  400. Required.
                "frontendPortRangeEnd": 0,  # The last port number in
                                                  the range of external ports that will be used to
                                                  provide inbound access to the backendPort on
                                                  individual Compute Nodes. Acceptable values range
                                                  between 1 and 65534 except ports from 50000 to 55000
                                                  which are reserved by the Batch service. All ranges
                                                  within a Pool must be distinct and cannot overlap.
                                                  Each range must contain at least 40 ports. If any
                                                  reserved or overlapping values are provided the
                                                  request fails with HTTP status code 400. Required.
                "frontendPortRangeStart": 0,  # The first port number
                                                  in the range of external ports that will be used to
                                                  provide inbound access to the backendPort on
                                                  individual Compute Nodes. Acceptable values range
                                                  between 1 and 65534 except ports from 50000 to 55000
                                                  which are reserved. All ranges within a Pool must be
                                                  distinct and cannot overlap. Each range must contain
                                                  at least 40 ports. If any reserved or overlapping
                                                  values are provided the request fails with HTTP
                                                  status code 400. Required.
                                                "name": "str",  # The
                                                  name of the endpoint. The name must be unique within
                                                  a Batch Pool, can contain letters, numbers,
                                                  underscores, periods, and hyphens. Names must start
                                                  with a letter or number, must end with a letter,
                                                  number, or underscore, and cannot exceed 77
                                                  characters.  If any invalid values are provided the
                                                  request fails with HTTP status code 400. Required.
                                                "protocol": "str",  #
                                                  The protocol of the endpoint. Required. Known values
                                                  are: "tcp" and "udp".
                "networkSecurityGroupRules": [
                                                    {
                "access": "str",  # The action that should be
                                                          taken for a specified IP address, subnet
                                                          range or tag. Required. Known values are:
                                                          "allow" and "deny".
                "priority": 0,  # The priority for this rule.
                                                          Priorities within a Pool must be unique and
                                                          are evaluated in order of priority. The lower
                                                          the number the higher the priority. For
                                                          example, rules could be specified with order
                                                          numbers of 150, 250, and 350. The rule with
                                                          the order number of 150 takes precedence over
                                                          the rule that has an order of 250. Allowed
                                                          priorities are 150 to 4096. If any reserved
                                                          or duplicate values are provided the request
                                                          fails with HTTP status code 400. Required.
                "sourceAddressPrefix": "str",  # The source
                                                          address prefix or tag to match for the rule.
                                                          Valid values are a single IP address (i.e.
                                                          10.10.10.10), IP subnet (i.e.
                                                          192.168.1.0/24), default tag, or * (for all
                                                          addresses).  If any other values are provided
                                                          the request fails with HTTP status code 400.
                                                          Required.
                "sourcePortRanges": [
                "str"  # Optional. The source port ranges
                                                              to match for the rule. Valid values are
                                                              '"" *' (for all ports 0 - 65535), a
                                                              specific port (i.e. 22), or a port range
                                                              (i.e. 100-200). The ports must be in the
                                                              range of 0 to 65535. Each entry in this
                                                              collection must not overlap any other
                                                              entry (either a range or an individual
                                                              port). If any other values are provided
                                                              the request fails with HTTP status code
                                                              400. The default value is '*"" '.
                                                        ]
                                                    }
                                                ]
                                            }
                                        ]
                                    },
                                    "publicIPAddressConfiguration": {
                                        "ipAddressIds": [
                                            "str"  # Optional. The list
                                              of public IPs which the Batch service will use when
                                              provisioning Compute Nodes. The number of IPs specified
                                              here limits the maximum size of the Pool - 100 dedicated
                                              nodes or 100 Spot/Low-priority nodes can be allocated for
                                              each public IP. For example, a pool needing 250 dedicated
                                              VMs would need at least 3 public IPs specified. Each
                                              element of this collection is of the form:
                                              /subscriptions/{subscription}/resourceGroups/{group}/providers/Microsoft.Network/publicIPAddresses/{ip}.
                                        ],
                                        "provision": "str"  # Optional. The
                                          provisioning type for Public IP Addresses for the Pool. The
                                          default value is BatchManaged. Known values are:
                                          "batchmanaged", "usermanaged", and "nopublicipaddresses".
                                    },
                                    "subnetId": "str"  # Optional. The ARM
                                      resource identifier of the virtual network subnet which the
                                      Compute Nodes of the Pool will join. This is of the form
                                      /subscriptions/{subscription}/resourceGroups/{group}/providers/{provider}/virtualNetworks/{network}/subnets/{subnet}.
                                      The virtual network must be in the same region and subscription
                                      as the Azure Batch Account. The specified subnet should have
                                      enough free IP addresses to accommodate the number of Compute
                                      Nodes in the Pool. If the subnet doesn't have enough free IP
                                      addresses, the Pool will partially allocate Nodes and a resize
                                      error will occur. The 'MicrosoftAzureBatch' service principal
                                      must have the 'Classic Virtual Machine Contributor' Role-Based
                                      Access Control (RBAC) role for the specified VNet. The specified
                                      subnet must allow communication from the Azure Batch service to
                                      be able to schedule Tasks on the Nodes. This can be verified by
                                      checking if the specified VNet has any associated Network
                                      Security Groups (NSG). If communication to the Nodes in the
                                      specified subnet is denied by an NSG, then the Batch service will
                                      set the state of the Compute Nodes to unusable. For Pools created
                                      with virtualMachineConfiguration only ARM virtual networks
                                      ('Microsoft.Network/virtualNetworks') are supported. If the
                                      specified VNet has any associated Network Security Groups (NSG),
                                      then a few reserved system ports must be enabled for inbound
                                      communication. For Pools created with a virtual machine
                                      configuration, enable ports 29876 and 29877, as well as port 22
                                      for Linux and port 3389 for Windows. Also enable outbound
                                      connections to Azure Storage on port 443. For more details see:
                                      https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration.
                                },
                                "resizeTimeout": "1 day, 0:00:00",  # Optional. The
                                  timeout for allocation of Compute Nodes to the Pool. This timeout
                                  applies only to manual scaling; it has no effect when enableAutoScale
                                  is set to true. The default value is 15 minutes. The minimum value is
                                  5 minutes. If you specify a value less than 5 minutes, the Batch
                                  service rejects the request with an error; if you are calling the
                                  REST API directly, the HTTP status code is 400 (Bad Request).
                                "resourceTags": "str",  # Optional. The
                                  user-specified tags associated with the pool.The user-defined tags to
                                  be associated with the Azure Batch Pool. When specified, these tags
                                  are propagated to the backing Azure resources associated with the
                                  pool. This property can only be specified when the Batch account was
                                  created with the poolAllocationMode property set to
                                  'UserSubscription'.
                                "startTask": {
                                    "commandLine": "str",  # The command line of
                                      the StartTask. The command line does not run under a shell, and
                                      therefore cannot take advantage of shell features such as
                                      environment variable expansion. If you want to take advantage of
                                      such features, you should invoke the shell in the command line,
                                      for example using "cmd /c MyCommand" in Windows or "/bin/sh -c
                                      MyCommand" in Linux. If the command line refers to file paths, it
                                      should use a relative path (relative to the Task working
                                      directory), or use the Batch provided environment variable
                                      (https://docs.microsoft.com/en-us/azure/batch/batch-compute-node-environment-variables).
                                      Required.
                                    "containerSettings": {
                                        "imageName": "str",  # The Image to
                                          use to create the container in which the Task will run. This
                                          is the full Image reference, as would be specified to "docker
                                          pull". If no tag is provided as part of the Image name, the
                                          tag ":latest" is used as a default. Required.
                                        "containerRunOptions": "str",  #
                                          Optional. Additional options to the container create command.
                                          These additional options are supplied as arguments to the
                                          "docker create" command, in addition to those controlled by
                                          the Batch Service.
                                        "registry": {
                                            "identityReference": {
                                                "resourceId": "str"
                                                  # Optional. The ARM resource id of the user assigned
                                                  identity.
                                            },
                                            "password": "str",  #
                                              Optional. The password to log into the registry server.
                                            "registryServer": "str",  #
                                              Optional. The registry URL. If omitted, the default is
                                              "docker.io".
                                            "username": "str"  #
                                              Optional. The user name to log into the registry server.
                                        },
                                        "workingDirectory": "str"  #
                                          Optional. The location of the container Task working
                                          directory. The default is 'taskWorkingDirectory'. Known
                                          values are: "taskWorkingDirectory" and
                                          "containerImageDefault".
                                    },
                                    "environmentSettings": [
                                        {
                                            "name": "str",  # The name of
                                              the environment variable. Required.
                                            "value": "str"  # Optional.
                                              The value of the environment variable.
                                        }
                                    ],
                                    "maxTaskRetryCount": 0,  # Optional. The
                                      maximum number of times the Task may be retried. The Batch
                                      service retries a Task if its exit code is nonzero. Note that
                                      this value specifically controls the number of retries. The Batch
                                      service will try the Task once, and may then retry up to this
                                      limit. For example, if the maximum retry count is 3, Batch tries
                                      the Task up to 4 times (one initial try and 3 retries). If the
                                      maximum retry count is 0, the Batch service does not retry the
                                      Task. If the maximum retry count is -1, the Batch service retries
                                      the Task without limit, however this is not recommended for a
                                      start task or any task. The default value is 0 (no retries).
                                    "resourceFiles": [
                                        {
                                            "autoStorageContainerName":
                                              "str",  # Optional. The storage container name in the
                                              auto storage Account. The autoStorageContainerName,
                                              storageContainerUrl and httpUrl properties are mutually
                                              exclusive and one of them must be specified.
                                            "blobPrefix": "str",  #
                                              Optional. The blob prefix to use when downloading blobs
                                              from an Azure Storage container. Only the blobs whose
                                              names begin with the specified prefix will be downloaded.
                                              The property is valid only when autoStorageContainerName
                                              or storageContainerUrl is used. This prefix can be a
                                              partial filename or a subdirectory. If a prefix is not
                                              specified, all the files in the container will be
                                              downloaded.
                                            "fileMode": "str",  #
                                              Optional. The file permission mode attribute in octal
                                              format. This property applies only to files being
                                              downloaded to Linux Compute Nodes. It will be ignored if
                                              it is specified for a resourceFile which will be
                                              downloaded to a Windows Compute Node. If this property is
                                              not specified for a Linux Compute Node, then a default
                                              value of 0770 is applied to the file.
                                            "filePath": "str",  #
                                              Optional. The location on the Compute Node to which to
                                              download the file(s), relative to the Task's working
                                              directory. If the httpUrl property is specified, the
                                              filePath is required and describes the path which the
                                              file will be downloaded to, including the filename.
                                              Otherwise, if the autoStorageContainerName or
                                              storageContainerUrl property is specified, filePath is
                                              optional and is the directory to download the files to.
                                              In the case where filePath is used as a directory, any
                                              directory structure already associated with the input
                                              data will be retained in full and appended to the
                                              specified filePath directory. The specified relative path
                                              cannot break out of the Task's working directory (for
                                              example by using '..').
                                            "httpUrl": "str",  #
                                              Optional. The URL of the file to download. The
                                              autoStorageContainerName, storageContainerUrl and httpUrl
                                              properties are mutually exclusive and one of them must be
                                              specified. If the URL points to Azure Blob Storage, it
                                              must be readable from compute nodes. There are three ways
                                              to get such a URL for a blob in Azure storage: include a
                                              Shared Access Signature (SAS) granting read permissions
                                              on the blob, use a managed identity with read permission,
                                              or set the ACL for the blob or its container to allow
                                              public access.
                                            "identityReference": {
                                                "resourceId": "str"
                                                  # Optional. The ARM resource id of the user assigned
                                                  identity.
                                            },
                                            "storageContainerUrl": "str"
                                              # Optional. The URL of the blob container within Azure
                                              Blob Storage. The autoStorageContainerName,
                                              storageContainerUrl and httpUrl properties are mutually
                                              exclusive and one of them must be specified. This URL
                                              must be readable and listable from compute nodes. There
                                              are three ways to get such a URL for a container in Azure
                                              storage: include a Shared Access Signature (SAS) granting
                                              read and list permissions on the container, use a managed
                                              identity with read and list permissions, or set the ACL
                                              for the container to allow public access.
                                        }
                                    ],
                                    "userIdentity": {
                                        "autoUser": {
                                            "elevationLevel": "str",  #
                                              Optional. The elevation level of the auto user. The
                                              default value is nonAdmin. Known values are: "nonadmin"
                                              and "admin".
                                            "scope": "str"  # Optional.
                                              The scope for the auto user. The default value is pool.
                                              If the pool is running Windows, a value of Task should be
                                              specified if stricter isolation between tasks is
                                              required, such as if the task mutates the registry in a
                                              way which could impact other tasks. Known values are:
                                              "task" and "pool".
                                        },
                                        "username": "str"  # Optional. The
                                          name of the user identity under which the Task is run. The
                                          userName and autoUser properties are mutually exclusive; you
                                          must specify one but not both.
                                    },
                                    "waitForSuccess": bool  # Optional. Whether
                                      the Batch service should wait for the StartTask to complete
                                      successfully (that is, to exit with exit code 0) before
                                      scheduling any Tasks on the Compute Node. If true and the
                                      StartTask fails on a Node, the Batch service retries the
                                      StartTask up to its maximum retry count (maxTaskRetryCount). If
                                      the Task has still not completed successfully after all retries,
                                      then the Batch service marks the Node unusable, and will not
                                      schedule Tasks to it. This condition can be detected via the
                                      Compute Node state and failure info details. If false, the Batch
                                      service will not wait for the StartTask to complete. In this
                                      case, other Tasks can start executing on the Compute Node while
                                      the StartTask is still running; and even if the StartTask fails,
                                      new Tasks will continue to be scheduled on the Compute Node. The
                                      default is true.
                                },
                                "targetDedicatedNodes": 0,  # Optional. The desired
                                  number of dedicated Compute Nodes in the Pool. This property must not
                                  be specified if enableAutoScale is set to true. If enableAutoScale is
                                  set to false, then you must set either targetDedicatedNodes,
                                  targetLowPriorityNodes, or both.
                                "targetLowPriorityNodes": 0,  # Optional. The desired
                                  number of Spot/Low-priority Compute Nodes in the Pool. This property
                                  must not be specified if enableAutoScale is set to true. If
                                  enableAutoScale is set to false, then you must set either
                                  targetDedicatedNodes, targetLowPriorityNodes, or both.
                                "targetNodeCommunicationMode": "str",  # Optional.
                                  The desired node communication mode for the pool. If omitted, the
                                  default value is Default. Known values are: "default", "classic", and
                                  "simplified".
                                "taskSchedulingPolicy": {
                                    "nodeFillType": "str"  # How Tasks are
                                      distributed across Compute Nodes in a Pool. If not specified, the
                                      default is spread. Required. Known values are: "spread" and
                                      "pack".
                                },
                                "taskSlotsPerNode": 0,  # Optional. The number of
                                  task slots that can be used to run concurrent tasks on a single
                                  compute node in the pool. The default value is 1. The maximum value
                                  is the smaller of 4 times the number of cores of the vmSize of the
                                  pool or 256.
                                "upgradePolicy": {
                                    "mode": "str",  # Specifies the mode of an
                                      upgrade to virtual machines in the scale set.:code:`<br
                                      />`:code:`<br />` Possible values are::code:`<br />`:code:`<br
                                      />` **Manual** - You  control the application of updates to
                                      virtual machines in the scale set. You do this by using the
                                      manualUpgrade action.:code:`<br />`:code:`<br />` **Automatic** -
                                      All virtual machines in the scale set are automatically updated
                                      at the same time.:code:`<br />`:code:`<br />` **Rolling** - Scale
                                      set performs updates in batches with an optional pause time in
                                      between. Required. Known values are: "automatic", "manual", and
                                      "rolling".
                                    "automaticOSUpgradePolicy": {
                                        "disableAutomaticRollback": bool,  #
                                          Optional. Whether OS image rollback feature should be
                                          disabled.
                                        "enableAutomaticOSUpgrade": bool,  #
                                          Optional. Indicates whether OS upgrades should automatically
                                          be applied to scale set instances in a rolling fashion when a
                                          newer version of the OS image becomes available. :code:`<br
                                          />`:code:`<br />` If this is set to true for Windows based
                                          pools, `WindowsConfiguration.enableAutomaticUpdates
                                          <https://learn.microsoft.com/en-us/rest/api/batchservice/pool/add?tabs=HTTP#windowsconfiguration>`_
                                          cannot be set to true.
                                        "osRollingUpgradeDeferral": bool,  #
                                          Optional. Defer OS upgrades on the TVMs if they are running
                                          tasks.
                                        "useRollingUpgradePolicy": bool  #
                                          Optional. Indicates whether rolling upgrade policy should be
                                          used during Auto OS Upgrade. Auto OS Upgrade will fallback to
                                          the default policy if no policy is defined on the VMSS.
                                    },
                                    "rollingUpgradePolicy": {
                                        "enableCrossZoneUpgrade": bool,  #
                                          Optional. Allow VMSS to ignore AZ boundaries when
                                          constructing upgrade batches. Take into consideration the
                                          Update Domain and maxBatchInstancePercent to determine the
                                          batch size. This field is able to be set to true or false
                                          only when using NodePlacementConfiguration as Zonal.
                                        "maxBatchInstancePercent": 0,  #
                                          Optional. The maximum percent of total virtual machine
                                          instances that will be upgraded simultaneously by the rolling
                                          upgrade in one batch. As this is a maximum, unhealthy
                                          instances in previous or future batches can cause the
                                          percentage of instances in a batch to decrease to ensure
                                          higher reliability. The value of this field should be between
                                          5 and 100, inclusive. If both maxBatchInstancePercent and
                                          maxUnhealthyInstancePercent are assigned with value, the
                                          value of maxBatchInstancePercent should not be more than
                                          maxUnhealthyInstancePercent.
                                        "maxUnhealthyInstancePercent": 0,  #
                                          Optional. The maximum percentage of the total virtual machine
                                          instances in the scale set that can be simultaneously
                                          unhealthy, either as a result of being upgraded, or by being
                                          found in an unhealthy state by the virtual machine health
                                          checks before the rolling upgrade aborts. This constraint
                                          will be checked prior to starting any batch. The value of
                                          this field should be between 5 and 100, inclusive. If both
                                          maxBatchInstancePercent and maxUnhealthyInstancePercent are
                                          assigned with value, the value of maxBatchInstancePercent
                                          should not be more than maxUnhealthyInstancePercent.
                "maxUnhealthyUpgradedInstancePercent": 0,  # Optional. The
                                          maximum percentage of upgraded virtual machine instances that
                                          can be found to be in an unhealthy state. This check will
                                          happen after each batch is upgraded. If this percentage is
                                          ever exceeded, the rolling update aborts. The value of this
                                          field should be between 0 and 100, inclusive.
                                        "pauseTimeBetweenBatches": "1 day,
                                          0:00:00",  # Optional. The wait time between completing the
                                          update for all virtual machines in one batch and starting the
                                          next batch. The time duration should be specified in ISO 8601
                                          format..
                                        "prioritizeUnhealthyInstances": bool,
                                          # Optional. Upgrade all unhealthy instances in a scale set
                                          before any healthy instances.
                "rollbackFailedInstancesOnPolicyBreach": bool  # Optional.
                                          Rollback failed instances to previous model if the Rolling
                                          Upgrade policy is violated.
                                    }
                                },
                                "userAccounts": [
                                    {
                                        "name": "str",  # The name of the
                                          user Account. Names can contain any Unicode characters up to
                                          a maximum length of 20. Required.
                                        "password": "str",  # The password
                                          for the user Account. Required.
                                        "elevationLevel": "str",  # Optional.
                                          The elevation level of the user Account. The default value is
                                          nonAdmin. Known values are: "nonadmin" and "admin".
                                        "linuxUserConfiguration": {
                                            "gid": 0,  # Optional. The
                                              group ID for the user Account. The uid and gid properties
                                              must be specified together or not at all. If not
                                              specified the underlying operating system picks the gid.
                                            "sshPrivateKey": "str",  #
                                              Optional. The SSH private key for the user Account. The
                                              private key must not be password protected. The private
                                              key is used to automatically configure asymmetric-key
                                              based authentication for SSH between Compute Nodes in a
                                              Linux Pool when the Pool's enableInterNodeCommunication
                                              property is true (it is ignored if
                                              enableInterNodeCommunication is false). It does this by
                                              placing the key pair into the user's .ssh directory. If
                                              not specified, password-less SSH is not configured
                                              between Compute Nodes (no modification of the user's .ssh
                                              directory is done).
                                            "uid": 0  # Optional. The
                                              user ID of the user Account. The uid and gid properties
                                              must be specified together or not at all. If not
                                              specified the underlying operating system picks the uid.
                                        },
                                        "windowsUserConfiguration": {
                                            "loginMode": "str"  #
                                              Optional. The login mode for the user. The default value
                                              for VirtualMachineConfiguration Pools is 'batch'. Known
                                              values are: "batch" and "interactive".
                                        }
                                    }
                                ],
                                "virtualMachineConfiguration": {
                                    "imageReference": {
                                        "exactVersion": "str",  # Optional.
                                          The specific version of the platform image or marketplace
                                          image used to create the node. This read-only field differs
                                          from 'version' only if the value specified for 'version' when
                                          the pool was created was 'latest'.
                                        "offer": "str",  # Optional. The
                                          offer type of the Azure Virtual Machines Marketplace Image.
                                          For example, UbuntuServer or WindowsServer.
                                        "publisher": "str",  # Optional. The
                                          publisher of the Azure Virtual Machines Marketplace Image.
                                          For example, Canonical or MicrosoftWindowsServer.
                                        "sku": "str",  # Optional. The SKU of
                                          the Azure Virtual Machines Marketplace Image. For example,
                                          18.04-LTS or 2019-Datacenter.
                                        "version": "str",  # Optional. The
                                          version of the Azure Virtual Machines Marketplace Image. A
                                          value of 'latest' can be specified to select the latest
                                          version of an Image. If omitted, the default is 'latest'.
                                        "virtualMachineImageId": "str"  #
                                          Optional. The ARM resource identifier of the Azure Compute
                                          Gallery Image. Compute Nodes in the Pool will be created
                                          using this Image Id. This is of the form
                                          /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/galleries/{galleryName}/images/{imageDefinitionName}/versions/{VersionId}
                                          or
                                          /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/galleries/{galleryName}/images/{imageDefinitionName}
                                          for always defaulting to the latest image version. This
                                          property is mutually exclusive with other ImageReference
                                          properties. The Azure Compute Gallery Image must have
                                          replicas in the same region and must be in the same
                                          subscription as the Azure Batch account. If the image version
                                          is not specified in the imageId, the latest version will be
                                          used. For information about the firewall settings for the
                                          Batch Compute Node agent to communicate with the Batch
                                          service see
                                          https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration.
                                    },
                                    "nodeAgentSKUId": "str",  # The SKU of the
                                      Batch Compute Node agent to be provisioned on Compute Nodes in
                                      the Pool. The Batch Compute Node agent is a program that runs on
                                      each Compute Node in the Pool, and provides the
                                      command-and-control interface between the Compute Node and the
                                      Batch service. There are different implementations of the Compute
                                      Node agent, known as SKUs, for different operating systems. You
                                      must specify a Compute Node agent SKU which matches the selected
                                      Image reference. To get the list of supported Compute Node agent
                                      SKUs along with their list of verified Image references, see the
                                      'List supported Compute Node agent SKUs' operation. Required.
                                    "containerConfiguration": {
                                        "type": "str",  # The container
                                          technology to be used. Required. Known values are:
                                          "dockerCompatible" and "criCompatible".
                                        "containerImageNames": [
                                            "str"  # Optional. The
                                              collection of container Image names. This is the full
                                              Image reference, as would be specified to "docker pull".
                                              An Image will be sourced from the default Docker registry
                                              unless the Image is fully qualified with an alternative
                                              registry.
                                        ],
                                        "containerRegistries": [
                                            {
                                                "identityReference":
                                                  {
                                                    "resourceId":
                                                      "str"  # Optional. The ARM resource id of the
                                                      user assigned identity.
                                                },
                                                "password": "str",  #
                                                  Optional. The password to log into the registry
                                                  server.
                                                "registryServer":
                                                  "str",  # Optional. The registry URL. If omitted, the
                                                  default is "docker.io".
                                                "username": "str"  #
                                                  Optional. The user name to log into the registry
                                                  server.
                                            }
                                        ]
                                    },
                                    "dataDisks": [
                                        {
                                            "diskSizeGB": 0,  # The
                                              initial disk size in gigabytes. Required.
                                            "lun": 0,  # The logical unit
                                              number. The logicalUnitNumber is used to uniquely
                                              identify each data disk. If attaching multiple disks,
                                              each should have a distinct logicalUnitNumber. The value
                                              must be between 0 and 63, inclusive. Required.
                                            "caching": "str",  #
                                              Optional. The type of caching to be enabled for the data
                                              disks. The default value for caching is readwrite. For
                                              information about the caching options see:
                                              https://blogs.msdn.microsoft.com/windowsazurestorage/2012/06/27/exploring-windows-azure-drives-disks-and-images/.
                                              Known values are: "none", "readonly", and "readwrite".
                                            "storageAccountType": "str"
                                              # Optional. The storage Account type to be used for the
                                              data disk. If omitted, the default is "standard_lrs".
                                              Known values are: "standard_lrs", "premium_lrs", and
                                              "standardssd_lrs".
                                        }
                                    ],
                                    "diskEncryptionConfiguration": {
                                        "targets": [
                                            "str"  # Optional. The list
                                              of disk targets Batch Service will encrypt on the compute
                                              node. If omitted, no disks on the compute nodes in the
                                              pool will be encrypted. On Linux pool, only
                                              "TemporaryDisk" is supported; on Windows pool, "OsDisk"
                                              and "TemporaryDisk" must be specified.
                                        ]
                                    },
                                    "extensions": [
                                        {
                                            "name": "str",  # The name of
                                              the virtual machine extension. Required.
                                            "publisher": "str",  # The
                                              name of the extension handler publisher. Required.
                                            "type": "str",  # The type of
                                              the extension. Required.
                                            "autoUpgradeMinorVersion":
                                              bool,  # Optional. Indicates whether the extension should
                                              use a newer minor version if one is available at
                                              deployment time. Once deployed, however, the extension
                                              will not upgrade minor versions unless redeployed, even
                                              with this property set to true.
                                            "enableAutomaticUpgrade":
                                              bool,  # Optional. Indicates whether the extension should
                                              be automatically upgraded by the platform if there is a
                                              newer version of the extension available.
                                            "protectedSettings": {
                                                "str": "str"  #
                                                  Optional. The extension can contain either
                                                  protectedSettings or protectedSettingsFromKeyVault or
                                                  no protected settings at all.
                                            },
                                            "provisionAfterExtensions": [
                                                "str"  # Optional.
                                                  The collection of extension names. Collection of
                                                  extension names after which this extension needs to
                                                  be provisioned.
                                            ],
                                            "settings": {
                                                "str": "str"  #
                                                  Optional. JSON formatted public settings for the
                                                  extension.
                                            },
                                            "typeHandlerVersion": "str"
                                              # Optional. The version of script handler.
                                        }
                                    ],
                                    "licenseType": "str",  # Optional. This only
                                      applies to Images that contain the Windows operating system, and
                                      should only be used when you hold valid on-premises licenses for
                                      the Compute Nodes which will be deployed. If omitted, no
                                      on-premises licensing discount is applied. Values are:
                                      Windows_Server - The on-premises license is for Windows Server.
                                      Windows_Client - The on-premises license is for Windows Client.
                                    "nodePlacementConfiguration": {
                                        "policy": "str"  # Optional. Node
                                          placement Policy type on Batch Pools. Allocation policy used
                                          by Batch Service to provision the nodes. If not specified,
                                          Batch will use the regional policy. Known values are:
                                          "regional" and "zonal".
                                    },
                                    "osDisk": {
                                        "caching": "str",  # Optional.
                                          Specifies the caching requirements. Possible values are:
                                          None, ReadOnly, ReadWrite. The default values are: None for
                                          Standard storage. ReadOnly for Premium storage. Known values
                                          are: "none", "readonly", and "readwrite".
                                        "diskSizeGB": 0,  # Optional. The
                                          initial disk size in GB when creating new OS disk.
                                        "ephemeralOSDiskSettings": {
                                            "placement": "str"  #
                                              Optional. Specifies the ephemeral disk placement for
                                              operating system disk for all VMs in the pool. This
                                              property can be used by user in the request to choose the
                                              location e.g., cache disk space for Ephemeral OS disk
                                              provisioning. For more information on Ephemeral OS disk
                                              size requirements, please refer to Ephemeral OS disk size
                                              requirements for Windows VMs at
                                              https://docs.microsoft.com/en-us/azure/virtual-machines/windows/ephemeral-os-disks#size-requirements
                                              and Linux VMs at
                                              https://docs.microsoft.com/en-us/azure/virtual-machines/linux/ephemeral-os-disks#size-requirements.
                                              "cachedisk"
                                        },
                                        "managedDisk": {
                                            "storageAccountType": "str"
                                              # The storage account type for managed disk. Required.
                                              Known values are: "standard_lrs", "premium_lrs", and
                                              "standardssd_lrs".
                                        },
                                        "writeAcceleratorEnabled": bool  #
                                          Optional. Specifies whether writeAccelerator should be
                                          enabled or disabled on the disk.
                                    },
                                    "securityProfile": {
                                        "encryptionAtHost": bool,  # This
                                          property can be used by user in the request to enable or
                                          disable the Host Encryption for the virtual machine or
                                          virtual machine scale set. This will enable the encryption
                                          for all the disks including Resource/Temp disk at host
                                          itself. Required.
                                        "securityType": "str",  # Specifies
                                          the SecurityType of the virtual machine. It has to be set to
                                          any specified value to enable UefiSettings. Required.
                                          "trustedLaunch"
                                        "uefiSettings": {
                                            "secureBootEnabled": bool,  #
                                              Optional. Specifies whether secure boot should be enabled
                                              on the virtual machine.
                                            "vTpmEnabled": bool  #
                                              Optional. Specifies whether vTPM should be enabled on the
                                              virtual machine.
                                        }
                                    },
                                    "serviceArtifactReference": {
                                        "id": "str"  # The service artifact
                                          reference id of ServiceArtifactReference. The service
                                          artifact reference id in the form of
                                          /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/galleries/{galleryName}/serviceArtifacts/{serviceArtifactName}/vmArtifactsProfiles/{vmArtifactsProfilesName}.
                                          Required.
                                    },
                                    "windowsConfiguration": {
                                        "enableAutomaticUpdates": bool  #
                                          Optional. Whether automatic updates are enabled on the
                                          virtual machine. If omitted, the default value is true.
                                    }
                                }
                            }
                        },
                        "poolId": "str"  # Optional. The ID of an existing Pool. All the
                          Tasks of the Job will run on the specified Pool. You must ensure that the
                          Pool referenced by this property exists. If the Pool does not exist at the
                          time the Batch service tries to schedule a Job, no Tasks for the Job will run
                          until you create a Pool with that id. Note that the Batch service will not
                          reject the Job request; it will simply not run Tasks until the Pool exists.
                          You must specify either the Pool ID or the auto Pool specification, but not
                          both.
                    },
                    "allowTaskPreemption": bool,  # Optional. Whether Tasks in this job can be
                      preempted by other high priority jobs. If the value is set to True, other high
                      priority jobs submitted to the system will take precedence and will be able
                      requeue tasks from this job. You can update a job's allowTaskPreemption after it
                      has been created using the update job API.
                    "commonEnvironmentSettings": [
                        {
                            "name": "str",  # The name of the environment variable.
                              Required.
                            "value": "str"  # Optional. The value of the environment
                              variable.
                        }
                    ],
                    "constraints": {
                        "maxTaskRetryCount": 0,  # Optional. The maximum number of times each
                          Task may be retried. The Batch service retries a Task if its exit code is
                          nonzero. Note that this value specifically controls the number of retries.
                          The Batch service will try each Task once, and may then retry up to this
                          limit. For example, if the maximum retry count is 3, Batch tries a Task up to
                          4 times (one initial try and 3 retries). If the maximum retry count is 0, the
                          Batch service does not retry Tasks. If the maximum retry count is -1, the
                          Batch service retries Tasks without limit. The default value is 0 (no
                          retries).
                        "maxWallClockTime": "1 day, 0:00:00"  # Optional. The maximum elapsed
                          time that the Job may run, measured from the time the Job is created. If the
                          Job does not complete within the time limit, the Batch service terminates it
                          and any Tasks that are still running. In this case, the termination reason
                          will be MaxWallClockTimeExpiry. If this property is not specified, there is
                          no time limit on how long the Job may run.
                    },
                    "creationTime": "2020-02-20 00:00:00",  # Optional. The creation time of the
                      Job.
                    "displayName": "str",  # Optional. The display name for the Job.
                    "eTag": "str",  # Optional. The ETag of the Job. This is an opaque string.
                      You can use it to detect whether the Job has changed between requests. In
                      particular, you can be pass the ETag when updating a Job to specify that your
                      changes should take effect only if nobody else has modified the Job in the
                      meantime.
                    "executionInfo": {
                        "startTime": "2020-02-20 00:00:00",  # The start time of the Job.
                          This is the time at which the Job was created. Required.
                        "endTime": "2020-02-20 00:00:00",  # Optional. The completion time of
                          the Job. This property is set only if the Job is in the completed state.
                        "poolId": "str",  # Optional. The ID of the Pool to which this Job is
                          assigned. This element contains the actual Pool where the Job is assigned.
                          When you get Job details from the service, they also contain a poolInfo
                          element, which contains the Pool configuration data from when the Job was
                          added or updated. That poolInfo element may also contain a poolId element. If
                          it does, the two IDs are the same. If it does not, it means the Job ran on an
                          auto Pool, and this property contains the ID of that auto Pool.
                        "schedulingError": {
                            "category": "str",  # The category of the Job scheduling
                              error. Required. Known values are: "usererror" and "servererror".
                            "code": "str",  # Optional. An identifier for the Job
                              scheduling error. Codes are invariant and are intended to be consumed
                              programmatically.
                            "details": [
                                {
                                    "name": "str",  # Optional. The name in the
                                      name-value pair.
                                    "value": "str"  # Optional. The value in the
                                      name-value pair.
                                }
                            ],
                            "message": "str"  # Optional. A message describing the Job
                              scheduling error, intended to be suitable for display in a user
                              interface.
                        },
                        "terminateReason": "str"  # Optional. A string describing the reason
                          the Job ended. This property is set only if the Job is in the completed
                          state. If the Batch service terminates the Job, it sets the reason as
                          follows: JMComplete - the Job Manager Task completed, and killJobOnCompletion
                          was set to true. MaxWallClockTimeExpiry - the Job reached its
                          maxWallClockTime constraint. TerminateJobSchedule - the Job ran as part of a
                          schedule, and the schedule terminated. AllTasksComplete - the Job's
                          onAllTasksComplete attribute is set to terminatejob, and all Tasks in the Job
                          are complete. TaskFailed - the Job's onTaskFailure attribute is set to
                          performExitOptionsJobAction, and a Task in the Job failed with an exit
                          condition that specified a jobAction of terminatejob. Any other string is a
                          user-defined reason specified in a call to the 'Terminate a Job' operation.
                    },
                    "id": "str",  # Optional. A string that uniquely identifies the Job within
                      the Account. The ID is case-preserving and case-insensitive (that is, you may not
                      have two IDs within an Account that differ only by case).
                    "jobManagerTask": {
                        "commandLine": "str",  # The command line of the Job Manager Task.
                          The command line does not run under a shell, and therefore cannot take
                          advantage of shell features such as environment variable expansion. If you
                          want to take advantage of such features, you should invoke the shell in the
                          command line, for example using "cmd /c MyCommand" in Windows or "/bin/sh -c
                          MyCommand" in Linux. If the command line refers to file paths, it should use
                          a relative path (relative to the Task working directory), or use the Batch
                          provided environment variable
                          (https://docs.microsoft.com/en-us/azure/batch/batch-compute-node-environment-variables).
                          Required.
                        "id": "str",  # A string that uniquely identifies the Job Manager
                          Task within the Job. The ID can contain any combination of alphanumeric
                          characters including hyphens and underscores and cannot contain more than 64
                          characters. Required.
                        "allowLowPriorityNode": bool,  # Optional. Whether the Job Manager
                          Task may run on a Spot/Low-priority Compute Node. The default value is true.
                        "applicationPackageReferences": [
                            {
                                "applicationId": "str",  # The ID of the application
                                  to deploy. When creating a pool, the package's application ID must be
                                  fully qualified
                                  (/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/applications/{applicationName}).
                                  Required.
                                "version": "str"  # Optional. The version of the
                                  application to deploy. If omitted, the default version is deployed.
                                  If this is omitted on a Pool, and no default version is specified for
                                  this application, the request fails with the error code
                                  InvalidApplicationPackageReferences and HTTP status code 409. If this
                                  is omitted on a Task, and no default version is specified for this
                                  application, the Task fails with a pre-processing error.
                            }
                        ],
                        "authenticationTokenSettings": {
                            "access": [
                                "str"  # Optional. The Batch resources to which the
                                  token grants access. The authentication token grants access to a
                                  limited set of Batch service operations. Currently the only supported
                                  value for the access property is 'job', which grants access to all
                                  operations related to the Job which contains the Task.
                            ]
                        },
                        "constraints": {
                            "maxTaskRetryCount": 0,  # Optional. The maximum number of
                              times the Task may be retried. The Batch service retries a Task if its
                              exit code is nonzero. Note that this value specifically controls the
                              number of retries for the Task executable due to a nonzero exit code. The
                              Batch service will try the Task once, and may then retry up to this
                              limit. For example, if the maximum retry count is 3, Batch tries the Task
                              up to 4 times (one initial try and 3 retries). If the maximum retry count
                              is 0, the Batch service does not retry the Task after the first attempt.
                              If the maximum retry count is -1, the Batch service retries the Task
                              without limit, however this is not recommended for a start task or any
                              task. The default value is 0 (no retries).
                            "maxWallClockTime": "1 day, 0:00:00",  # Optional. The
                              maximum elapsed time that the Task may run, measured from the time the
                              Task starts. If the Task does not complete within the time limit, the
                              Batch service terminates it. If this is not specified, there is no time
                              limit on how long the Task may run.
                            "retentionTime": "1 day, 0:00:00"  # Optional. The minimum
                              time to retain the Task directory on the Compute Node where it ran, from
                              the time it completes execution. After this time, the Batch service may
                              delete the Task directory and all its contents. The default is 7 days,
                              i.e. the Task directory will be retained for 7 days unless the Compute
                              Node is removed or the Job is deleted.
                        },
                        "containerSettings": {
                            "imageName": "str",  # The Image to use to create the
                              container in which the Task will run. This is the full Image reference,
                              as would be specified to "docker pull". If no tag is provided as part of
                              the Image name, the tag ":latest" is used as a default. Required.
                            "containerRunOptions": "str",  # Optional. Additional options
                              to the container create command. These additional options are supplied as
                              arguments to the "docker create" command, in addition to those controlled
                              by the Batch Service.
                            "registry": {
                                "identityReference": {
                                    "resourceId": "str"  # Optional. The ARM
                                      resource id of the user assigned identity.
                                },
                                "password": "str",  # Optional. The password to log
                                  into the registry server.
                                "registryServer": "str",  # Optional. The registry
                                  URL. If omitted, the default is "docker.io".
                                "username": "str"  # Optional. The user name to log
                                  into the registry server.
                            },
                            "workingDirectory": "str"  # Optional. The location of the
                              container Task working directory. The default is 'taskWorkingDirectory'.
                              Known values are: "taskWorkingDirectory" and "containerImageDefault".
                        },
                        "displayName": "str",  # Optional. The display name of the Job
                          Manager Task. It need not be unique and can contain any Unicode characters up
                          to a maximum length of 1024.
                        "environmentSettings": [
                            {
                                "name": "str",  # The name of the environment
                                  variable. Required.
                                "value": "str"  # Optional. The value of the
                                  environment variable.
                            }
                        ],
                        "killJobOnCompletion": bool,  # Optional. Whether completion of the
                          Job Manager Task signifies completion of the entire Job. If true, when the
                          Job Manager Task completes, the Batch service marks the Job as complete. If
                          any Tasks are still running at this time (other than Job Release), those
                          Tasks are terminated. If false, the completion of the Job Manager Task does
                          not affect the Job status. In this case, you should either use the
                          onAllTasksComplete attribute to terminate the Job, or have a client or user
                          terminate the Job explicitly. An example of this is if the Job Manager
                          creates a set of Tasks but then takes no further role in their execution. The
                          default value is true. If you are using the onAllTasksComplete and
                          onTaskFailure attributes to control Job lifetime, and using the Job Manager
                          Task only to create the Tasks for the Job (not to monitor progress), then it
                          is important to set killJobOnCompletion to false.
                        "outputFiles": [
                            {
                                "destination": {
                                    "container": {
                                        "containerUrl": "str",  # The URL of
                                          the container within Azure Blob Storage to which to upload
                                          the file(s). If not using a managed identity, the URL must
                                          include a Shared Access Signature (SAS) granting write
                                          permissions to the container. Required.
                                        "identityReference": {
                                            "resourceId": "str"  #
                                              Optional. The ARM resource id of the user assigned
                                              identity.
                                        },
                                        "path": "str",  # Optional. The
                                          destination blob or virtual directory within the Azure
                                          Storage container. If filePattern refers to a specific file
                                          (i.e. contains no wildcards), then path is the name of the
                                          blob to which to upload that file. If filePattern contains
                                          one or more wildcards (and therefore may match multiple
                                          files), then path is the name of the blob virtual directory
                                          (which is prepended to each blob name) to which to upload the
                                          file(s). If omitted, file(s) are uploaded to the root of the
                                          container with a blob name matching their file name.
                                        "uploadHeaders": [
                                            {
                                                "name": "str",  # The
                                                  case-insensitive name of the header to be used while
                                                  uploading output files. Required.
                                                "value": "str"  #
                                                  Optional. The value of the header to be used while
                                                  uploading output files.
                                            }
                                        ]
                                    }
                                },
                                "filePattern": "str",  # A pattern indicating which
                                  file(s) to upload. Both relative and absolute paths are supported.
                                  Relative paths are relative to the Task working directory. The
                                  following wildcards are supported: * matches 0 or more characters
                                  (for example pattern abc* would match abc or abcdef), ** matches any
                                  directory, ? matches any single character, [abc] matches one
                                  character in the brackets, and [a-c] matches one character in the
                                  range. Brackets can include a negation to match any character not
                                  specified (for example [!abc] matches any character but a, b, or c).
                                  If a file name starts with "." it is ignored by default but may be
                                  matched by specifying it explicitly (for example *.gif will not match
                                  .a.gif, but .*.gif will). A simple example: **"" *.txt matches any
                                  file that does not start in '.' and ends with .txt in the Task
                                  working directory or any subdirectory. If the filename contains a
                                  wildcard character it can be escaped using brackets (for example
                                  abc["" *] would match a file named abc*"" ). Note that both and / are
                                  treated as directory separators on Windows, but only / is on Linux.
                                  Environment variables (%var% on Windows or $var on Linux) are
                                  expanded prior to the pattern being applied. Required.
                                "uploadOptions": {
                                    "uploadCondition": "str"  # The conditions
                                      under which the Task output file or set of files should be
                                      uploaded. The default is taskcompletion. Required. Known values
                                      are: "tasksuccess", "taskfailure", and "taskcompletion".
                                }
                            }
                        ],
                        "requiredSlots": 0,  # Optional. The number of scheduling slots that
                          the Task requires to run. The default is 1. A Task can only be scheduled to
                          run on a compute node if the node has enough free scheduling slots available.
                          For multi-instance Tasks, this property is not supported and must not be
                          specified.
                        "resourceFiles": [
                            {
                                "autoStorageContainerName": "str",  # Optional. The
                                  storage container name in the auto storage Account. The
                                  autoStorageContainerName, storageContainerUrl and httpUrl properties
                                  are mutually exclusive and one of them must be specified.
                                "blobPrefix": "str",  # Optional. The blob prefix to
                                  use when downloading blobs from an Azure Storage container. Only the
                                  blobs whose names begin with the specified prefix will be downloaded.
                                  The property is valid only when autoStorageContainerName or
                                  storageContainerUrl is used. This prefix can be a partial filename or
                                  a subdirectory. If a prefix is not specified, all the files in the
                                  container will be downloaded.
                                "fileMode": "str",  # Optional. The file permission
                                  mode attribute in octal format. This property applies only to files
                                  being downloaded to Linux Compute Nodes. It will be ignored if it is
                                  specified for a resourceFile which will be downloaded to a Windows
                                  Compute Node. If this property is not specified for a Linux Compute
                                  Node, then a default value of 0770 is applied to the file.
                                "filePath": "str",  # Optional. The location on the
                                  Compute Node to which to download the file(s), relative to the Task's
                                  working directory. If the httpUrl property is specified, the filePath
                                  is required and describes the path which the file will be downloaded
                                  to, including the filename. Otherwise, if the
                                  autoStorageContainerName or storageContainerUrl property is
                                  specified, filePath is optional and is the directory to download the
                                  files to. In the case where filePath is used as a directory, any
                                  directory structure already associated with the input data will be
                                  retained in full and appended to the specified filePath directory.
                                  The specified relative path cannot break out of the Task's working
                                  directory (for example by using '..').
                                "httpUrl": "str",  # Optional. The URL of the file to
                                  download. The autoStorageContainerName, storageContainerUrl and
                                  httpUrl properties are mutually exclusive and one of them must be
                                  specified. If the URL points to Azure Blob Storage, it must be
                                  readable from compute nodes. There are three ways to get such a URL
                                  for a blob in Azure storage: include a Shared Access Signature (SAS)
                                  granting read permissions on the blob, use a managed identity with
                                  read permission, or set the ACL for the blob or its container to
                                  allow public access.
                                "identityReference": {
                                    "resourceId": "str"  # Optional. The ARM
                                      resource id of the user assigned identity.
                                },
                                "storageContainerUrl": "str"  # Optional. The URL of
                                  the blob container within Azure Blob Storage. The
                                  autoStorageContainerName, storageContainerUrl and httpUrl properties
                                  are mutually exclusive and one of them must be specified. This URL
                                  must be readable and listable from compute nodes. There are three
                                  ways to get such a URL for a container in Azure storage: include a
                                  Shared Access Signature (SAS) granting read and list permissions on
                                  the container, use a managed identity with read and list permissions,
                                  or set the ACL for the container to allow public access.
                            }
                        ],
                        "runExclusive": bool,  # Optional. Whether the Job Manager Task
                          requires exclusive use of the Compute Node where it runs. If true, no other
                          Tasks will run on the same Node for as long as the Job Manager is running. If
                          false, other Tasks can run simultaneously with the Job Manager on a Compute
                          Node. The Job Manager Task counts normally against the Compute Node's
                          concurrent Task limit, so this is only relevant if the Compute Node allows
                          multiple concurrent Tasks. The default value is true.
                        "userIdentity": {
                            "autoUser": {
                                "elevationLevel": "str",  # Optional. The elevation
                                  level of the auto user. The default value is nonAdmin. Known values
                                  are: "nonadmin" and "admin".
                                "scope": "str"  # Optional. The scope for the auto
                                  user. The default value is pool. If the pool is running Windows, a
                                  value of Task should be specified if stricter isolation between tasks
                                  is required, such as if the task mutates the registry in a way which
                                  could impact other tasks. Known values are: "task" and "pool".
                            },
                            "username": "str"  # Optional. The name of the user identity
                              under which the Task is run. The userName and autoUser properties are
                              mutually exclusive; you must specify one but not both.
                        }
                    },
                    "jobPreparationTask": {
                        "commandLine": "str",  # The command line of the Job Preparation
                          Task. The command line does not run under a shell, and therefore cannot take
                          advantage of shell features such as environment variable expansion. If you
                          want to take advantage of such features, you should invoke the shell in the
                          command line, for example using "cmd /c MyCommand" in Windows or "/bin/sh -c
                          MyCommand" in Linux. If the command line refers to file paths, it should use
                          a relative path (relative to the Task working directory), or use the Batch
                          provided environment variable
                          (https://docs.microsoft.com/en-us/azure/batch/batch-compute-node-environment-variables).
                          Required.
                        "constraints": {
                            "maxTaskRetryCount": 0,  # Optional. The maximum number of
                              times the Task may be retried. The Batch service retries a Task if its
                              exit code is nonzero. Note that this value specifically controls the
                              number of retries for the Task executable due to a nonzero exit code. The
                              Batch service will try the Task once, and may then retry up to this
                              limit. For example, if the maximum retry count is 3, Batch tries the Task
                              up to 4 times (one initial try and 3 retries). If the maximum retry count
                              is 0, the Batch service does not retry the Task after the first attempt.
                              If the maximum retry count is -1, the Batch service retries the Task
                              without limit, however this is not recommended for a start task or any
                              task. The default value is 0 (no retries).
                            "maxWallClockTime": "1 day, 0:00:00",  # Optional. The
                              maximum elapsed time that the Task may run, measured from the time the
                              Task starts. If the Task does not complete within the time limit, the
                              Batch service terminates it. If this is not specified, there is no time
                              limit on how long the Task may run.
                            "retentionTime": "1 day, 0:00:00"  # Optional. The minimum
                              time to retain the Task directory on the Compute Node where it ran, from
                              the time it completes execution. After this time, the Batch service may
                              delete the Task directory and all its contents. The default is 7 days,
                              i.e. the Task directory will be retained for 7 days unless the Compute
                              Node is removed or the Job is deleted.
                        },
                        "containerSettings": {
                            "imageName": "str",  # The Image to use to create the
                              container in which the Task will run. This is the full Image reference,
                              as would be specified to "docker pull". If no tag is provided as part of
                              the Image name, the tag ":latest" is used as a default. Required.
                            "containerRunOptions": "str",  # Optional. Additional options
                              to the container create command. These additional options are supplied as
                              arguments to the "docker create" command, in addition to those controlled
                              by the Batch Service.
                            "registry": {
                                "identityReference": {
                                    "resourceId": "str"  # Optional. The ARM
                                      resource id of the user assigned identity.
                                },
                                "password": "str",  # Optional. The password to log
                                  into the registry server.
                                "registryServer": "str",  # Optional. The registry
                                  URL. If omitted, the default is "docker.io".
                                "username": "str"  # Optional. The user name to log
                                  into the registry server.
                            },
                            "workingDirectory": "str"  # Optional. The location of the
                              container Task working directory. The default is 'taskWorkingDirectory'.
                              Known values are: "taskWorkingDirectory" and "containerImageDefault".
                        },
                        "environmentSettings": [
                            {
                                "name": "str",  # The name of the environment
                                  variable. Required.
                                "value": "str"  # Optional. The value of the
                                  environment variable.
                            }
                        ],
                        "id": "str",  # Optional. A string that uniquely identifies the Job
                          Preparation Task within the Job. The ID can contain any combination of
                          alphanumeric characters including hyphens and underscores and cannot contain
                          more than 64 characters. If you do not specify this property, the Batch
                          service assigns a default value of 'jobpreparation'. No other Task in the Job
                          can have the same ID as the Job Preparation Task. If you try to submit a Task
                          with the same id, the Batch service rejects the request with error code
                          TaskIdSameAsJobPreparationTask; if you are calling the REST API directly, the
                          HTTP status code is 409 (Conflict).
                        "rerunOnNodeRebootAfterSuccess": bool,  # Optional. Whether the Batch
                          service should rerun the Job Preparation Task after a Compute Node reboots.
                          The Job Preparation Task is always rerun if a Compute Node is reimaged, or if
                          the Job Preparation Task did not complete (e.g. because the reboot occurred
                          while the Task was running). Therefore, you should always write a Job
                          Preparation Task to be idempotent and to behave correctly if run multiple
                          times. The default value is true.
                        "resourceFiles": [
                            {
                                "autoStorageContainerName": "str",  # Optional. The
                                  storage container name in the auto storage Account. The
                                  autoStorageContainerName, storageContainerUrl and httpUrl properties
                                  are mutually exclusive and one of them must be specified.
                                "blobPrefix": "str",  # Optional. The blob prefix to
                                  use when downloading blobs from an Azure Storage container. Only the
                                  blobs whose names begin with the specified prefix will be downloaded.
                                  The property is valid only when autoStorageContainerName or
                                  storageContainerUrl is used. This prefix can be a partial filename or
                                  a subdirectory. If a prefix is not specified, all the files in the
                                  container will be downloaded.
                                "fileMode": "str",  # Optional. The file permission
                                  mode attribute in octal format. This property applies only to files
                                  being downloaded to Linux Compute Nodes. It will be ignored if it is
                                  specified for a resourceFile which will be downloaded to a Windows
                                  Compute Node. If this property is not specified for a Linux Compute
                                  Node, then a default value of 0770 is applied to the file.
                                "filePath": "str",  # Optional. The location on the
                                  Compute Node to which to download the file(s), relative to the Task's
                                  working directory. If the httpUrl property is specified, the filePath
                                  is required and describes the path which the file will be downloaded
                                  to, including the filename. Otherwise, if the
                                  autoStorageContainerName or storageContainerUrl property is
                                  specified, filePath is optional and is the directory to download the
                                  files to. In the case where filePath is used as a directory, any
                                  directory structure already associated with the input data will be
                                  retained in full and appended to the specified filePath directory.
                                  The specified relative path cannot break out of the Task's working
                                  directory (for example by using '..').
                                "httpUrl": "str",  # Optional. The URL of the file to
                                  download. The autoStorageContainerName, storageContainerUrl and
                                  httpUrl properties are mutually exclusive and one of them must be
                                  specified. If the URL points to Azure Blob Storage, it must be
                                  readable from compute nodes. There are three ways to get such a URL
                                  for a blob in Azure storage: include a Shared Access Signature (SAS)
                                  granting read permissions on the blob, use a managed identity with
                                  read permission, or set the ACL for the blob or its container to
                                  allow public access.
                                "identityReference": {
                                    "resourceId": "str"  # Optional. The ARM
                                      resource id of the user assigned identity.
                                },
                                "storageContainerUrl": "str"  # Optional. The URL of
                                  the blob container within Azure Blob Storage. The
                                  autoStorageContainerName, storageContainerUrl and httpUrl properties
                                  are mutually exclusive and one of them must be specified. This URL
                                  must be readable and listable from compute nodes. There are three
                                  ways to get such a URL for a container in Azure storage: include a
                                  Shared Access Signature (SAS) granting read and list permissions on
                                  the container, use a managed identity with read and list permissions,
                                  or set the ACL for the container to allow public access.
                            }
                        ],
                        "userIdentity": {
                            "autoUser": {
                                "elevationLevel": "str",  # Optional. The elevation
                                  level of the auto user. The default value is nonAdmin. Known values
                                  are: "nonadmin" and "admin".
                                "scope": "str"  # Optional. The scope for the auto
                                  user. The default value is pool. If the pool is running Windows, a
                                  value of Task should be specified if stricter isolation between tasks
                                  is required, such as if the task mutates the registry in a way which
                                  could impact other tasks. Known values are: "task" and "pool".
                            },
                            "username": "str"  # Optional. The name of the user identity
                              under which the Task is run. The userName and autoUser properties are
                              mutually exclusive; you must specify one but not both.
                        },
                        "waitForSuccess": bool  # Optional. Whether the Batch service should
                          wait for the Job Preparation Task to complete successfully before scheduling
                          any other Tasks of the Job on the Compute Node. A Job Preparation Task has
                          completed successfully if it exits with exit code 0. If true and the Job
                          Preparation Task fails on a Node, the Batch service retries the Job
                          Preparation Task up to its maximum retry count (as specified in the
                          constraints element). If the Task has still not completed successfully after
                          all retries, then the Batch service will not schedule Tasks of the Job to the
                          Node. The Node remains active and eligible to run Tasks of other Jobs. If
                          false, the Batch service will not wait for the Job Preparation Task to
                          complete. In this case, other Tasks of the Job can start executing on the
                          Compute Node while the Job Preparation Task is still running; and even if the
                          Job Preparation Task fails, new Tasks will continue to be scheduled on the
                          Compute Node. The default value is true.
                    },
                    "jobReleaseTask": {
                        "commandLine": "str",  # The command line of the Job Release Task.
                          The command line does not run under a shell, and therefore cannot take
                          advantage of shell features such as environment variable expansion. If you
                          want to take advantage of such features, you should invoke the shell in the
                          command line, for example using "cmd /c MyCommand" in Windows or "/bin/sh -c
                          MyCommand" in Linux. If the command line refers to file paths, it should use
                          a relative path (relative to the Task working directory), or use the Batch
                          provided environment variable
                          (https://docs.microsoft.com/en-us/azure/batch/batch-compute-node-environment-variables).
                          Required.
                        "containerSettings": {
                            "imageName": "str",  # The Image to use to create the
                              container in which the Task will run. This is the full Image reference,
                              as would be specified to "docker pull". If no tag is provided as part of
                              the Image name, the tag ":latest" is used as a default. Required.
                            "containerRunOptions": "str",  # Optional. Additional options
                              to the container create command. These additional options are supplied as
                              arguments to the "docker create" command, in addition to those controlled
                              by the Batch Service.
                            "registry": {
                                "identityReference": {
                                    "resourceId": "str"  # Optional. The ARM
                                      resource id of the user assigned identity.
                                },
                                "password": "str",  # Optional. The password to log
                                  into the registry server.
                                "registryServer": "str",  # Optional. The registry
                                  URL. If omitted, the default is "docker.io".
                                "username": "str"  # Optional. The user name to log
                                  into the registry server.
                            },
                            "workingDirectory": "str"  # Optional. The location of the
                              container Task working directory. The default is 'taskWorkingDirectory'.
                              Known values are: "taskWorkingDirectory" and "containerImageDefault".
                        },
                        "environmentSettings": [
                            {
                                "name": "str",  # The name of the environment
                                  variable. Required.
                                "value": "str"  # Optional. The value of the
                                  environment variable.
                            }
                        ],
                        "id": "str",  # Optional. A string that uniquely identifies the Job
                          Release Task within the Job. The ID can contain any combination of
                          alphanumeric characters including hyphens and underscores and cannot contain
                          more than 64 characters. If you do not specify this property, the Batch
                          service assigns a default value of 'jobrelease'. No other Task in the Job can
                          have the same ID as the Job Release Task. If you try to submit a Task with
                          the same id, the Batch service rejects the request with error code
                          TaskIdSameAsJobReleaseTask; if you are calling the REST API directly, the
                          HTTP status code is 409 (Conflict).
                        "maxWallClockTime": "1 day, 0:00:00",  # Optional. The maximum
                          elapsed time that the Job Release Task may run on a given Compute Node,
                          measured from the time the Task starts. If the Task does not complete within
                          the time limit, the Batch service terminates it. The default value is 15
                          minutes. You may not specify a timeout longer than 15 minutes. If you do, the
                          Batch service rejects it with an error; if you are calling the REST API
                          directly, the HTTP status code is 400 (Bad Request).
                        "resourceFiles": [
                            {
                                "autoStorageContainerName": "str",  # Optional. The
                                  storage container name in the auto storage Account. The
                                  autoStorageContainerName, storageContainerUrl and httpUrl properties
                                  are mutually exclusive and one of them must be specified.
                                "blobPrefix": "str",  # Optional. The blob prefix to
                                  use when downloading blobs from an Azure Storage container. Only the
                                  blobs whose names begin with the specified prefix will be downloaded.
                                  The property is valid only when autoStorageContainerName or
                                  storageContainerUrl is used. This prefix can be a partial filename or
                                  a subdirectory. If a prefix is not specified, all the files in the
                                  container will be downloaded.
                                "fileMode": "str",  # Optional. The file permission
                                  mode attribute in octal format. This property applies only to files
                                  being downloaded to Linux Compute Nodes. It will be ignored if it is
                                  specified for a resourceFile which will be downloaded to a Windows
                                  Compute Node. If this property is not specified for a Linux Compute
                                  Node, then a default value of 0770 is applied to the file.
                                "filePath": "str",  # Optional. The location on the
                                  Compute Node to which to download the file(s), relative to the Task's
                                  working directory. If the httpUrl property is specified, the filePath
                                  is required and describes the path which the file will be downloaded
                                  to, including the filename. Otherwise, if the
                                  autoStorageContainerName or storageContainerUrl property is
                                  specified, filePath is optional and is the directory to download the
                                  files to. In the case where filePath is used as a directory, any
                                  directory structure already associated with the input data will be
                                  retained in full and appended to the specified filePath directory.
                                  The specified relative path cannot break out of the Task's working
                                  directory (for example by using '..').
                                "httpUrl": "str",  # Optional. The URL of the file to
                                  download. The autoStorageContainerName, storageContainerUrl and
                                  httpUrl properties are mutually exclusive and one of them must be
                                  specified. If the URL points to Azure Blob Storage, it must be
                                  readable from compute nodes. There are three ways to get such a URL
                                  for a blob in Azure storage: include a Shared Access Signature (SAS)
                                  granting read permissions on the blob, use a managed identity with
                                  read permission, or set the ACL for the blob or its container to
                                  allow public access.
                                "identityReference": {
                                    "resourceId": "str"  # Optional. The ARM
                                      resource id of the user assigned identity.
                                },
                                "storageContainerUrl": "str"  # Optional. The URL of
                                  the blob container within Azure Blob Storage. The
                                  autoStorageContainerName, storageContainerUrl and httpUrl properties
                                  are mutually exclusive and one of them must be specified. This URL
                                  must be readable and listable from compute nodes. There are three
                                  ways to get such a URL for a container in Azure storage: include a
                                  Shared Access Signature (SAS) granting read and list permissions on
                                  the container, use a managed identity with read and list permissions,
                                  or set the ACL for the container to allow public access.
                            }
                        ],
                        "retentionTime": "1 day, 0:00:00",  # Optional. The minimum time to
                          retain the Task directory for the Job Release Task on the Compute Node. After
                          this time, the Batch service may delete the Task directory and all its
                          contents. The default is 7 days, i.e. the Task directory will be retained for
                          7 days unless the Compute Node is removed or the Job is deleted.
                        "userIdentity": {
                            "autoUser": {
                                "elevationLevel": "str",  # Optional. The elevation
                                  level of the auto user. The default value is nonAdmin. Known values
                                  are: "nonadmin" and "admin".
                                "scope": "str"  # Optional. The scope for the auto
                                  user. The default value is pool. If the pool is running Windows, a
                                  value of Task should be specified if stricter isolation between tasks
                                  is required, such as if the task mutates the registry in a way which
                                  could impact other tasks. Known values are: "task" and "pool".
                            },
                            "username": "str"  # Optional. The name of the user identity
                              under which the Task is run. The userName and autoUser properties are
                              mutually exclusive; you must specify one but not both.
                        }
                    },
                    "lastModified": "2020-02-20 00:00:00",  # Optional. The last modified time of
                      the Job. This is the last time at which the Job level data, such as the Job state
                      or priority, changed. It does not factor in task-level changes such as adding new
                      Tasks or Tasks changing state.
                    "maxParallelTasks": 0,  # Optional. The maximum number of tasks that can be
                      executed in parallel for the job. The value of maxParallelTasks must be -1 or
                      greater than 0 if specified. If not specified, the default value is -1, which
                      means there's no limit to the number of tasks that can be run at once. You can
                      update a job's maxParallelTasks after it has been created using the update job
                      API.
                    "metadata": [
                        {
                            "name": "str",  # The name of the metadata item. Required.
                            "value": "str"  # The value of the metadata item. Required.
                        }
                    ],
                    "networkConfiguration": {
                        "subnetId": "str"  # The ARM resource identifier of the virtual
                          network subnet which Compute Nodes running Tasks from the Job will join for
                          the duration of the Task. This will only work with a
                          VirtualMachineConfiguration Pool. The virtual network must be in the same
                          region and subscription as the Azure Batch Account. The specified subnet
                          should have enough free IP addresses to accommodate the number of Compute
                          Nodes which will run Tasks from the Job. This can be up to the number of
                          Compute Nodes in the Pool. The 'MicrosoftAzureBatch' service principal must
                          have the 'Classic Virtual Machine Contributor' Role-Based Access Control
                          (RBAC) role for the specified VNet so that Azure Batch service can schedule
                          Tasks on the Nodes. This can be verified by checking if the specified VNet
                          has any associated Network Security Groups (NSG). If communication to the
                          Nodes in the specified subnet is denied by an NSG, then the Batch service
                          will set the state of the Compute Nodes to unusable. This is of the form
                          /subscriptions/{subscription}/resourceGroups/{group}/providers/{provider}/virtualNetworks/{network}/subnets/{subnet}.
                          If the specified VNet has any associated Network Security Groups (NSG), then
                          a few reserved system ports must be enabled for inbound communication from
                          the Azure Batch service. For Pools created with a Virtual Machine
                          configuration, enable ports 29876 and 29877, as well as port 22 for Linux and
                          port 3389 for Windows. Port 443 is also required to be open for outbound
                          connections for communications to Azure Storage. For more details see:
                          https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration.
                          Required.
                    },
                    "onAllTasksComplete": "str",  # Optional. The action the Batch service should
                      take when all Tasks in the Job are in the completed state. The default is
                      noaction. Known values are: "noaction" and "terminatejob".
                    "onTaskFailure": "str",  # Optional. The action the Batch service should take
                      when any Task in the Job fails. A Task is considered to have failed if has a
                      failureInfo. A failureInfo is set if the Task completes with a non-zero exit code
                      after exhausting its retry count, or if there was an error starting the Task, for
                      example due to a resource file download error. The default is noaction. Known
                      values are: "noaction" and "performexitoptionsjobaction".
                    "previousState": "str",  # Optional. The previous state of the Job. This
                      property is not set if the Job is in its initial Active state. Known values are:
                      "active", "disabling", "disabled", "enabling", "terminating", "completed", and
                      "deleting".
                    "previousStateTransitionTime": "2020-02-20 00:00:00",  # Optional. The time
                      at which the Job entered its previous state. This property is not set if the Job
                      is in its initial Active state.
                    "priority": 0,  # Optional. The priority of the Job. Priority values can
                      range from -1000 to 1000, with -1000 being the lowest priority and 1000 being the
                      highest priority. The default value is 0.
                    "state": "str",  # Optional. The current state of the Job. Known values are:
                      "active", "disabling", "disabled", "enabling", "terminating", "completed", and
                      "deleting".
                    "stateTransitionTime": "2020-02-20 00:00:00",  # Optional. The time at which
                      the Job entered its current state.
                    "stats": {
                        "kernelCPUTime": "1 day, 0:00:00",  # The total kernel mode CPU time
                          (summed across all cores and all Compute Nodes) consumed by all Tasks in the
                          Job. Required.
                        "lastUpdateTime": "2020-02-20 00:00:00",  # The time at which the
                          statistics were last updated. All statistics are limited to the range between
                          startTime and lastUpdateTime. Required.
                        "numFailedTasks": 0,  # The total number of Tasks in the Job that
                          failed during the given time range. A Task fails if it exhausts its maximum
                          retry count without returning exit code 0. Required.
                        "numSucceededTasks": 0,  # The total number of Tasks successfully
                          completed in the Job during the given time range. A Task completes
                          successfully if it returns exit code 0. Required.
                        "numTaskRetries": 0,  # The total number of retries on all the Tasks
                          in the Job during the given time range. Required.
                        "readIOGiB": 0.0,  # The total amount of data in GiB read from disk
                          by all Tasks in the Job. Required.
                        "readIOps": 0,  # The total number of disk read operations made by
                          all Tasks in the Job. Required.
                        "startTime": "2020-02-20 00:00:00",  # The start time of the time
                          range covered by the statistics. Required.
                        "url": "str",  # The URL of the statistics. Required.
                        "userCPUTime": "1 day, 0:00:00",  # The total user mode CPU time
                          (summed across all cores and all Compute Nodes) consumed by all Tasks in the
                          Job. Required.
                        "waitTime": "1 day, 0:00:00",  # The total wait time of all Tasks in
                          the Job. The wait time for a Task is defined as the elapsed time between the
                          creation of the Task and the start of Task execution. (If the Task is retried
                          due to failures, the wait time is the time to the most recent Task
                          execution.) This value is only reported in the Account lifetime statistics;
                          it is not included in the Job statistics. Required.
                        "wallClockTime": "1 day, 0:00:00",  # The total wall clock time of
                          all Tasks in the Job.  The wall clock time is the elapsed time from when the
                          Task started running on a Compute Node to when it finished (or to the last
                          time the statistics were updated, if the Task had not finished by then). If a
                          Task was retried, this includes the wall clock time of all the Task retries.
                          Required.
                        "writeIOGiB": 0.0,  # The total amount of data in GiB written to disk
                          by all Tasks in the Job. Required.
                        "writeIOps": 0  # The total number of disk write operations made by
                          all Tasks in the Job. Required.
                    },
                    "url": "str",  # Optional. The URL of the Job.
                    "usesTaskDependencies": bool  # Optional. Whether Tasks in the Job can define
                      dependencies on each other. The default is false.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: str = kwargs.pop(
            "content_type", _headers.pop("content-type", "application/json; odata=minimalmetadata")
        )
        cls: ClsType[None] = kwargs.pop("cls", None)

        _content = json.dumps(job, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_batch_replace_job_request(
            job_id=job_id,
            time_out_in_seconds=time_out_in_seconds,
            ocpdate=ocpdate,
            if_modified_since=if_modified_since,
            if_unmodified_since=if_unmodified_since,
            etag=etag,
            match_condition=match_condition,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.BatchError, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["DataServiceId"] = self._deserialize("str", response.headers.get("DataServiceId"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def disable_job(  # pylint: disable=inconsistent-return-statements
        self,
        job_id: str,
        content: _models.BatchJobDisableContent,
        *,
        time_out_in_seconds: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        if_modified_since: Optional[datetime.datetime] = None,
        if_unmodified_since: Optional[datetime.datetime] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> None:
        # pylint: disable=line-too-long
        """Disables the specified Job, preventing new Tasks from running.

        The Batch Service immediately moves the Job to the disabling state. Batch then
        uses the disableTasks parameter to determine what to do with the currently
        running Tasks of the Job. The Job remains in the disabling state until the
        disable operation is completed and all Tasks have been dealt with according to
        the disableTasks option; the Job then moves to the disabled state. No new Tasks
        are started under the Job until it moves back to active state. If you try to
        disable a Job that is in any state other than active, disabling, or disabled,
        the request fails with status code 409.

        :param job_id: The ID of the Job to disable. Required.
        :type job_id: str
        :param content: The options to use for disabling the Job. Required.
        :type content: ~azure.batch.models.BatchJobDisableContent
        :keyword time_out_in_seconds: The maximum time that the server can spend processing the
         request, in seconds. The default is 30 seconds. If the value is larger than 30, the default
         will be used instead.". Default value is None.
        :paramtype time_out_in_seconds: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword if_modified_since: A timestamp indicating the last modified time of the resource known
         to the
         client. The operation will be performed only if the resource on the service has
         been modified since the specified time. Default value is None.
        :paramtype if_modified_since: ~datetime.datetime
        :keyword if_unmodified_since: A timestamp indicating the last modified time of the resource
         known to the
         client. The operation will be performed only if the resource on the service has
         not been modified since the specified time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                content = {
                    "disableTasks": "str"  # What to do with active Tasks associated with the
                      Job. Required. Known values are: "requeue", "terminate", and "wait".
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: str = kwargs.pop(
            "content_type", _headers.pop("content-type", "application/json; odata=minimalmetadata")
        )
        cls: ClsType[None] = kwargs.pop("cls", None)

        _content = json.dumps(content, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_batch_disable_job_request(
            job_id=job_id,
            time_out_in_seconds=time_out_in_seconds,
            ocpdate=ocpdate,
            if_modified_since=if_modified_since,
            if_unmodified_since=if_unmodified_since,
            etag=etag,
            match_condition=match_condition,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.BatchError, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["DataServiceId"] = self._deserialize("str", response.headers.get("DataServiceId"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def enable_job(  # pylint: disable=inconsistent-return-statements
        self,
        job_id: str,
        *,
        time_out_in_seconds: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        if_modified_since: Optional[datetime.datetime] = None,
        if_unmodified_since: Optional[datetime.datetime] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> None:
        """Enables the specified Job, allowing new Tasks to run.

        When you call this API, the Batch service sets a disabled Job to the enabling
        state. After the this operation is completed, the Job moves to the active
        state, and scheduling of new Tasks under the Job resumes. The Batch service
        does not allow a Task to remain in the active state for more than 180 days.
        Therefore, if you enable a Job containing active Tasks which were added more
        than 180 days ago, those Tasks will not run.

        :param job_id: The ID of the Job to enable. Required.
        :type job_id: str
        :keyword time_out_in_seconds: The maximum time that the server can spend processing the
         request, in seconds. The default is 30 seconds. If the value is larger than 30, the default
         will be used instead.". Default value is None.
        :paramtype time_out_in_seconds: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword if_modified_since: A timestamp indicating the last modified time of the resource known
         to the
         client. The operation will be performed only if the resource on the service has
         been modified since the specified time. Default value is None.
        :paramtype if_modified_since: ~datetime.datetime
        :keyword if_unmodified_since: A timestamp indicating the last modified time of the resource
         known to the
         client. The operation will be performed only if the resource on the service has
         not been modified since the specified time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_batch_enable_job_request(
            job_id=job_id,
            time_out_in_seconds=time_out_in_seconds,
            ocpdate=ocpdate,
            if_modified_since=if_modified_since,
            if_unmodified_since=if_unmodified_since,
            etag=etag,
            match_condition=match_condition,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.BatchError, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["DataServiceId"] = self._deserialize("str", response.headers.get("DataServiceId"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def terminate_job(  # pylint: disable=inconsistent-return-statements
        self,
        job_id: str,
        parameters: Optional[_models.BatchJobTerminateContent] = None,
        *,
        time_out_in_seconds: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        if_modified_since: Optional[datetime.datetime] = None,
        if_unmodified_since: Optional[datetime.datetime] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> None:
        # pylint: disable=line-too-long
        """Terminates the specified Job, marking it as completed.

        When a Terminate Job request is received, the Batch service sets the Job to the
        terminating state. The Batch service then terminates any running Tasks
        associated with the Job and runs any required Job release Tasks. Then the Job
        moves into the completed state. If there are any Tasks in the Job in the active
        state, they will remain in the active state. Once a Job is terminated, new
        Tasks cannot be added and any remaining active Tasks will not be scheduled.

        :param job_id: The ID of the Job to terminate. Required.
        :type job_id: str
        :param parameters: The options to use for terminating the Job. Default value is None.
        :type parameters: ~azure.batch.models.BatchJobTerminateContent
        :keyword time_out_in_seconds: The maximum time that the server can spend processing the
         request, in seconds. The default is 30 seconds. If the value is larger than 30, the default
         will be used instead.". Default value is None.
        :paramtype time_out_in_seconds: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword if_modified_since: A timestamp indicating the last modified time of the resource known
         to the
         client. The operation will be performed only if the resource on the service has
         been modified since the specified time. Default value is None.
        :paramtype if_modified_since: ~datetime.datetime
        :keyword if_unmodified_since: A timestamp indicating the last modified time of the resource
         known to the
         client. The operation will be performed only if the resource on the service has
         not been modified since the specified time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                parameters = {
                    "terminateReason": "str"  # Optional. The text you want to appear as the
                      Job's TerminationReason. The default is 'UserTerminate'.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: str = kwargs.pop(
            "content_type", _headers.pop("content-type", "application/json; odata=minimalmetadata")
        )
        cls: ClsType[None] = kwargs.pop("cls", None)

        if parameters is not None:
            _content = json.dumps(parameters, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore
        else:
            _content = None

        _request = build_batch_terminate_job_request(
            job_id=job_id,
            time_out_in_seconds=time_out_in_seconds,
            ocpdate=ocpdate,
            if_modified_since=if_modified_since,
            if_unmodified_since=if_unmodified_since,
            etag=etag,
            match_condition=match_condition,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.BatchError, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["DataServiceId"] = self._deserialize("str", response.headers.get("DataServiceId"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def create_job(  # pylint: disable=inconsistent-return-statements
        self,
        job: _models.BatchJobCreateContent,
        *,
        time_out_in_seconds: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        # pylint: disable=line-too-long
        """Creates a Job to the specified Account.

        The Batch service supports two ways to control the work done as part of a Job.
        In the first approach, the user specifies a Job Manager Task. The Batch service
        launches this Task when it is ready to start the Job. The Job Manager Task
        controls all other Tasks that run under this Job, by using the Task APIs. In
        the second approach, the user directly controls the execution of Tasks under an
        active Job, by using the Task APIs. Also note: when naming Jobs, avoid
        including sensitive information such as user names or secret project names.
        This information may appear in telemetry logs accessible to Microsoft Support
        engineers.

        :param job: The Job to be created. Required.
        :type job: ~azure.batch.models.BatchJobCreateContent
        :keyword time_out_in_seconds: The maximum time that the server can spend processing the
         request, in seconds. The default is 30 seconds. If the value is larger than 30, the default
         will be used instead.". Default value is None.
        :paramtype time_out_in_seconds: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                job = {
                    "id": "str",  # A string that uniquely identifies the Job within the Account.
                      The ID can contain any combination of alphanumeric characters including hyphens
                      and underscores, and cannot contain more than 64 characters. The ID is
                      case-preserving and case-insensitive (that is, you may not have two IDs within an
                      Account that differ only by case). Required.
                    "poolInfo": {
                        "autoPoolSpecification": {
                            "poolLifetimeOption": "str",  # The minimum lifetime of
                              created auto Pools, and how multiple Jobs on a schedule are assigned to
                              Pools. Required. Known values are: "jobschedule" and "job".
                            "autoPoolIdPrefix": "str",  # Optional. A prefix to be added
                              to the unique identifier when a Pool is automatically created. The Batch
                              service assigns each auto Pool a unique identifier on creation. To
                              distinguish between Pools created for different purposes, you can specify
                              this element to add a prefix to the ID that is assigned. The prefix can
                              be up to 20 characters long.
                            "keepAlive": bool,  # Optional. Whether to keep an auto Pool
                              alive after its lifetime expires. If false, the Batch service deletes the
                              Pool once its lifetime (as determined by the poolLifetimeOption setting)
                              expires; that is, when the Job or Job Schedule completes. If true, the
                              Batch service does not delete the Pool automatically. It is up to the
                              user to delete auto Pools created with this option.
                            "pool": {
                                "vmSize": "str",  # The size of the virtual machines
                                  in the Pool. All virtual machines in a Pool are the same size. For
                                  information about available sizes of virtual machines in Pools, see
                                  Choose a VM size for Compute Nodes in an Azure Batch Pool
                                  (https://docs.microsoft.com/azure/batch/batch-pool-vm-sizes).
                                  Required.
                                "applicationPackageReferences": [
                                    {
                                        "applicationId": "str",  # The ID of
                                          the application to deploy. When creating a pool, the
                                          package's application ID must be fully qualified
                                          (/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/applications/{applicationName}).
                                          Required.
                                        "version": "str"  # Optional. The
                                          version of the application to deploy. If omitted, the default
                                          version is deployed. If this is omitted on a Pool, and no
                                          default version is specified for this application, the
                                          request fails with the error code
                                          InvalidApplicationPackageReferences and HTTP status code 409.
                                          If this is omitted on a Task, and no default version is
                                          specified for this application, the Task fails with a
                                          pre-processing error.
                                    }
                                ],
                                "autoScaleEvaluationInterval": "1 day, 0:00:00",  #
                                  Optional. The time interval at which to automatically adjust the Pool
                                  size according to the autoscale formula. The default value is 15
                                  minutes. The minimum and maximum value are 5 minutes and 168 hours
                                  respectively. If you specify a value less than 5 minutes or greater
                                  than 168 hours, the Batch service rejects the request with an invalid
                                  property value error; if you are calling the REST API directly, the
                                  HTTP status code is 400 (Bad Request).
                                "autoScaleFormula": "str",  # Optional. The formula
                                  for the desired number of Compute Nodes in the Pool. This property
                                  must not be specified if enableAutoScale is set to false. It is
                                  required if enableAutoScale is set to true. The formula is checked
                                  for validity before the Pool is created. If the formula is not valid,
                                  the Batch service rejects the request with detailed error
                                  information.
                                "displayName": "str",  # Optional. The display name
                                  for the Pool. The display name need not be unique and can contain any
                                  Unicode characters up to a maximum length of 1024.
                                "enableAutoScale": bool,  # Optional. Whether the
                                  Pool size should automatically adjust over time. If false, at least
                                  one of targetDedicatedNodes and targetLowPriorityNodes must be
                                  specified. If true, the autoScaleFormula element is required. The
                                  Pool automatically resizes according to the formula. The default
                                  value is false.
                                "enableInterNodeCommunication": bool,  # Optional.
                                  Whether the Pool permits direct communication between Compute Nodes.
                                  Enabling inter-node communication limits the maximum size of the Pool
                                  due to deployment restrictions on the Compute Nodes of the Pool. This
                                  may result in the Pool not reaching its desired size. The default
                                  value is false.
                                "metadata": [
                                    {
                                        "name": "str",  # The name of the
                                          metadata item. Required.
                                        "value": "str"  # The value of the
                                          metadata item. Required.
                                    }
                                ],
                                "mountConfiguration": [
                                    {
                                        "azureBlobFileSystemConfiguration": {
                                            "accountName": "str",  # The
                                              Azure Storage Account name. Required.
                                            "containerName": "str",  #
                                              The Azure Blob Storage Container name. Required.
                                            "relativeMountPath": "str",
                                              # The relative path on the compute node where the file
                                              system will be mounted. All file systems are mounted
                                              relative to the Batch mounts directory, accessible via
                                              the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
                                              Required.
                                            "accountKey": "str",  #
                                              Optional. The Azure Storage Account key. This property is
                                              mutually exclusive with both sasKey and identity; exactly
                                              one must be specified.
                                            "blobfuseOptions": "str",  #
                                              Optional. Additional command line options to pass to the
                                              mount command. These are 'net use' options in Windows and
                                              'mount' options in Linux.
                                            "identityReference": {
                                                "resourceId": "str"
                                                  # Optional. The ARM resource id of the user assigned
                                                  identity.
                                            },
                                            "sasKey": "str"  # Optional.
                                              The Azure Storage SAS token. This property is mutually
                                              exclusive with both accountKey and identity; exactly one
                                              must be specified.
                                        },
                                        "azureFileShareConfiguration": {
                                            "accountKey": "str",  # The
                                              Azure Storage account key. Required.
                                            "accountName": "str",  # The
                                              Azure Storage account name. Required.
                                            "azureFileUrl": "str",  # The
                                              Azure Files URL. This is of the form
                                              'https://{account}.file.core.windows.net/'. Required.
                                            "relativeMountPath": "str",
                                              # The relative path on the compute node where the file
                                              system will be mounted. All file systems are mounted
                                              relative to the Batch mounts directory, accessible via
                                              the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
                                              Required.
                                            "mountOptions": "str"  #
                                              Optional. Additional command line options to pass to the
                                              mount command. These are 'net use' options in Windows and
                                              'mount' options in Linux.
                                        },
                                        "cifsMountConfiguration": {
                                            "password": "str",  # The
                                              password to use for authentication against the CIFS file
                                              system. Required.
                                            "relativeMountPath": "str",
                                              # The relative path on the compute node where the file
                                              system will be mounted. All file systems are mounted
                                              relative to the Batch mounts directory, accessible via
                                              the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
                                              Required.
                                            "source": "str",  # The URI
                                              of the file system to mount. Required.
                                            "username": "str",  # The
                                              user to use for authentication against the CIFS file
                                              system. Required.
                                            "mountOptions": "str"  #
                                              Optional. Additional command line options to pass to the
                                              mount command. These are 'net use' options in Windows and
                                              'mount' options in Linux.
                                        },
                                        "nfsMountConfiguration": {
                                            "relativeMountPath": "str",
                                              # The relative path on the compute node where the file
                                              system will be mounted. All file systems are mounted
                                              relative to the Batch mounts directory, accessible via
                                              the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
                                              Required.
                                            "source": "str",  # The URI
                                              of the file system to mount. Required.
                                            "mountOptions": "str"  #
                                              Optional. Additional command line options to pass to the
                                              mount command. These are 'net use' options in Windows and
                                              'mount' options in Linux.
                                        }
                                    }
                                ],
                                "networkConfiguration": {
                                    "dynamicVNetAssignmentScope": "str",  #
                                      Optional. The scope of dynamic vnet assignment. Known values are:
                                      "none" and "job".
                                    "enableAcceleratedNetworking": bool,  #
                                      Optional. Whether this pool should enable accelerated networking.
                                      Accelerated networking enables single root I/O virtualization
                                      (SR-IOV) to a VM, which may lead to improved networking
                                      performance. For more details, see:
                                      https://learn.microsoft.com/azure/virtual-network/accelerated-networking-overview.
                                    "endpointConfiguration": {
                                        "inboundNATPools": [
                                            {
                                                "backendPort": 0,  #
                                                  The port number on the Compute Node. This must be
                                                  unique within a Batch Pool. Acceptable values are
                                                  between 1 and 65535 except for 22, 3389, 29876 and
                                                  29877 as these are reserved. If any reserved values
                                                  are provided the request fails with HTTP status code
                                                  400. Required.
                "frontendPortRangeEnd": 0,  # The last port number in
                                                  the range of external ports that will be used to
                                                  provide inbound access to the backendPort on
                                                  individual Compute Nodes. Acceptable values range
                                                  between 1 and 65534 except ports from 50000 to 55000
                                                  which are reserved by the Batch service. All ranges
                                                  within a Pool must be distinct and cannot overlap.
                                                  Each range must contain at least 40 ports. If any
                                                  reserved or overlapping values are provided the
                                                  request fails with HTTP status code 400. Required.
                "frontendPortRangeStart": 0,  # The first port number
                                                  in the range of external ports that will be used to
                                                  provide inbound access to the backendPort on
                                                  individual Compute Nodes. Acceptable values range
                                                  between 1 and 65534 except ports from 50000 to 55000
                                                  which are reserved. All ranges within a Pool must be
                                                  distinct and cannot overlap. Each range must contain
                                                  at least 40 ports. If any reserved or overlapping
                                                  values are provided the request fails with HTTP
                                                  status code 400. Required.
                                                "name": "str",  # The
                                                  name of the endpoint. The name must be unique within
                                                  a Batch Pool, can contain letters, numbers,
                                                  underscores, periods, and hyphens. Names must start
                                                  with a letter or number, must end with a letter,
                                                  number, or underscore, and cannot exceed 77
                                                  characters.  If any invalid values are provided the
                                                  request fails with HTTP status code 400. Required.
                                                "protocol": "str",  #
                                                  The protocol of the endpoint. Required. Known values
                                                  are: "tcp" and "udp".
                "networkSecurityGroupRules": [
                                                    {
                "access": "str",  # The action that should be
                                                          taken for a specified IP address, subnet
                                                          range or tag. Required. Known values are:
                                                          "allow" and "deny".
                "priority": 0,  # The priority for this rule.
                                                          Priorities within a Pool must be unique and
                                                          are evaluated in order of priority. The lower
                                                          the number the higher the priority. For
                                                          example, rules could be specified with order
                                                          numbers of 150, 250, and 350. The rule with
                                                          the order number of 150 takes precedence over
                                                          the rule that has an order of 250. Allowed
                                                          priorities are 150 to 4096. If any reserved
                                                          or duplicate values are provided the request
                                                          fails with HTTP status code 400. Required.
                "sourceAddressPrefix": "str",  # The source
                                                          address prefix or tag to match for the rule.
                                                          Valid values are a single IP address (i.e.
                                                          10.10.10.10), IP subnet (i.e.
                                                          192.168.1.0/24), default tag, or * (for all
                                                          addresses).  If any other values are provided
                                                          the request fails with HTTP status code 400.
                                                          Required.
                "sourcePortRanges": [
                "str"  # Optional. The source port ranges
                                                              to match for the rule. Valid values are
                                                              '"" *' (for all ports 0 - 65535), a
                                                              specific port (i.e. 22), or a port range
                                                              (i.e. 100-200). The ports must be in the
                                                              range of 0 to 65535. Each entry in this
                                                              collection must not overlap any other
                                                              entry (either a range or an individual
                                                              port). If any other values are provided
                                                              the request fails with HTTP status code
                                                              400. The default value is '*"" '.
                                                        ]
                                                    }
                                                ]
                                            }
                                        ]
                                    },
                                    "publicIPAddressConfiguration": {
                                        "ipAddressIds": [
                                            "str"  # Optional. The list
                                              of public IPs which the Batch service will use when
                                              provisioning Compute Nodes. The number of IPs specified
                                              here limits the maximum size of the Pool - 100 dedicated
                                              nodes or 100 Spot/Low-priority nodes can be allocated for
                                              each public IP. For example, a pool needing 250 dedicated
                                              VMs would need at least 3 public IPs specified. Each
                                              element of this collection is of the form:
                                              /subscriptions/{subscription}/resourceGroups/{group}/providers/Microsoft.Network/publicIPAddresses/{ip}.
                                        ],
                                        "provision": "str"  # Optional. The
                                          provisioning type for Public IP Addresses for the Pool. The
                                          default value is BatchManaged. Known values are:
                                          "batchmanaged", "usermanaged", and "nopublicipaddresses".
                                    },
                                    "subnetId": "str"  # Optional. The ARM
                                      resource identifier of the virtual network subnet which the
                                      Compute Nodes of the Pool will join. This is of the form
                                      /subscriptions/{subscription}/resourceGroups/{group}/providers/{provider}/virtualNetworks/{network}/subnets/{subnet}.
                                      The virtual network must be in the same region and subscription
                                      as the Azure Batch Account. The specified subnet should have
                                      enough free IP addresses to accommodate the number of Compute
                                      Nodes in the Pool. If the subnet doesn't have enough free IP
                                      addresses, the Pool will partially allocate Nodes and a resize
                                      error will occur. The 'MicrosoftAzureBatch' service principal
                                      must have the 'Classic Virtual Machine Contributor' Role-Based
                                      Access Control (RBAC) role for the specified VNet. The specified
                                      subnet must allow communication from the Azure Batch service to
                                      be able to schedule Tasks on the Nodes. This can be verified by
                                      checking if the specified VNet has any associated Network
                                      Security Groups (NSG). If communication to the Nodes in the
                                      specified subnet is denied by an NSG, then the Batch service will
                                      set the state of the Compute Nodes to unusable. For Pools created
                                      with virtualMachineConfiguration only ARM virtual networks
                                      ('Microsoft.Network/virtualNetworks') are supported. If the
                                      specified VNet has any associated Network Security Groups (NSG),
                                      then a few reserved system ports must be enabled for inbound
                                      communication. For Pools created with a virtual machine
                                      configuration, enable ports 29876 and 29877, as well as port 22
                                      for Linux and port 3389 for Windows. Also enable outbound
                                      connections to Azure Storage on port 443. For more details see:
                                      https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration.
                                },
                                "resizeTimeout": "1 day, 0:00:00",  # Optional. The
                                  timeout for allocation of Compute Nodes to the Pool. This timeout
                                  applies only to manual scaling; it has no effect when enableAutoScale
                                  is set to true. The default value is 15 minutes. The minimum value is
                                  5 minutes. If you specify a value less than 5 minutes, the Batch
                                  service rejects the request with an error; if you are calling the
                                  REST API directly, the HTTP status code is 400 (Bad Request).
                                "resourceTags": "str",  # Optional. The
                                  user-specified tags associated with the pool.The user-defined tags to
                                  be associated with the Azure Batch Pool. When specified, these tags
                                  are propagated to the backing Azure resources associated with the
                                  pool. This property can only be specified when the Batch account was
                                  created with the poolAllocationMode property set to
                                  'UserSubscription'.
                                "startTask": {
                                    "commandLine": "str",  # The command line of
                                      the StartTask. The command line does not run under a shell, and
                                      therefore cannot take advantage of shell features such as
                                      environment variable expansion. If you want to take advantage of
                                      such features, you should invoke the shell in the command line,
                                      for example using "cmd /c MyCommand" in Windows or "/bin/sh -c
                                      MyCommand" in Linux. If the command line refers to file paths, it
                                      should use a relative path (relative to the Task working
                                      directory), or use the Batch provided environment variable
                                      (https://docs.microsoft.com/en-us/azure/batch/batch-compute-node-environment-variables).
                                      Required.
                                    "containerSettings": {
                                        "imageName": "str",  # The Image to
                                          use to create the container in which the Task will run. This
                                          is the full Image reference, as would be specified to "docker
                                          pull". If no tag is provided as part of the Image name, the
                                          tag ":latest" is used as a default. Required.
                                        "containerRunOptions": "str",  #
                                          Optional. Additional options to the container create command.
                                          These additional options are supplied as arguments to the
                                          "docker create" command, in addition to those controlled by
                                          the Batch Service.
                                        "registry": {
                                            "identityReference": {
                                                "resourceId": "str"
                                                  # Optional. The ARM resource id of the user assigned
                                                  identity.
                                            },
                                            "password": "str",  #
                                              Optional. The password to log into the registry server.
                                            "registryServer": "str",  #
                                              Optional. The registry URL. If omitted, the default is
                                              "docker.io".
                                            "username": "str"  #
                                              Optional. The user name to log into the registry server.
                                        },
                                        "workingDirectory": "str"  #
                                          Optional. The location of the container Task working
                                          directory. The default is 'taskWorkingDirectory'. Known
                                          values are: "taskWorkingDirectory" and
                                          "containerImageDefault".
                                    },
                                    "environmentSettings": [
                                        {
                                            "name": "str",  # The name of
                                              the environment variable. Required.
                                            "value": "str"  # Optional.
                                              The value of the environment variable.
                                        }
                                    ],
                                    "maxTaskRetryCount": 0,  # Optional. The
                                      maximum number of times the Task may be retried. The Batch
                                      service retries a Task if its exit code is nonzero. Note that
                                      this value specifically controls the number of retries. The Batch
                                      service will try the Task once, and may then retry up to this
                                      limit. For example, if the maximum retry count is 3, Batch tries
                                      the Task up to 4 times (one initial try and 3 retries). If the
                                      maximum retry count is 0, the Batch service does not retry the
                                      Task. If the maximum retry count is -1, the Batch service retries
                                      the Task without limit, however this is not recommended for a
                                      start task or any task. The default value is 0 (no retries).
                                    "resourceFiles": [
                                        {
                                            "autoStorageContainerName":
                                              "str",  # Optional. The storage container name in the
                                              auto storage Account. The autoStorageContainerName,
                                              storageContainerUrl and httpUrl properties are mutually
                                              exclusive and one of them must be specified.
                                            "blobPrefix": "str",  #
                                              Optional. The blob prefix to use when downloading blobs
                                              from an Azure Storage container. Only the blobs whose
                                              names begin with the specified prefix will be downloaded.
                                              The property is valid only when autoStorageContainerName
                                              or storageContainerUrl is used. This prefix can be a
                                              partial filename or a subdirectory. If a prefix is not
                                              specified, all the files in the container will be
                                              downloaded.
                                            "fileMode": "str",  #
                                              Optional. The file permission mode attribute in octal
                                              format. This property applies only to files being
                                              downloaded to Linux Compute Nodes. It will be ignored if
                                              it is specified for a resourceFile which will be
                                              downloaded to a Windows Compute Node. If this property is
                                              not specified for a Linux Compute Node, then a default
                                              value of 0770 is applied to the file.
                                            "filePath": "str",  #
                                              Optional. The location on the Compute Node to which to
                                              download the file(s), relative to the Task's working
                                              directory. If the httpUrl property is specified, the
                                              filePath is required and describes the path which the
                                              file will be downloaded to, including the filename.
                                              Otherwise, if the autoStorageContainerName or
                                              storageContainerUrl property is specified, filePath is
                                              optional and is the directory to download the files to.
                                              In the case where filePath is used as a directory, any
                                              directory structure already associated with the input
                                              data will be retained in full and appended to the
                                              specified filePath directory. The specified relative path
                                              cannot break out of the Task's working directory (for
                                              example by using '..').
                                            "httpUrl": "str",  #
                                              Optional. The URL of the file to download. The
                                              autoStorageContainerName, storageContainerUrl and httpUrl
                                              properties are mutually exclusive and one of them must be
                                              specified. If the URL points to Azure Blob Storage, it
                                              must be readable from compute nodes. There are three ways
                                              to get such a URL for a blob in Azure storage: include a
                                              Shared Access Signature (SAS) granting read permissions
                                              on the blob, use a managed identity with read permission,
                                              or set the ACL for the blob or its container to allow
                                              public access.
                                            "identityReference": {
                                                "resourceId": "str"
                                                  # Optional. The ARM resource id of the user assigned
                                                  identity.
                                            },
                                            "storageContainerUrl": "str"
                                              # Optional. The URL of the blob container within Azure
                                              Blob Storage. The autoStorageContainerName,
                                              storageContainerUrl and httpUrl properties are mutually
                                              exclusive and one of them must be specified. This URL
                                              must be readable and listable from compute nodes. There
                                              are three ways to get such a URL for a container in Azure
                                              storage: include a Shared Access Signature (SAS) granting
                                              read and list permissions on the container, use a managed
                                              identity with read and list permissions, or set the ACL
                                              for the container to allow public access.
                                        }
                                    ],
                                    "userIdentity": {
                                        "autoUser": {
                                            "elevationLevel": "str",  #
                                              Optional. The elevation level of the auto user. The
                                              default value is nonAdmin. Known values are: "nonadmin"
                                              and "admin".
                                            "scope": "str"  # Optional.
                                              The scope for the auto user. The default value is pool.
                                              If the pool is running Windows, a value of Task should be
                                              specified if stricter isolation between tasks is
                                              required, such as if the task mutates the registry in a
                                              way which could impact other tasks. Known values are:
                                              "task" and "pool".
                                        },
                                        "username": "str"  # Optional. The
                                          name of the user identity under which the Task is run. The
                                          userName and autoUser properties are mutually exclusive; you
                                          must specify one but not both.
                                    },
                                    "waitForSuccess": bool  # Optional. Whether
                                      the Batch service should wait for the StartTask to complete
                                      successfully (that is, to exit with exit code 0) before
                                      scheduling any Tasks on the Compute Node. If true and the
                                      StartTask fails on a Node, the Batch service retries the
                                      StartTask up to its maximum retry count (maxTaskRetryCount). If
                                      the Task has still not completed successfully after all retries,
                                      then the Batch service marks the Node unusable, and will not
                                      schedule Tasks to it. This condition can be detected via the
                                      Compute Node state and failure info details. If false, the Batch
                                      service will not wait for the StartTask to complete. In this
                                      case, other Tasks can start executing on the Compute Node while
                                      the StartTask is still running; and even if the StartTask fails,
                                      new Tasks will continue to be scheduled on the Compute Node. The
                                      default is true.
                                },
                                "targetDedicatedNodes": 0,  # Optional. The desired
                                  number of dedicated Compute Nodes in the Pool. This property must not
                                  be specified if enableAutoScale is set to true. If enableAutoScale is
                                  set to false, then you must set either targetDedicatedNodes,
                                  targetLowPriorityNodes, or both.
                                "targetLowPriorityNodes": 0,  # Optional. The desired
                                  number of Spot/Low-priority Compute Nodes in the Pool. This property
                                  must not be specified if enableAutoScale is set to true. If
                                  enableAutoScale is set to false, then you must set either
                                  targetDedicatedNodes, targetLowPriorityNodes, or both.
                                "targetNodeCommunicationMode": "str",  # Optional.
                                  The desired node communication mode for the pool. If omitted, the
                                  default value is Default. Known values are: "default", "classic", and
                                  "simplified".
                                "taskSchedulingPolicy": {
                                    "nodeFillType": "str"  # How Tasks are
                                      distributed across Compute Nodes in a Pool. If not specified, the
                                      default is spread. Required. Known values are: "spread" and
                                      "pack".
                                },
                                "taskSlotsPerNode": 0,  # Optional. The number of
                                  task slots that can be used to run concurrent tasks on a single
                                  compute node in the pool. The default value is 1. The maximum value
                                  is the smaller of 4 times the number of cores of the vmSize of the
                                  pool or 256.
                                "upgradePolicy": {
                                    "mode": "str",  # Specifies the mode of an
                                      upgrade to virtual machines in the scale set.:code:`<br
                                      />`:code:`<br />` Possible values are::code:`<br />`:code:`<br
                                      />` **Manual** - You  control the application of updates to
                                      virtual machines in the scale set. You do this by using the
                                      manualUpgrade action.:code:`<br />`:code:`<br />` **Automatic** -
                                      All virtual machines in the scale set are automatically updated
                                      at the same time.:code:`<br />`:code:`<br />` **Rolling** - Scale
                                      set performs updates in batches with an optional pause time in
                                      between. Required. Known values are: "automatic", "manual", and
                                      "rolling".
                                    "automaticOSUpgradePolicy": {
                                        "disableAutomaticRollback": bool,  #
                                          Optional. Whether OS image rollback feature should be
                                          disabled.
                                        "enableAutomaticOSUpgrade": bool,  #
                                          Optional. Indicates whether OS upgrades should automatically
                                          be applied to scale set instances in a rolling fashion when a
                                          newer version of the OS image becomes available. :code:`<br
                                          />`:code:`<br />` If this is set to true for Windows based
                                          pools, `WindowsConfiguration.enableAutomaticUpdates
                                          <https://learn.microsoft.com/en-us/rest/api/batchservice/pool/add?tabs=HTTP#windowsconfiguration>`_
                                          cannot be set to true.
                                        "osRollingUpgradeDeferral": bool,  #
                                          Optional. Defer OS upgrades on the TVMs if they are running
                                          tasks.
                                        "useRollingUpgradePolicy": bool  #
                                          Optional. Indicates whether rolling upgrade policy should be
                                          used during Auto OS Upgrade. Auto OS Upgrade will fallback to
                                          the default policy if no policy is defined on the VMSS.
                                    },
                                    "rollingUpgradePolicy": {
                                        "enableCrossZoneUpgrade": bool,  #
                                          Optional. Allow VMSS to ignore AZ boundaries when
                                          constructing upgrade batches. Take into consideration the
                                          Update Domain and maxBatchInstancePercent to determine the
                                          batch size. This field is able to be set to true or false
                                          only when using NodePlacementConfiguration as Zonal.
                                        "maxBatchInstancePercent": 0,  #
                                          Optional. The maximum percent of total virtual machine
                                          instances that will be upgraded simultaneously by the rolling
                                          upgrade in one batch. As this is a maximum, unhealthy
                                          instances in previous or future batches can cause the
                                          percentage of instances in a batch to decrease to ensure
                                          higher reliability. The value of this field should be between
                                          5 and 100, inclusive. If both maxBatchInstancePercent and
                                          maxUnhealthyInstancePercent are assigned with value, the
                                          value of maxBatchInstancePercent should not be more than
                                          maxUnhealthyInstancePercent.
                                        "maxUnhealthyInstancePercent": 0,  #
                                          Optional. The maximum percentage of the total virtual machine
                                          instances in the scale set that can be simultaneously
                                          unhealthy, either as a result of being upgraded, or by being
                                          found in an unhealthy state by the virtual machine health
                                          checks before the rolling upgrade aborts. This constraint
                                          will be checked prior to starting any batch. The value of
                                          this field should be between 5 and 100, inclusive. If both
                                          maxBatchInstancePercent and maxUnhealthyInstancePercent are
                                          assigned with value, the value of maxBatchInstancePercent
                                          should not be more than maxUnhealthyInstancePercent.
                "maxUnhealthyUpgradedInstancePercent": 0,  # Optional. The
                                          maximum percentage of upgraded virtual machine instances that
                                          can be found to be in an unhealthy state. This check will
                                          happen after each batch is upgraded. If this percentage is
                                          ever exceeded, the rolling update aborts. The value of this
                                          field should be between 0 and 100, inclusive.
                                        "pauseTimeBetweenBatches": "1 day,
                                          0:00:00",  # Optional. The wait time between completing the
                                          update for all virtual machines in one batch and starting the
                                          next batch. The time duration should be specified in ISO 8601
                                          format..
                                        "prioritizeUnhealthyInstances": bool,
                                          # Optional. Upgrade all unhealthy instances in a scale set
                                          before any healthy instances.
                "rollbackFailedInstancesOnPolicyBreach": bool  # Optional.
                                          Rollback failed instances to previous model if the Rolling
                                          Upgrade policy is violated.
                                    }
                                },
                                "userAccounts": [
                                    {
                                        "name": "str",  # The name of the
                                          user Account. Names can contain any Unicode characters up to
                                          a maximum length of 20. Required.
                                        "password": "str",  # The password
                                          for the user Account. Required.
                                        "elevationLevel": "str",  # Optional.
                                          The elevation level of the user Account. The default value is
                                          nonAdmin. Known values are: "nonadmin" and "admin".
                                        "linuxUserConfiguration": {
                                            "gid": 0,  # Optional. The
                                              group ID for the user Account. The uid and gid properties
                                              must be specified together or not at all. If not
                                              specified the underlying operating system picks the gid.
                                            "sshPrivateKey": "str",  #
                                              Optional. The SSH private key for the user Account. The
                                              private key must not be password protected. The private
                                              key is used to automatically configure asymmetric-key
                                              based authentication for SSH between Compute Nodes in a
                                              Linux Pool when the Pool's enableInterNodeCommunication
                                              property is true (it is ignored if
                                              enableInterNodeCommunication is false). It does this by
                                              placing the key pair into the user's .ssh directory. If
                                              not specified, password-less SSH is not configured
                                              between Compute Nodes (no modification of the user's .ssh
                                              directory is done).
                                            "uid": 0  # Optional. The
                                              user ID of the user Account. The uid and gid properties
                                              must be specified together or not at all. If not
                                              specified the underlying operating system picks the uid.
                                        },
                                        "windowsUserConfiguration": {
                                            "loginMode": "str"  #
                                              Optional. The login mode for the user. The default value
                                              for VirtualMachineConfiguration Pools is 'batch'. Known
                                              values are: "batch" and "interactive".
                                        }
                                    }
                                ],
                                "virtualMachineConfiguration": {
                                    "imageReference": {
                                        "exactVersion": "str",  # Optional.
                                          The specific version of the platform image or marketplace
                                          image used to create the node. This read-only field differs
                                          from 'version' only if the value specified for 'version' when
                                          the pool was created was 'latest'.
                                        "offer": "str",  # Optional. The
                                          offer type of the Azure Virtual Machines Marketplace Image.
                                          For example, UbuntuServer or WindowsServer.
                                        "publisher": "str",  # Optional. The
                                          publisher of the Azure Virtual Machines Marketplace Image.
                                          For example, Canonical or MicrosoftWindowsServer.
                                        "sku": "str",  # Optional. The SKU of
                                          the Azure Virtual Machines Marketplace Image. For example,
                                          18.04-LTS or 2019-Datacenter.
                                        "version": "str",  # Optional. The
                                          version of the Azure Virtual Machines Marketplace Image. A
                                          value of 'latest' can be specified to select the latest
                                          version of an Image. If omitted, the default is 'latest'.
                                        "virtualMachineImageId": "str"  #
                                          Optional. The ARM resource identifier of the Azure Compute
                                          Gallery Image. Compute Nodes in the Pool will be created
                                          using this Image Id. This is of the form
                                          /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/galleries/{galleryName}/images/{imageDefinitionName}/versions/{VersionId}
                                          or
                                          /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/galleries/{galleryName}/images/{imageDefinitionName}
                                          for always defaulting to the latest image version. This
                                          property is mutually exclusive with other ImageReference
                                          properties. The Azure Compute Gallery Image must have
                                          replicas in the same region and must be in the same
                                          subscription as the Azure Batch account. If the image version
                                          is not specified in the imageId, the latest version will be
                                          used. For information about the firewall settings for the
                                          Batch Compute Node agent to communicate with the Batch
                                          service see
                                          https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration.
                                    },
                                    "nodeAgentSKUId": "str",  # The SKU of the
                                      Batch Compute Node agent to be provisioned on Compute Nodes in
                                      the Pool. The Batch Compute Node agent is a program that runs on
                                      each Compute Node in the Pool, and provides the
                                      command-and-control interface between the Compute Node and the
                                      Batch service. There are different implementations of the Compute
                                      Node agent, known as SKUs, for different operating systems. You
                                      must specify a Compute Node agent SKU which matches the selected
                                      Image reference. To get the list of supported Compute Node agent
                                      SKUs along with their list of verified Image references, see the
                                      'List supported Compute Node agent SKUs' operation. Required.
                                    "containerConfiguration": {
                                        "type": "str",  # The container
                                          technology to be used. Required. Known values are:
                                          "dockerCompatible" and "criCompatible".
                                        "containerImageNames": [
                                            "str"  # Optional. The
                                              collection of container Image names. This is the full
                                              Image reference, as would be specified to "docker pull".
                                              An Image will be sourced from the default Docker registry
                                              unless the Image is fully qualified with an alternative
                                              registry.
                                        ],
                                        "containerRegistries": [
                                            {
                                                "identityReference":
                                                  {
                                                    "resourceId":
                                                      "str"  # Optional. The ARM resource id of the
                                                      user assigned identity.
                                                },
                                                "password": "str",  #
                                                  Optional. The password to log into the registry
                                                  server.
                                                "registryServer":
                                                  "str",  # Optional. The registry URL. If omitted, the
                                                  default is "docker.io".
                                                "username": "str"  #
                                                  Optional. The user name to log into the registry
                                                  server.
                                            }
                                        ]
                                    },
                                    "dataDisks": [
                                        {
                                            "diskSizeGB": 0,  # The
                                              initial disk size in gigabytes. Required.
                                            "lun": 0,  # The logical unit
                                              number. The logicalUnitNumber is used to uniquely
                                              identify each data disk. If attaching multiple disks,
                                              each should have a distinct logicalUnitNumber. The value
                                              must be between 0 and 63, inclusive. Required.
                                            "caching": "str",  #
                                              Optional. The type of caching to be enabled for the data
                                              disks. The default value for caching is readwrite. For
                                              information about the caching options see:
                                              https://blogs.msdn.microsoft.com/windowsazurestorage/2012/06/27/exploring-windows-azure-drives-disks-and-images/.
                                              Known values are: "none", "readonly", and "readwrite".
                                            "storageAccountType": "str"
                                              # Optional. The storage Account type to be used for the
                                              data disk. If omitted, the default is "standard_lrs".
                                              Known values are: "standard_lrs", "premium_lrs", and
                                              "standardssd_lrs".
                                        }
                                    ],
                                    "diskEncryptionConfiguration": {
                                        "targets": [
                                            "str"  # Optional. The list
                                              of disk targets Batch Service will encrypt on the compute
                                              node. If omitted, no disks on the compute nodes in the
                                              pool will be encrypted. On Linux pool, only
                                              "TemporaryDisk" is supported; on Windows pool, "OsDisk"
                                              and "TemporaryDisk" must be specified.
                                        ]
                                    },
                                    "extensions": [
                                        {
                                            "name": "str",  # The name of
                                              the virtual machine extension. Required.
                                            "publisher": "str",  # The
                                              name of the extension handler publisher. Required.
                                            "type": "str",  # The type of
                                              the extension. Required.
                                            "autoUpgradeMinorVersion":
                                              bool,  # Optional. Indicates whether the extension should
                                              use a newer minor version if one is available at
                                              deployment time. Once deployed, however, the extension
                                              will not upgrade minor versions unless redeployed, even
                                              with this property set to true.
                                            "enableAutomaticUpgrade":
                                              bool,  # Optional. Indicates whether the extension should
                                              be automatically upgraded by the platform if there is a
                                              newer version of the extension available.
                                            "protectedSettings": {
                                                "str": "str"  #
                                                  Optional. The extension can contain either
                                                  protectedSettings or protectedSettingsFromKeyVault or
                                                  no protected settings at all.
                                            },
                                            "provisionAfterExtensions": [
                                                "str"  # Optional.
                                                  The collection of extension names. Collection of
                                                  extension names after which this extension needs to
                                                  be provisioned.
                                            ],
                                            "settings": {
                                                "str": "str"  #
                                                  Optional. JSON formatted public settings for the
                                                  extension.
                                            },
                                            "typeHandlerVersion": "str"
                                              # Optional. The version of script handler.
                                        }
                                    ],
                                    "licenseType": "str",  # Optional. This only
                                      applies to Images that contain the Windows operating system, and
                                      should only be used when you hold valid on-premises licenses for
                                      the Compute Nodes which will be deployed. If omitted, no
                                      on-premises licensing discount is applied. Values are:
                                      Windows_Server - The on-premises license is for Windows Server.
                                      Windows_Client - The on-premises license is for Windows Client.
                                    "nodePlacementConfiguration": {
                                        "policy": "str"  # Optional. Node
                                          placement Policy type on Batch Pools. Allocation policy used
                                          by Batch Service to provision the nodes. If not specified,
                                          Batch will use the regional policy. Known values are:
                                          "regional" and "zonal".
                                    },
                                    "osDisk": {
                                        "caching": "str",  # Optional.
                                          Specifies the caching requirements. Possible values are:
                                          None, ReadOnly, ReadWrite. The default values are: None for
                                          Standard storage. ReadOnly for Premium storage. Known values
                                          are: "none", "readonly", and "readwrite".
                                        "diskSizeGB": 0,  # Optional. The
                                          initial disk size in GB when creating new OS disk.
                                        "ephemeralOSDiskSettings": {
                                            "placement": "str"  #
                                              Optional. Specifies the ephemeral disk placement for
                                              operating system disk for all VMs in the pool. This
                                              property can be used by user in the request to choose the
                                              location e.g., cache disk space for Ephemeral OS disk
                                              provisioning. For more information on Ephemeral OS disk
                                              size requirements, please refer to Ephemeral OS disk size
                                              requirements for Windows VMs at
                                              https://docs.microsoft.com/en-us/azure/virtual-machines/windows/ephemeral-os-disks#size-requirements
                                              and Linux VMs at
                                              https://docs.microsoft.com/en-us/azure/virtual-machines/linux/ephemeral-os-disks#size-requirements.
                                              "cachedisk"
                                        },
                                        "managedDisk": {
                                            "storageAccountType": "str"
                                              # The storage account type for managed disk. Required.
                                              Known values are: "standard_lrs", "premium_lrs", and
                                              "standardssd_lrs".
                                        },
                                        "writeAcceleratorEnabled": bool  #
                                          Optional. Specifies whether writeAccelerator should be
                                          enabled or disabled on the disk.
                                    },
                                    "securityProfile": {
                                        "encryptionAtHost": bool,  # This
                                          property can be used by user in the request to enable or
                                          disable the Host Encryption for the virtual machine or
                                          virtual machine scale set. This will enable the encryption
                                          for all the disks including Resource/Temp disk at host
                                          itself. Required.
                                        "securityType": "str",  # Specifies
                                          the SecurityType of the virtual machine. It has to be set to
                                          any specified value to enable UefiSettings. Required.
                                          "trustedLaunch"
                                        "uefiSettings": {
                                            "secureBootEnabled": bool,  #
                                              Optional. Specifies whether secure boot should be enabled
                                              on the virtual machine.
                                            "vTpmEnabled": bool  #
                                              Optional. Specifies whether vTPM should be enabled on the
                                              virtual machine.
                                        }
                                    },
                                    "serviceArtifactReference": {
                                        "id": "str"  # The service artifact
                                          reference id of ServiceArtifactReference. The service
                                          artifact reference id in the form of
                                          /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/galleries/{galleryName}/serviceArtifacts/{serviceArtifactName}/vmArtifactsProfiles/{vmArtifactsProfilesName}.
                                          Required.
                                    },
                                    "windowsConfiguration": {
                                        "enableAutomaticUpdates": bool  #
                                          Optional. Whether automatic updates are enabled on the
                                          virtual machine. If omitted, the default value is true.
                                    }
                                }
                            }
                        },
                        "poolId": "str"  # Optional. The ID of an existing Pool. All the
                          Tasks of the Job will run on the specified Pool. You must ensure that the
                          Pool referenced by this property exists. If the Pool does not exist at the
                          time the Batch service tries to schedule a Job, no Tasks for the Job will run
                          until you create a Pool with that id. Note that the Batch service will not
                          reject the Job request; it will simply not run Tasks until the Pool exists.
                          You must specify either the Pool ID or the auto Pool specification, but not
                          both.
                    },
                    "allowTaskPreemption": bool,  # Optional. Whether Tasks in this job can be
                      preempted by other high priority jobs. If the value is set to True, other high
                      priority jobs submitted to the system will take precedence and will be able
                      requeue tasks from this job. You can update a job's allowTaskPreemption after it
                      has been created using the update job API.
                    "commonEnvironmentSettings": [
                        {
                            "name": "str",  # The name of the environment variable.
                              Required.
                            "value": "str"  # Optional. The value of the environment
                              variable.
                        }
                    ],
                    "constraints": {
                        "maxTaskRetryCount": 0,  # Optional. The maximum number of times each
                          Task may be retried. The Batch service retries a Task if its exit code is
                          nonzero. Note that this value specifically controls the number of retries.
                          The Batch service will try each Task once, and may then retry up to this
                          limit. For example, if the maximum retry count is 3, Batch tries a Task up to
                          4 times (one initial try and 3 retries). If the maximum retry count is 0, the
                          Batch service does not retry Tasks. If the maximum retry count is -1, the
                          Batch service retries Tasks without limit. The default value is 0 (no
                          retries).
                        "maxWallClockTime": "1 day, 0:00:00"  # Optional. The maximum elapsed
                          time that the Job may run, measured from the time the Job is created. If the
                          Job does not complete within the time limit, the Batch service terminates it
                          and any Tasks that are still running. In this case, the termination reason
                          will be MaxWallClockTimeExpiry. If this property is not specified, there is
                          no time limit on how long the Job may run.
                    },
                    "displayName": "str",  # Optional. The display name for the Job. The display
                      name need not be unique and can contain any Unicode characters up to a maximum
                      length of 1024.
                    "jobManagerTask": {
                        "commandLine": "str",  # The command line of the Job Manager Task.
                          The command line does not run under a shell, and therefore cannot take
                          advantage of shell features such as environment variable expansion. If you
                          want to take advantage of such features, you should invoke the shell in the
                          command line, for example using "cmd /c MyCommand" in Windows or "/bin/sh -c
                          MyCommand" in Linux. If the command line refers to file paths, it should use
                          a relative path (relative to the Task working directory), or use the Batch
                          provided environment variable
                          (https://docs.microsoft.com/en-us/azure/batch/batch-compute-node-environment-variables).
                          Required.
                        "id": "str",  # A string that uniquely identifies the Job Manager
                          Task within the Job. The ID can contain any combination of alphanumeric
                          characters including hyphens and underscores and cannot contain more than 64
                          characters. Required.
                        "allowLowPriorityNode": bool,  # Optional. Whether the Job Manager
                          Task may run on a Spot/Low-priority Compute Node. The default value is true.
                        "applicationPackageReferences": [
                            {
                                "applicationId": "str",  # The ID of the application
                                  to deploy. When creating a pool, the package's application ID must be
                                  fully qualified
                                  (/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/applications/{applicationName}).
                                  Required.
                                "version": "str"  # Optional. The version of the
                                  application to deploy. If omitted, the default version is deployed.
                                  If this is omitted on a Pool, and no default version is specified for
                                  this application, the request fails with the error code
                                  InvalidApplicationPackageReferences and HTTP status code 409. If this
                                  is omitted on a Task, and no default version is specified for this
                                  application, the Task fails with a pre-processing error.
                            }
                        ],
                        "authenticationTokenSettings": {
                            "access": [
                                "str"  # Optional. The Batch resources to which the
                                  token grants access. The authentication token grants access to a
                                  limited set of Batch service operations. Currently the only supported
                                  value for the access property is 'job', which grants access to all
                                  operations related to the Job which contains the Task.
                            ]
                        },
                        "constraints": {
                            "maxTaskRetryCount": 0,  # Optional. The maximum number of
                              times the Task may be retried. The Batch service retries a Task if its
                              exit code is nonzero. Note that this value specifically controls the
                              number of retries for the Task executable due to a nonzero exit code. The
                              Batch service will try the Task once, and may then retry up to this
                              limit. For example, if the maximum retry count is 3, Batch tries the Task
                              up to 4 times (one initial try and 3 retries). If the maximum retry count
                              is 0, the Batch service does not retry the Task after the first attempt.
                              If the maximum retry count is -1, the Batch service retries the Task
                              without limit, however this is not recommended for a start task or any
                              task. The default value is 0 (no retries).
                            "maxWallClockTime": "1 day, 0:00:00",  # Optional. The
                              maximum elapsed time that the Task may run, measured from the time the
                              Task starts. If the Task does not complete within the time limit, the
                              Batch service terminates it. If this is not specified, there is no time
                              limit on how long the Task may run.
                            "retentionTime": "1 day, 0:00:00"  # Optional. The minimum
                              time to retain the Task directory on the Compute Node where it ran, from
                              the time it completes execution. After this time, the Batch service may
                              delete the Task directory and all its contents. The default is 7 days,
                              i.e. the Task directory will be retained for 7 days unless the Compute
                              Node is removed or the Job is deleted.
                        },
                        "containerSettings": {
                            "imageName": "str",  # The Image to use to create the
                              container in which the Task will run. This is the full Image reference,
                              as would be specified to "docker pull". If no tag is provided as part of
                              the Image name, the tag ":latest" is used as a default. Required.
                            "containerRunOptions": "str",  # Optional. Additional options
                              to the container create command. These additional options are supplied as
                              arguments to the "docker create" command, in addition to those controlled
                              by the Batch Service.
                            "registry": {
                                "identityReference": {
                                    "resourceId": "str"  # Optional. The ARM
                                      resource id of the user assigned identity.
                                },
                                "password": "str",  # Optional. The password to log
                                  into the registry server.
                                "registryServer": "str",  # Optional. The registry
                                  URL. If omitted, the default is "docker.io".
                                "username": "str"  # Optional. The user name to log
                                  into the registry server.
                            },
                            "workingDirectory": "str"  # Optional. The location of the
                              container Task working directory. The default is 'taskWorkingDirectory'.
                              Known values are: "taskWorkingDirectory" and "containerImageDefault".
                        },
                        "displayName": "str",  # Optional. The display name of the Job
                          Manager Task. It need not be unique and can contain any Unicode characters up
                          to a maximum length of 1024.
                        "environmentSettings": [
                            {
                                "name": "str",  # The name of the environment
                                  variable. Required.
                                "value": "str"  # Optional. The value of the
                                  environment variable.
                            }
                        ],
                        "killJobOnCompletion": bool,  # Optional. Whether completion of the
                          Job Manager Task signifies completion of the entire Job. If true, when the
                          Job Manager Task completes, the Batch service marks the Job as complete. If
                          any Tasks are still running at this time (other than Job Release), those
                          Tasks are terminated. If false, the completion of the Job Manager Task does
                          not affect the Job status. In this case, you should either use the
                          onAllTasksComplete attribute to terminate the Job, or have a client or user
                          terminate the Job explicitly. An example of this is if the Job Manager
                          creates a set of Tasks but then takes no further role in their execution. The
                          default value is true. If you are using the onAllTasksComplete and
                          onTaskFailure attributes to control Job lifetime, and using the Job Manager
                          Task only to create the Tasks for the Job (not to monitor progress), then it
                          is important to set killJobOnCompletion to false.
                        "outputFiles": [
                            {
                                "destination": {
                                    "container": {
                                        "containerUrl": "str",  # The URL of
                                          the container within Azure Blob Storage to which to upload
                                          the file(s). If not using a managed identity, the URL must
                                          include a Shared Access Signature (SAS) granting write
                                          permissions to the container. Required.
                                        "identityReference": {
                                            "resourceId": "str"  #
                                              Optional. The ARM resource id of the user assigned
                                              identity.
                                        },
                                        "path": "str",  # Optional. The
                                          destination blob or virtual directory within the Azure
                                          Storage container. If filePattern refers to a specific file
                                          (i.e. contains no wildcards), then path is the name of the
                                          blob to which to upload that file. If filePattern contains
                                          one or more wildcards (and therefore may match multiple
                                          files), then path is the name of the blob virtual directory
                                          (which is prepended to each blob name) to which to upload the
                                          file(s). If omitted, file(s) are uploaded to the root of the
                                          container with a blob name matching their file name.
                                        "uploadHeaders": [
                                            {
                                                "name": "str",  # The
                                                  case-insensitive name of the header to be used while
                                                  uploading output files. Required.
                                                "value": "str"  #
                                                  Optional. The value of the header to be used while
                                                  uploading output files.
                                            }
                                        ]
                                    }
                                },
                                "filePattern": "str",  # A pattern indicating which
                                  file(s) to upload. Both relative and absolute paths are supported.
                                  Relative paths are relative to the Task working directory. The
                                  following wildcards are supported: * matches 0 or more characters
                                  (for example pattern abc* would match abc or abcdef), ** matches any
                                  directory, ? matches any single character, [abc] matches one
                                  character in the brackets, and [a-c] matches one character in the
                                  range. Brackets can include a negation to match any character not
                                  specified (for example [!abc] matches any character but a, b, or c).
                                  If a file name starts with "." it is ignored by default but may be
                                  matched by specifying it explicitly (for example *.gif will not match
                                  .a.gif, but .*.gif will). A simple example: **"" *.txt matches any
                                  file that does not start in '.' and ends with .txt in the Task
                                  working directory or any subdirectory. If the filename contains a
                                  wildcard character it can be escaped using brackets (for example
                                  abc["" *] would match a file named abc*"" ). Note that both and / are
                                  treated as directory separators on Windows, but only / is on Linux.
                                  Environment variables (%var% on Windows or $var on Linux) are
                                  expanded prior to the pattern being applied. Required.
                                "uploadOptions": {
                                    "uploadCondition": "str"  # The conditions
                                      under which the Task output file or set of files should be
                                      uploaded. The default is taskcompletion. Required. Known values
                                      are: "tasksuccess", "taskfailure", and "taskcompletion".
                                }
                            }
                        ],
                        "requiredSlots": 0,  # Optional. The number of scheduling slots that
                          the Task requires to run. The default is 1. A Task can only be scheduled to
                          run on a compute node if the node has enough free scheduling slots available.
                          For multi-instance Tasks, this property is not supported and must not be
                          specified.
                        "resourceFiles": [
                            {
                                "autoStorageContainerName": "str",  # Optional. The
                                  storage container name in the auto storage Account. The
                                  autoStorageContainerName, storageContainerUrl and httpUrl properties
                                  are mutually exclusive and one of them must be specified.
                                "blobPrefix": "str",  # Optional. The blob prefix to
                                  use when downloading blobs from an Azure Storage container. Only the
                                  blobs whose names begin with the specified prefix will be downloaded.
                                  The property is valid only when autoStorageContainerName or
                                  storageContainerUrl is used. This prefix can be a partial filename or
                                  a subdirectory. If a prefix is not specified, all the files in the
                                  container will be downloaded.
                                "fileMode": "str",  # Optional. The file permission
                                  mode attribute in octal format. This property applies only to files
                                  being downloaded to Linux Compute Nodes. It will be ignored if it is
                                  specified for a resourceFile which will be downloaded to a Windows
                                  Compute Node. If this property is not specified for a Linux Compute
                                  Node, then a default value of 0770 is applied to the file.
                                "filePath": "str",  # Optional. The location on the
                                  Compute Node to which to download the file(s), relative to the Task's
                                  working directory. If the httpUrl property is specified, the filePath
                                  is required and describes the path which the file will be downloaded
                                  to, including the filename. Otherwise, if the
                                  autoStorageContainerName or storageContainerUrl property is
                                  specified, filePath is optional and is the directory to download the
                                  files to. In the case where filePath is used as a directory, any
                                  directory structure already associated with the input data will be
                                  retained in full and appended to the specified filePath directory.
                                  The specified relative path cannot break out of the Task's working
                                  directory (for example by using '..').
                                "httpUrl": "str",  # Optional. The URL of the file to
                                  download. The autoStorageContainerName, storageContainerUrl and
                                  httpUrl properties are mutually exclusive and one of them must be
                                  specified. If the URL points to Azure Blob Storage, it must be
                                  readable from compute nodes. There are three ways to get such a URL
                                  for a blob in Azure storage: include a Shared Access Signature (SAS)
                                  granting read permissions on the blob, use a managed identity with
                                  read permission, or set the ACL for the blob or its container to
                                  allow public access.
                                "identityReference": {
                                    "resourceId": "str"  # Optional. The ARM
                                      resource id of the user assigned identity.
                                },
                                "storageContainerUrl": "str"  # Optional. The URL of
                                  the blob container within Azure Blob Storage. The
                                  autoStorageContainerName, storageContainerUrl and httpUrl properties
                                  are mutually exclusive and one of them must be specified. This URL
                                  must be readable and listable from compute nodes. There are three
                                  ways to get such a URL for a container in Azure storage: include a
                                  Shared Access Signature (SAS) granting read and list permissions on
                                  the container, use a managed identity with read and list permissions,
                                  or set the ACL for the container to allow public access.
                            }
                        ],
                        "runExclusive": bool,  # Optional. Whether the Job Manager Task
                          requires exclusive use of the Compute Node where it runs. If true, no other
                          Tasks will run on the same Node for as long as the Job Manager is running. If
                          false, other Tasks can run simultaneously with the Job Manager on a Compute
                          Node. The Job Manager Task counts normally against the Compute Node's
                          concurrent Task limit, so this is only relevant if the Compute Node allows
                          multiple concurrent Tasks. The default value is true.
                        "userIdentity": {
                            "autoUser": {
                                "elevationLevel": "str",  # Optional. The elevation
                                  level of the auto user. The default value is nonAdmin. Known values
                                  are: "nonadmin" and "admin".
                                "scope": "str"  # Optional. The scope for the auto
                                  user. The default value is pool. If the pool is running Windows, a
                                  value of Task should be specified if stricter isolation between tasks
                                  is required, such as if the task mutates the registry in a way which
                                  could impact other tasks. Known values are: "task" and "pool".
                            },
                            "username": "str"  # Optional. The name of the user identity
                              under which the Task is run. The userName and autoUser properties are
                              mutually exclusive; you must specify one but not both.
                        }
                    },
                    "jobPreparationTask": {
                        "commandLine": "str",  # The command line of the Job Preparation
                          Task. The command line does not run under a shell, and therefore cannot take
                          advantage of shell features such as environment variable expansion. If you
                          want to take advantage of such features, you should invoke the shell in the
                          command line, for example using "cmd /c MyCommand" in Windows or "/bin/sh -c
                          MyCommand" in Linux. If the command line refers to file paths, it should use
                          a relative path (relative to the Task working directory), or use the Batch
                          provided environment variable
                          (https://docs.microsoft.com/en-us/azure/batch/batch-compute-node-environment-variables).
                          Required.
                        "constraints": {
                            "maxTaskRetryCount": 0,  # Optional. The maximum number of
                              times the Task may be retried. The Batch service retries a Task if its
                              exit code is nonzero. Note that this value specifically controls the
                              number of retries for the Task executable due to a nonzero exit code. The
                              Batch service will try the Task once, and may then retry up to this
                              limit. For example, if the maximum retry count is 3, Batch tries the Task
                              up to 4 times (one initial try and 3 retries). If the maximum retry count
                              is 0, the Batch service does not retry the Task after the first attempt.
                              If the maximum retry count is -1, the Batch service retries the Task
                              without limit, however this is not recommended for a start task or any
                              task. The default value is 0 (no retries).
                            "maxWallClockTime": "1 day, 0:00:00",  # Optional. The
                              maximum elapsed time that the Task may run, measured from the time the
                              Task starts. If the Task does not complete within the time limit, the
                              Batch service terminates it. If this is not specified, there is no time
                              limit on how long the Task may run.
                            "retentionTime": "1 day, 0:00:00"  # Optional. The minimum
                              time to retain the Task directory on the Compute Node where it ran, from
                              the time it completes execution. After this time, the Batch service may
                              delete the Task directory and all its contents. The default is 7 days,
                              i.e. the Task directory will be retained for 7 days unless the Compute
                              Node is removed or the Job is deleted.
                        },
                        "containerSettings": {
                            "imageName": "str",  # The Image to use to create the
                              container in which the Task will run. This is the full Image reference,
                              as would be specified to "docker pull". If no tag is provided as part of
                              the Image name, the tag ":latest" is used as a default. Required.
                            "containerRunOptions": "str",  # Optional. Additional options
                              to the container create command. These additional options are supplied as
                              arguments to the "docker create" command, in addition to those controlled
                              by the Batch Service.
                            "registry": {
                                "identityReference": {
                                    "resourceId": "str"  # Optional. The ARM
                                      resource id of the user assigned identity.
                                },
                                "password": "str",  # Optional. The password to log
                                  into the registry server.
                                "registryServer": "str",  # Optional. The registry
                                  URL. If omitted, the default is "docker.io".
                                "username": "str"  # Optional. The user name to log
                                  into the registry server.
                            },
                            "workingDirectory": "str"  # Optional. The location of the
                              container Task working directory. The default is 'taskWorkingDirectory'.
                              Known values are: "taskWorkingDirectory" and "containerImageDefault".
                        },
                        "environmentSettings": [
                            {
                                "name": "str",  # The name of the environment
                                  variable. Required.
                                "value": "str"  # Optional. The value of the
                                  environment variable.
                            }
                        ],
                        "id": "str",  # Optional. A string that uniquely identifies the Job
                          Preparation Task within the Job. The ID can contain any combination of
                          alphanumeric characters including hyphens and underscores and cannot contain
                          more than 64 characters. If you do not specify this property, the Batch
                          service assigns a default value of 'jobpreparation'. No other Task in the Job
                          can have the same ID as the Job Preparation Task. If you try to submit a Task
                          with the same id, the Batch service rejects the request with error code
                          TaskIdSameAsJobPreparationTask; if you are calling the REST API directly, the
                          HTTP status code is 409 (Conflict).
                        "rerunOnNodeRebootAfterSuccess": bool,  # Optional. Whether the Batch
                          service should rerun the Job Preparation Task after a Compute Node reboots.
                          The Job Preparation Task is always rerun if a Compute Node is reimaged, or if
                          the Job Preparation Task did not complete (e.g. because the reboot occurred
                          while the Task was running). Therefore, you should always write a Job
                          Preparation Task to be idempotent and to behave correctly if run multiple
                          times. The default value is true.
                        "resourceFiles": [
                            {
                                "autoStorageContainerName": "str",  # Optional. The
                                  storage container name in the auto storage Account. The
                                  autoStorageContainerName, storageContainerUrl and httpUrl properties
                                  are mutually exclusive and one of them must be specified.
                                "blobPrefix": "str",  # Optional. The blob prefix to
                                  use when downloading blobs from an Azure Storage container. Only the
                                  blobs whose names begin with the specified prefix will be downloaded.
                                  The property is valid only when autoStorageContainerName or
                                  storageContainerUrl is used. This prefix can be a partial filename or
                                  a subdirectory. If a prefix is not specified, all the files in the
                                  container will be downloaded.
                                "fileMode": "str",  # Optional. The file permission
                                  mode attribute in octal format. This property applies only to files
                                  being downloaded to Linux Compute Nodes. It will be ignored if it is
                                  specified for a resourceFile which will be downloaded to a Windows
                                  Compute Node. If this property is not specified for a Linux Compute
                                  Node, then a default value of 0770 is applied to the file.
                                "filePath": "str",  # Optional. The location on the
                                  Compute Node to which to download the file(s), relative to the Task's
                                  working directory. If the httpUrl property is specified, the filePath
                                  is required and describes the path which the file will be downloaded
                                  to, including the filename. Otherwise, if the
                                  autoStorageContainerName or storageContainerUrl property is
                                  specified, filePath is optional and is the directory to download the
                                  files to. In the case where filePath is used as a directory, any
                                  directory structure already associated with the input data will be
                                  retained in full and appended to the specified filePath directory.
                                  The specified relative path cannot break out of the Task's working
                                  directory (for example by using '..').
                                "httpUrl": "str",  # Optional. The URL of the file to
                                  download. The autoStorageContainerName, storageContainerUrl and
                                  httpUrl properties are mutually exclusive and one of them must be
                                  specified. If the URL points to Azure Blob Storage, it must be
                                  readable from compute nodes. There are three ways to get such a URL
                                  for a blob in Azure storage: include a Shared Access Signature (SAS)
                                  granting read permissions on the blob, use a managed identity with
                                  read permission, or set the ACL for the blob or its container to
                                  allow public access.
                                "identityReference": {
                                    "resourceId": "str"  # Optional. The ARM
                                      resource id of the user assigned identity.
                                },
                                "storageContainerUrl": "str"  # Optional. The URL of
                                  the blob container within Azure Blob Storage. The
                                  autoStorageContainerName, storageContainerUrl and httpUrl properties
                                  are mutually exclusive and one of them must be specified. This URL
                                  must be readable and listable from compute nodes. There are three
                                  ways to get such a URL for a container in Azure storage: include a
                                  Shared Access Signature (SAS) granting read and list permissions on
                                  the container, use a managed identity with read and list permissions,
                                  or set the ACL for the container to allow public access.
                            }
                        ],
                        "userIdentity": {
                            "autoUser": {
                                "elevationLevel": "str",  # Optional. The elevation
                                  level of the auto user. The default value is nonAdmin. Known values
                                  are: "nonadmin" and "admin".
                                "scope": "str"  # Optional. The scope for the auto
                                  user. The default value is pool. If the pool is running Windows, a
                                  value of Task should be specified if stricter isolation between tasks
                                  is required, such as if the task mutates the registry in a way which
                                  could impact other tasks. Known values are: "task" and "pool".
                            },
                            "username": "str"  # Optional. The name of the user identity
                              under which the Task is run. The userName and autoUser properties are
                              mutually exclusive; you must specify one but not both.
                        },
                        "waitForSuccess": bool  # Optional. Whether the Batch service should
                          wait for the Job Preparation Task to complete successfully before scheduling
                          any other Tasks of the Job on the Compute Node. A Job Preparation Task has
                          completed successfully if it exits with exit code 0. If true and the Job
                          Preparation Task fails on a Node, the Batch service retries the Job
                          Preparation Task up to its maximum retry count (as specified in the
                          constraints element). If the Task has still not completed successfully after
                          all retries, then the Batch service will not schedule Tasks of the Job to the
                          Node. The Node remains active and eligible to run Tasks of other Jobs. If
                          false, the Batch service will not wait for the Job Preparation Task to
                          complete. In this case, other Tasks of the Job can start executing on the
                          Compute Node while the Job Preparation Task is still running; and even if the
                          Job Preparation Task fails, new Tasks will continue to be scheduled on the
                          Compute Node. The default value is true.
                    },
                    "jobReleaseTask": {
                        "commandLine": "str",  # The command line of the Job Release Task.
                          The command line does not run under a shell, and therefore cannot take
                          advantage of shell features such as environment variable expansion. If you
                          want to take advantage of such features, you should invoke the shell in the
                          command line, for example using "cmd /c MyCommand" in Windows or "/bin/sh -c
                          MyCommand" in Linux. If the command line refers to file paths, it should use
                          a relative path (relative to the Task working directory), or use the Batch
                          provided environment variable
                          (https://docs.microsoft.com/en-us/azure/batch/batch-compute-node-environment-variables).
                          Required.
                        "containerSettings": {
                            "imageName": "str",  # The Image to use to create the
                              container in which the Task will run. This is the full Image reference,
                              as would be specified to "docker pull". If no tag is provided as part of
                              the Image name, the tag ":latest" is used as a default. Required.
                            "containerRunOptions": "str",  # Optional. Additional options
                              to the container create command. These additional options are supplied as
                              arguments to the "docker create" command, in addition to those controlled
                              by the Batch Service.
                            "registry": {
                                "identityReference": {
                                    "resourceId": "str"  # Optional. The ARM
                                      resource id of the user assigned identity.
                                },
                                "password": "str",  # Optional. The password to log
                                  into the registry server.
                                "registryServer": "str",  # Optional. The registry
                                  URL. If omitted, the default is "docker.io".
                                "username": "str"  # Optional. The user name to log
                                  into the registry server.
                            },
                            "workingDirectory": "str"  # Optional. The location of the
                              container Task working directory. The default is 'taskWorkingDirectory'.
                              Known values are: "taskWorkingDirectory" and "containerImageDefault".
                        },
                        "environmentSettings": [
                            {
                                "name": "str",  # The name of the environment
                                  variable. Required.
                                "value": "str"  # Optional. The value of the
                                  environment variable.
                            }
                        ],
                        "id": "str",  # Optional. A string that uniquely identifies the Job
                          Release Task within the Job. The ID can contain any combination of
                          alphanumeric characters including hyphens and underscores and cannot contain
                          more than 64 characters. If you do not specify this property, the Batch
                          service assigns a default value of 'jobrelease'. No other Task in the Job can
                          have the same ID as the Job Release Task. If you try to submit a Task with
                          the same id, the Batch service rejects the request with error code
                          TaskIdSameAsJobReleaseTask; if you are calling the REST API directly, the
                          HTTP status code is 409 (Conflict).
                        "maxWallClockTime": "1 day, 0:00:00",  # Optional. The maximum
                          elapsed time that the Job Release Task may run on a given Compute Node,
                          measured from the time the Task starts. If the Task does not complete within
                          the time limit, the Batch service terminates it. The default value is 15
                          minutes. You may not specify a timeout longer than 15 minutes. If you do, the
                          Batch service rejects it with an error; if you are calling the REST API
                          directly, the HTTP status code is 400 (Bad Request).
                        "resourceFiles": [
                            {
                                "autoStorageContainerName": "str",  # Optional. The
                                  storage container name in the auto storage Account. The
                                  autoStorageContainerName, storageContainerUrl and httpUrl properties
                                  are mutually exclusive and one of them must be specified.
                                "blobPrefix": "str",  # Optional. The blob prefix to
                                  use when downloading blobs from an Azure Storage container. Only the
                                  blobs whose names begin with the specified prefix will be downloaded.
                                  The property is valid only when autoStorageContainerName or
                                  storageContainerUrl is used. This prefix can be a partial filename or
                                  a subdirectory. If a prefix is not specified, all the files in the
                                  container will be downloaded.
                                "fileMode": "str",  # Optional. The file permission
                                  mode attribute in octal format. This property applies only to files
                                  being downloaded to Linux Compute Nodes. It will be ignored if it is
                                  specified for a resourceFile which will be downloaded to a Windows
                                  Compute Node. If this property is not specified for a Linux Compute
                                  Node, then a default value of 0770 is applied to the file.
                                "filePath": "str",  # Optional. The location on the
                                  Compute Node to which to download the file(s), relative to the Task's
                                  working directory. If the httpUrl property is specified, the filePath
                                  is required and describes the path which the file will be downloaded
                                  to, including the filename. Otherwise, if the
                                  autoStorageContainerName or storageContainerUrl property is
                                  specified, filePath is optional and is the directory to download the
                                  files to. In the case where filePath is used as a directory, any
                                  directory structure already associated with the input data will be
                                  retained in full and appended to the specified filePath directory.
                                  The specified relative path cannot break out of the Task's working
                                  directory (for example by using '..').
                                "httpUrl": "str",  # Optional. The URL of the file to
                                  download. The autoStorageContainerName, storageContainerUrl and
                                  httpUrl properties are mutually exclusive and one of them must be
                                  specified. If the URL points to Azure Blob Storage, it must be
                                  readable from compute nodes. There are three ways to get such a URL
                                  for a blob in Azure storage: include a Shared Access Signature (SAS)
                                  granting read permissions on the blob, use a managed identity with
                                  read permission, or set the ACL for the blob or its container to
                                  allow public access.
                                "identityReference": {
                                    "resourceId": "str"  # Optional. The ARM
                                      resource id of the user assigned identity.
                                },
                                "storageContainerUrl": "str"  # Optional. The URL of
                                  the blob container within Azure Blob Storage. The
                                  autoStorageContainerName, storageContainerUrl and httpUrl properties
                                  are mutually exclusive and one of them must be specified. This URL
                                  must be readable and listable from compute nodes. There are three
                                  ways to get such a URL for a container in Azure storage: include a
                                  Shared Access Signature (SAS) granting read and list permissions on
                                  the container, use a managed identity with read and list permissions,
                                  or set the ACL for the container to allow public access.
                            }
                        ],
                        "retentionTime": "1 day, 0:00:00",  # Optional. The minimum time to
                          retain the Task directory for the Job Release Task on the Compute Node. After
                          this time, the Batch service may delete the Task directory and all its
                          contents. The default is 7 days, i.e. the Task directory will be retained for
                          7 days unless the Compute Node is removed or the Job is deleted.
                        "userIdentity": {
                            "autoUser": {
                                "elevationLevel": "str",  # Optional. The elevation
                                  level of the auto user. The default value is nonAdmin. Known values
                                  are: "nonadmin" and "admin".
                                "scope": "str"  # Optional. The scope for the auto
                                  user. The default value is pool. If the pool is running Windows, a
                                  value of Task should be specified if stricter isolation between tasks
                                  is required, such as if the task mutates the registry in a way which
                                  could impact other tasks. Known values are: "task" and "pool".
                            },
                            "username": "str"  # Optional. The name of the user identity
                              under which the Task is run. The userName and autoUser properties are
                              mutually exclusive; you must specify one but not both.
                        }
                    },
                    "maxParallelTasks": 0,  # Optional. The maximum number of tasks that can be
                      executed in parallel for the job. The value of maxParallelTasks must be -1 or
                      greater than 0 if specified. If not specified, the default value is -1, which
                      means there's no limit to the number of tasks that can be run at once. You can
                      update a job's maxParallelTasks after it has been created using the update job
                      API.
                    "metadata": [
                        {
                            "name": "str",  # The name of the metadata item. Required.
                            "value": "str"  # The value of the metadata item. Required.
                        }
                    ],
                    "networkConfiguration": {
                        "subnetId": "str"  # The ARM resource identifier of the virtual
                          network subnet which Compute Nodes running Tasks from the Job will join for
                          the duration of the Task. This will only work with a
                          VirtualMachineConfiguration Pool. The virtual network must be in the same
                          region and subscription as the Azure Batch Account. The specified subnet
                          should have enough free IP addresses to accommodate the number of Compute
                          Nodes which will run Tasks from the Job. This can be up to the number of
                          Compute Nodes in the Pool. The 'MicrosoftAzureBatch' service principal must
                          have the 'Classic Virtual Machine Contributor' Role-Based Access Control
                          (RBAC) role for the specified VNet so that Azure Batch service can schedule
                          Tasks on the Nodes. This can be verified by checking if the specified VNet
                          has any associated Network Security Groups (NSG). If communication to the
                          Nodes in the specified subnet is denied by an NSG, then the Batch service
                          will set the state of the Compute Nodes to unusable. This is of the form
                          /subscriptions/{subscription}/resourceGroups/{group}/providers/{provider}/virtualNetworks/{network}/subnets/{subnet}.
                          If the specified VNet has any associated Network Security Groups (NSG), then
                          a few reserved system ports must be enabled for inbound communication from
                          the Azure Batch service. For Pools created with a Virtual Machine
                          configuration, enable ports 29876 and 29877, as well as port 22 for Linux and
                          port 3389 for Windows. Port 443 is also required to be open for outbound
                          connections for communications to Azure Storage. For more details see:
                          https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration.
                          Required.
                    },
                    "onAllTasksComplete": "str",  # Optional. The action the Batch service should
                      take when all Tasks in the Job are in the completed state. Note that if a Job
                      contains no Tasks, then all Tasks are considered complete. This option is
                      therefore most commonly used with a Job Manager task; if you want to use
                      automatic Job termination without a Job Manager, you should initially set
                      onAllTasksComplete to noaction and update the Job properties to set
                      onAllTasksComplete to terminatejob once you have finished adding Tasks. The
                      default is noaction. Known values are: "noaction" and "terminatejob".
                    "onTaskFailure": "str",  # Optional. The action the Batch service should take
                      when any Task in the Job fails. A Task is considered to have failed if has a
                      failureInfo. A failureInfo is set if the Task completes with a non-zero exit code
                      after exhausting its retry count, or if there was an error starting the Task, for
                      example due to a resource file download error. The default is noaction. Known
                      values are: "noaction" and "performexitoptionsjobaction".
                    "priority": 0,  # Optional. The priority of the Job. Priority values can
                      range from -1000 to 1000, with -1000 being the lowest priority and 1000 being the
                      highest priority. The default value is 0.
                    "usesTaskDependencies": bool  # Optional. Whether Tasks in the Job can define
                      dependencies on each other. The default is false.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: str = kwargs.pop(
            "content_type", _headers.pop("content-type", "application/json; odata=minimalmetadata")
        )
        cls: ClsType[None] = kwargs.pop("cls", None)

        _content = json.dumps(job, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_batch_create_job_request(
            time_out_in_seconds=time_out_in_seconds,
            ocpdate=ocpdate,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.BatchError, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["DataServiceId"] = self._deserialize("str", response.headers.get("DataServiceId"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def list_jobs(
        self,
        *,
        time_out_in_seconds: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        maxresults: Optional[int] = None,
        filter: Optional[str] = None,
        select: Optional[List[str]] = None,
        expand: Optional[List[str]] = None,
        **kwargs: Any
    ) -> Iterable["_models.BatchJob"]:
        # pylint: disable=line-too-long
        """Lists all of the Jobs in the specified Account.

        Lists all of the Jobs in the specified Account.

        :keyword time_out_in_seconds: The maximum time that the server can spend processing the
         request, in seconds. The default is 30 seconds. If the value is larger than 30, the default
         will be used instead.". Default value is None.
        :paramtype time_out_in_seconds: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword maxresults: The maximum number of items to return in the response. A maximum of 1000
         applications can be returned. Default value is None.
        :paramtype maxresults: int
        :keyword filter: An OData $filter clause. For more information on constructing this filter, see
         https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-jobs.
         Default value is None.
        :paramtype filter: str
        :keyword select: An OData $select clause. Default value is None.
        :paramtype select: list[str]
        :keyword expand: An OData $expand clause. Default value is None.
        :paramtype expand: list[str]
        :return: An iterator like instance of BatchJob
        :rtype: ~azure.core.paging.ItemPaged[~azure.batch.models.BatchJob]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "poolInfo": {
                        "autoPoolSpecification": {
                            "poolLifetimeOption": "str",  # The minimum lifetime of
                              created auto Pools, and how multiple Jobs on a schedule are assigned to
                              Pools. Required. Known values are: "jobschedule" and "job".
                            "autoPoolIdPrefix": "str",  # Optional. A prefix to be added
                              to the unique identifier when a Pool is automatically created. The Batch
                              service assigns each auto Pool a unique identifier on creation. To
                              distinguish between Pools created for different purposes, you can specify
                              this element to add a prefix to the ID that is assigned. The prefix can
                              be up to 20 characters long.
                            "keepAlive": bool,  # Optional. Whether to keep an auto Pool
                              alive after its lifetime expires. If false, the Batch service deletes the
                              Pool once its lifetime (as determined by the poolLifetimeOption setting)
                              expires; that is, when the Job or Job Schedule completes. If true, the
                              Batch service does not delete the Pool automatically. It is up to the
                              user to delete auto Pools created with this option.
                            "pool": {
                                "vmSize": "str",  # The size of the virtual machines
                                  in the Pool. All virtual machines in a Pool are the same size. For
                                  information about available sizes of virtual machines in Pools, see
                                  Choose a VM size for Compute Nodes in an Azure Batch Pool
                                  (https://docs.microsoft.com/azure/batch/batch-pool-vm-sizes).
                                  Required.
                                "applicationPackageReferences": [
                                    {
                                        "applicationId": "str",  # The ID of
                                          the application to deploy. When creating a pool, the
                                          package's application ID must be fully qualified
                                          (/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/applications/{applicationName}).
                                          Required.
                                        "version": "str"  # Optional. The
                                          version of the application to deploy. If omitted, the default
                                          version is deployed. If this is omitted on a Pool, and no
                                          default version is specified for this application, the
                                          request fails with the error code
                                          InvalidApplicationPackageReferences and HTTP status code 409.
                                          If this is omitted on a Task, and no default version is
                                          specified for this application, the Task fails with a
                                          pre-processing error.
                                    }
                                ],
                                "autoScaleEvaluationInterval": "1 day, 0:00:00",  #
                                  Optional. The time interval at which to automatically adjust the Pool
                                  size according to the autoscale formula. The default value is 15
                                  minutes. The minimum and maximum value are 5 minutes and 168 hours
                                  respectively. If you specify a value less than 5 minutes or greater
                                  than 168 hours, the Batch service rejects the request with an invalid
                                  property value error; if you are calling the REST API directly, the
                                  HTTP status code is 400 (Bad Request).
                                "autoScaleFormula": "str",  # Optional. The formula
                                  for the desired number of Compute Nodes in the Pool. This property
                                  must not be specified if enableAutoScale is set to false. It is
                                  required if enableAutoScale is set to true. The formula is checked
                                  for validity before the Pool is created. If the formula is not valid,
                                  the Batch service rejects the request with detailed error
                                  information.
                                "displayName": "str",  # Optional. The display name
                                  for the Pool. The display name need not be unique and can contain any
                                  Unicode characters up to a maximum length of 1024.
                                "enableAutoScale": bool,  # Optional. Whether the
                                  Pool size should automatically adjust over time. If false, at least
                                  one of targetDedicatedNodes and targetLowPriorityNodes must be
                                  specified. If true, the autoScaleFormula element is required. The
                                  Pool automatically resizes according to the formula. The default
                                  value is false.
                                "enableInterNodeCommunication": bool,  # Optional.
                                  Whether the Pool permits direct communication between Compute Nodes.
                                  Enabling inter-node communication limits the maximum size of the Pool
                                  due to deployment restrictions on the Compute Nodes of the Pool. This
                                  may result in the Pool not reaching its desired size. The default
                                  value is false.
                                "metadata": [
                                    {
                                        "name": "str",  # The name of the
                                          metadata item. Required.
                                        "value": "str"  # The value of the
                                          metadata item. Required.
                                    }
                                ],
                                "mountConfiguration": [
                                    {
                                        "azureBlobFileSystemConfiguration": {
                                            "accountName": "str",  # The
                                              Azure Storage Account name. Required.
                                            "containerName": "str",  #
                                              The Azure Blob Storage Container name. Required.
                                            "relativeMountPath": "str",
                                              # The relative path on the compute node where the file
                                              system will be mounted. All file systems are mounted
                                              relative to the Batch mounts directory, accessible via
                                              the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
                                              Required.
                                            "accountKey": "str",  #
                                              Optional. The Azure Storage Account key. This property is
                                              mutually exclusive with both sasKey and identity; exactly
                                              one must be specified.
                                            "blobfuseOptions": "str",  #
                                              Optional. Additional command line options to pass to the
                                              mount command. These are 'net use' options in Windows and
                                              'mount' options in Linux.
                                            "identityReference": {
                                                "resourceId": "str"
                                                  # Optional. The ARM resource id of the user assigned
                                                  identity.
                                            },
                                            "sasKey": "str"  # Optional.
                                              The Azure Storage SAS token. This property is mutually
                                              exclusive with both accountKey and identity; exactly one
                                              must be specified.
                                        },
                                        "azureFileShareConfiguration": {
                                            "accountKey": "str",  # The
                                              Azure Storage account key. Required.
                                            "accountName": "str",  # The
                                              Azure Storage account name. Required.
                                            "azureFileUrl": "str",  # The
                                              Azure Files URL. This is of