/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.detailview.list;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.graph.selection.GraphSelection;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.treelist.parts.PartsTable;
import com.paterva.maltego.treelist.parts.PartsTreelistModel;
import com.paterva.maltego.ui.graph.actions.ZoomToSelectionAction;
import com.paterva.maltego.ui.graph.view2d.ZoomAndFlasher;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.SystemAction;

public abstract class SelectionSyncButton<PartID extends Guid, Part extends MaltegoPart<PartID>>
extends JButton {
    private final PartsTable<PartID, Part> _table;
    private ListSelectionListener _listSelectionListener;

    public SelectionSyncButton(PartsTable<PartID, Part> table) {
        this._table = table;
        this.setIcon(ImageUtilities.loadImageIcon((String)"com/paterva/maltego/detailview/SyncToLeft.png", (boolean)true));
        this.addActionListener(new SelectionSyncAction());
        this.setToolTipText(this.getName());
    }

    public abstract void sync(GraphSelection var1, Collection<PartID> var2);

    @Override
    public String getName() {
        return "Sync Selection to Graph";
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this._listSelectionListener = new TableSelectionListener();
        this._table.getSelectionModel().addListSelectionListener(this._listSelectionListener);
        this.updateEnabled();
    }

    @Override
    public void removeNotify() {
        this._table.getSelectionModel().removeListSelectionListener(this._listSelectionListener);
        this._listSelectionListener = null;
        super.removeNotify();
    }

    private void updateEnabled() {
        int[] selectedRows = this._table.getSelectedRows();
        this.setEnabled(selectedRows.length > 0);
    }

    private class TableSelectionListener
    implements ListSelectionListener {
        private TableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                SelectionSyncButton.this.updateEnabled();
            }
        }
    }

    private class SelectionSyncAction
    implements ActionListener {
        private SelectionSyncAction() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            int[] selectedRows = SelectionSyncButton.this._table.getSelectedRows();
            if (selectedRows.length > 0) {
                ArrayList<Guid> partIDs = new ArrayList<Guid>(selectedRows.length);
                PartsTreelistModel model = SelectionSyncButton.this._table.getTreelistModel();
                for (int selectedRow : selectedRows) {
                    int modelRow = SelectionSyncButton.this._table.convertRowIndexToModel(selectedRow);
                    Guid partID = model.getModelPartID(modelRow);
                    partIDs.add(partID);
                }
                GraphID graphID = model.getGraphID();
                GraphSelection selection = GraphSelection.forGraph((GraphID)graphID);
                SelectionSyncButton.this.sync(selection, partIDs);
                if (partIDs.size() == 1 && partIDs.get(0) instanceof EntityID) {
                    EntityID entityID = (EntityID)partIDs.get(0);
                    try {
                        ZoomAndFlasher.instance().zoomAndFlash(graphID, entityID);
                    }
                    catch (GraphStoreException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                } else {
                    ((ZoomToSelectionAction)SystemAction.get(ZoomToSelectionAction.class)).zoomToSelection();
                }
            }
        }
    }
}

