/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.imex;

import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.entity.api.LinkRegistry;
import com.paterva.maltego.entity.api.MaltegoLinkSpec;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.ui.graph.imex.IOHelper;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class MaltegoLinkIOStax {
    public static void write(XMLStreamWriter writer, MaltegoLink link) throws XMLStreamException {
        writer.writeStartElement("mtg", "MaltegoLink", "http://maltego.paterva.com/xml/mtgx");
        writer.writeAttribute("id", ((LinkID)link.getID()).toString());
        writer.writeAttribute("type", link.getTypeName());
        if (Boolean.TRUE.equals(link.isReversed())) {
            writer.writeAttribute("reversed", Boolean.toString(link.isReversed()));
        }
        MaltegoLinkIOStax.writeProperties(writer, link);
        writer.writeEndElement();
    }

    private static void writeProperties(XMLStreamWriter writer, MaltegoLink link) throws XMLStreamException {
        writer.writeStartElement("mtg", "Properties", "http://maltego.paterva.com/xml/mtgx");
        MaltegoLinkSpec spec = (MaltegoLinkSpec)LinkRegistry.getDefault().get(link.getTypeName());
        for (PropertyDescriptor pd : link.getProperties()) {
            DisplayDescriptor dd;
            boolean shouldWrite = true;
            if (link.getValue(pd) == null && spec != null && (dd = spec.getProperties().get(pd.getName())) != null && dd.getDefaultValue() == null) {
                shouldWrite = false;
            }
            if (!shouldWrite) continue;
            if (("maltego.link.style".equals(pd.getName()) || "maltego.link.thickness".equals(pd.getName())) && Integer.valueOf(-1).equals(link.getValue(pd))) {
                shouldWrite = false;
            }
            if (!shouldWrite) continue;
            IOHelper.writeProperty(writer, (MaltegoPart<? extends Guid>)link, pd);
        }
        writer.writeEndElement();
    }
}

