/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.data;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.event.EventListenerList;
import org.openide.util.NbPreferences;

public class RecentFiles {
    protected static String DEFAULT_NODE_NAME = "prefs";
    protected String _nodeName = "mrufiles";
    private EventListenerList _listenerList;
    public static final String MRU_FILE_LIST_PROPERTY = "MRUFileList";
    private List<String> _mruFileList = new ArrayList<String>(this._maxSize);
    private int _maxSize = 12;
    private static RecentFiles _instance = new RecentFiles();

    public static RecentFiles getInstance() {
        return _instance;
    }

    protected RecentFiles() {
        this._listenerList = new EventListenerList();
        this.retrieve();
    }

    public List<String> getMRUFileList() {
        return this._mruFileList;
    }

    private void setMRUFileList(List<String> list) {
        this._mruFileList.clear();
        this._mruFileList.addAll(list.subList(0, Math.min(list.size(), this._maxSize)));
        this.firePropertyChange(MRU_FILE_LIST_PROPERTY, null, this._mruFileList);
        this.store();
    }

    public void addFile(String absolutePath) {
        if (absolutePath != null && absolutePath.startsWith("file")) {
            this._mruFileList.remove(absolutePath);
            this._mruFileList.add(0, absolutePath);
            while (this._mruFileList.size() > this._maxSize) {
                this._mruFileList.remove(this._mruFileList.size() - 1);
            }
            this.firePropertyChange(MRU_FILE_LIST_PROPERTY, null, this._mruFileList);
            this.store();
        }
    }

    public void removeFile(String absolutePath) {
        if (absolutePath != null && absolutePath.startsWith("file")) {
            this._mruFileList.remove(absolutePath);
            this.firePropertyChange(MRU_FILE_LIST_PROPERTY, null, this._mruFileList);
            this.store();
        }
    }

    protected void store() {
        Preferences prefs = this.getPreferences();
        try {
            prefs.clear();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        for (int i = 0; i < this._mruFileList.size(); ++i) {
            String str = this._mruFileList.get(i);
            prefs.put(MRU_FILE_LIST_PROPERTY + i, str);
        }
    }

    protected void retrieve() {
        String str;
        this._mruFileList.clear();
        Preferences prefs = this.getPreferences();
        for (int i = 0; i < this._maxSize && (str = prefs.get(MRU_FILE_LIST_PROPERTY + i, null)) != null; ++i) {
            this._mruFileList.add(str);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._listenerList.add(PropertyChangeListener.class, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._listenerList.remove(PropertyChangeListener.class, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        Object[] listeners = this._listenerList.getListenerList();
        PropertyChangeEvent event = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != PropertyChangeListener.class) continue;
            ((PropertyChangeListener)listeners[i + 1]).propertyChange(event);
        }
    }

    protected final Preferences getPreferences() {
        String name = DEFAULT_NODE_NAME;
        if (this._nodeName != null) {
            name = this._nodeName;
        }
        Preferences prefs = NbPreferences.forModule(this.getClass()).node("options").node(name);
        return prefs;
    }
}

