/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.errorstripe.caret;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.caret.CaretInfo;
import org.netbeans.api.editor.caret.EditorCaret;
import org.netbeans.modules.editor.errorstripe.caret.CaretMark;
import org.netbeans.modules.editor.errorstripe.privatespi.Mark;
import org.netbeans.modules.editor.errorstripe.privatespi.MarkProvider;
import org.openide.text.NbDocument;
import org.openide.util.RequestProcessor;

public class CaretMarkProvider
extends MarkProvider
implements CaretListener {
    private static final RequestProcessor RP = new RequestProcessor("CaretMarkProvider");
    private List<Mark> marks;
    private JTextComponent component;

    public CaretMarkProvider(JTextComponent component) {
        this.component = component;
        component.addCaretListener(this);
        this.marks = this.createMarks();
    }

    private List<Mark> createMarks() {
        Document doc = this.component.getDocument();
        if (!(doc instanceof StyledDocument)) {
            return Collections.singletonList(new CaretMark(0));
        }
        LinkedList<Mark> lines = new LinkedList<Mark>();
        Caret caret = this.component.getCaret();
        if (caret instanceof EditorCaret) {
            EditorCaret editorCaret = (EditorCaret)caret;
            for (CaretInfo caretInfo : editorCaret.getCarets()) {
                int offset = caretInfo.getDot();
                int line = NbDocument.findLineNumber((StyledDocument)((StyledDocument)doc), (int)offset);
                lines.add(new CaretMark(line));
            }
        } else {
            int offset = this.component.getCaretPosition();
            int line = NbDocument.findLineNumber((StyledDocument)((StyledDocument)doc), (int)offset);
            lines.add(new CaretMark(line));
        }
        return lines;
    }

    @Override
    public synchronized List<Mark> getMarks() {
        return Collections.unmodifiableList(this.marks);
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        final List<Mark> old = this.getMarks();
        this.marks = this.createMarks();
        final List<Mark> nue = this.getMarks();
        RP.post(new Runnable(){

            @Override
            public void run() {
                CaretMarkProvider.this.firePropertyChange("marks", old, nue);
            }
        });
    }
}

