/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.runviews.list;

import com.paterva.maltego.runregistry.RunRegistry;
import com.paterva.maltego.runregistry.item.RunCategoryItem;
import com.paterva.maltego.runregistry.item.RunProviderItem;
import com.paterva.maltego.runregistry.item.RunnableItem;
import com.paterva.maltego.runviews.list.RootRunProviderItem;
import com.paterva.maltego.runviews.list.RunProviderTreeListItem;
import com.paterva.maltego.util.ui.outline.TextQuickFilter;
import com.paterva.maltego.util.ui.treelist.AbstractTreeListItem;
import com.paterva.maltego.util.ui.treelist.TreeListItem;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RootRunProviderTreeListItem
extends RunProviderTreeListItem {
    private static final Logger LOG = Logger.getLogger(RootRunProviderTreeListItem.class.getName());
    private static final String TRANSFORMS_NAME = "maltego.builtin.Transforms";
    private static final String MACHINES_NAME = "maltego.builtin.Machines";
    private final TextQuickFilter quickFilter = new TreeListQuickFilter();
    private final String _componentName;
    private boolean _suppressEvents = false;

    public RootRunProviderTreeListItem(String componentName) {
        super(null, (RunProviderItem)new RootRunProviderItem(), 0);
        this._componentName = componentName;
        RunRegistry.getDefault().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                RootRunProviderTreeListItem.this.updateChildren();
            }
        });
    }

    public TextQuickFilter getQuickFilter() {
        return this.quickFilter;
    }

    protected void updateChildren() {
        RunRegistry registry = RunRegistry.getDefault();
        if (registry.isUpdating()) {
            return;
        }
        LOG.log(Level.FINE, "{0} updateChildren", this._componentName);
        List items = registry.getItems(this._componentName);
        if ("context-menu".equals(this._componentName)) {
            boolean updateTransforms = false;
            boolean updateMachines = false;
            int random = (int)(Math.random() * 50.0 + 1.0);
            ArrayList<RunnableItem> itemsInterleaved = new ArrayList<RunnableItem>();
            for (RunProviderItem item : items) {
                List transformsChildren;
                if (!TRANSFORMS_NAME.equals(item.getName()) || !(item instanceof RunnableItem) || !RootRunProviderTreeListItem.transformsFound(transformsChildren = ((RunnableItem)item).getChildren())) continue;
                itemsInterleaved.addAll(transformsChildren);
                updateTransforms = true;
                LOG.log(Level.FINEST, "{0} updateTransforms", random);
            }
            for (RunProviderItem item : items) {
                if (!MACHINES_NAME.equals(item.getName()) || !(item instanceof RunnableItem)) continue;
                List machinesChildren = ((RunnableItem)item).getChildren();
                if (RootRunProviderTreeListItem.noMachinesItemFound(machinesChildren)) {
                    itemsInterleaved.addAll(machinesChildren);
                    updateMachines = true;
                    LOG.log(Level.FINEST, "{0} updateMachines", random);
                    continue;
                }
                if (!RootRunProviderTreeListItem.machinesFound(machinesChildren)) continue;
                itemsInterleaved.add((RunnableItem)item);
                updateMachines = true;
                LOG.log(Level.FINEST, "{0} updateMachines", random);
            }
            if (updateTransforms || updateMachines) {
                this.updateChildren(itemsInterleaved);
                LOG.log(Level.FINEST, "{0} --UPDATE", random);
            } else {
                this.updateChildren(Collections.EMPTY_LIST);
                LOG.log(Level.FINEST, "{0} ----EMPTY", random);
            }
        } else if ("run-view".equals(this._componentName)) {
            this.updateChildren(items);
        }
    }

    private static boolean transformsFound(List<? extends RunProviderItem> transformsChildren) {
        return transformsChildren != null && !transformsChildren.isEmpty();
    }

    private static boolean machinesFound(List<? extends RunProviderItem> machinesChildren) {
        return machinesChildren != null && !machinesChildren.isEmpty();
    }

    private static boolean noMachinesItemFound(List<? extends RunProviderItem> machinesChildren) {
        return RootRunProviderTreeListItem.machinesFound(machinesChildren) && machinesChildren.size() == 1 && "maltego.builtin.(No Machines)".equals(machinesChildren.get(0).getName());
    }

    private void updateChildren(List<? extends RunProviderItem> runChildren) {
        LOG.log(Level.FINE, "updateChildren {0}", runChildren);
        List children = this.getChildren();
        if (children.isEmpty() || runChildren.isEmpty()) {
            this.updateChildrenAll(runChildren);
        } else {
            this.updateChildrenIndividual(this, runChildren);
        }
    }

    private void updateChildrenAll(List<? extends RunProviderItem> runChildren) {
        LOG.log(Level.FINE, "updateChildrenAll {0}", runChildren);
        this._suppressEvents = true;
        this.updateChildrenIndividual(this, runChildren);
        this._suppressEvents = false;
        this.firePropertyChange("itemsReplaced", null, null);
    }

    protected void firePropertyChange(String prop, Object oldValue, Object newValue) {
        if (!this._suppressEvents) {
            super.firePropertyChange(prop, oldValue, newValue);
        }
    }

    private void updateChildrenIndividual(AbstractTreeListItem listItem, List<? extends RunProviderItem> runChildren) {
        LOG.log(Level.FINE, "updateChildrenIndividual for {0}", listItem.getName());
        List listChildren = listItem.getChildren();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Children:");
            for (Object item : listChildren) {
                LOG.log(Level.FINE, "   {0}", item.getName());
            }
        }
        ArrayList<TreeListItem> removed = new ArrayList<TreeListItem>();
        for (TreeListItem child : listChildren) {
            boolean bl = false;
            for (RunProviderItem runProviderItem : runChildren) {
                if (!runProviderItem.isShowIn(this._componentName) || !child.getName().equals(runProviderItem.getName())) continue;
                bl = true;
                ((RunProviderTreeListItem)child).setItem(runProviderItem);
                break;
            }
            if (bl) continue;
            removed.add(child);
        }
        for (TreeListItem item : removed) {
            LOG.log(Level.FINE, "Removed {0}", item.getName());
            this.removeRecursively(item);
            listItem.removeChild(item);
        }
        int index = 0;
        for (RunProviderItem runProviderItem : runChildren) {
            if (!runProviderItem.isShowIn(this._componentName)) continue;
            boolean found = false;
            for (Object child : listChildren) {
                if (!child.getName().equals(runProviderItem.getName())) continue;
                found = true;
                break;
            }
            if (!found) {
                int n = listItem.getChildren().size();
                LOG.log(Level.FINE, "Adding {0} (index={1}, size={2})", new Object[]{runProviderItem.getName(), index, n});
                if (n < index) {
                    Object child;
                    LOG.severe("List item names must be unique, but found duplicate! Items:");
                    child = runChildren.iterator();
                    while (child.hasNext()) {
                        RunProviderItem runProviderItem2 = (RunProviderItem)child.next();
                        LOG.log(Level.SEVERE, "   {0} ({1})", new Object[]{runProviderItem2.getName(), runProviderItem2.getClass().getSimpleName()});
                    }
                    --index;
                }
                RunProviderTreeListItem newItem = new RunProviderTreeListItem((TreeListItem)listItem, runProviderItem, listItem.getDepth() + 1);
                listItem.addChild((TreeListItem)newItem, index);
                newItem.addNotify();
            }
            ++index;
        }
        listChildren = listItem.getChildren();
        this.updateChildrensChildren(listChildren);
    }

    private void updateChildrensChildren(List<TreeListItem> children) {
        for (TreeListItem child : children) {
            RunProviderTreeListItem item = (RunProviderTreeListItem)child;
            RunProviderItem runItem = item.getItem();
            if (runItem instanceof RunCategoryItem) {
                RunCategoryItem categoryItem = (RunCategoryItem)runItem;
                this.updateChildrenIndividual(item, categoryItem.getChildren());
                continue;
            }
            if (!(runItem instanceof RunnableItem)) continue;
            RunnableItem runnableItem = (RunnableItem)runItem;
            this.updateChildrenIndividual(item, runnableItem.getChildren());
        }
    }

    private void removeRecursively(TreeListItem item) {
        item.removeNotify();
        ArrayList children = new ArrayList(item.getChildren());
        for (TreeListItem child : children) {
            this.removeRecursively(child);
            item.removeChild(child);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        super.addPropertyChangeListener(listener);
        LOG.log(Level.FINE, "Add listener to {0}: {1}", new Object[]{this._componentName, listener});
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        super.removePropertyChangeListener(listener);
        LOG.log(Level.FINE, "Rmove listener from {0}: {1}", new Object[]{this._componentName, listener});
    }

    private class TreeListQuickFilter
    implements TextQuickFilter {
        private String filterText = "";

        private TreeListQuickFilter() {
        }

        public String getText() {
            return this.filterText;
        }

        public void setText(String text) {
            this.filterText = text != null ? text.toLowerCase() : "";
            RunRegistry.getDefault().setFilterText(RootRunProviderTreeListItem.this._componentName, this.filterText);
        }

        public boolean accept(Object o) {
            return true;
        }
    }
}

