/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.propertygrid.editors;

import com.paterva.maltego.typing.editing.propertygrid.editors.InplacePropertyEditor;
import com.paterva.maltego.typing.editing.propertygrid.editors.InplacePropertyEditorSupport;
import com.paterva.maltego.typing.editors.OptionItemCollection;
import java.text.Format;
import javax.swing.JComboBox;
import org.openide.explorer.propertysheet.InplaceEditor;

public class ComboBoxPropertyEditor
extends InplacePropertyEditorSupport {
    private OptionItemCollection _items;
    private boolean _allowUserSpecified = false;

    public ComboBoxPropertyEditor(OptionItemCollection items) {
        this(items, false);
    }

    public ComboBoxPropertyEditor(OptionItemCollection items, boolean allowUserSpecified) {
        this(items, allowUserSpecified, null);
    }

    public ComboBoxPropertyEditor(OptionItemCollection items, boolean allowUserSpecified, Format format) {
        super(items.getType(), format);
        this._items = items;
        this._allowUserSpecified = allowUserSpecified;
    }

    @Override
    public InplaceEditor createEditor() {
        return new ComboBoxInplaceEditor(this._items, this._allowUserSpecified);
    }

    public boolean allowUserSpecified() {
        return this._allowUserSpecified;
    }

    private static class ComboBoxInplaceEditor
    extends InplacePropertyEditor<JComboBox> {
        private OptionItemCollection _pairs;
        private boolean _allowUserSpecified = false;

        public ComboBoxInplaceEditor(OptionItemCollection pairs, boolean allowUserSpecified) {
            super(new JComboBox<OptionItemCollection.OptionItem>(pairs.toArray()));
            this._pairs = pairs;
            this._allowUserSpecified = allowUserSpecified;
            ((JComboBox)this.getEditorControl()).setEditable(allowUserSpecified);
        }

        public Object getValue() {
            Object selected = ((JComboBox)this.getEditorControl()).getSelectedItem();
            if (selected instanceof OptionItemCollection.OptionItem) {
                return this._pairs.getValue((OptionItemCollection.OptionItem)selected);
            }
            if (this._allowUserSpecified && selected != null) {
                return selected;
            }
            return null;
        }

        public void setValue(Object object) {
            OptionItemCollection.OptionItem selectedItem = this._pairs.getItem(object);
            if (!this._allowUserSpecified || selectedItem != null) {
                ((JComboBox)this.getEditorControl()).setSelectedItem(selectedItem);
            }
        }

        @Override
        public void reset(Object value) {
            OptionItemCollection.OptionItem item = null;
            if (value != null) {
                item = this._pairs.getItem(value);
            }
            ((JComboBox)this.getEditorControl()).setSelectedItem(item);
        }
    }
}

