/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.graph.store.pandora.parts;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.Guid;
import com.pinkmatter.pandora.PandoraConnection;
import com.pinkmatter.pandora.PandoraSearch;
import com.pinkmatter.pandora.lucene.PandoraLuceneFactory;
import java.util.Collection;

public abstract class PandoraPartsReader {
    private final GraphID _id;
    private PandoraSearch _entitySearch;
    private PandoraSearch _linkSearch;

    public PandoraPartsReader(GraphID id) {
        this._id = id;
    }

    public GraphID getGraphID() {
        return this._id;
    }

    public PandoraSearch getEntitySearch() {
        return this._entitySearch;
    }

    public PandoraSearch getLinkSearch() {
        return this._linkSearch;
    }

    void setEntityConnection(PandoraConnection entityConn) {
        if (entityConn == null) {
            this._entitySearch = null;
        } else {
            PandoraLuceneFactory factory = new PandoraLuceneFactory();
            this._entitySearch = factory.createSearcher(entityConn, true);
        }
    }

    void setLinkConnection(PandoraConnection linkConn) {
        if (linkConn == null) {
            this._linkSearch = null;
        } else {
            PandoraLuceneFactory factory = new PandoraLuceneFactory();
            this._linkSearch = factory.createSearcher(linkConn, true);
        }
    }

    protected long[] toLongIDs(Collection<? extends Guid> guids) {
        long[] longIDs = new long[guids.size()];
        int num = 0;
        for (Guid guid : guids) {
            longIDs[num] = guid.getValue();
            ++num;
        }
        return longIDs;
    }

    protected Long[] toLongObjIDs(Collection<? extends Guid> guids) {
        Long[] longIDs = new Long[guids.size()];
        int num = 0;
        for (Guid guid : guids) {
            longIDs[num] = guid.getValue();
            ++num;
        }
        return longIDs;
    }
}

