/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.graph.store;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.LinkRegistry;
import com.paterva.maltego.graph.GraphLifeCycleManager;
import com.paterva.maltego.graph.GraphUserData;
import com.paterva.maltego.graph.store.ClipboardGraphID;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreFactory;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.imgfactoryapi.IconRegistry;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultGraphStoreRegistry
extends GraphStoreRegistry {
    private static final Logger LOG = Logger.getLogger(DefaultGraphStoreRegistry.class.getName());

    public void register(GraphID graphID, GraphStore graphStore) throws GraphStoreException {
        String key;
        GraphUserData gud = GraphUserData.forGraph((GraphID)graphID);
        if (gud.containsKey((Object)(key = DefaultGraphStoreRegistry.class.getName()))) {
            throw new GraphStoreException("Graph store already exists for id: " + graphID);
        }
        LOG.log(Level.FINE, "Registering: {0}", graphID);
        gud.put((Object)key, (Object)graphStore);
    }

    public synchronized GraphStore forGraphID(GraphID graphID) throws GraphStoreException {
        GraphUserData gud = GraphUserData.forGraph((GraphID)graphID);
        GraphStore graphStore = DefaultGraphStoreRegistry.getGraphStore(gud);
        if (graphStore == null) {
            if (ClipboardGraphID.get().equals((Object)graphID)) {
                EntityRegistry.associate((GraphID)graphID, (EntityRegistry)EntityRegistry.getDefault());
                LinkRegistry.associate((GraphID)graphID, (LinkRegistry)LinkRegistry.getDefault());
                IconRegistry.associate((GraphID)graphID, (IconRegistry)IconRegistry.getDefault());
                graphStore = GraphStoreFactory.getDefault().create(graphID, false);
            } else {
                throw new GraphStoreException("Graph store does not exist for id: " + graphID);
            }
        }
        return graphStore;
    }

    public boolean isExistingAndOpen(GraphID graphID) throws GraphStoreException {
        GraphUserData gud = GraphUserData.forGraph((GraphID)graphID, (boolean)false);
        if (gud != null) {
            GraphStore graphStore = DefaultGraphStoreRegistry.getGraphStore(gud);
            return graphStore != null && graphStore.isOpen();
        }
        return false;
    }

    public void closeAll() {
        for (Map.Entry entry : GraphUserData.getAll().entrySet()) {
            GraphStore graphStore = DefaultGraphStoreRegistry.getGraphStore((GraphUserData)entry.getValue());
            if (graphStore == null || !graphStore.isOpen()) continue;
            graphStore.close(true);
            GraphLifeCycleManager.getDefault().fireGraphClosed((GraphID)entry.getKey());
        }
    }

    private static GraphStore getGraphStore(GraphUserData gud) {
        return (GraphStore)gud.get((Object)DefaultGraphStoreRegistry.class.getName());
    }
}

