/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.chat;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashSet;
import java.util.Set;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public abstract class FilteredTopComponentRegistry {
    public static final String PROP_OPENED = "opened";
    public static final String PROP_CLOSED = "closed";
    public static final String PROP_ACTIVATED = "activated";
    public static final String PROP_TOPMOST = "topmost";
    private TopComponent _topmost;
    private TopComponent.Registry _registry;
    private PropertyChangeSupport _support = new PropertyChangeSupport(this);

    public FilteredTopComponentRegistry() {
        this(TopComponent.getRegistry());
    }

    public FilteredTopComponentRegistry(TopComponent.Registry registry) {
        this._registry = registry;
        this._registry.addPropertyChangeListener((PropertyChangeListener)new RegistryListener());
        this.init();
    }

    public abstract boolean isTracked(TopComponent var1);

    private void init() {
        TopComponent active = this.getActive();
        if (active != null) {
            this._topmost = active;
        } else {
            for (TopComponent tc : this._registry.getOpened()) {
                if (!this.isTracked(tc)) continue;
                this._topmost = tc;
                break;
            }
        }
    }

    public synchronized TopComponent getTopmost() {
        return this._topmost;
    }

    private void setTopmost(TopComponent tc) {
        if (this._topmost != tc) {
            TopComponent old = this._topmost;
            this._topmost = tc;
            this.firePropertyChanged(PROP_TOPMOST, old, this._topmost);
        }
    }

    public synchronized TopComponent getActive() {
        TopComponent active = this._registry.getActivated();
        if (this.isTracked(active)) {
            return active;
        }
        return null;
    }

    public synchronized Set<TopComponent> getOpen() {
        HashSet<TopComponent> open = new HashSet<TopComponent>();
        for (TopComponent tc : this._registry.getOpened()) {
            if (!this.isTracked(tc)) continue;
            open.add(tc);
        }
        return open;
    }

    private TopComponent asTracked(TopComponent tc) {
        if (this.isTracked(tc)) {
            return tc;
        }
        return null;
    }

    public void forceUpdate() {
        TopComponent active = this.getActive();
        this.setTopmost(active);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener pcl) {
        this._support.addPropertyChangeListener(pcl);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener pcl) {
        this._support.removePropertyChangeListener(pcl);
    }

    protected synchronized void firePropertyChanged(String property, Object oldValue, Object newValue) {
        this._support.firePropertyChange(property, oldValue, newValue);
    }

    private class RegistryListener
    implements PropertyChangeListener {
        private RegistryListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String type = evt.getPropertyName();
            if (FilteredTopComponentRegistry.PROP_ACTIVATED.equals(type)) {
                TopComponent newActive = (TopComponent)evt.getNewValue();
                TopComponent oldActive = (TopComponent)evt.getOldValue();
                if (FilteredTopComponentRegistry.this.isTracked(newActive)) {
                    FilteredTopComponentRegistry.this.setTopmost(newActive);
                    FilteredTopComponentRegistry.this.firePropertyChanged(FilteredTopComponentRegistry.PROP_ACTIVATED, FilteredTopComponentRegistry.this.asTracked(oldActive), newActive);
                } else if (FilteredTopComponentRegistry.this.isTracked(oldActive)) {
                    if (WindowManager.getDefault().isEditorTopComponent(newActive)) {
                        FilteredTopComponentRegistry.this.setTopmost(null);
                    }
                    FilteredTopComponentRegistry.this.firePropertyChanged(FilteredTopComponentRegistry.PROP_ACTIVATED, oldActive, null);
                }
            } else if ("tcOpened".equals(type)) {
                TopComponent tc = (TopComponent)evt.getNewValue();
                if (FilteredTopComponentRegistry.this.isTracked(tc)) {
                    FilteredTopComponentRegistry.this.firePropertyChanged(FilteredTopComponentRegistry.PROP_OPENED, null, tc);
                } else if (WindowManager.getDefault().isEditorTopComponent(tc)) {
                    FilteredTopComponentRegistry.this.setTopmost(null);
                }
            } else if ("tcClosed".equals(type)) {
                TopComponent tc = (TopComponent)evt.getNewValue();
                if (tc == FilteredTopComponentRegistry.this._topmost) {
                    FilteredTopComponentRegistry.this.setTopmost(null);
                }
                if (FilteredTopComponentRegistry.this.isTracked(tc)) {
                    FilteredTopComponentRegistry.this.firePropertyChanged(FilteredTopComponentRegistry.PROP_CLOSED, null, tc);
                }
            }
        }
    }
}

