/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.dialog;

import java.awt.Window;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JComponent;
import org.openide.util.Lookup;

public abstract class FullScreenManager {
    public static final String PROP_FULL_SCREEN = "fullScreenModeChanged";
    private PropertyChangeSupport _support = new PropertyChangeSupport(this);

    public static FullScreenManager getDefault() {
        FullScreenManager manager = (FullScreenManager)Lookup.getDefault().lookup(FullScreenManager.class);
        if (manager == null) {
            manager = new TrivialFullScreenManager();
        }
        return manager;
    }

    public abstract void setFullScreen(JComponent var1, Runnable var2);

    public abstract boolean isFullScreen();

    public abstract void exitFullScreen();

    abstract Window getFullScreenWindow();

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this._support.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this._support.removePropertyChangeListener(pcl);
    }

    protected void firePropertyChanged(String property, Object oldValue, Object newValue) {
        this._support.firePropertyChange(property, oldValue, newValue);
    }

    private static class TrivialFullScreenManager
    extends FullScreenManager {
        private TrivialFullScreenManager() {
        }

        @Override
        public void setFullScreen(JComponent component, Runnable exitCallback) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean isFullScreen() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void exitFullScreen() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Window getFullScreenWindow() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

