/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.darcula;

import com.bulenkov.iconloader.util.CenteredIcon;
import com.bulenkov.iconloader.util.ColorUtil;
import com.bulenkov.iconloader.util.DoubleColor;
import com.bulenkov.iconloader.util.SystemInfo;
import com.bulenkov.iconloader.util.UIUtil;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.Icon;
import javax.swing.UIManager;

public class DarculaUIUtil {
    public static final Color GLOW_COLOR = new DoubleColor(new Color(96, 132, 212), new Color(96, 175, 255));
    public static final boolean USE_QUARTZ = "true".equals(System.getProperty("apple.awt.graphics.UseQuartz"));
    public static final String MAC_FILL_BORDER = "MAC_FILL_BORDER";
    public static final int MAC_COMBO_BORDER_V_OFFSET = SystemInfo.isMacOSLion ? 1 : 0;
    private static Cursor INVERTED_TEXT_CURSOR;

    public static void paintFocusRing(Graphics g, int x, int y, int width, int height) {
        DarculaUIUtil.paintFocusRing((Graphics2D)g, DarculaUIUtil.getGlow(), new Rectangle(x, y, width, height));
    }

    public static void paintFocusOval(Graphics g, int x, int y, int width, int height) {
        DarculaUIUtil.paintFocusRing((Graphics2D)g, DarculaUIUtil.getGlow(), new Rectangle(x, y, width, height), false);
    }

    private static Color getGlow() {
        return UIManager.getLookAndFeelDefaults().getColor("darculaMod.borderFocusGlowColor");
    }

    public static void paintFocusRing(Graphics2D g2d, Color ringColor, Rectangle bounds) {
        DarculaUIUtil.paintFocusRing(g2d, ringColor, bounds, false);
    }

    public static void paintFocusRing(Graphics2D g, Color ringColor, Rectangle bounds, boolean oval) {
        int correction = UIUtil.isUnderDarcula() ? 50 : 0;
        Color[] colors = new Color[]{ColorUtil.toAlpha(ringColor, 180 - correction), ColorUtil.toAlpha(ringColor, 120 - correction), ColorUtil.toAlpha(ringColor, 70 - correction), ColorUtil.toAlpha(ringColor, 100 - correction), ColorUtil.toAlpha(ringColor, 50 - correction)};
        Object oldAntialiasingValue = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Object oldStrokeControlValue = g.getRenderingHint(RenderingHints.KEY_STROKE_CONTROL);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, !oval && USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
        Rectangle r = new Rectangle(bounds.x - 3, bounds.y - 3, bounds.width + 6, bounds.height + 6);
        g.setColor(colors[0]);
        DarculaUIUtil.drawRectOrOval(g, oval, 0, r.x + 2, r.y + 2, r.width - 5, r.height - 5);
        g.setColor(colors[1]);
        DarculaUIUtil.drawRectOrOval(g, oval, 0, r.x + 1, r.y + 1, r.width - 3, r.height - 3);
        g.setColor(colors[2]);
        DarculaUIUtil.drawRectOrOval(g, oval, 0, r.x, r.y, r.width - 1, r.height - 1);
        g.setColor(colors[3]);
        DarculaUIUtil.drawRectOrOval(g, oval, 0, r.x + 3, r.y + 3, r.width - 7, r.height - 7);
        g.setColor(colors[4]);
        DarculaUIUtil.drawRectOrOval(g, oval, 0, r.x + 4, r.y + 4, r.width - 9, r.height - 9);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAntialiasingValue);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, oldStrokeControlValue);
    }

    private static void drawRectOrOval(Graphics2D g, boolean oval, int arc, int x, int y, int width, int height) {
        if (oval) {
            g.drawOval(x, y, width, height);
        } else if (arc == 0) {
            g.drawRect(x, y, width, height);
        } else {
            g.drawRoundRect(x, y, width, height, arc, arc);
        }
    }

    public static void paintSearchFocusRing(Graphics2D g, Rectangle bounds) {
        int correction = UIUtil.isUnderDarcula() ? 50 : 0;
        Color[] colors = new Color[]{ColorUtil.toAlpha(DarculaUIUtil.getGlow(), 180 - correction), ColorUtil.toAlpha(DarculaUIUtil.getGlow(), 120 - correction), ColorUtil.toAlpha(DarculaUIUtil.getGlow(), 70 - correction), ColorUtil.toAlpha(DarculaUIUtil.getGlow(), 100 - correction), ColorUtil.toAlpha(DarculaUIUtil.getGlow(), 50 - correction)};
        Object oldAntialiasingValue = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Object oldStrokeControlValue = g.getRenderingHint(RenderingHints.KEY_STROKE_CONTROL);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
        Rectangle r = new Rectangle(bounds.x - 3, bounds.y - 3, bounds.width + 6, bounds.height + 6);
        g.setColor(colors[0]);
        g.drawRoundRect(r.x + 2, r.y + 2, r.width - 5, r.height - 5, r.height - 5, r.height - 5);
        g.setColor(colors[1]);
        g.drawRoundRect(r.x + 1, r.y + 1, r.width - 3, r.height - 3, r.height - 3, r.height - 3);
        g.setColor(colors[2]);
        g.drawRoundRect(r.x, r.y, r.width - 1, r.height - 1, r.height - 1, r.height - 1);
        g.setColor(colors[3]);
        g.drawRoundRect(r.x + 3, r.y + 3, r.width - 7, r.height - 7, r.height - 7, r.height - 7);
        g.setColor(colors[4]);
        g.drawRoundRect(r.x + 4, r.y + 4, r.width - 9, r.height - 9, r.height - 9, r.height - 9);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAntialiasingValue);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, oldStrokeControlValue);
    }

    public static Icon getTreeNodeIcon(boolean expanded, boolean selected, boolean focused) {
        boolean white = selected && focused || UIUtil.isUnderDarcula();
        Icon selectedIcon = DarculaUIUtil.getTreeSelectedExpandedIcon();
        Icon notSelectedIcon = DarculaUIUtil.getTreeExpandedIcon();
        int width = Math.max(selectedIcon.getIconWidth(), notSelectedIcon.getIconWidth());
        int height = Math.max(selectedIcon.getIconWidth(), notSelectedIcon.getIconWidth());
        return new CenteredIcon(expanded ? (white ? DarculaUIUtil.getTreeSelectedExpandedIcon() : DarculaUIUtil.getTreeExpandedIcon()) : (white ? DarculaUIUtil.getTreeSelectedCollapsedIcon() : DarculaUIUtil.getTreeCollapsedIcon()), width, height, false);
    }

    public static Icon getTreeCollapsedIcon() {
        return UIManager.getLookAndFeelDefaults().getIcon("Tree.collapsedIcon");
    }

    public static Icon getTreeExpandedIcon() {
        return UIManager.getLookAndFeelDefaults().getIcon("Tree.expandedIcon");
    }

    public static Icon getTreeSelectedCollapsedIcon() {
        return DarculaUIUtil.getTreeCollapsedIcon();
    }

    public static Icon getTreeSelectedExpandedIcon() {
        return DarculaUIUtil.getTreeExpandedIcon();
    }
}

