/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.customicons.manage;

import com.paterva.maltego.customicons.actions.AddIconAction;
import com.paterva.maltego.customicons.actions.DeleteIconsAction;
import com.paterva.maltego.customicons.manage.IconDetailsPanel;
import com.paterva.maltego.customicons.manage.IconNodeQuickFilter;
import com.paterva.maltego.customicons.nodes.IconNode;
import com.paterva.maltego.customicons.nodes.IconRootNode;
import com.paterva.maltego.imgfactoryapi.IconRegistry;
import com.paterva.maltego.imgfactoryapi.RegistryIcon;
import com.paterva.maltego.imgfactoryapi.WrappedRegistryIcon;
import com.paterva.maltego.util.ui.outline.OutlineViewPanel;
import com.paterva.maltego.util.ui.outline.TextQuickFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.Optional;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

public class IconManagerForm
extends TopComponent
implements ExplorerManager.Provider {
    private final ExplorerManager _explorer;
    private final PropertyChangeListener _selectionListener;
    private NewIconListener _iconListener;
    private RegistryIcon _selectedIcon;
    private IconDetailsPanel _iconDetailsPanel;
    private OutlineViewPanel _outlineViewPanel;
    private JSplitPane jSplitPane1;

    public IconManagerForm(RegistryIcon selectedIcon) {
        this.initComponents();
        this._selectedIcon = selectedIcon;
        this._selectionListener = new NodeSelectionListener();
        IconRootNode iconRootNode = new IconRootNode();
        this._explorer = new ExplorerManager();
        this._explorer.setRootContext((Node)iconRootNode);
        this._explorer.addPropertyChangeListener(this._selectionListener);
        ActionMap map = this.getActionMap();
        Action actionDelete = ExplorerUtils.actionDelete((ExplorerManager)this._explorer, (boolean)true);
        map.put("delete", actionDelete);
        this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)this._explorer, (ActionMap)map));
        this._outlineViewPanel.addToToolbarLeft(((DeleteIconsAction)SystemAction.get(DeleteIconsAction.class)).createContextAwareInstance(this.getLookup()));
        this._outlineViewPanel.addToToolbarLeft((Action)SystemAction.get(AddIconAction.class));
        this._outlineViewPanel.setFilter((TextQuickFilter)new IconNodeQuickFilter());
    }

    public ExplorerManager getExplorerManager() {
        return this._explorer;
    }

    protected void componentActivated() {
        ExplorerUtils.activateActions((ExplorerManager)this.getExplorerManager(), (boolean)true);
    }

    protected void componentDeactivated() {
        ExplorerUtils.activateActions((ExplorerManager)this.getExplorerManager(), (boolean)false);
    }

    public void addNotify() {
        super.addNotify();
        this._iconListener = new NewIconListener();
        if (this._selectedIcon != null) {
            this._iconListener.setSelectedIcon(this._selectedIcon);
        }
        IconRegistry.getDefault().addPropertyChangeListener((PropertyChangeListener)this._iconListener);
    }

    public void removeNotify() {
        IconRegistry.getDefault().removePropertyChangeListener((PropertyChangeListener)this._iconListener);
        this._iconListener = null;
        super.removeNotify();
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    private IconNode findIconNode(Node node, RegistryIcon icon) {
        IconNode iconNode;
        if (node instanceof IconNode && (iconNode = (IconNode)node).getIcon().getRegistryIcon().equals((Object)icon)) {
            return iconNode;
        }
        Children children = node.getChildren();
        for (Node child : children.getNodes(true)) {
            IconNode iconNode2 = this.findIconNode(child, icon);
            if (iconNode2 == null) continue;
            return iconNode2;
        }
        return null;
    }

    public Optional<RegistryIcon> getSelectedIcon() {
        return Optional.ofNullable(this._selectedIcon);
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this._iconDetailsPanel = new IconDetailsPanel();
        this._outlineViewPanel = new OutlineViewPanel("Icons");
        this.setBorder(BorderFactory.createEmptyBorder(2, 5, 0, 5));
        this.setPreferredSize(new Dimension(650, 550));
        this.setLayout(new BorderLayout());
        this.jSplitPane1.setDividerLocation(300);
        this.jSplitPane1.setRightComponent(this._iconDetailsPanel);
        this.jSplitPane1.setLeftComponent((Component)this._outlineViewPanel);
        this.add(this.jSplitPane1, "Center");
    }

    private class NewIconListener
    implements PropertyChangeListener {
        private NewIconListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt != null && evt.getPropertyName() != null) {
                switch (evt.getPropertyName()) {
                    case "addedIcon": 
                    case "renamedIcon": 
                    case "replacedIconSize": 
                    case "aliasesChanged": 
                    case "aliasAdded": 
                    case "aliasRemoved": {
                        SwingUtilities.invokeLater(() -> {
                            Object newValue = evt.getNewValue();
                            if (newValue instanceof WrappedRegistryIcon) {
                                this.setSelectedIcon(((WrappedRegistryIcon)newValue).getRegistryIcon());
                            } else if (newValue instanceof RegistryIcon) {
                                this.setSelectedIcon((RegistryIcon)newValue);
                            }
                        });
                    }
                }
            }
        }

        public void setSelectedIcon(RegistryIcon icon) {
            IconNode iconNode = IconManagerForm.this.findIconNode(IconManagerForm.this._explorer.getRootContext(), icon);
            if (iconNode != null) {
                try {
                    IconManagerForm.this._explorer.setSelectedNodes(new Node[0]);
                    IconManagerForm.this._explorer.setSelectedNodes(new Node[]{iconNode});
                }
                catch (PropertyVetoException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    private class NodeSelectionListener
    implements PropertyChangeListener {
        private NodeSelectionListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("selectedNodes".equals(evt.getPropertyName())) {
                Node node;
                Node[] nodes = (Node[])evt.getNewValue();
                RegistryIcon icon = null;
                if (nodes != null && nodes.length == 1 && (node = nodes[0]) instanceof IconNode) {
                    IconNode iconNode = (IconNode)node;
                    RegistryIcon registryIcon = icon = iconNode.getIcon() == null ? null : iconNode.getIcon().getRegistryIcon();
                    if (icon != null) {
                        IconManagerForm.this._selectedIcon = icon;
                    }
                }
                IconManagerForm.this._iconDetailsPanel.setIcon(icon);
            }
        }
    }
}

