/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editors;

import com.paterva.maltego.typing.FormattedConverter;
import java.text.Format;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;

public class OptionItemCollection
implements Iterable<OptionItem> {
    private Class _valueClass;
    private Format _format;
    private ArrayList<OptionItem> _pairs = new ArrayList();

    public OptionItemCollection(Class valueType, Format format) {
        if (valueType == null) {
            throw new IllegalArgumentException("Value type cannot be null");
        }
        this._valueClass = valueType;
        this._format = format;
    }

    public Class getType() {
        return this._valueClass;
    }

    public void add(String name, Object value) {
        this._pairs.add(new OptionItem(name, value));
    }

    public void add(Object value) {
        this._pairs.add(new OptionItem(value));
    }

    public Object getValue(OptionItem item) {
        return item.getValue();
    }

    public OptionItem getItem(Object value) {
        for (OptionItem p : this._pairs) {
            if (p == null || !(value == null ? p.getValue() == null : value.equals(p.getValue()))) continue;
            return p;
        }
        return null;
    }

    public OptionItem[] toArray() {
        return this._pairs.toArray(new OptionItem[this._pairs.size()]);
    }

    @Override
    public Iterator<OptionItem> iterator() {
        return this._pairs.iterator();
    }

    public Format getFormat() {
        return this._format;
    }

    public void setFormat(Format format) {
        this._format = format;
    }

    public class OptionItem {
        private String _name;
        private Object _value;

        public OptionItem() {
        }

        public OptionItem(String name, Object value) {
            this._name = name;
            this._value = value;
        }

        public OptionItem(Object value) {
            this(null, value);
        }

        public String getName() {
            return this._name;
        }

        public void setName(String name) {
            this._name = name;
        }

        public Object getValue() {
            return this._value;
        }

        public void setValue(Object value) {
            this._value = value;
        }

        public String toString() {
            if (this._name == null) {
                if (this._value == null) {
                    return "(null)";
                }
                return FormattedConverter.convertTo(this._value, OptionItemCollection.this._valueClass, OptionItemCollection.this.getFormat());
            }
            return this._name;
        }

        public int hashCode() {
            if (this._value == null) {
                return super.hashCode();
            }
            return this._value.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OptionItem other = (OptionItem)obj;
            return Objects.equals(this._value, other._value);
        }
    }
}

