/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.convert;

import com.paterva.maltego.typing.TypeRegistry;
import com.paterva.maltego.typing.convert.DefaultStringConverter;
import com.paterva.maltego.typing.convert.StringConverter;
import com.paterva.maltego.util.StringUtilities;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DateStringConverter
implements StringConverter {
    private static final Logger LOG = Logger.getLogger(DateStringConverter.class.getName());
    private SimpleDateFormat _format;

    private synchronized SimpleDateFormat getFormat() {
        if (this._format == null) {
            this._format = new SimpleDateFormat(TypeRegistry.getDefaultDateFormat());
        }
        return this._format;
    }

    private synchronized Date parse(String value) throws ParseException {
        return this.getFormat().parse(value);
    }

    private synchronized String format(Date date) {
        return this.getFormat().format(date);
    }

    @Override
    public Object convertFrom(String value, Class to) throws IllegalArgumentException {
        if (!StringUtilities.isNullOrEmpty((String)value)) {
            Date date = null;
            try {
                date = this.parse(value);
            }
            catch (ParseException ex) {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S z");
                try {
                    date = df.parse(value);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            if (date == null) {
                try {
                    long millis = Long.parseLong(value);
                    date = new Date(millis);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (date == null) {
                LOG.log(Level.WARNING, "Could not convert string '{0}' to Date", value);
            }
            return date;
        }
        return null;
    }

    @Override
    public String convertTo(Object value, Class from) throws IllegalArgumentException {
        if (value instanceof Date) {
            return this.format((Date)value);
        }
        return DefaultStringConverter.instance().convertTo(value, from);
    }
}

